/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.lexer;

import fleet.com.intellij.lexer.LexerBase;
import fleet.com.intellij.openapi.diagnostic.Logger;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.psi.StringEscapesTokenTypes;
import fleet.com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PhpStringLiteralLexer
extends LexerBase {
    private static final Logger LOG = Logger.getInstance(PhpStringLiteralLexer.class);
    private static final short BEFORE_FIRST_QUOTE = 0;
    private static final short AFTER_FIRST_QUOTE = 1;
    private static final short AFTER_LAST_QUOTE = 2;
    private static final short LAST_STATE = 2;
    public static final short TYPE_SINGLE_QUOTE = 1;
    public static final short TYPE_DOUBLE_QUOTE = 2;
    private CharSequence myBuffer;
    private int myStart;
    private int myEnd;
    private int myState;
    private int myLastState;
    private int myBufferEnd;
    private final IElementType myOriginalLiteralToken;
    private final int myStringType;

    public PhpStringLiteralLexer(IElementType originalLiteralToken, int stringType) {
        this.myOriginalLiteralToken = originalLiteralToken;
        LOG.assertTrue(stringType == 1 || stringType == 2, (Object)"Invalid string type");
        this.myStringType = stringType;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myBuffer = buffer;
        this.myStart = startOffset;
        this.myState = 1;
        this.myLastState = initialState;
        this.myBufferEnd = endOffset;
        this.myEnd = this.locateToken(this.myStart);
    }

    public int getState() {
        return this.myLastState;
    }

    private IElementType getTokenTypeSingleQuote(char nextChar) {
        if (nextChar == '\'' || nextChar == '\\') {
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        return this.myOriginalLiteralToken;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IElementType getTokenTypeDoubleQuote(char nextChar) {
        IElementType iElementType;
        if (nextChar == 'x') {
            for (int i = this.myStart + 2; i < this.myStart + 4; ++i) {
                if (i > this.myEnd || i == this.myStart + 2 && (i >= this.myBuffer.length() || !StringUtil.isHexDigit((char)this.myBuffer.charAt(i)))) {
                    return this.myOriginalLiteralToken;
                }
                if (i > this.myStart + 2 && (i >= this.myBuffer.length() || !StringUtil.isHexDigit((char)this.myBuffer.charAt(i)))) return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            }
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        if (nextChar == 'u') {
            int zeroes;
            int i;
            if (this.myBuffer.length() <= this.myStart + 2 || this.myBuffer.charAt(this.myStart + 2) != '{') return this.myOriginalLiteralToken;
            for (i = zeroes = PhpStringLiteralLexer.skipLeadingZeroes(this.myBuffer, this.myStart + 3); i < zeroes + 6; ++i) {
                if (i > this.myEnd || i == this.myStart + 2 && (i >= this.myBuffer.length() || !StringUtil.isHexDigit((char)this.myBuffer.charAt(i)) && this.myBuffer.charAt(i) != '}')) {
                    return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
                }
                if (i > this.myStart + 2 && (i >= this.myBuffer.length() || !StringUtil.isHexDigit((char)this.myBuffer.charAt(i)))) break;
            }
            if (i < this.myBuffer.length() && this.myBuffer.charAt(i) == '}' && (this.myBuffer.charAt(i) != '}' || i != this.myStart + 3)) return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
        }
        if (StringUtil.isOctalDigit((char)nextChar)) {
            for (int i = this.myStart + 1; i < this.myStart + 4; ++i) {
                if (i > this.myEnd || i == this.myStart + 1 && !StringUtil.isOctalDigit((char)this.myBuffer.charAt(i))) {
                    return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
                }
                if (i > this.myStart + 1 && (i >= this.myBuffer.length() || !StringUtil.isOctalDigit((char)this.myBuffer.charAt(i)))) return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            }
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        switch (nextChar) {
            case '\"': 
            case '$': 
            case '\\': 
            case 'e': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': 
            case 'v': {
                iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                return iElementType;
            }
            default: {
                iElementType = this.myOriginalLiteralToken;
            }
        }
        return iElementType;
    }

    public IElementType getTokenType() {
        if (this.myStart >= this.myEnd) {
            return null;
        }
        if (this.myBuffer.charAt(this.myStart) != '\\') {
            return this.myOriginalLiteralToken;
        }
        if (this.myStart + 1 >= this.myEnd) {
            return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
        }
        char nextChar = this.myBuffer.charAt(this.myStart + 1);
        if (this.myStringType == 1) {
            return this.getTokenTypeSingleQuote(nextChar);
        }
        if (this.myStringType == 2) {
            return this.getTokenTypeDoubleQuote(nextChar);
        }
        return null;
    }

    public int getTokenStart() {
        return this.myStart;
    }

    public int getTokenEnd() {
        return this.myEnd;
    }

    private int locateToken(int start) {
        if (start == this.myBufferEnd) {
            this.myState = 2;
        }
        if (this.myState == 2) {
            return start;
        }
        int i = start;
        if (this.myBuffer.charAt(i) == '\\') {
            LOG.assertTrue(this.myState == 1);
            if (++i == this.myBufferEnd) {
                this.myState = 2;
                return i;
            }
            if (this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7') {
                char first = this.myBuffer.charAt(i);
                if (++i < this.myBufferEnd && this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7' && ++i < this.myBufferEnd && first <= '7' && this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7') {
                    ++i;
                }
                return i;
            }
            if (this.myBuffer.charAt(i) == 'x') {
                ++i;
                while (i < start + 4) {
                    if (i == this.myBufferEnd || !StringUtil.isHexDigit((char)this.myBuffer.charAt(i))) {
                        return i;
                    }
                    ++i;
                }
                return i;
            }
            if (this.myBuffer.charAt(i) == 'u') {
                int zeroesOffset;
                if (++i == this.myBufferEnd || this.myBuffer.charAt(i) != '{') {
                    return i;
                }
                ++i;
                for (i = zeroesOffset = PhpStringLiteralLexer.skipLeadingZeroes(this.myBuffer, i); i < 6 + zeroesOffset && i != this.myBufferEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(i)); ++i) {
                }
                while (i < this.myBufferEnd && !StringUtil.isLineBreak((char)this.myBuffer.charAt(i)) && !StringUtil.isWhiteSpace((char)this.myBuffer.charAt(i)) && this.myBuffer.charAt(i++) != '}') {
                }
                return i;
            }
            return i + 1;
        }
        LOG.assertTrue(this.myState == 1);
        while (i < this.myBufferEnd) {
            if (this.myBuffer.charAt(i) == '\\') {
                return i;
            }
            ++i;
            this.myState = 1;
        }
        return i;
    }

    private static int skipLeadingZeroes(CharSequence buffer, int offset) {
        int i;
        for (i = offset; i < buffer.length() && buffer.charAt(i) == '0'; ++i) {
        }
        return i;
    }

    public void advance() {
        this.myLastState = this.myState;
        this.myStart = this.myEnd;
        this.myEnd = this.locateToken(this.myStart);
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        return this.myBuffer;
    }
}

