/*
 * Decompiled with CFR 0.152.
 */
package fleet.mercury.frontend.schema;

import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.mercury.frontend.schema.AbstractMercuryTestConfigurationStructureAnalyserBase;
import fleet.mercury.frontend.schema.UtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lfleet/mercury/frontend/schema/MercuryTestConfigurationStructureAnalyser;", "Lfleet/mercury/frontend/schema/AbstractMercuryTestConfigurationStructureAnalyserBase;", "()V", "validate", "", "keyName", "node", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "fleet.plugins.mercury.frontend"})
public final class MercuryTestConfigurationStructureAnalyser
extends AbstractMercuryTestConfigurationStructureAnalyserBase {
    @NotNull
    public static final MercuryTestConfigurationStructureAnalyser INSTANCE = new MercuryTestConfigurationStructureAnalyser();

    private MercuryTestConfigurationStructureAnalyser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    protected String validate(@Nullable String keyName, @NotNull SyntaxNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = keyName;
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case -1191170682: {
                if (string.equals("testSuite")) {
                    n = 1;
                }
                break;
            }
            case 1542179859: {
                if (string.equals("testMethod")) {
                    n = 2;
                }
                break;
            }
            case -1183689058: {
                if (string.equals("testPattern")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                if (UtilKt.siblingPropertyValue(node, "testPattern") == null) return null;
                return "'testSuite' cannot be declared simultaneously with a 'testPattern'";
            }
            case 3: {
                if (UtilKt.siblingPropertyValue(node, "testSuite") == null) return null;
                return "'testPattern' cannot be declared simultaneously with a 'testSuite'";
            }
            case 2: {
                if (UtilKt.siblingPropertyValue(node, "testSuite") != null) return null;
                return "'testMethod' requires a 'testSuite' to be present";
            }
            default: {
                return null;
            }
        }
    }
}

