/*
 * Decompiled with CFR 0.152.
 */
package fleet.mercury.frontend.highlighting;

import fleet.com.intellij.psi.StringEscapesTokenTypes;
import fleet.com.intellij.psi.TokenType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.swift.SwiftParserTypes;
import fleet.com.jetbrains.swift.lang.parser.SwiftFileElementType;
import fleet.com.jetbrains.swift.lexer.SwiftTokenTypes;
import fleet.com.jetbrains.swift.parser.SwiftParserUtilKt;
import fleet.mercury.frontend.highlighting.SwiftEditorSchemeKt;
import fleet.mercury.frontend.highlighting.SwiftHighlightingLexerExtender;
import fleet.mercury.frontend.highlighting.SwiftSoftKeywordHighlighterKt;
import fleet.mercury.frontend.util.SwiftTreeWalkerUtilKt;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import noria.model.components.editor.HoverableKind;
import noria.model.components.editor.TextAttributesKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a,\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002\u001a\u0012\u0010\u0012\u001a\u00020\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u001a\u0012\u0010\u0015\u001a\u00020\u00022\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u001a\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u0014\u001a\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0002*\u00020\u0014H\u0002\u001a\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u0002*\u00020\u0014H\u0002\"\u001e\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\"\u0010\u0004\u001a\u0016\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"HOVERABLE_ATTRIBUTES", "Ljava/util/HashSet;", "Lnoria/model/components/editor/TextAttributesKey;", "Lkotlin/collections/HashSet;", "IDENTIFIER_KINDS", "", "Lfleet/com/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "TOKEN_ATTRIBUTES", "TYPE_DECLARATIONS", "Lfleet/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "fillMap", "", "map", "", "keys", "value", "handleReferenceExpression", "parent", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "handleVariableDeclaration", "swiftNodeHighlighter", "node", "findIdentifierType", "getAttribute", "fleet.plugins.mercury.frontend"})
@SourceDebugExtension(value={"SMAP\nSwiftNodeHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwiftNodeHighlighter.kt\nfleet/mercury/frontend/highlighting/SwiftNodeHighlighterKt\n+ 2 KtUtils.kt\nfleet/com/intellij/util/KotlinUtils\n+ 3 SwiftTreeWalkerUtil.kt\nfleet/mercury/frontend/util/SwiftTreeWalkerUtilKt\n+ 4 Uitil.kt\nfleet/util/UitilKt\n+ 5 SwiftTemplatePlaceholderUtil.kt\nfleet/mercury/frontend/util/SwiftTemplatePlaceholderUtilKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n14#2:203\n33#3:204\n119#4:205\n14#5:206\n11#5:207\n1#6:208\n*S KotlinDebug\n*F\n+ 1 SwiftNodeHighlighter.kt\nfleet/mercury/frontend/highlighting/SwiftNodeHighlighterKt\n*L\n78#1:203\n79#1:204\n79#1:205\n86#1:206\n86#1:207\n*E\n"})
public final class SwiftNodeHighlighterKt {
    @NotNull
    private static final Map<IElementType, TextAttributesKey> IDENTIFIER_KINDS;
    @NotNull
    private static final TokenSet TYPE_DECLARATIONS;
    @NotNull
    private static final HashSet<TextAttributesKey> HOVERABLE_ATTRIBUTES;
    @NotNull
    private static final Map<IElementType, TextAttributesKey> TOKEN_ATTRIBUTES;

    @Nullable
    public static final TextAttributesKey swiftNodeHighlighter(@NotNull SyntaxNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        TextAttributesKey textAttributesKey = SwiftSoftKeywordHighlighterKt.swiftSoftKeywordHighlighter(node);
        if (textAttributesKey == null) {
            textAttributesKey = SwiftNodeHighlighterKt.getAttribute(node);
        }
        return textAttributesKey;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final TextAttributesKey getAttribute(SyntaxNode $this$getAttribute) {
        TextAttributesKey textAttributesKey;
        IElementType iElementType;
        Object object = $this$getAttribute.getType();
        IElementType iElementType2 = iElementType = object instanceof IElementType ? (IElementType)object : null;
        if (Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.IDENTIFIER)) {
            textAttributesKey = SwiftNodeHighlighterKt.findIdentifierType($this$getAttribute);
            return textAttributesKey;
        }
        if (((((Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.L_CURLY) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.R_CURLY)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.L_BRACKET)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.R_BRACKET)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.L_PAREN)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.R_PAREN)) {
            textAttributesKey = SwiftEditorSchemeKt.getSwiftEditorScheme().getPunctuationOperator();
            return textAttributesKey;
        }
        if ((((Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.COMMA) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.COLON)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.SEMICOLON)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.DOT)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.HASH)) {
            textAttributesKey = SwiftEditorSchemeKt.getSwiftEditorScheme().getPunctuation();
            return textAttributesKey;
        }
        if (((Intrinsics.areEqual((Object)iElementType, (Object)SwiftHighlightingLexerExtender.INSTANCE.getTEMPLATE_BACKGROUND()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.EOL_COMMENT)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.SHEBANG_COMMENT)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.BLOCK_COMMENT)) {
            textAttributesKey = SwiftEditorSchemeKt.getSwiftEditorScheme().getComment();
            return textAttributesKey;
        }
        if ((((Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.ISTRING_BEGIN) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.ISTRING_CONTENT)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.ISTRING_END)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.IMULTILINE_STRING_BEGIN)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.IMULTILINE_STRING_END)) {
            textAttributesKey = SwiftEditorSchemeKt.getSwiftEditorScheme().getString();
            return textAttributesKey;
        }
        if (((((Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.REGEX_BEGIN) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.BARE_SLASH_REGEX_BEGIN)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.REGEX_CONTENT)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.BARE_SLASH_REGEX)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.REGEX_END)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.BARE_SLASH_REGEX_END)) {
            textAttributesKey = SwiftEditorSchemeKt.getSwiftEditorScheme().getRegexp();
            return textAttributesKey;
        }
        if ((((Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.ISTRING_ESCAPE) ? true : Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.ISTRING_ESCAPE_SEQUENCE)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN)) {
            textAttributesKey = SwiftEditorSchemeKt.getSwiftEditorScheme().getStringEscape();
            return textAttributesKey;
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.INSTANCE_SELF) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.SUPER)) {
            textAttributesKey = SwiftEditorSchemeKt.getSwiftEditorScheme().getKeyword();
            return textAttributesKey;
        }
        if (((((((Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.CUSTOM_ATTRIBUTE) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.ATTRIBUTE_ARGUMENT)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.ATTRIBUTE_ARGUMENT_CLAUSE)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.ATTRIBUTE_ARGUMENT_LABEL)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.ATTRIBUTE_ARGUMENT_VALUE)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.ATTRIBUTE_INITIALIZER)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.ATTRIBUTE_QUALIFIER)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.ATTRIBUTE)) {
            textAttributesKey = SwiftEditorSchemeKt.getSwiftEditorScheme().getAttribute();
            return textAttributesKey;
        }
        if (((((((Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.COND_IF) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.COND_ELSE_IF)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.COND_ELSE)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.COND_END_IF)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.LINE_CONTROL_STATEMENT)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.POSTFIX_IF_CONFIG_ELSE)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.POSTFIX_IF_CONFIG_ELSE_IF)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SwiftParserTypes.NESTED_POSTFIX_IF_CONFIG_EXPRESSION)) {
            textAttributesKey = SwiftEditorSchemeKt.getSwiftEditorScheme().getDirective();
            return textAttributesKey;
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)TokenType.ERROR_ELEMENT)) {
            textAttributesKey = SwiftEditorSchemeKt.getSwiftEditorScheme().getError();
            return textAttributesKey;
        }
        Object $this$asSafely$iv = $this$getAttribute.getType();
        boolean $i$f$asSafely = false;
        Object object2 = $this$asSafely$iv;
        if (!(object2 instanceof IElementType)) {
            object2 = null;
        }
        IElementType it = (IElementType)object2;
        boolean bl = false;
        if (SwiftTokenTypes.KEYWORDS.contains(it)) {
            IElementType iElementType3;
            SyntaxNode $this$typeAsIElementType$iv = $this$getAttribute;
            boolean $i$f$getTypeAsIElementType = false;
            Object $this$safeAs$iv$iv = $this$typeAsIElementType$iv.getType();
            boolean $i$f$safeAs = false;
            Object object3 = $this$safeAs$iv$iv;
            if (!(object3 instanceof IElementType)) {
                object3 = null;
            }
            IElementType iElementType4 = (IElementType)object3;
            SyntaxNode syntaxNode = $this$getAttribute.parent();
            if (syntaxNode != null) {
                SyntaxNode $this$typeAsIElementType$iv2 = syntaxNode;
                boolean $i$f$getTypeAsIElementType2 = false;
                Object $this$safeAs$iv$iv2 = $this$typeAsIElementType$iv2.getType();
                boolean $i$f$safeAs2 = false;
                Object object4 = $this$safeAs$iv$iv2;
                if (!(object4 instanceof IElementType)) {
                    object4 = null;
                }
                iElementType3 = (IElementType)object4;
            } else {
                iElementType3 = null;
            }
            if (SwiftParserUtilKt.isKeywordUsedAsIdentifier((IElementType)iElementType4, iElementType3)) {
                textAttributesKey = SwiftNodeHighlighterKt.findIdentifierType($this$getAttribute);
                return textAttributesKey;
            }
        }
        textAttributesKey = TOKEN_ATTRIBUTES.get(it);
        return textAttributesKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final TextAttributesKey findIdentifierType(SyntaxNode $this$findIdentifierType) {
        TextAttributesKey textAttributesKey;
        Object object;
        SyntaxNode ancestor;
        SyntaxNode $this$isSwiftTemplate$iv = $this$findIdentifierType;
        boolean $i$f$isSwiftTemplate = false;
        if (Intrinsics.areEqual((Object)$this$isSwiftTemplate$iv.getType(), (Object)SwiftParserTypes.IDENTIFIER)) {
            CharSequence $this$isSwiftTemplate$iv$iv = $this$isSwiftTemplate$iv.getText();
            boolean $i$f$isSwiftTemplate2 = false;
            if (StringsKt.startsWith$default((CharSequence)$this$isSwiftTemplate$iv$iv, (CharSequence)"<#", (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)$this$isSwiftTemplate$iv$iv, (CharSequence)"#>", (boolean)false, (int)2, null)) {
                return null;
            }
            boolean bl = false;
            if (bl) {
                return null;
            }
        }
        boolean bl = false;
        if (bl) {
            return null;
        }
        SyntaxNode syntaxNode = ancestor = SwiftTreeWalkerUtilKt.findParent($this$findIdentifierType, IDENTIFIER_KINDS.keySet());
        SyntaxNode ancestorParent = syntaxNode != null ? SwiftTreeWalkerUtilKt.parentSkippingDirectives(syntaxNode) : null;
        SyntaxNode syntaxNode2 = ancestor;
        Object object2 = object = syntaxNode2 != null ? syntaxNode2.getType() : null;
        if (Intrinsics.areEqual((Object)object, (Object)SwiftParserTypes.ACTOR_DECLARATION)) {
            textAttributesKey = SwiftEditorSchemeKt.getSwiftEditorScheme().getClass();
        } else if (Intrinsics.areEqual((Object)object, (Object)SwiftParserTypes.RAW_ENUM_CASE) ? true : Intrinsics.areEqual((Object)object, (Object)SwiftParserTypes.TAGGED_ENUM_CASE)) {
            textAttributesKey = SwiftEditorSchemeKt.getSwiftEditorScheme().getEnumValue();
        } else if (Intrinsics.areEqual((Object)object, (Object)SwiftParserTypes.VARIABLE_DECLARATION)) {
            textAttributesKey = SwiftNodeHighlighterKt.handleVariableDeclaration(ancestorParent);
        } else if (Intrinsics.areEqual((Object)object, (Object)SwiftParserTypes.REFERENCE_EXPRESSION)) {
            textAttributesKey = SwiftNodeHighlighterKt.handleReferenceExpression(ancestorParent);
        } else {
            SyntaxNode syntaxNode3 = ancestor;
            Object object3 = syntaxNode3 != null ? syntaxNode3.getType() : null;
            textAttributesKey = IDENTIFIER_KINDS.get(object3 instanceof IElementType ? (IElementType)object3 : null);
            if (textAttributesKey == null) {
                textAttributesKey = SwiftEditorSchemeKt.getSwiftEditorScheme().getIdentifier();
            }
        }
        TextAttributesKey it = textAttributesKey;
        boolean bl2 = false;
        return HOVERABLE_ATTRIBUTES.contains(it) ? TextAttributesKey.copy-l6UcrTM$default((TextAttributesKey)it, null, (int)0, (HoverableKind)HoverableKind.HyperLink, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, null, (int)16379, null) : it;
    }

    private static final TextAttributesKey handleReferenceExpression(SyntaxNode parent2) {
        SyntaxNode syntaxNode = parent2;
        return Intrinsics.areEqual((Object)(syntaxNode != null ? syntaxNode.getType() : null), (Object)SwiftParserTypes.CALL_EXPRESSION) ? SwiftEditorSchemeKt.getSwiftEditorScheme().getFunctionCall() : SwiftEditorSchemeKt.getSwiftEditorScheme().getIdentifier();
    }

    private static final TextAttributesKey handleVariableDeclaration(SyntaxNode parent2) {
        TextAttributesKey textAttributesKey;
        SyntaxNode syntaxNode = parent2;
        Object object = syntaxNode != null ? syntaxNode.getType() : null;
        if (TYPE_DECLARATIONS.contains(object instanceof IElementType ? (IElementType)object : null)) {
            textAttributesKey = SwiftEditorSchemeKt.getSwiftEditorScheme().getProperty();
        } else {
            SyntaxNode syntaxNode2 = parent2;
            textAttributesKey = (syntaxNode2 != null ? syntaxNode2.getType() : null) instanceof SwiftFileElementType ? SwiftEditorSchemeKt.getSwiftEditorScheme().getVariable() : SwiftEditorSchemeKt.getSwiftEditorScheme().getVariable();
        }
        return textAttributesKey;
    }

    private static final void fillMap(Map<IElementType, TextAttributesKey> map2, TokenSet keys, TextAttributesKey value) {
        IElementType[] iElementTypeArray = keys.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"getTypes(...)");
        for (IElementType type : iElementTypeArray) {
            Intrinsics.checkNotNull((Object)type);
            map2.put(type, value);
        }
    }

    static {
        Object object = new Pair[]{TuplesKt.to((Object)SwiftParserTypes.IMPORT_DECLARATION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getIdentifier()), TuplesKt.to((Object)SwiftParserTypes.CLASS_DECLARATION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getClass()), TuplesKt.to((Object)SwiftParserTypes.ACTOR_DECLARATION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getClass()), TuplesKt.to((Object)SwiftParserTypes.ENUM_DECLARATION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getEnum()), TuplesKt.to((Object)SwiftParserTypes.STRUCT_DECLARATION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getStruct()), TuplesKt.to((Object)SwiftParserTypes.EXTENSION_DECLARATION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getClass()), TuplesKt.to((Object)SwiftParserTypes.PROTOCOL_DECLARATION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getProtocol()), TuplesKt.to((Object)SwiftParserTypes.FUNCTION_DECLARATION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getFunctionDeclaration()), TuplesKt.to((Object)SwiftParserTypes.DEINITIALIZER_DECLARATION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getFunctionDeclaration()), TuplesKt.to((Object)SwiftParserTypes.INITIALIZER_DECLARATION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getFunctionDeclaration()), TuplesKt.to((Object)SwiftParserTypes.OPERATOR_DECLARATION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getFunctionDeclaration()), TuplesKt.to((Object)SwiftParserTypes.PRECEDENCE_GROUP_DECLARATION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getFunctionDeclaration()), TuplesKt.to((Object)SwiftParserTypes.SUBSCRIPT_DECLARATION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getFunctionDeclaration()), TuplesKt.to((Object)SwiftParserTypes.ASSOCIATED_TYPE_DECLARATION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getTypeName()), TuplesKt.to((Object)SwiftParserTypes.GENERIC_PARAMETER, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getTypeParameter()), TuplesKt.to((Object)SwiftParserTypes.TYPE_ALIAS_DECLARATION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getTypeName()), TuplesKt.to((Object)SwiftParserTypes.VARIABLE_DECLARATION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getVariable()), TuplesKt.to((Object)SwiftParserTypes.VALUE_BINDING_PATTERN, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getVariable()), TuplesKt.to((Object)SwiftParserTypes.OPTIONAL_BINDING_VARIABLE, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getVariable()), TuplesKt.to((Object)SwiftParserTypes.SETTER_CLAUSE, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getKeyword()), TuplesKt.to((Object)SwiftParserTypes.GETTER_CLAUSE, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getKeyword()), TuplesKt.to((Object)SwiftParserTypes.WILL_SET_CLAUSE, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getKeyword()), TuplesKt.to((Object)SwiftParserTypes.DID_SET_CLAUSE, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getKeyword()), TuplesKt.to((Object)SwiftParserTypes.PARAMETER, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getParameter()), TuplesKt.to((Object)SwiftParserTypes.CLOSURE_PARAMETER, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getParameter()), TuplesKt.to((Object)SwiftParserTypes.INLINED_PARAMETER, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getParameter()), TuplesKt.to((Object)SwiftParserTypes.TUPLE_TYPE_ELEMENT, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getParameter()), TuplesKt.to((Object)SwiftParserTypes.CALL_EXPRESSION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getFunctionCall()), TuplesKt.to((Object)SwiftParserTypes.ARGUMENT_LIST_ITEM, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getNamedArgument()), TuplesKt.to((Object)SwiftParserTypes.REFERENCE_TYPE_ELEMENT, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getTypeName()), TuplesKt.to((Object)SwiftParserTypes.REFERENCE_EXPRESSION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getIdentifier()), TuplesKt.to((Object)SwiftParserTypes.TAGGED_ENUM_CASE, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getField()), TuplesKt.to((Object)SwiftParserTypes.RAW_ENUM_CASE, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getField()), TuplesKt.to((Object)SwiftParserTypes.ENUM_CASE_PATTERN, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getIdentifier()), TuplesKt.to((Object)SwiftParserTypes.IF_DIRECTIVE, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getDirective()), TuplesKt.to((Object)SwiftParserTypes.ELSE_IF_DIRECTIVE, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getDirective()), TuplesKt.to((Object)SwiftParserTypes.ROOT_POSTFIX_IF_CONFIG_EXPRESSION, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getDirective()), TuplesKt.to((Object)SwiftParserTypes.POSTFIX_IF_CONFIG_ELSE_IF, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getDirective()), TuplesKt.to((Object)SwiftParserTypes.SOME_TYPE_ELEMENT, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getKeyword()), TuplesKt.to((Object)SwiftParserTypes.ANY_TYPE_ELEMENT, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getKeyword()), TuplesKt.to((Object)SwiftParserTypes.PLATFORM_NAME, (Object)SwiftEditorSchemeKt.getSwiftEditorScheme().getIdentifier())};
        IDENTIFIER_KINDS = MapsKt.mapOf((Pair[])object);
        IElementType[] iElementTypeArray = new IElementType[]{SwiftParserTypes.ACTOR_DECLARATION, SwiftParserTypes.CLASS_DECLARATION, SwiftParserTypes.ENUM_DECLARATION, SwiftParserTypes.EXTENSION_DECLARATION, SwiftParserTypes.PROTOCOL_DECLARATION, SwiftParserTypes.STRUCT_DECLARATION};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        TYPE_DECLARATIONS = tokenSet;
        object = new TextAttributesKey[]{SwiftEditorSchemeKt.getSwiftEditorScheme().getIdentifier(), SwiftEditorSchemeKt.getSwiftEditorScheme().getVariable(), SwiftEditorSchemeKt.getSwiftEditorScheme().getParameter(), SwiftEditorSchemeKt.getSwiftEditorScheme().getFunctionDeclaration(), SwiftEditorSchemeKt.getSwiftEditorScheme().getFunctionCall(), SwiftEditorSchemeKt.getSwiftEditorScheme().getTypeName(), SwiftEditorSchemeKt.getSwiftEditorScheme().getProperty(), SwiftEditorSchemeKt.getSwiftEditorScheme().getProtocol(), SwiftEditorSchemeKt.getSwiftEditorScheme().getClass(), SwiftEditorSchemeKt.getSwiftEditorScheme().getEnum(), SwiftEditorSchemeKt.getSwiftEditorScheme().getStruct(), SwiftEditorSchemeKt.getSwiftEditorScheme().getTypeParameter(), SwiftEditorSchemeKt.getSwiftEditorScheme().getNamedArgument(), SwiftEditorSchemeKt.getSwiftEditorScheme().getEnumValue()};
        HOVERABLE_ATTRIBUTES = SetsKt.hashSetOf((Object[])object);
        Object $this$TOKEN_ATTRIBUTES_u24lambda_u242 = object = MapsKt.createMapBuilder();
        boolean bl = false;
        TokenSet tokenSet2 = SwiftTokenTypes.NUMBERS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"NUMBERS");
        SwiftNodeHighlighterKt.fillMap((Map<IElementType, TextAttributesKey>)$this$TOKEN_ATTRIBUTES_u24lambda_u242, tokenSet2, SwiftEditorSchemeKt.getSwiftEditorScheme().getNumber());
        TokenSet tokenSet3 = SwiftTokenTypes.KEYWORDS;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"KEYWORDS");
        SwiftNodeHighlighterKt.fillMap((Map<IElementType, TextAttributesKey>)$this$TOKEN_ATTRIBUTES_u24lambda_u242, tokenSet3, SwiftEditorSchemeKt.getSwiftEditorScheme().getKeyword());
        TOKEN_ATTRIBUTES = MapsKt.build((Map)object);
    }
}

