/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.psi.css.impl.util.scheme;

import fleet.com.intellij.openapi.diagnostic.Logger;
import fleet.com.intellij.openapi.util.JDOMUtil;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.psi.css.impl.descriptor.CssPseudoClassDescriptorImpl;
import fleet.com.intellij.psi.css.impl.descriptor.CssPseudoElementDescriptorImpl;
import fleet.com.intellij.psi.css.impl.util.scheme.CssDescriptorsHolder;
import java.io.IOException;
import java.net.URL;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class CssDescriptorsLoader {
    private final CssDescriptorsHolder myDescriptors = new CssDescriptorsHolder();
    private static final Logger LOG = Logger.getInstance(CssDescriptorsLoader.class);

    public void loadDescriptors(@NotNull URL resource) {
        try {
            for (Element element : JDOMUtil.load((URL)resource).getChildren()) {
                this.checkCancelled();
                String tagName = element.getName();
                if ("pseudo-element".equals(tagName)) {
                    this.loadPseudoElementDescriptor(element);
                    continue;
                }
                if (!"pseudo-class".equals(tagName)) continue;
                this.loadPseudoClassDescriptor(element);
            }
        }
        catch (JDOMException e) {
            LOG.error("Error loading " + resource.getPath(), (Throwable)e, new String[0]);
        }
        catch (IOException e) {
            LOG.error("Error loading " + resource.getPath(), (Throwable)e, new String[0]);
        }
    }

    @NotNull
    public CssDescriptorsHolder getDescriptors() {
        return this.myDescriptors;
    }

    private void loadPseudoClassDescriptor(@NotNull Element element) {
        String name = element.getAttributeValue("id");
        this.myDescriptors.pseudoSelectors.putValue((Object)StringUtil.toLowerCase((String)name), (Object)new CssPseudoClassDescriptorImpl());
    }

    private void loadPseudoElementDescriptor(@NotNull Element element) {
        String name = element.getAttributeValue("id");
        this.myDescriptors.pseudoSelectors.putValue((Object)StringUtil.toLowerCase((String)name), (Object)new CssPseudoElementDescriptorImpl());
    }

    private void checkCancelled() {
    }
}

