/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.psi.css.impl.parsing;

import fleet.com.intellij.indentation.OperationParserHelper;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.psi.css.CssBundle;
import fleet.com.intellij.psi.css.impl.CssElementTypes;
import fleet.com.intellij.psi.css.impl.parsing.CssParser;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssMathParser
implements OperationParserHelper.BinaryOperationParser {
    public static final TokenSet OPERATORS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_ASTERISK, CssElementTypes.CSS_SLASH, CssElementTypes.CSS_MINUS, CssElementTypes.CSS_PLUS});
    private static final TokenSet[] OPERATOR_PRIORITIES = new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_ASTERISK, CssElementTypes.CSS_SLASH}), TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_PLUS, CssElementTypes.CSS_MINUS})};
    private static final TokenSet STOP_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_ASTERISK, CssElementTypes.CSS_SLASH, CssElementTypes.CSS_MINUS, CssElementTypes.CSS_PLUS, CssElementTypes.CSS_SEMICOLON, CssElementTypes.CSS_RPAREN, CssElementTypes.CSS_RBRACE, CssElementTypes.CSS_COMMA});
    private static final TokenSet PREFIX_OPERATORS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_MINUS, CssElementTypes.CSS_PLUS});
    @NotNull
    private final CssParser myParser;
    private final IElementType @NotNull [] myOperationElementTypes;

    public CssMathParser(@NotNull CssParser parser) {
        this.myParser = parser;
        this.myOperationElementTypes = new IElementType[OPERATOR_PRIORITIES.length];
        for (int i = 0; i < OPERATOR_PRIORITIES.length; ++i) {
            this.myOperationElementTypes[i] = CssElementTypes.CSS_BINARY_OPERATION;
        }
    }

    public boolean parse() {
        return OperationParserHelper.callParsingBinaryOperation((OperationParserHelper.BinaryOperationParser)this, (int)(OPERATOR_PRIORITIES.length - 1));
    }

    public boolean parseSimpleExpression() {
        IElementType prevOperation = this.lookBehind(1);
        if (PREFIX_OPERATORS.contains(prevOperation)) {
            IElementType lookBehind2 = this.lookBehind(2);
            if (PREFIX_OPERATORS.contains(lookBehind2) && !this.getWhitespaceTokenSet().contains(this.lookBehindAndGetTokenBefore(1))) {
                this.mark().error(CssBundle.message("parsing.error.whitespace.expected", new Object[0]));
            } else if (!this.myParser.hasWhitespaceBefore()) {
                if (lookBehind2 != CssElementTypes.CSS_LPAREN && lookBehind2 != CssElementTypes.CSS_COMMA && !OPERATORS.contains(lookBehind2)) {
                    this.mark().error(CssBundle.message("parsing.error.whitespace.expected", new Object[0]));
                }
            } else if (OPERATORS.contains(lookBehind2) || lookBehind2 == CssElementTypes.CSS_LPAREN) {
                this.mark().error(CssBundle.message("parsing.error.unexpected.whitespace", new Object[0]));
            }
        }
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
            this.advance();
            boolean result = this.parse();
            if (this.getTokenType() == CssElementTypes.CSS_RPAREN) {
                this.advance();
            } else {
                this.mark().error(CssBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
            }
            return result;
        }
        PsiBuilder.Marker term = this.mark();
        if (this.parseTerm(prevOperation)) {
            term.done(CssElementTypes.CSS_TERM);
            this.afterParsedTerm();
            return true;
        }
        if (!STOP_ELEMENTS.contains(this.getTokenType())) {
            this.myParser.advanceUntil(STOP_ELEMENTS.getTypes());
        }
        term.error(CssBundle.message("parsing.error.term.expected", new Object[0]));
        return false;
    }

    protected void afterParsedTerm() {
        if (!STOP_ELEMENTS.contains(this.getTokenType())) {
            PsiBuilder.Marker error = this.mark();
            this.myParser.advanceUntil(STOP_ELEMENTS.getTypes());
            error.error(CssBundle.message("parsing.error.unexpected.term", new Object[0]));
        }
    }

    protected boolean parseTerm(@Nullable IElementType prevOperation) {
        if (this.getTokenType() == CssElementTypes.CSS_NUMBER) {
            PsiBuilder.Marker numberTerm = this.mark();
            this.advance();
            if (!this.myParser.hasWhitespaceBefore()) {
                IElementType type = this.getTokenType();
                boolean markAsError = prevOperation == CssElementTypes.CSS_SLASH;
                PsiBuilder.Marker possibleError = this.mark();
                if (this.myParser.isIdent() && type != CssElementTypes.CSS_MINUS) {
                    this.myParser.addIdentOrError();
                } else if (this.getTokenType() == CssElementTypes.CSS_PERCENT) {
                    this.advance();
                } else {
                    markAsError = false;
                }
                if (markAsError) {
                    possibleError.error(CssBundle.message("parsing.error.divider.should.be.a.number", new Object[0]));
                } else {
                    possibleError.drop();
                }
            }
            numberTerm.done(CssElementTypes.CSS_NUMBER_TERM);
        } else if (this.getTokenType() == CssElementTypes.CSS_IDENT && this.lookAhead(1) != CssElementTypes.CSS_PERIOD) {
            this.advance();
        } else if (!this.myParser.parseFunction(true)) {
            return false;
        }
        return true;
    }

    @Nullable
    private IElementType lookBehind(int steps) {
        int rawSteps = 0;
        IElementType type = null;
        for (int i = 0; i < steps; ++i) {
            type = this.myParser.rawLookup(--rawSteps);
            while (this.getWhitespaceTokenSet().contains(type)) {
                type = this.myParser.rawLookup(--rawSteps);
            }
        }
        return type;
    }

    @Nullable
    private IElementType lookBehindAndGetTokenBefore(int steps) {
        int rawSteps = 0;
        for (int i = 0; i < steps; ++i) {
            IElementType type = this.myParser.rawLookup(--rawSteps);
            while (this.getWhitespaceTokenSet().contains(type)) {
                type = this.myParser.rawLookup(--rawSteps);
            }
        }
        return this.myParser.rawLookup(rawSteps - 1);
    }

    public IElementType getTokenType() {
        return this.myParser.getTokenType();
    }

    public boolean isNewLine() {
        return false;
    }

    public void advance() {
        this.myParser.addSingleToken();
    }

    public IElementType rawLookup(int step) {
        return this.myParser.rawLookup(step);
    }

    public IElementType lookAhead(int step) {
        return this.myParser.lookAhead(step);
    }

    public PsiBuilder.Marker mark() {
        return this.myParser.createCompositeElement();
    }

    public void done(PsiBuilder.Marker marker, IElementType elementType) {
        marker.done(elementType);
    }

    public TokenSet getWhitespaceTokenSet() {
        return CssElementTypes.WHITESPACES;
    }

    public TokenSet getPrefixOperators() {
        return PREFIX_OPERATORS;
    }

    public TokenSet getPostfixOperators() {
        return TokenSet.EMPTY;
    }

    public TokenSet @NotNull [] getOperatorsByPriority() {
        return OPERATOR_PRIORITIES;
    }

    @Nullable
    public IElementType getPostfixExpressionElementType() {
        return null;
    }

    @Nullable
    public IElementType getPrefixExpressionElementType() {
        return CssElementTypes.CSS_UNARY_OPERATION;
    }

    public IElementType @NotNull [] getOperationElementTypes() {
        return this.myOperationElementTypes;
    }
}

