/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.runDestination.common.api;

import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import fleet.api.Directory;
import fleet.api.Location;
import fleet.api.LocationInFile;
import fleet.api.LocationKt;
import fleet.api.ProjectRootId;
import fleet.api.ProjectRootStatus;
import fleet.api.ProjectRootsHookApiKt;
import fleet.common.document.DocumentEntityKt;
import fleet.common.fs.SharedProjectRootEntity;
import fleet.common.fs.SharedProjectRootStatusEntity;
import fleet.common.run.api.DocumentBasedRunConfigEntity;
import fleet.common.run.api.ProvidedRunConfigEntity;
import fleet.common.run.api.RunConfigEntity;
import fleet.common.run.api.RunTaskConfigEntity;
import fleet.common.topology.ServiceProviderEntity;
import fleet.common.util.VersionedReferencesKt;
import fleet.plugins.runDestination.protocol.RunDestinationContext;
import fleet.protocol.run.TaskDescriptor;
import fleet.util.UID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"findRunDestinationContext", "Lfleet/plugins/runDestination/protocol/RunDestinationContext;", "runConfigEntity", "Lfleet/common/run/api/RunConfigEntity;", "root", "Lfleet/common/fs/SharedProjectRootEntity;", "provider", "Lfleet/common/topology/ServiceProviderEntity;", "projectId", "Lfleet/api/ProjectRootId;", "findProvidedRunConfigRunDestinationContext", "Lfleet/common/run/api/ProvidedRunConfigEntity;", "fleet.plugins.runDestination.common"})
@SourceDebugExtension(value={"SMAP\nRunDestinationContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunDestinationContext.kt\nfleet/plugins/runDestination/common/api/RunDestinationContextKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n295#2,2:62\n295#2,2:64\n1#3:66\n*S KotlinDebug\n*F\n+ 1 RunDestinationContext.kt\nfleet/plugins/runDestination/common/api/RunDestinationContextKt\n*L\n22#1:62,2\n56#1:64,2\n*E\n"})
public final class RunDestinationContextKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final RunDestinationContext findRunDestinationContext(@NotNull RunConfigEntity runConfigEntity, @NotNull SharedProjectRootEntity root) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)runConfigEntity, (String)"runConfigEntity");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Iterable iterable = EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)SharedProjectRootStatusEntity.Companion.getRootAttr()), (Object)root);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SharedProjectRootStatusEntity it = (SharedProjectRootStatusEntity)element$iv;
                boolean bl = false;
                if (!ProjectRootsHookApiKt.isReadyForRequests((ProjectRootStatus)it.getStatus())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        SharedProjectRootStatusEntity sharedProjectRootStatusEntity = v0;
        if (sharedProjectRootStatusEntity == null) {
            return null;
        }
        SharedProjectRootStatusEntity rootStatusEntity = sharedProjectRootStatusEntity;
        ServiceProviderEntity serviceProvider = rootStatusEntity.getProvider();
        return RunDestinationContextKt.findRunDestinationContext(serviceProvider, runConfigEntity, root.getId());
    }

    private static final RunDestinationContext findRunDestinationContext(ServiceProviderEntity provider, RunConfigEntity runConfigEntity, ProjectRootId projectId) {
        RunDestinationContext runDestinationContext;
        RunConfigEntity runConfigEntity2 = runConfigEntity;
        if (runConfigEntity2 instanceof DocumentBasedRunConfigEntity || runConfigEntity2 instanceof RunTaskConfigEntity) {
            TaskDescriptor taskDescriptor = new TaskDescriptor(runConfigEntity.getName(), runConfigEntity.getType());
            runDestinationContext = (RunDestinationContext)new RunDestinationContext.Descriptor(taskDescriptor, projectId, null, 4, null);
        } else {
            runDestinationContext = runConfigEntity2 instanceof ProvidedRunConfigEntity ? RunDestinationContextKt.findProvidedRunConfigRunDestinationContext(provider, (ProvidedRunConfigEntity)runConfigEntity) : null;
        }
        return runDestinationContext;
    }

    /*
     * WARNING - void declaration
     */
    private static final RunDestinationContext findProvidedRunConfigRunDestinationContext(ServiceProviderEntity provider, ProvidedRunConfigEntity runConfigEntity) {
        RunDestinationContext runDestinationContext;
        Location actualLocation = VersionedReferencesKt.rebase$default((Location)runConfigEntity.getLocation(), null, (int)1, null);
        if (actualLocation instanceof LocationInFile) {
            UID documentId = DocumentEntityKt.documentIdOrFail((Location)actualLocation);
            long offset = ((Number)LocationKt.navigationRange((Location)actualLocation).getFirst()).longValue();
            runDestinationContext = (RunDestinationContext)new RunDestinationContext.DocumentLocation(documentId, offset, null, 4, null);
        } else if (actualLocation instanceof Directory) {
            RunDestinationContext.Descriptor descriptor;
            Object v1;
            TaskDescriptor taskDescriptor;
            block7: {
                void $this$firstOrNull$iv;
                taskDescriptor = new TaskDescriptor(runConfigEntity.getName(), runConfigEntity.getType());
                Iterable iterable = EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)SharedProjectRootStatusEntity.Companion.getProviderAttr()), (Object)provider);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SharedProjectRootStatusEntity root = (SharedProjectRootStatusEntity)element$iv;
                    boolean bl = false;
                    if (!(!(root.getStatus() instanceof ProjectRootStatus.Ignored) && Intrinsics.areEqual((Object)root.getRoot().getFileAddress(), (Object)((Directory)actualLocation).getFileAddress()))) continue;
                    v1 = element$iv;
                    break block7;
                }
                v1 = null;
            }
            SharedProjectRootStatusEntity sharedProjectRootStatusEntity = v1;
            if (sharedProjectRootStatusEntity != null) {
                SharedProjectRootStatusEntity $this$findProvidedRunConfigRunDestinationContext_u24lambda_u242 = sharedProjectRootStatusEntity;
                boolean bl = false;
                descriptor = new RunDestinationContext.Descriptor(taskDescriptor, $this$findProvidedRunConfigRunDestinationContext_u24lambda_u242.getRoot().getId(), null, 4, null);
            } else {
                descriptor = null;
            }
            runDestinationContext = (RunDestinationContext)descriptor;
        } else {
            runDestinationContext = null;
        }
        return runDestinationContext;
    }
}

