/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.grazie.python;

import andel.text.TextRange;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.python.PyElementTypes;
import fleet.com.jetbrains.python.PyTokenTypes;
import fleet.plugins.grazie.frontend.TextContent;
import fleet.plugins.grazie.frontend.TextContentBuilder;
import fleet.plugins.grazie.frontend.TextContentBuilderKt;
import fleet.plugins.grazie.frontend.TextContentExtractor;
import fleet.plugins.grazie.python.PythonTextContentExtractor;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\f\u0010\u0011\u001a\u00020\r*\u00020\rH\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lfleet/plugins/grazie/python/PythonTextContentExtractor;", "Lfleet/plugins/grazie/frontend/TextContentExtractor;", "<init>", "()V", "sphinxDocStringTags", "", "", "[Ljava/lang/String;", "epydocStringTags", "KNOWN_DOCSTRING_TAGS_PATTERN", "DOCSTRING_DIRECTIVE_PATTERN", "Lkotlin/text/Regex;", "collectTextContent", "Lfleet/plugins/grazie/frontend/TextContent;", "root", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "(Lfleet/com/jetbrains/lang/syntax/SyntaxNode;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "excludeDocstringTags", "fleet.plugins.grazie.python"})
public final class PythonTextContentExtractor
implements TextContentExtractor {
    @NotNull
    public static final PythonTextContentExtractor INSTANCE = new PythonTextContentExtractor();
    @NotNull
    private static final String[] sphinxDocStringTags;
    @NotNull
    private static final String[] epydocStringTags;
    @NotNull
    private static final String KNOWN_DOCSTRING_TAGS_PATTERN;
    @NotNull
    private static final Regex DOCSTRING_DIRECTIVE_PATTERN;

    private PythonTextContentExtractor() {
    }

    @Nullable
    public Object collectTextContent(@NotNull SyntaxNode root, @NotNull Continuation<? super TextContent> $completion) {
        Object object = root.getType();
        IElementType iElementType = object instanceof IElementType ? (IElementType)object : null;
        if (iElementType == null) {
            return null;
        }
        IElementType type = iElementType;
        if (Intrinsics.areEqual((Object)type, (Object)PyElementTypes.FSTRING_NODE)) {
            return TextContentBuilderKt.buildTextContent((SyntaxNode)root, (Function1)collectTextContent.2.INSTANCE);
        }
        Object object2 = new TokenSet[]{PyTokenTypes.STRING_NODES};
        if (TokenSet.orSet((TokenSet[])object2).contains(type)) {
            object2 = TextContentBuilderKt.buildTextContent((SyntaxNode)root, (Function1)collectTextContent.3.INSTANCE);
            return object2 != null ? this.excludeDocstringTags((TextContent)object2) : null;
        }
        object2 = root.getType();
        if (Intrinsics.areEqual((Object)(object2 instanceof IElementType ? (IElementType)object2 : null), (Object)PyTokenTypes.END_OF_LINE_COMMENT)) {
            TextRange range2 = TextContentExtractor.Companion.findCloseSimilarSiblings(root, (Function1)collectTextContent.range.1.INSTANCE, (Function1)collectTextContent.range.2.INSTANCE);
            SyntaxNode syntaxNode = root.parent();
            if (syntaxNode == null) {
                return null;
            }
            SyntaxNode parent = syntaxNode;
            TextContent content2 = TextContentBuilderKt.buildTextContent((SyntaxNode)parent, (Function1)((Function1)new Function1<TextContentBuilder, Unit>(range2){
                final /* synthetic */ TextRange $range;
                {
                    this.$range = $range;
                    super(1);
                }

                public final void invoke(TextContentBuilder $this$buildTextContent) {
                    Intrinsics.checkNotNullParameter((Object)$this$buildTextContent, (String)"$this$buildTextContent");
                    $this$buildTextContent.withRange(this.$range);
                    $this$buildTextContent.removeIndents(" \t#");
                    $this$buildTextContent.removeLineSuffixes(" \t");
                }
            }));
            return content2;
        }
        return null;
    }

    private final TextContent excludeDocstringTags(TextContent $this$excludeDocstringTags) {
        return $this$excludeDocstringTags.excludeRanges(SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)DOCSTRING_DIRECTIVE_PATTERN, (CharSequence)$this$excludeDocstringTags.getText(), (int)0, (int)2, null), (Function1)excludeDocstringTags.1.INSTANCE)));
    }

    static {
        String[] stringArray = new String[]{":param", ":parameter", ":arg", ":argument", ":keyword", ":key", ":type", ":raise", ":raises", ":var", ":cvar", ":ivar", ":return", ":returns", ":rtype", ":except", ":exception"};
        sphinxDocStringTags = stringArray;
        stringArray = new String[]{"@param", "@type", "@return", "@rtype", "@keyword", "@raise", "@ivar", "@cvar", "@var", "@group", "@sort", "@note", "@attention", "@bug", "@warning", "@version", "@todo", "@deprecated", "@since", "@status", "@change", "@permission", "@requires", "@precondition", "@postcondition", "@invariant", "@author", "@organization", "@copyright", "@license", "@contact", "@summary", "@see"};
        epydocStringTags = stringArray;
        KNOWN_DOCSTRING_TAGS_PATTERN = ArraysKt.joinToString$default((Object[])ArraysKt.plus((Object[])sphinxDocStringTags, (Object[])epydocStringTags), (CharSequence)"|", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)KNOWN_DOCSTRING_TAGS_PATTERN.1.INSTANCE, (int)24, null);
        Pattern pattern = Pattern.compile("^" + KNOWN_DOCSTRING_TAGS_PATTERN + "[^\n:]*: *", 8);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        DOCSTRING_DIRECTIVE_PATTERN = new Regex(pattern);
    }
}

