/*
 * Decompiled with CFR 0.152.
 */
package fleet.ssh.frontend.mina;

import fleet.api.ExitStatus;
import fleet.rpc.core.Blob;
import fleet.ssh.frontend.mina.FleetSshConnectionKt;
import fleet.ssh.frontend.mina.OutputType;
import fleet.ssh.frontend.mina.ProcessOutputEntry;
import fleet.ssh.frontend.mina.SshExecCommand;
import fleet.util.async.CoroutineUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001BE\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0080@\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u0011\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0003H\u00c2\u0003JK\u0010\u001a\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0013H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lfleet/ssh/frontend/mina/SshExecCommand;", "", "stdout", "Lkotlinx/coroutines/channels/ReceiveChannel;", "Lfleet/rpc/core/Blob;", "stderr", "exitStatus", "Lkotlinx/coroutines/Deferred;", "Lfleet/api/ExitStatus;", "log", "Lfleet/ssh/frontend/mina/ProcessOutputEntry;", "<init>", "(Lkotlinx/coroutines/channels/ReceiveChannel;Lkotlinx/coroutines/channels/ReceiveChannel;Lkotlinx/coroutines/Deferred;Lkotlinx/coroutines/channels/ReceiveChannel;)V", "getStdout", "()Lkotlinx/coroutines/channels/ReceiveChannel;", "getStderr", "getExitStatus", "()Lkotlinx/coroutines/Deferred;", "collectLog", "", "collectLog$fleet_plugins_ssh_frontend", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "fleet.plugins.ssh.frontend"})
@SourceDebugExtension(value={"SMAP\nFleetSshConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FleetSshConnection.kt\nfleet/ssh/frontend/mina/SshExecCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,597:1\n1368#2:598\n1454#2,2:599\n1557#2:601\n1628#2,3:602\n1456#2,3:605\n3193#2,10:608\n*S KotlinDebug\n*F\n+ 1 FleetSshConnection.kt\nfleet/ssh/frontend/mina/SshExecCommand\n*L\n443#1:598\n443#1:599,2\n444#1:601\n444#1:602,3\n443#1:605,3\n445#1:608,10\n*E\n"})
public final class SshExecCommand {
    @NotNull
    private final ReceiveChannel<Blob> stdout;
    @NotNull
    private final ReceiveChannel<Blob> stderr;
    @NotNull
    private final Deferred<ExitStatus> exitStatus;
    @Nullable
    private final ReceiveChannel<ProcessOutputEntry> log;

    public SshExecCommand(@NotNull ReceiveChannel<Blob> stdout2, @NotNull ReceiveChannel<Blob> stderr, @NotNull Deferred<? extends ExitStatus> exitStatus2, @Nullable ReceiveChannel<ProcessOutputEntry> log) {
        Intrinsics.checkNotNullParameter(stdout2, (String)"stdout");
        Intrinsics.checkNotNullParameter(stderr, (String)"stderr");
        Intrinsics.checkNotNullParameter(exitStatus2, (String)"exitStatus");
        this.stdout = stdout2;
        this.stderr = stderr;
        this.exitStatus = exitStatus2;
        this.log = log;
    }

    public /* synthetic */ SshExecCommand(ReceiveChannel receiveChannel, ReceiveChannel receiveChannel2, Deferred deferred, ReceiveChannel receiveChannel3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            receiveChannel3 = null;
        }
        this((ReceiveChannel<Blob>)receiveChannel, (ReceiveChannel<Blob>)receiveChannel2, (Deferred<? extends ExitStatus>)deferred, (ReceiveChannel<ProcessOutputEntry>)receiveChannel3);
    }

    @NotNull
    public final ReceiveChannel<Blob> getStdout() {
        return this.stdout;
    }

    @NotNull
    public final ReceiveChannel<Blob> getStderr() {
        return this.stderr;
    }

    @NotNull
    public final Deferred<ExitStatus> getExitStatus() {
        return this.exitStatus;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object collectLog$fleet_plugins_ssh_frontend(@NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof collectLog.1)) ** GOTO lbl-1000
        var25_2 = $completion;
        if ((var25_2.label & -2147483648) != 0) {
            var25_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SshExecCommand this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.collectLog$fleet_plugins_ssh_frontend((Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var28_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.log == null) {
                    FleetSshConnectionKt.access$getLogger().warn((Object)"createReadOnlyEditorWithLog was called on SshExecCommand without log. `withLogging = true` should be passed to execNonInteractiveCommand!");
                    return null;
                }
                if (this.log.isClosedForReceive()) {
                    throw new IllegalStateException("createReadOnlyEditorWithLog can only be called once!".toString());
                }
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = CoroutineUtilsKt.awaitResult(this.exitStatus, (Continuation)$continuation);
                if (v0 == var28_4) {
                    return var28_4;
                }
                ** GOTO lbl27
            }
            case 1: {
                this = (SshExecCommand)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = ((Result)$result).unbox-impl();
lbl27:
                // 2 sources

                v1 = Result.isFailure-impl((Object)(var3_5 = v0)) != false ? null : var3_5;
                var26_6 = OutputType.Stdout;
                var27_7 = "Error while connecting via ssh. Command exited with status " + v1 + ".";
                prefix = new ProcessOutputEntry(var27_7, var26_6);
                var23_9 = CollectionsKt.listOf((Object)prefix);
                $continuation.L$0 = var23_9;
                $continuation.label = 2;
                v2 = FlowKt.toList$default((Flow)FlowKt.consumeAsFlow(this.log), null, (Continuation)$continuation, (int)1, null);
                if (v2 == var28_4) {
                    return var28_4;
                }
                ** GOTO lbl42
            }
            case 2: {
                var23_9 = (Collection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl42:
                // 2 sources

                var4_10 = (Iterable)v2;
                $i$f$flatMap = false;
                var6_13 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    entry = (ProcessOutputEntry)element$iv$iv;
                    $i$a$-flatMap-SshExecCommand$collectLog$2 = false;
                    $this$map$iv = StringsKt.lines((CharSequence)entry.getText());
                    $i$f$map = false;
                    var15_25 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var20_30 = (String)item$iv$iv;
                        var21_31 = destination$iv$iv;
                        $i$a$-map-SshExecCommand$collectLog$2$1 = false;
                        var21_31.add(new ProcessOutputEntry((String)it, entry.getType()));
                    }
                    list$iv$iv = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$partition$iv = CollectionsKt.plus((Collection)var23_9, (Iterable)((List)destination$iv$iv));
                $i$f$partition = false;
                first$iv = new ArrayList<T>();
                second$iv = new ArrayList<T>();
                for (T element$iv : $this$partition$iv) {
                    it = (ProcessOutputEntry)element$iv;
                    $i$a$-partition-SshExecCommand$collectLog$3 = false;
                    if (it.getType() == OutputType.Stdout) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                var3_5 = new Pair(first$iv, second$iv);
                stdout = (List)var3_5.component1();
                stderr = (List)var3_5.component2();
                stdoutText = CollectionsKt.joinToString$default((Iterable)stdout, (CharSequence)"\n", null, null, (int)0, null, (Function1)collectLog.stdoutText.1.INSTANCE, (int)30, null);
                stderrText = CollectionsKt.joinToString$default((Iterable)stderr, (CharSequence)"\n", null, null, (int)0, null, (Function1)collectLog.stderrText.1.INSTANCE, (int)30, null);
                return stdoutText + (String)(StringsKt.isBlank((CharSequence)stderrText) == false != false ? "\nError output:\n" + stderrText : "");
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final ReceiveChannel<Blob> component1() {
        return this.stdout;
    }

    @NotNull
    public final ReceiveChannel<Blob> component2() {
        return this.stderr;
    }

    @NotNull
    public final Deferred<ExitStatus> component3() {
        return this.exitStatus;
    }

    private final ReceiveChannel<ProcessOutputEntry> component4() {
        return this.log;
    }

    @NotNull
    public final SshExecCommand copy(@NotNull ReceiveChannel<Blob> stdout2, @NotNull ReceiveChannel<Blob> stderr, @NotNull Deferred<? extends ExitStatus> exitStatus2, @Nullable ReceiveChannel<ProcessOutputEntry> log) {
        Intrinsics.checkNotNullParameter(stdout2, (String)"stdout");
        Intrinsics.checkNotNullParameter(stderr, (String)"stderr");
        Intrinsics.checkNotNullParameter(exitStatus2, (String)"exitStatus");
        return new SshExecCommand(stdout2, stderr, exitStatus2, log);
    }

    public static /* synthetic */ SshExecCommand copy$default(SshExecCommand sshExecCommand2, ReceiveChannel receiveChannel, ReceiveChannel receiveChannel2, Deferred deferred, ReceiveChannel receiveChannel3, int n, Object object) {
        if ((n & 1) != 0) {
            receiveChannel = sshExecCommand2.stdout;
        }
        if ((n & 2) != 0) {
            receiveChannel2 = sshExecCommand2.stderr;
        }
        if ((n & 4) != 0) {
            deferred = sshExecCommand2.exitStatus;
        }
        if ((n & 8) != 0) {
            receiveChannel3 = sshExecCommand2.log;
        }
        return sshExecCommand2.copy(receiveChannel, receiveChannel2, deferred, receiveChannel3);
    }

    @NotNull
    public String toString() {
        return "SshExecCommand(stdout=" + this.stdout + ", stderr=" + this.stderr + ", exitStatus=" + this.exitStatus + ", log=" + this.log + ")";
    }

    public int hashCode() {
        int result2 = this.stdout.hashCode();
        result2 = result2 * 31 + this.stderr.hashCode();
        result2 = result2 * 31 + this.exitStatus.hashCode();
        result2 = result2 * 31 + (this.log == null ? 0 : this.log.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SshExecCommand)) {
            return false;
        }
        SshExecCommand sshExecCommand2 = (SshExecCommand)other;
        if (!Intrinsics.areEqual(this.stdout, sshExecCommand2.stdout)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.stderr, sshExecCommand2.stderr)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.exitStatus, sshExecCommand2.exitStatus)) {
            return false;
        }
        return Intrinsics.areEqual(this.log, sshExecCommand2.log);
    }
}

