/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.tokenizer.sentence;

import ai.grazie.Direction;
import ai.grazie.nlp.patterns.AggregatedPattern;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.patterns.RegexPattern;
import ai.grazie.nlp.patterns.standard.LikelyPatterns;
import ai.grazie.nlp.patterns.standard.StrictPatterns;
import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.rule.PatternSplitTokenizer;
import ai.grazie.nlp.tokenizer.sentence.StandardSentenceTokenizer;
import ai.grazie.nlp.utils.normalization.UnicodePunctuationNormalizer;
import ai.grazie.text.ExtensionsKt;
import ai.grazie.text.Text;
import ai.grazie.text.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000;\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\r\u001a\u00020\u0011H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "Lai/grazie/nlp/tokenizer/Tokenizer;", "splitByNewLinesNumber", "", "(Ljava/lang/Integer;)V", "newLineTokenizer", "Lai/grazie/nlp/tokenizer/rule/PatternSplitTokenizer;", "newLinesPattern", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$newLinesPattern$1", "(I)Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$newLinesPattern$1;", "tokenRanges", "", "Lai/grazie/text/TextRange;", "text", "", "tokenize", "Lai/grazie/nlp/tokenizer/Tokenizer$Token;", "Lai/grazie/text/Text;", "Companion", "nlp-tokenizer"})
@SourceDebugExtension(value={"SMAP\nStandardSentenceTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardSentenceTokenizer.kt\nai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1549#2:161\n1620#2,3:162\n1360#2:165\n1446#2,2:166\n1549#2:168\n1620#2,3:169\n1448#2,3:172\n*S KotlinDebug\n*F\n+ 1 StandardSentenceTokenizer.kt\nai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer\n*L\n148#1:161\n148#1:162,3\n154#1:165\n154#1:166,2\n155#1:168\n155#1:169,3\n154#1:172,3\n*E\n"})
public final class StandardSentenceTokenizer
implements Tokenizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PatternSplitTokenizer newLineTokenizer;
    @NotNull
    private static final StandardSentenceTokenizer Default = new StandardSentenceTokenizer(2);
    @NotNull
    private static final String quotes = "'\"`\u2018\u2019" + CollectionsKt.joinToString$default((Iterable)UnicodePunctuationNormalizer.Companion.getDoubleQuotes(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    @NotNull
    private static final Companion.Parenthetical.1 Parenthetical;
    @NotNull
    private static final Companion.Ellipsis.1 Ellipsis;
    @NotNull
    private static final Companion.ShortQuotationWithEllipsis.1 ShortQuotationWithEllipsis;
    @NotNull
    private static final Companion.QuotedIdWithTrailingDot.1 QuotedIdWithTrailingDot;
    @NotNull
    private static final Companion.SymbolsInQuotes.1 SymbolsInQuotes;
    @NotNull
    private static final AggregatedPattern ignore;
    @NotNull
    private static final String normalSentenceEnd;
    @NotNull
    private static final String romanBullet;
    @NotNull
    private static final String braceBulletContents = "[\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*";
    @NotNull
    private static final String braceBullet = "(^|\n)(\\([\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\)|\\[[\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\])";
    @NotNull
    private static final String spaceOrEnd = "\n+|\\s+|$";
    @NotNull
    private static final Regex sentenceContinuation;
    @NotNull
    private static final Companion.endPunctuation.1 endPunctuation;
    @NotNull
    private static final PatternSplitTokenizer punctuationTokenizer;

    public StandardSentenceTokenizer(@Nullable Integer splitByNewLinesNumber) {
        this.newLineTokenizer = splitByNewLinesNumber == null ? null : new PatternSplitTokenizer((Pattern)this.newLinesPattern(splitByNewLinesNumber), Direction.Right, null);
    }

    public /* synthetic */ StandardSentenceTokenizer(Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n);
    }

    private final newLinesPattern.1 newLinesPattern(int splitByNewLinesNumber) {
        Regex regex = new Regex("\n{" + splitByNewLinesNumber + ",}");
        return new RegexPattern(regex){

            @NotNull
            public List<TextRange> find(@NotNull CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return super.find(text);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Tokenizer.Token> tokenize(@NotNull Text text) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Iterable $this$map$iv = this.tokenRanges((CharSequence)text);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Tokenizer.Token(text.substring((TextRange)it), (TextRange)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextRange> tokenRanges(@NotNull CharSequence text) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object object = this.newLineTokenizer;
        if (object == null || (object = ((PatternSplitTokenizer)object).tokenRanges(text)) == null) {
            object = CollectionsKt.listOf((Object)new TextRange(0, text.length()));
        }
        Object hard = object;
        Iterable $this$flatMap$iv = (Iterable)hard;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            TextRange chunk = (TextRange)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = punctuationTokenizer.tokenRanges(text.subSequence(chunk.getStart(), chunk.getEndExclusive()));
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TextRange textRange = (TextRange)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(ExtensionsKt.withOffset((TextRange)it, (int)chunk.getStart()));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public StandardSentenceTokenizer() {
        this(null, 1, null);
    }

    public static final /* synthetic */ String access$getNormalSentenceEnd$cp() {
        return normalSentenceEnd;
    }

    public static final /* synthetic */ String access$getRomanBullet$cp() {
        return romanBullet;
    }

    public static final /* synthetic */ Regex access$getSentenceContinuation$cp() {
        return sentenceContinuation;
    }

    static {
        Pattern[] patternArray = new Pattern[]{StandardSentenceTokenizer.Companion.pairedParentheses(), StandardSentenceTokenizer.Companion.pairedDashes()};
        Pattern[] patternArray2 = patternArray;
        Parenthetical = new AggregatedPattern(patternArray2){

            @NotNull
            public List<TextRange> find(@NotNull CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return super.find(text);
            }
        };
        patternArray2 = new Regex("(^|[" + quotes + "]|\\s)(\\.{3,}|\u2026)($|[" + quotes + "]|\\s)|\\[(\\.{3,}|\u2026)\\]|\\.[ \u00a0]\\.[ \u00a0]\\.");
        Ellipsis = new RegexPattern((Regex)patternArray2){

            @NotNull
            public List<TextRange> find(@NotNull CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return super.find(text);
            }
        };
        patternArray2 = new Regex("[" + quotes + "][\\p{L}\\s\\d]{1,42}(\\.{3,}|\u2026)[" + quotes + "]\\s+\\p{Ll}");
        ShortQuotationWithEllipsis = new RegexPattern((Regex)patternArray2){

            @NotNull
            public List<TextRange> find(@NotNull CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return super.find(text);
            }
        };
        patternArray2 = new Regex("[" + quotes + "]\\p{L}+\\.[" + quotes + "]([,;:]|\\s+\\p{Ll})");
        QuotedIdWithTrailingDot = new RegexPattern((Regex)patternArray2){

            @NotNull
            public List<TextRange> find(@NotNull CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return super.find(text);
            }
        };
        patternArray2 = new Regex("[" + quotes + "][^\\s\\p{L}]*[" + quotes + "]");
        SymbolsInQuotes = new RegexPattern((Regex)patternArray2){

            @NotNull
            public List<TextRange> find(@NotNull CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return super.find(text);
            }
        };
        patternArray2 = new Pattern[]{Parenthetical, Ellipsis, ShortQuotationWithEllipsis, SymbolsInQuotes, QuotedIdWithTrailingDot, LikelyPatterns.NameInitials, LikelyPatterns.ActionNameEllipsis, LikelyPatterns.PunctuationOperator, LikelyPatterns.IsEmail, LikelyPatterns.IsAbbreviation, LikelyPatterns.IsOrdinalNumeral, LikelyPatterns.IsIPv4, LikelyPatterns.IsURL, LikelyPatterns.IsFilePath, StrictPatterns.INSTANCE.getIsUUID()};
        ignore = new AggregatedPattern(patternArray2);
        normalSentenceEnd = "[?!.]+[)}\\]" + quotes + "]?";
        String string2 = "IVXLMCD".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        romanBullet = "(^|\n)([IVXLMCD]{1,4}|[" + string2 + "]{1,4})\\)";
        Companion $this$sentenceContinuation_u24lambda_u243 = Companion;
        boolean bl = false;
        String dashes = "(\\s+[-\u2013\u2014]+)";
        String emotionalPunctuation = "([?!]\\.*|([:;]-?[()]+))";
        String directSpeechEnd = "(\\?[" + quotes + "]|!(\\.+[" + quotes + "]?|\\.*[" + quotes + "])|\\.{3,}[" + quotes + "?]*)";
        sentenceContinuation = new Regex("(" + directSpeechEnd + dashes + "?|" + emotionalPunctuation + dashes + ")\\s+([\\[({<])?\\p{Ll}");
        endPunctuation = new Pattern(){
            @NotNull
            private final char[] startChars;
            @NotNull
            private final Regex regex;
            {
                char[] cArray = "?!.:;\n".toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                this.startChars = cArray;
                this.regex = new Regex("(" + StandardSentenceTokenizer.access$getNormalSentenceEnd$cp() + "|" + StandardSentenceTokenizer.access$getRomanBullet$cp() + "|(^|\n)(\\([\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\)|\\[[\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\]))(\n+|\\s+|$)|([:;]-?[()]+)(\n+|\\s+|$|" + StandardSentenceTokenizer.access$getNormalSentenceEnd$cp() + ")+");
            }

            @NotNull
            public List<TextRange> find(@NotNull CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                int offset = 0;
                ArrayList<TextRange> result = new ArrayList<TextRange>();
                while (offset >= 0) {
                    MatchResult mr = this.regex.matchAt(text, offset);
                    if (mr != null) {
                        if (!StandardSentenceTokenizer.access$getSentenceContinuation$cp().matchesAt(text, offset)) {
                            result.add(TextRange.Companion.invoke(mr.getRange()));
                        }
                        offset = mr.getRange().getLast() + 1;
                    }
                    offset = StringsKt.indexOfAny$default((CharSequence)text, (char[])this.startChars, (int)(offset + 1), (boolean)false, (int)4, null);
                }
                return result;
            }
        };
        punctuationTokenizer = new PatternSplitTokenizer(endPunctuation, Direction.Right, (Pattern)ignore);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0006\b\u000b\u000e\u0011\u0014\u001a\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020)H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion;", "", "()V", "Default", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "getDefault", "()Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "Ellipsis", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$Ellipsis$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$Ellipsis$1;", "Parenthetical", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$Parenthetical$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$Parenthetical$1;", "QuotedIdWithTrailingDot", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$QuotedIdWithTrailingDot$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$QuotedIdWithTrailingDot$1;", "ShortQuotationWithEllipsis", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$ShortQuotationWithEllipsis$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$ShortQuotationWithEllipsis$1;", "SymbolsInQuotes", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$SymbolsInQuotes$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$SymbolsInQuotes$1;", "braceBullet", "", "braceBulletContents", "endPunctuation", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$endPunctuation$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$endPunctuation$1;", "ignore", "Lai/grazie/nlp/patterns/AggregatedPattern;", "normalSentenceEnd", "punctuationTokenizer", "Lai/grazie/nlp/tokenizer/rule/PatternSplitTokenizer;", "quotes", "romanBullet", "sentenceContinuation", "Lkotlin/text/Regex;", "spaceOrEnd", "pairedDashes", "Lai/grazie/nlp/patterns/Pattern;", "pairedParentheses", "Lai/grazie/nlp/patterns/RegexPattern;", "nlp-tokenizer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StandardSentenceTokenizer getDefault() {
            return Default;
        }

        private final RegexPattern pairedParentheses() {
            String noParentheses = "[^()]";
            String nestedParentheses = "\\(" + noParentheses + "{1,500}\\)" + noParentheses + "{0,500}";
            return new RegexPattern(new Regex("\\(" + noParentheses + "{1,500}(" + nestedParentheses + ")*\\)"));
        }

        private final Pattern pairedDashes() {
            Regex dashRegex = new Regex("\\s+[-\u2013\u2014]+\\s+([^-\u2013\u2014]{1,100})\\s+[-\u2013\u2014]+\\s+");
            Regex smileyRegex = new Regex("[:;]-?[()]+");
            return (Pattern)new RegexPattern(dashRegex, smileyRegex){
                final /* synthetic */ Regex $dashRegex;
                final /* synthetic */ Regex $smileyRegex;
                {
                    this.$dashRegex = $dashRegex;
                    this.$smileyRegex = $smileyRegex;
                    super($dashRegex);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public List<TextRange> find(@NotNull CharSequence text) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    Iterable iterable = super.find(text);
                    Regex regex = this.$dashRegex;
                    Regex regex2 = this.$smileyRegex;
                    boolean $i$f$filter = false;
                    void var6_6 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        TextRange it = (TextRange)element$iv$iv;
                        boolean bl = false;
                        CharSequence withDashes = text.subSequence(it.getStart(), it.getEndExclusive());
                        MatchResult matchResult = regex.matchEntire(withDashes);
                        Intrinsics.checkNotNull((Object)matchResult);
                        String withoutDashes = (String)matchResult.getGroupValues().get(1);
                        if (!(Regex.find$default((Regex)regex2, (CharSequence)withoutDashes, (int)0, (int)2, null) == null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

