/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tooling.core.impl;

import org.clang.tooling.core.Replacement;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Unsigned;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.llvm;

public class MergedReplacement
implements Destructors.ClassWithDestructor {
    private boolean MergeSecond;
    private int Delta;
    private int DeltaFirst;
    private StringRef FilePath;
    private int Offset;
    private int Length;
    private std.string Text;

    public MergedReplacement(Replacement R, boolean MergeSecond, int D) {
        this.MergeSecond = MergeSecond;
        this.Delta = D;
        this.FilePath = R.getFilePath();
        this.Offset = R.getOffset() + (MergeSecond ? 0 : this.Delta);
        this.Length = R.getLength();
        this.Text = R.getReplacementText().$string();
        this.Delta += MergeSecond ? 0 : this.Text.size() - this.Length;
        this.DeltaFirst = MergeSecond ? this.Text.size() - this.Length : 0;
    }

    public void merge(Replacement R) {
        if (this.MergeSecond) {
            int End;
            int REnd = R.getOffset() + this.Delta + R.getLength();
            if (Unsigned.$greater_uint((int)REnd, (int)(End = this.Offset + this.Text.size()))) {
                this.Length += REnd - End;
                this.MergeSecond = false;
            }
            StringRef TextRef = new StringRef(this.Text);
            StringRef Head = TextRef.substr(0, R.getOffset() + this.Delta - this.Offset);
            StringRef Tail = TextRef.substr(REnd - this.Offset);
            this.Text.$assignMove(llvm.$add_Twine$C((Twine)llvm.$add_Twine$C((Twine)new Twine(Head), (Twine)new Twine(R.getReplacementText())), (Twine)new Twine(Tail)).str());
            this.Delta += R.getReplacementText().size() - R.getLength();
        } else {
            int End = this.Offset + this.Length;
            StringRef RText = R.getReplacementText();
            StringRef Tail = RText.substr(End - R.getOffset());
            this.Text.$assignMove(llvm.$add_Twine$C((Twine)new Twine(this.Text), (Twine)new Twine(Tail)).str());
            if (Unsigned.$greater_uint((int)(R.getOffset() + RText.size()), (int)End)) {
                this.Length = R.getOffset() + R.getLength() - this.Offset;
                this.MergeSecond = true;
            } else {
                this.Length += R.getLength() - RText.size();
            }
            this.DeltaFirst += RText.size() - R.getLength();
        }
    }

    public boolean endsBefore(Replacement R) {
        if (this.MergeSecond) {
            return Unsigned.$less_uint((int)(this.Offset + this.Text.size()), (int)(R.getOffset() + this.Delta));
        }
        return Unsigned.$less_uint((int)(this.Offset + this.Length), (int)R.getOffset());
    }

    public boolean mergeSecond() {
        return this.MergeSecond;
    }

    public int deltaFirst() {
        return this.DeltaFirst;
    }

    public Replacement asReplacement() {
        return new Replacement(new StringRef(this.FilePath), this.Offset, this.Length, new StringRef(this.Text));
    }

    public void $destroy() {
        this.Text.$destroy();
    }

    public String toString() {
        return "MergeSecond=" + this.MergeSecond + ", Delta=" + this.Delta + ", DeltaFirst=" + this.DeltaFirst + ", FilePath=" + this.FilePath + ", Offset=" + this.Offset + ", Length=" + this.Length + ", Text=" + this.Text;
    }
}

