/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.code.snippets;

import andel.UtilsKt;
import andel.editor.Caret;
import andel.editor.DocumentExtKt;
import andel.editor.MutableDocument;
import andel.editor.MutableEditor;
import andel.intervals.Interval;
import andel.intervals.Intervals;
import andel.text.LineNumberKt;
import andel.text.TextFragment;
import andel.text.TextLine;
import andel.text.TextRange;
import andel.text.TextView;
import andel.text.TextViewExtKt;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.Entity;
import fleet.ast.AST;
import fleet.ast.SyntaxDocumentComponentKt;
import fleet.common.document.EditorEntity;
import fleet.frontend.code.snippets.LineIndentation;
import fleet.frontend.code.snippets.Marker;
import fleet.frontend.code.snippets.PlaceholderData;
import fleet.frontend.code.snippets.SnippetBorder;
import fleet.frontend.code.snippets.SnippetComponentEntity;
import fleet.frontend.code.snippets.Text;
import fleet.frontend.code.snippets.TextmateSnippet;
import fleet.frontend.editor.editorconfig.EditorConfigs;
import fleet.frontend.lang.Indenter;
import fleet.frontend.lang.IndentingMode;
import fleet.frontend.lang.indent.IndentKt;
import fleet.util.UID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.LongIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import noria.model.components.editor.MarkupData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0002\u001a\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u001c\u0010\u000b\u001a\u00020\u0006*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a&\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00120\u00170\u0016*\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0014H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"INDENTATION_SYMBOLS", "", "isMultiline", "", "Lfleet/frontend/code/snippets/TextmateSnippet;", "indentOtherLinesBasedOnFirst", "", "editor", "Lfleet/common/document/EditorEntity;", "caret", "Landel/editor/Caret;", "reindentSnippetLines", "Landel/editor/MutableEditor;", "snippet", "Lfleet/frontend/code/snippets/SnippetComponentEntity;", "editorConfig", "Lfleet/frontend/editor/editorconfig/EditorConfigs;", "visibleBorders", "Landel/text/TextRange;", "snippetUID", "Lfleet/util/UID;", "placeholdersIndexToBorders", "", "Lkotlin/Pair;", "", "snippetId", "fleet.code.frontend"})
@SourceDebugExtension(value={"SMAP\nSnippetFormatting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnippetFormatting.kt\nfleet/frontend/code/snippets/SnippetFormattingKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,135:1\n648#2,5:136\n1611#3,9:141\n1863#3:150\n1864#3:153\n1620#3:154\n1368#3:155\n1454#3,2:156\n1557#3:158\n1628#3,3:159\n1062#3:162\n1202#3,2:163\n1230#3,4:165\n1557#3:169\n1628#3,3:170\n1456#3,3:173\n1062#3:176\n1863#3,2:177\n1#4:151\n1#4:152\n183#5,2:179\n*S KotlinDebug\n*F\n+ 1 SnippetFormatting.kt\nfleet/frontend/code/snippets/SnippetFormattingKt\n*L\n47#1:136,5\n70#1:141,9\n70#1:150\n70#1:153\n70#1:154\n74#1:155\n74#1:156,2\n78#1:158\n78#1:159,3\n79#1:162\n80#1:163,2\n80#1:165,4\n83#1:169\n83#1:170,3\n74#1:173,3\n102#1:176\n103#1:177,2\n70#1:152\n117#1:179,2\n*E\n"})
public final class SnippetFormattingKt {
    @NotNull
    private static final char[] INDENTATION_SYMBOLS;

    private static final boolean isMultiline(TextmateSnippet $this$isMultiline) {
        Ref.BooleanRef foundNewLine = new Ref.BooleanRef();
        $this$isMultiline.walk((Function1<? super Marker, Boolean>)((Function1)new Function1<Marker, Boolean>(foundNewLine){
            final /* synthetic */ Ref.BooleanRef $foundNewLine;
            {
                this.$foundNewLine = $foundNewLine;
                super(1);
            }

            public final Boolean invoke(Marker marker) {
                Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                if (marker instanceof Text && StringsKt.contains$default((CharSequence)((Text)marker).getValue(), (CharSequence)"\n", (boolean)false, (int)2, null)) {
                    this.$foundNewLine.element = true;
                }
                return !this.$foundNewLine.element;
            }
        }));
        return foundNewLine.element;
    }

    public static final void indentOtherLinesBasedOnFirst(@NotNull TextmateSnippet $this$indentOtherLinesBasedOnFirst, @NotNull EditorEntity editor2, @NotNull Caret caret) {
        Intrinsics.checkNotNullParameter((Object)$this$indentOtherLinesBasedOnFirst, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        boolean preformatNeeded = SnippetFormattingKt.isMultiline($this$indentOtherLinesBasedOnFirst);
        if (preformatNeeded && EntitiesKt.exists((Entity)((Entity)editor2))) {
            String string;
            block2: {
                String lineStartText;
                TextLine currentLine = TextViewExtKt.textLines$default((TextView)editor2.getDocument().getText().view(), (boolean)false, (int)1, null).atCharOffset(caret.getOffset());
                String $this$takeWhile$iv = lineStartText = editor2.getDocument().getText().view().string((int)currentLine.getFromChar(), (int)caret.getOffset());
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (ArraysKt.contains((char[])INDENTATION_SYMBOLS, (char)it)) continue;
                    String string2 = $this$takeWhile$iv;
                    int n2 = 0;
                    String string3 = string2.substring(n2, index$iv);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    break block2;
                }
                string = $this$takeWhile$iv;
            }
            String indentationPrefix = string;
            String replacement = "\n" + indentationPrefix;
            $this$indentOtherLinesBasedOnFirst.walk((Function1<? super Marker, Boolean>)((Function1)new Function1<Marker, Boolean>(replacement){
                final /* synthetic */ String $replacement;
                {
                    this.$replacement = $replacement;
                    super(1);
                }

                public final Boolean invoke(Marker marker) {
                    Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                    if (marker instanceof Text) {
                        ((Text)marker).setValue(StringsKt.replace$default((String)((Text)marker).getValue(), (String)"\n", (String)this.$replacement, (boolean)false, (int)4, null));
                    }
                    return true;
                }
            }));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void reindentSnippetLines(@NotNull MutableEditor $this$reindentSnippetLines, @NotNull SnippetComponentEntity snippet, @NotNull EditorConfigs editorConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$reindentSnippetLines, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)snippet, (String)"snippet");
        Intrinsics.checkNotNullParameter((Object)editorConfig, (String)"editorConfig");
        Indenter indenter = IndentKt.getIndenter((MutableDocument)$this$reindentSnippetLines.getDocument());
        if (indenter != null && !((Collection)SyntaxDocumentComponentKt.getSyntaxDocumentComponents((MutableDocument)$this$reindentSnippetLines.getDocument())).isEmpty()) {
            void $this$forEach$iv;
            Iterable $this$sortedByDescending$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Iterable iterable = snippet.getSnippetIds();
            boolean $i$f$mapNotNull = false;
            Iterator iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Pair pair = $this$forEach$iv$iv$iv.iterator();
            while (pair.hasNext()) {
                Pair pair2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = pair.next();
                boolean bl = false;
                UID id = (UID)element$iv$iv;
                boolean bl2 = false;
                TextRange border = SnippetFormattingKt.visibleBorders(snippet, id);
                if (border != null) {
                    boolean bl3 = false;
                    pair2 = TuplesKt.to((Object)id, (Object)border);
                } else {
                    pair2 = null;
                }
                if (pair2 == null) continue;
                Pair it$iv$iv = pair2;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                void $this$associateByTo$iv$iv;
                Iterable $this$associateBy$iv;
                Iterable $this$sortedByDescending$iv2;
                Object object;
                Object item$iv$iv2;
                void $this$mapTo$iv$iv2;
                pair = (Pair)element$iv$iv;
                boolean bl = false;
                UID snippetId = (UID)pair.component1();
                TextRange border = (TextRange)pair.component2();
                long firstLine = TextViewExtKt.textLines((TextView)$this$reindentSnippetLines.getDocument().getText().view(), (boolean)true).offsetToLineNumber(border.getStart());
                long lastLine = TextViewExtKt.textLines((TextView)$this$reindentSnippetLines.getDocument().getText().view(), (boolean)true).offsetToLineNumber(border.getEnd());
                Iterable $this$map$iv = SnippetFormattingKt.placeholdersIndexToBorders(snippet, snippetId);
                boolean $i$f$map = false;
                Iterable bl4 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    Pair pair3 = (Pair)item$iv$iv2;
                    object = destination$iv$iv2;
                    boolean bl5 = false;
                    TextRange range = (TextRange)pair3.component2();
                    object.add(range);
                }
                $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$sortedByDescending = false;
                $this$sortedByDescending$iv2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        TextRange it = (TextRange)b;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getStart());
                        it = (TextRange)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getStart()));
                    }
                });
                boolean $i$f$associateBy = false;
                int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                destination$iv$iv2 = $this$associateBy$iv;
                Map destination$iv$iv3 = new LinkedHashMap(capacity$iv22);
                boolean $i$f$associateByTo = false;
                item$iv$iv2 = $this$associateByTo$iv$iv.iterator();
                while (item$iv$iv2.hasNext()) {
                    void it;
                    Object element$iv$iv2 = item$iv$iv2.next();
                    TextRange bl5 = (TextRange)element$iv$iv2;
                    object = destination$iv$iv3;
                    boolean bl6 = false;
                    object.put(TextViewExtKt.textLines((TextView)$this$reindentSnippetLines.getDocument().getText().view(), (boolean)true).offsetToLineNumber(it.getStart()), element$iv$iv2);
                }
                Map leftMostPlaceholderByLine = destination$iv$iv3;
                $this$associateBy$iv = (Iterable)new LongRange(firstLine + 1L, lastLine);
                $i$f$map = false;
                Iterable capacity$iv22 = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void lineNumber;
                    long l = item$iv$iv = ((LongIterator)iterator2).nextLong();
                    object = destination$iv$iv2;
                    boolean bl7 = false;
                    TextLine line = TextViewExtKt.textLine-g54jA0s$default((TextView)$this$reindentSnippetLines.getDocument().getText().view(), (int)LineNumberKt.getLine((long)lineNumber), (boolean)false, (int)2, null);
                    TextFragment realTextFragment = UtilsKt.dropLeadingWhitespace((TextFragment)((TextFragment)line));
                    TextRange textRange = (TextRange)leftMostPlaceholderByLine.get((long)lineNumber);
                    Long leftMostPlaceholderStart = textRange != null ? Long.valueOf(textRange.getStart()) : null;
                    Object[] objectArray = new Long[]{realTextFragment.getFromChar(), line.getToCharExcludingSeparator(), leftMostPlaceholderStart};
                    List candidates = CollectionsKt.listOfNotNull((Object[])objectArray);
                    Comparable comparable = CollectionsKt.minOrNull((Iterable)candidates);
                    Intrinsics.checkNotNull((Object)comparable);
                    long leftMostReasonableOffset = ((Number)((Object)comparable)).longValue();
                    MutableDocument mutableDocument = $this$reindentSnippetLines.getDocument();
                    AST aST = SyntaxDocumentComponentKt.getActualAstAtOffset$default((MutableEditor)$this$reindentSnippetLines, (long)leftMostReasonableOffset, (long)0L, (long)0L, (int)6, null);
                    Intrinsics.checkNotNull((Object)aST);
                    String desiredIndent = IndentKt.desiredIndent((long)leftMostReasonableOffset, (MutableDocument)mutableDocument, (AST)aST, (EditorConfigs)editorConfig, (Indenter)indenter, (IndentingMode)IndentingMode.ADJUST_EXISTING_LINE);
                    object.add(new LineIndentation(desiredIndent, (long)lineNumber, leftMostReasonableOffset));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List expectedIndentations = (List)destination$iv$iv;
            $this$flatMap$iv = expectedIndentations;
            boolean $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    LineIndentation it = (LineIndentation)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getLineNumber());
                    it = (LineIndentation)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getLineNumber()));
                }
            });
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                LineIndentation lineIndentation = (LineIndentation)element$iv;
                boolean bl = false;
                String desiredIndent = lineIndentation.component1();
                long lineNumber = lineIndentation.component2();
                long leftMostReasonableOffset = lineIndentation.component3();
                TextLine line = TextViewExtKt.textLine-g54jA0s$default((TextView)$this$reindentSnippetLines.getDocument().getText().view(), (int)LineNumberKt.getLine((long)lineNumber), (boolean)false, (int)2, null);
                if (line.getFromChar() == line.getToCharExcludingSeparator()) {
                    DocumentExtKt.replaceRange((MutableDocument)$this$reindentSnippetLines.getDocument(), (TextRange)new TextRange(line.getFromChar() - 1L, line.getFromChar()), (String)("\n" + desiredIndent));
                    continue;
                }
                DocumentExtKt.replaceRange((MutableDocument)$this$reindentSnippetLines.getDocument(), (TextRange)new TextRange(line.getFromChar(), leftMostReasonableOffset), (String)desiredIndent);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final TextRange visibleBorders(@NotNull SnippetComponentEntity $this$visibleBorders, @NotNull UID snippetUID) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$visibleBorders, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)snippetUID, (String)"snippetUID");
            Intervals<Long, ? extends MarkupData> intervals2 = $this$visibleBorders.getIntervals();
            if (intervals2 == null) return null;
            Sequence sequence2 = intervals2.query(0L, Long.MAX_VALUE);
            if (sequence2 == null) return null;
            Sequence $this$firstOrNull$iv = sequence2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Interval interval = (Interval)element$iv;
                boolean bl = false;
                MarkupData data = (MarkupData)interval.data;
                if (!(data instanceof SnippetBorder && Intrinsics.areEqual((Object)((SnippetBorder)data).getSnippetId(), (Object)snippetUID))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Interval interval = v0;
        if (interval == null) return null;
        Interval it = interval;
        boolean bl = false;
        TextRange textRange = new TextRange(it.from, it.to);
        return textRange;
    }

    @NotNull
    public static final List<Pair<Integer, TextRange>> placeholdersIndexToBorders(@NotNull SnippetComponentEntity $this$placeholdersIndexToBorders, @NotNull UID snippetId) {
        Intrinsics.checkNotNullParameter((Object)$this$placeholdersIndexToBorders, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)snippetId, (String)"snippetId");
        Sequence sequence2 = $this$placeholdersIndexToBorders.getIntervals();
        if (sequence2 == null || (sequence2 = sequence2.query(0L, Long.MAX_VALUE)) == null) {
            sequence2 = SequencesKt.emptySequence();
        }
        Sequence baseSequence = sequence2;
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)baseSequence, (Function1)((Function1)new Function1<Interval<? extends Long, ? extends MarkupData>, Pair<? extends Integer, ? extends TextRange>>(snippetId){
            final /* synthetic */ UID $snippetId;
            {
                this.$snippetId = $snippetId;
                super(1);
            }

            public final Pair<Integer, TextRange> invoke(Interval<Long, ? extends MarkupData> interval) {
                PlaceholderData data;
                Intrinsics.checkNotNullParameter(interval, (String)"interval");
                Object object = interval.data;
                PlaceholderData placeholderData = data = object instanceof PlaceholderData ? (PlaceholderData)object : null;
                return Intrinsics.areEqual((Object)(placeholderData != null ? placeholderData.getSnippetId() : null), (Object)this.$snippetId) ? TuplesKt.to((Object)data.getPlaceholderIndex(), (Object)new TextRange(interval.from, interval.to)) : null;
            }
        })));
    }

    static {
        char[] cArray = new char[]{' ', '\t'};
        INDENTATION_SYMBOLS = cArray;
    }
}

