/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.code.snippets;

import fleet.frontend.code.snippets.Token;
import fleet.frontend.code.snippets.TokenType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u001aJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u001cR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\u0005\u00a8\u0006\u001e"}, d2={"Lfleet/frontend/code/snippets/Scanner;", "", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "setValue", "pos", "", "getPos", "()I", "setPos", "(I)V", "newValue", "text", "getText", "setText", "tokenText", "token", "Lfleet/frontend/code/snippets/Token;", "next", "get", "", "len", "(I)Ljava/lang/Character;", "allTokens", "", "Companion", "fleet.code.frontend"})
public final class Scanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String value;
    private int pos;
    @NotNull
    private static final Map<Character, TokenType> table;

    public Scanner(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.value = value2;
    }

    public /* synthetic */ Scanner(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string);
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    public final void setValue(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.value = string;
    }

    public final int getPos() {
        return this.pos;
    }

    public final void setPos(int n) {
        this.pos = n;
    }

    @NotNull
    public final String getText() {
        return this.value;
    }

    public final void setText(@NotNull String newValue2) {
        Intrinsics.checkNotNullParameter((Object)newValue2, (String)"newValue");
        this.value = newValue2;
        this.pos = 0;
    }

    @NotNull
    public final String tokenText(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        String string = this.value.substring(token.getPos(), token.getPos() + token.getLen());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @NotNull
    public final Token next() {
        if (this.pos >= this.value.length()) {
            return new Token(TokenType.EOF, this.pos, 0);
        }
        int tokenPos = this.pos;
        int len = 0;
        Character ch = this.get(this.pos);
        TokenType type = table.get(ch);
        if (type != null) {
            ++this.pos;
            return new Token(type, tokenPos, 1);
        }
        if (Companion.isDigitCharacter(ch)) {
            type = TokenType.Int;
            while (Companion.isDigitCharacter(ch = this.get(tokenPos + ++len))) {
            }
            this.pos += len;
            return new Token(type, tokenPos, len);
        }
        if (Companion.isVariableCharacter(ch)) {
            type = TokenType.VariableName;
            while (Companion.isVariableCharacter(ch = this.get(tokenPos + ++len)) || Companion.isDigitCharacter(ch)) {
            }
            this.pos += len;
            return new Token(type, tokenPos, len);
        }
        type = TokenType.Format;
        while ((ch = this.get(tokenPos + ++len)) != null && table.get(ch) == null && !Companion.isDigitCharacter(ch) && !Companion.isVariableCharacter(ch)) {
        }
        this.pos += len;
        return new Token(type, tokenPos, len);
    }

    private final Character get(int len) {
        if (len >= this.value.length()) {
            return null;
        }
        return Character.valueOf(this.value.charAt(len));
    }

    @NotNull
    public final List<Token> allTokens() {
        Token t;
        List tokens = new ArrayList();
        do {
            t = this.next();
            tokens.add(t);
        } while (t.getType() != TokenType.EOF);
        return tokens;
    }

    public Scanner() {
        this(null, 1, null);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('$'), (Object)((Object)TokenType.Dollar)), TuplesKt.to((Object)Character.valueOf(':'), (Object)((Object)TokenType.Colon)), TuplesKt.to((Object)Character.valueOf(','), (Object)((Object)TokenType.Comma)), TuplesKt.to((Object)Character.valueOf('{'), (Object)((Object)TokenType.CurlyOpen)), TuplesKt.to((Object)Character.valueOf('}'), (Object)((Object)TokenType.CurlyClose)), TuplesKt.to((Object)Character.valueOf('\\'), (Object)((Object)TokenType.Backslash)), TuplesKt.to((Object)Character.valueOf('/'), (Object)((Object)TokenType.Forwardslash)), TuplesKt.to((Object)Character.valueOf('|'), (Object)((Object)TokenType.Pipe)), TuplesKt.to((Object)Character.valueOf('+'), (Object)((Object)TokenType.Plus)), TuplesKt.to((Object)Character.valueOf('-'), (Object)((Object)TokenType.Dash)), TuplesKt.to((Object)Character.valueOf('?'), (Object)((Object)TokenType.QuestionMark))};
        table = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u000bR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lfleet/frontend/code/snippets/Scanner$Companion;", "", "<init>", "()V", "table", "", "", "Lfleet/frontend/code/snippets/TokenType;", "isDigitCharacter", "", "ch", "(Ljava/lang/Character;)Z", "isVariableCharacter", "fleet.code.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isDigitCharacter(@Nullable Character ch) {
            CharRange charRange = new CharRange('0', '9');
            return ch != null && charRange.contains(ch.charValue());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isVariableCharacter(@Nullable Character ch) {
            Character c = ch;
            char c2 = '_';
            if (c != null) {
                if (c.charValue() == c2) return true;
            }
            CharRange charRange = new CharRange('a', 'z');
            if (ch != null && charRange.contains(ch.charValue())) {
                return true;
            }
            boolean bl = false;
            if (bl) return true;
            charRange = new CharRange('A', 'Z');
            if (ch == null) return false;
            if (!charRange.contains(ch.charValue())) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

