/*
 * Decompiled with CFR 0.152.
 */
package fleet.org.jetbrains.plugins.scss.parser;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.openapi.util.Pair;
import fleet.com.intellij.psi.css.CssBundle;
import fleet.com.intellij.psi.css.impl.CssElementTypes;
import fleet.com.intellij.psi.css.impl.CssStubElementTypes;
import fleet.com.intellij.psi.css.impl.parsing.CssBlockSkipper;
import fleet.com.intellij.psi.css.impl.parsing.CssMathParser;
import fleet.com.intellij.psi.css.impl.parsing.CssParser2;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.ILazyParseableElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.intellij.util.Function;
import fleet.org.jetbrains.plugins.sass.SASSBundle;
import fleet.org.jetbrains.plugins.sass.psi.SASSElementTypes;
import fleet.org.jetbrains.plugins.scss.SCSSElementTypes;
import fleet.org.jetbrains.plugins.scss.ScssStubElementTypes;
import fleet.org.jetbrains.plugins.scss.lexer.SCSSTokenTypes;
import fleet.org.jetbrains.plugins.scss.parser.ScssMathParser;
import org.jetbrains.annotations.NotNull;

public class SCSSParser
extends CssParser2 {
    public static final TokenSet COMPARING_OPS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_EQ, CssElementTypes.CSS_GT, CssElementTypes.CSS_GE, CssElementTypes.CSS_LT, CssElementTypes.CSS_LE, SCSSTokenTypes.EQQ, SCSSTokenTypes.NEQ});
    public static final TokenSet ADD_OPS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_MINUS, CssElementTypes.CSS_PLUS});
    public static final TokenSet AND_OPS = TokenSet.create((IElementType[])new IElementType[]{SCSSTokenTypes.AND});
    public static final TokenSet OR_OPS = TokenSet.create((IElementType[])new IElementType[]{SCSSTokenTypes.OR});
    public static final TokenSet EQEQ_OPS = TokenSet.create((IElementType[])new IElementType[]{SCSSTokenTypes.EQQ});
    public static final TokenSet MULT_OPS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_ASTERISK, CssElementTypes.CSS_SLASH});
    private static final TokenSet MODULO_OPS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_PERCENT});
    private boolean allowImportantInTermList = false;
    private boolean mySkipFunctionBody = true;
    private boolean variableDeclarationsProhibited = false;
    private final ScssMathParser SCSS_MATH_PARSER = new ScssMathParser(this);
    private boolean isInFilter = false;

    public void parse(IElementType root) {
        if (root == SCSSElementTypes.SCSS_FUNCTION_BODY) {
            PsiBuilder.Marker rootMarker = this.myBuilder.mark();
            this.mySkipFunctionBody = false;
            this.parseFunctionBody();
            rootMarker.done(root);
            return;
        }
        super.parse(root);
    }

    public void addToken() {
        if (this.isIdent()) {
            this.addIdentOrError();
        } else {
            super.addToken();
        }
    }

    protected boolean parseImportReference() {
        boolean result;
        boolean bl = result = this.parseUri() || this.parseCssString(false);
        while (this.getTokenType() == CssElementTypes.CSS_COMMA) {
            this.advanceAndSkipWhitespace();
            result &= this.parseUri() || this.parseCssString(false);
        }
        return result;
    }

    protected boolean canStartImportList(IElementType tokenType) {
        return super.canStartImportList(tokenType) || tokenType == SCSSTokenTypes.USE || tokenType == SCSSTokenTypes.FORWARD;
    }

    protected boolean parseImport() {
        if (super.parseImport()) {
            return true;
        }
        if (this.getTokenType() == SCSSTokenTypes.USE) {
            this.parseUseAtRule();
            return true;
        }
        if (this.getTokenType() == SCSSTokenTypes.FORWARD) {
            this.parseForwardAtRule();
            return true;
        }
        return false;
    }

    private void parseUseAtRule() {
        assert (this.getTokenType() == SCSSTokenTypes.USE);
        PsiBuilder.Marker useAtRule = this.myBuilder.mark();
        this.addToken();
        if (!this.parseCssString(false)) {
            this.createErrorElement(SASSBundle.message("parsing.error.string.expected", new Object[0]));
        }
        if (this.getTokenType() == CssElementTypes.CSS_IDENT && "as".equals(this.getTokenText())) {
            PsiBuilder.Marker useAs = this.myBuilder.mark();
            this.addToken();
            if (this.getTokenType() == CssElementTypes.CSS_ASTERISK) {
                this.addToken();
            } else if (this.getTokenType() == CssElementTypes.CSS_IDENT) {
                this.addToken();
            } else {
                this.createErrorElement(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
            }
            useAs.done(SCSSElementTypes.SCSS_USE_AS);
        }
        if (this.getTokenType() == CssElementTypes.CSS_IDENT && "with".equals(this.getTokenText())) {
            PsiBuilder.Marker useWith = this.myBuilder.mark();
            this.addToken();
            this.parseArgumentList();
            useWith.done(SCSSElementTypes.SCSS_USE_WITH);
        }
        this.addSemicolonOrError();
        useAtRule.done(SCSSElementTypes.SCSS_USE_AT_RULE);
    }

    private void parseForwardAtRule() {
        assert (this.getTokenType() == SCSSTokenTypes.FORWARD);
        PsiBuilder.Marker forwardAtRule = this.myBuilder.mark();
        this.addToken();
        if (!this.parseCssString(false)) {
            this.createErrorElement(SASSBundle.message("parsing.error.string.expected", new Object[0]));
        }
        if (this.getTokenType() == CssElementTypes.CSS_IDENT && "as".equals(this.getTokenText())) {
            this.addToken();
            if (this.addTokenOrError(CssElementTypes.CSS_IDENT, CssBundle.message((String)"css.identifier", (Object[])new Object[0]))) {
                this.addTokenOrError(CssElementTypes.CSS_ASTERISK, "'*'");
            }
        }
        if (this.getTokenType() == CssElementTypes.CSS_IDENT && ("show".equals(this.getTokenText()) || "hide".equals(this.getTokenText()))) {
            this.addToken();
            if (this.getTokenType() == CssElementTypes.CSS_IDENT || this.getTokenType() == SCSSTokenTypes.VARIABLE) {
                this.addToken();
                while (this.getTokenType() == CssElementTypes.CSS_COMMA) {
                    this.addToken();
                    if (this.getTokenType() == CssElementTypes.CSS_IDENT || this.getTokenType() == SCSSTokenTypes.VARIABLE) {
                        this.addToken();
                        continue;
                    }
                    this.createErrorElement(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
                    break;
                }
            } else {
                this.createErrorElement(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
            }
        }
        if (this.getTokenType() == CssElementTypes.CSS_IDENT && "with".equals(this.getTokenText())) {
            PsiBuilder.Marker useWith = this.myBuilder.mark();
            this.addToken();
            this.parseArgumentList();
            useWith.done(SCSSElementTypes.SCSS_USE_WITH);
        }
        this.addSemicolonOrError();
        forwardAtRule.done(SCSSElementTypes.SCSS_FORWARD_AT_RULE);
    }

    protected boolean parseKeyframesRuleset() {
        if (!super.parseKeyframesRuleset()) {
            if (this.parseScssConstructionsDeclarations()) {
                if (this.isSemicolonRequired()) {
                    if (this.getTokenType() == CssElementTypes.CSS_SEMICOLON) {
                        this.addToken();
                    } else if (this.getTokenType() != CssElementTypes.CSS_RBRACE) {
                        this.createErrorElement(CssBundle.message((String)"parsing.error.semicolon.expected", (Object[])new Object[0]));
                    }
                }
                return true;
            }
            return false;
        }
        this.blockDeclarationSeen = true;
        return true;
    }

    protected void parseSimpleSelector() {
        if (this.getTokenType() == CssElementTypes.CSS_AMPERSAND) {
            PsiBuilder.Marker simpleSelector = this.createCompositeElement();
            this.addSingleToken();
            if (!this.hasWhitespaceBefore()) {
                while (!this.hasWhitespaceBefore() && (this.getTokenType() == CssElementTypes.CSS_MINUS || this.isIdent() || CssElementTypes.CSS_NUMBER == this.getTokenType())) {
                    this.addToken();
                }
            }
            this.parseSelectorSuffixList(true);
            simpleSelector.done(CssStubElementTypes.CSS_SIMPLE_SELECTOR);
        } else {
            super.parseSimpleSelector();
        }
    }

    public boolean isIdent(IElementType type) {
        return SCSSTokenTypes.IDENT_AND_INTERPOLATION.contains(type);
    }

    protected boolean parseRulesetListItem(boolean stopOnRBrace) {
        if (this.parseNamespaceList() || this.parseVariableDeclaration() || this.parseMixinDeclaration() || this.parseFunctionDeclaration() || this.parseInclude() || this.parseControlDirectivesAndLogging(true) || this.parseExtend() || this.parseContent() || this.parseMedia() || this.parseAtRoot()) {
            return true;
        }
        return super.parseRulesetListItem(stopOnRBrace);
    }

    private boolean parseIf(boolean withDeclarations) {
        if (this.getTokenType() != SCSSTokenTypes.IF) {
            return false;
        }
        PsiBuilder.Marker ifStatement = this.createCompositeElement();
        this.parseSingleIfTokens(withDeclarations);
        while (this.getTokenType() == SCSSTokenTypes.ELSE && this.myBuilder.lookAhead(1) == SCSSTokenTypes.IF) {
            this.addToken();
            this.parseSingleIfTokens(withDeclarations);
        }
        if (this.getTokenType() == SCSSTokenTypes.ELSE) {
            this.addToken();
            if (this.getTokenType() == CssElementTypes.CSS_LBRACE) {
                this.parseInnerBlock(withDeclarations);
            } else {
                this.createErrorElement(SASSBundle.message("parsing.error.block.declaration.or.if.expected", new Object[0]));
            }
        }
        ifStatement.done(SCSSElementTypes.SCSS_IF_STATEMENT);
        return true;
    }

    private void parseSingleIfTokens(boolean withDeclarations) {
        this.addToken();
        if (!this.parseCondition(false, false)) {
            this.createErrorElement(SASSBundle.message("parsing.error.condition.expected", new Object[0]));
        }
        if (this.getTokenType() == CssElementTypes.CSS_LBRACE) {
            this.parseInnerBlock(withDeclarations);
        } else {
            this.createErrorElement(SASSBundle.message("parsing.error.body.expected", new Object[0]));
        }
    }

    private boolean parseWhile(boolean withDeclarations) {
        if (this.getTokenType() != SCSSTokenTypes.WHILE) {
            return false;
        }
        PsiBuilder.Marker whileStatement = this.createCompositeElement();
        this.addToken();
        if (!this.parseCondition(false, false)) {
            this.createErrorElement(SASSBundle.message("parsing.error.condition.expected", new Object[0]));
        }
        if (this.getTokenType() == CssElementTypes.CSS_LBRACE) {
            this.parseInnerBlock(withDeclarations);
        } else {
            this.createErrorElement(SASSBundle.message("parsing.error.body.expected", new Object[0]));
        }
        whileStatement.done(SCSSElementTypes.SCSS_WHILE_STATEMENT);
        return true;
    }

    protected boolean isExpectedTokenAfterDeclarationBlock() {
        return true;
    }

    private boolean parseEach(boolean withDeclarations) {
        if (this.getTokenType() != SCSSTokenTypes.EACH) {
            return false;
        }
        PsiBuilder.Marker eachStatement = this.createCompositeElement();
        this.addToken();
        if (this.parseVariableDeclarationWithoutValue()) {
            while (this.getTokenType() == CssElementTypes.CSS_COMMA) {
                this.addToken();
                if (this.parseVariableDeclarationWithoutValue()) continue;
                this.createErrorElement(CssBundle.message((String)"parsing.error.variable.expected", (Object[])new Object[0]));
                break;
            }
        }
        if ("in".equals(this.getTokenText())) {
            this.addToken();
        } else {
            this.createErrorElement(SASSBundle.message("parsing.error.in.expected", new Object[0]));
        }
        if (!this.parseVariableValue(true, false, CssElementTypes.CSS_LBRACE)) {
            this.createErrorElement(CssBundle.message((String)"parsing.error.expression.list.expected", (Object[])new Object[0]));
        }
        if (this.getTokenType() == CssElementTypes.CSS_LBRACE) {
            this.parseInnerBlock(withDeclarations);
        } else {
            this.createErrorElement(SASSBundle.message("parsing.error.body.expected", new Object[0]));
        }
        eachStatement.done(SCSSElementTypes.SCSS_EACH_STATEMENT);
        return true;
    }

    private boolean parseVariableDeclarationWithoutValue() {
        if (this.getTokenType() != SCSSTokenTypes.VARIABLE) {
            return false;
        }
        PsiBuilder.Marker variableDeclaration = this.createCompositeElement();
        this.parseVariable();
        variableDeclaration.done(ScssStubElementTypes.SCSS_VARIABLE_DECLARATION);
        return true;
    }

    private void parseInnerBlock(boolean withDeclarations) {
        if (withDeclarations) {
            this.parseDeclarationBlock();
        } else {
            this.parseFunctionBody();
        }
    }

    protected boolean addCustomMediaQueryIdent() {
        if (this.getTokenType() == SCSSTokenTypes.INTERPOLATION_PREFIX) {
            return this.parseInterpolation();
        }
        this.variableDeclarationsProhibited = true;
        this.addLParenOrError();
        if (this.parseTermList(true, new IElementType[]{CssElementTypes.CSS_COLON, CssElementTypes.CSS_RPAREN}) && this.getTokenType() == CssElementTypes.CSS_COLON) {
            this.addSingleToken();
            if (!this.parseTermList(true, new IElementType[]{CssElementTypes.CSS_RPAREN})) {
                this.createTermExpectedErrorElement();
                return false;
            }
        }
        this.addRParenOrError();
        this.variableDeclarationsProhibited = false;
        return true;
    }

    protected boolean isCustomMediaQueryIdent(boolean insideMediaExpression) {
        IElementType lookAhead1 = this.lookAhead(1);
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
            IElementType lookAhead2 = this.lookAhead(2);
            return insideMediaExpression && !this.isTermListFinished(lookAhead1) && (!this.isIdent(lookAhead1) || lookAhead2 != CssElementTypes.CSS_COLON && lookAhead2 != CssElementTypes.CSS_RPAREN && lookAhead2 != CssElementTypes.CSS_LBRACE);
        }
        return this.getTokenType() == SCSSTokenTypes.INTERPOLATION_PREFIX;
    }

    private boolean parseFor(boolean withDeclarations) {
        String tokenText;
        if (this.getTokenType() != SCSSTokenTypes.FOR) {
            return false;
        }
        PsiBuilder.Marker forStatement = this.createCompositeElement();
        this.addToken();
        this.parseVariableDeclaration();
        if ("from".equals(this.getTokenText())) {
            this.addToken();
        } else {
            this.createErrorElement(CssBundle.message((String)"parsing.error.from.expected", (Object[])new Object[0]));
        }
        if (!this._parseTerm(false, false)) {
            this.createErrorElement(CssBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        if ("through".equals(tokenText = this.getTokenText()) || "to".equals(tokenText)) {
            this.addToken();
        } else {
            this.createErrorElement(SASSBundle.message("parsing.error.through.or.to.expected", new Object[0]));
        }
        if (!this._parseTerm(false, false)) {
            this.createErrorElement(CssBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        if (this.getTokenType() == CssElementTypes.CSS_LBRACE) {
            this.parseInnerBlock(withDeclarations);
        } else {
            this.createErrorElement(SASSBundle.message("parsing.error.body.expected", new Object[0]));
        }
        forStatement.done(SCSSElementTypes.SCSS_FOR_STATEMENT);
        return true;
    }

    private boolean parseExtend() {
        if (this.getTokenType() != SCSSTokenTypes.EXTEND) {
            return false;
        }
        PsiBuilder.Marker extendStatement = this.createCompositeElement();
        this.addToken();
        this.parseSelectorList();
        if (this.getTokenType() == SCSSTokenTypes.OPTIONAL) {
            this.addToken();
        } else if ("!".equals(this.getTokenText())) {
            this.addToken();
            PsiBuilder.Marker error = this.createCompositeElement();
            if (!this.hasWhitespaceBefore() && this.isIdent()) {
                this.addToken();
            }
            error.error(SASSBundle.message("parsing.error.optional.expected", new Object[0]));
        }
        extendStatement.done(SCSSElementTypes.SCSS_EXTEND_STATEMENT);
        return true;
    }

    private boolean parseError() {
        return this.parseLogStatement(SCSSTokenTypes.ERROR, SCSSElementTypes.SCSS_ERROR_STATEMENT);
    }

    private boolean parseWarn() {
        return this.parseLogStatement(SCSSTokenTypes.WARN, SCSSElementTypes.SCSS_WARN_STATEMENT);
    }

    private boolean parseDebug() {
        return this.parseLogStatement(SCSSTokenTypes.DEBUG, SCSSElementTypes.SCSS_DEBUG_STATEMENT);
    }

    private boolean parseLogStatement(IElementType tokenType, IElementType wrapperType) {
        if (this.getTokenType() != tokenType) {
            return false;
        }
        PsiBuilder.Marker warnStatement = this.createCompositeElement();
        this.addToken();
        if (!this.parseVariableValue(false, false, new IElementType[0])) {
            this.createErrorElement(SASSBundle.message("parsing.error.subject.expected", new Object[0]));
        }
        warnStatement.done(wrapperType);
        return true;
    }

    protected boolean isSimpleSelectorStart() {
        return this.getTokenType() == CssElementTypes.CSS_AMPERSAND || super.isSimpleSelectorStart();
    }

    protected boolean isTrailingCommaInSelectorListAllowed() {
        return true;
    }

    private boolean parseVariableDeclaration() {
        if (this.getTokenType() != SCSSTokenTypes.VARIABLE) {
            return false;
        }
        this.parseVariableDeclarationElement();
        return true;
    }

    protected boolean isTermListFinished(IElementType type) {
        return this.getTokenType() == SCSSTokenTypes.GLOBAL || this.getTokenType() == SCSSTokenTypes.DEFAULT || this.getTokenType() == SCSSTokenTypes.DYNAMIC || type == CssElementTypes.CSS_LBRACE || super.isTermListFinished(type);
    }

    protected void parseFilterTermList() {
        this.isInFilter = true;
        super.parseFilterTermList();
        this.isInFilter = false;
    }

    protected boolean parseTermList(boolean strict, boolean nameValuePairSyntax, IElementType ... stopElements) {
        PsiBuilder.Marker toRollback = this.createCompositeElement();
        boolean result = super.parseTermList(strict, nameValuePairSyntax, stopElements);
        if (!(result || strict || this.isInFilter)) {
            toRollback.rollbackTo();
        } else {
            toRollback.drop();
        }
        return result;
    }

    private boolean parseParameter() {
        if (this.getTokenType() == SCSSTokenTypes.VARIABLE) {
            PsiBuilder.Marker parameter = this.createCompositeElement();
            PsiBuilder.Marker declaration = this.createCompositeElement();
            this.parseVariable();
            boolean defaultValueParsed = false;
            if (this.getTokenType() == CssElementTypes.CSS_COLON) {
                defaultValueParsed = true;
                this.addToken();
                this.parseVariableValue(true, false, CssElementTypes.CSS_COMMA);
            }
            declaration.done(ScssStubElementTypes.SCSS_VARIABLE_DECLARATION);
            if (!defaultValueParsed) {
                this.parseThreeDots();
            }
            parameter.done(ScssStubElementTypes.SCSS_PARAMETER);
            return true;
        }
        return false;
    }

    void parseVariable() {
        PsiBuilder.Marker variableNameMarker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        variableNameMarker.done(SCSSElementTypes.SCSS_VARIABLE);
    }

    private boolean parseThreeDots() {
        if (this.getTokenType() == CssElementTypes.CSS_PERIOD && this.myBuilder.rawLookup(1) == CssElementTypes.CSS_PERIOD && this.myBuilder.rawLookup(2) == CssElementTypes.CSS_PERIOD) {
            this.addToken();
            this.addToken();
            this.addToken();
            return true;
        }
        return false;
    }

    private boolean parseArgument() {
        if (this.getTokenType() == SCSSTokenTypes.VARIABLE && (this.myBuilder.rawLookup(1) == CssElementTypes.CSS_PERIOD && this.myBuilder.rawLookup(2) == CssElementTypes.CSS_PERIOD && this.myBuilder.rawLookup(3) == CssElementTypes.CSS_PERIOD || this.myBuilder.lookAhead(1) == CssElementTypes.CSS_COLON)) {
            PsiBuilder.Marker declaration = this.createCompositeElement();
            this.parseVariable();
            if (this.parseThreeDots()) {
                declaration.drop();
            } else if (this.getTokenType() == CssElementTypes.CSS_COLON) {
                this.addToken();
                this.parseVariableValue(true, false, CssElementTypes.CSS_COMMA);
                if (this.getTokenType() == SCSSTokenTypes.DEFAULT) {
                    this.addToken();
                }
                declaration.done(ScssStubElementTypes.SCSS_VARIABLE_DECLARATION);
            } else {
                declaration.drop();
            }
        } else {
            return this.parseVariableValue(false, false, CssElementTypes.CSS_COMMA);
        }
        return true;
    }

    private boolean parseVariableDeclarationElement() {
        PsiBuilder.Marker declaration = this.createCompositeElement();
        this.parseVariable();
        if (this.getTokenType() == CssElementTypes.CSS_COLON) {
            this.addToken();
            this.parseVariableValue(true, false, new IElementType[0]);
        }
        boolean hasAtLeastOneFlag = false;
        IElementType tokenType = this.getTokenType();
        while (tokenType == SCSSTokenTypes.GLOBAL || tokenType == SCSSTokenTypes.DEFAULT || tokenType == SCSSTokenTypes.DYNAMIC) {
            hasAtLeastOneFlag = true;
            this.addToken();
            tokenType = this.getTokenType();
        }
        if (hasAtLeastOneFlag) {
            while ("!".equals(this.getTokenText())) {
                PsiBuilder.Marker unknownFlag = this.createCompositeElement();
                this.addToken();
                if (!this.hasWhitespaceBefore() && this.isIdent()) {
                    this.addIdentOrError();
                }
                unknownFlag.error(SASSBundle.message("error.text.unknown.flag", new Object[0]));
            }
        }
        declaration.done(ScssStubElementTypes.SCSS_VARIABLE_DECLARATION);
        return true;
    }

    private boolean parseVariableValue(boolean strict, boolean pairSyntax, IElementType ... stopElements) {
        boolean oldValue = this.allowImportantInTermList;
        this.allowImportantInTermList = true;
        boolean result = this.parseEmptyList(stopElements) || this.parseTermList(strict, pairSyntax, stopElements);
        this.allowImportantInTermList = oldValue;
        return result;
    }

    protected boolean isOrToken() {
        return this.getTokenType() == SCSSTokenTypes.OR;
    }

    protected boolean isAndToken() {
        return this.getTokenType() == SCSSTokenTypes.AND;
    }

    protected boolean isNotToken() {
        return this.getTokenType() == SCSSTokenTypes.NOT;
    }

    private boolean parseEmptyList(IElementType ... stopElements) {
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN && this.myBuilder.lookAhead(1) == CssElementTypes.CSS_RPAREN) {
            return this.parseTermList(false, stopElements);
        }
        return false;
    }

    private boolean parseMixinDeclaration() {
        if (this.getTokenType() != SCSSTokenTypes.MIXIN) {
            return false;
        }
        PsiBuilder.Marker declaration = this.createCompositeElement();
        this.addToken();
        if (this.getTokenType() == CssElementTypes.CSS_IDENT || this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN) {
            this.addToken();
            if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
                this.parseParameterList();
            }
        } else {
            this.createErrorElement(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
        }
        if (!this.parseDeclarationBlock()) {
            this.createErrorElement(SASSBundle.message("parsing.error.declaration.block.expected", new Object[0]));
        }
        declaration.done(ScssStubElementTypes.SCSS_MIXIN_DECLARATION);
        return true;
    }

    private void parseParameterList() {
        this.addLParenOrError();
        PsiBuilder.Marker parametersList = this.createCompositeElement();
        if (this.getTokenType() != CssElementTypes.CSS_RPAREN) {
            PsiBuilder.Marker parameterError;
            if (!this.parseParameter()) {
                parameterError = this.createCompositeElement();
                this.moveUntilToken(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_COMMA, CssElementTypes.CSS_RPAREN}));
                parameterError.error(CssBundle.message((String)"parsing.error.invalid.parameter", (Object[])new Object[0]));
            }
            while (this.getTokenType() == CssElementTypes.CSS_COMMA) {
                this.addToken();
                if (this.parseParameter() || this.getTokenType() == CssElementTypes.CSS_RPAREN) continue;
                parameterError = this.createCompositeElement();
                this.moveUntilToken(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_COMMA, CssElementTypes.CSS_RPAREN}));
                parameterError.error(CssBundle.message((String)"parsing.error.invalid.parameter", (Object[])new Object[0]));
            }
        }
        parametersList.done(ScssStubElementTypes.SCSS_PARAMETER_LIST);
        this.addRParenOrError();
    }

    private boolean parseFunctionDeclaration() {
        if (this.getTokenType() != SCSSTokenTypes.FUNCTION_KEYWORD) {
            return false;
        }
        PsiBuilder.Marker declaration = this.createCompositeElement();
        this.addToken();
        if (this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN) {
            this.addToken();
            this.parseParameterList();
        } else if (this.isIdent()) {
            this.addIdentOrError();
            this.parseParameterList();
        } else {
            this.createErrorElement(SASSBundle.message("parsing.error.function.name.expected", new Object[0]));
        }
        if (!this.parseFunctionBody()) {
            this.createErrorElement(SASSBundle.message("parsing.error.function.body.expected", new Object[0]));
        }
        declaration.done(ScssStubElementTypes.SCSS_FUNCTION_DECLARATION);
        return true;
    }

    private boolean parseFunctionBody() {
        if (this.mySkipFunctionBody) {
            return CssBlockSkipper.skipDeclarationBlockAndCollapse((CssParser2)this, (ILazyParseableElementType)SCSSElementTypes.SCSS_FUNCTION_BODY);
        }
        this.mySkipFunctionBody = true;
        if (this.getTokenType() == CssElementTypes.CSS_LBRACE) {
            this.addToken();
        }
        while (this.getTokenType() != null && this.getTokenType() != CssElementTypes.CSS_RBRACE) {
            this.blockDeclarationSeen = false;
            if (!(this.parseVariableDeclaration() || this.parseControlDirectivesAndLogging(false) || this.parseReturnStatement())) {
                PsiBuilder.Marker possibleError = this.createCompositeElement();
                int offsetBeforeDeclarationParsing = this.myBuilder.getCurrentOffset();
                this.parseSingleDeclarationInBlock(false, false);
                if (offsetBeforeDeclarationParsing < this.myBuilder.getCurrentOffset()) {
                    possibleError.error(SASSBundle.message("error.text.functions.can.only.contain.variable.declarations", new Object[0]));
                } else {
                    this.addToken();
                    possibleError.error(CssBundle.message((String)"parsing.error.unexpected.token", (Object[])new Object[0]));
                    break;
                }
            }
            if (!this.isSemicolonRequired()) continue;
            if (this.getTokenType() == CssElementTypes.CSS_SEMICOLON) {
                this.addToken();
                continue;
            }
            if (this.getTokenType() == CssElementTypes.CSS_RBRACE) continue;
            this.createErrorElement(CssBundle.message((String)"parsing.error.semicolon.expected", (Object[])new Object[0]));
        }
        this.addTokenOrError(CssElementTypes.CSS_RBRACE, "'}'");
        if (!this.isDone()) {
            PsiBuilder.Marker error = this.createCompositeElement();
            while (!this.isDone()) {
                this.addToken();
            }
            error.error(CssBundle.message((String)"parsing.error.unexpected.terms", (Object[])new Object[0]));
        }
        this.mySkipFunctionBody = false;
        return true;
    }

    private void moveUntilToken(TokenSet tokenSet) {
        while (this.getTokenType() != null && !tokenSet.contains(this.getTokenType())) {
            super.addToken();
        }
    }

    protected boolean parseSingleDeclarationInBlock(boolean withPageMarginRules, boolean inlineCss, boolean requirePropertyValue, @NotNull IElementType elementType) {
        if (!this.myIsMediaFeature) {
            this.blockDeclarationSeen = false;
            if (this.parseExtend()) {
                return true;
            }
            if (this.parseScssConstructionsDeclarations()) {
                return true;
            }
            if (this.parseNamespaceList()) {
                return true;
            }
            if (this.parseNamespaceNesting() || this.parseAtRoot()) {
                this.onBlockDeclarationSeen();
                return true;
            }
        }
        return super.parseSingleDeclarationInBlock(withPageMarginRules, inlineCss, requirePropertyValue, elementType);
    }

    protected void onBlockDeclarationSeen() {
        this.blockDeclarationSeen = true;
    }

    private boolean parseAtRoot() {
        if (this.getTokenType() != SCSSTokenTypes.AT_ROOT_SYM) {
            return false;
        }
        PsiBuilder.Marker atRoot = this.createCompositeElement();
        this.addToken();
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
            this.addLParenOrError();
            PsiBuilder.Marker atRootQuery = this.createCompositeElement();
            if (this.isIdent()) {
                String text = this.getTokenText();
                PsiBuilder.Marker possibleError = this.createCompositeElement();
                this.addIdentOrError();
                if ("without".equals(text) || "with".equals(text)) {
                    possibleError.drop();
                } else {
                    possibleError.error(SASSBundle.message("parsing.error.with.or.without.query.expected", new Object[0]));
                }
                if (this.addTokenOrError(CssElementTypes.CSS_COLON, "':'")) {
                    PsiBuilder.Marker queryValue = this.createCompositeElement();
                    while (this.isIdent()) {
                        this.addIdentOrError();
                    }
                    queryValue.done(SCSSElementTypes.SCSS_AT_ROOT_QUERY_VALUE);
                }
            } else {
                this.createErrorElement(SASSBundle.message("parsing.error.with.or.without.query.expected", new Object[0]));
            }
            atRootQuery.done(SCSSElementTypes.SCSS_AT_ROOT_QUERY);
            this.addRParenOrError();
        } else if (this.getTokenType() != CssElementTypes.CSS_LBRACE) {
            this.parseSelectorList();
        }
        if (!this.parseDeclarationBlock()) {
            this.createErrorElement(CssBundle.message((String)"parsing.error.opening.brace.expected", (Object[])new Object[0]));
        }
        atRoot.done(SCSSElementTypes.SCSS_AT_ROOT);
        return true;
    }

    protected boolean shouldIgnoreLbraceAfterDeclaration() {
        return true;
    }

    private boolean parseScssConstructionsDeclarations() {
        this.blockDeclarationSeen = false;
        if (this.parseContent() || this.parseVariableDeclaration() || this.parseControlDirectivesAndLogging(true)) {
            return true;
        }
        if (this.parseInclude()) {
            return true;
        }
        if (this.parseMixinDeclaration() || this.parseFunctionDeclaration() || this.parseImport()) {
            this.blockDeclarationSeen = true;
            return true;
        }
        return false;
    }

    private boolean parseContent() {
        if (this.getTokenType() == SCSSTokenTypes.CONTENT) {
            PsiBuilder.Marker atRule = this.createCompositeElement();
            this.addToken();
            if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
                this.parseArgumentList();
            }
            atRule.done(SCSSElementTypes.SCSS_CONTENT_STATEMENT);
            return true;
        }
        return false;
    }

    private boolean parseControlDirectivesAndLogging(boolean withDeclarations) {
        return this.parseControlDirectives(withDeclarations) || this.parseWarn() || this.parseDebug() || this.parseError();
    }

    private boolean parseControlDirectives(boolean withDeclarations) {
        if (this.parseIf(withDeclarations) || this.parseWhile(withDeclarations) || this.parseEach(withDeclarations) || this.parseFor(withDeclarations)) {
            this.blockDeclarationSeen = true;
            return true;
        }
        return false;
    }

    private boolean parseReturnStatement() {
        if (this.getTokenType() == SCSSTokenTypes.RETURN) {
            PsiBuilder.Marker returnStatement = this.createCompositeElement();
            this.addToken();
            this.parseVariableValue(true, false, new IElementType[0]);
            returnStatement.done(SCSSElementTypes.SCSS_RETURN_STATEMENT);
            return true;
        }
        return false;
    }

    private boolean parseInclude() {
        if (this.getTokenType() != SCSSTokenTypes.INCLUDE) {
            return false;
        }
        PsiBuilder.Marker possibleRuleset = this.createCompositeElement();
        PsiBuilder.Marker declaration = this.createCompositeElement();
        this.addToken();
        if (this.getTokenType() == CssElementTypes.CSS_IDENT || this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN) {
            this.addToken();
            if (this.getTokenType() == CssElementTypes.CSS_PERIOD) {
                this.addToken();
                if (this.getTokenType() == CssElementTypes.CSS_IDENT || this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN) {
                    this.addToken();
                } else {
                    this.createErrorElement(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
                }
            }
            if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
                this.parseArgumentList();
            }
            if ((this.getTokenType() == CssElementTypes.CSS_IDENT || this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN) && "using".equals(this.getTokenText())) {
                this.addToken();
                this.parseParameterList();
            }
        } else {
            this.createErrorElement(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
        }
        declaration.done(SCSSElementTypes.SCSS_INCLUDE);
        if (this.getTokenType() == CssElementTypes.CSS_LBRACE) {
            if (!this.parseDeclarationBlock()) {
                this.createErrorElement(SASSBundle.message("parsing.error.content.block.expected", new Object[0]));
            }
            possibleRuleset.done(CssStubElementTypes.CSS_RULESET);
            this.blockDeclarationSeen = true;
        } else {
            this.blockDeclarationSeen = false;
            possibleRuleset.drop();
        }
        return true;
    }

    private void parseArgumentList() {
        this.addLParenOrError();
        PsiBuilder.Marker termListMarker = this.createCompositeElement();
        if (this.getTokenType() != CssElementTypes.CSS_RPAREN) {
            PsiBuilder.Marker argumentError;
            if (!this.parseArgument()) {
                argumentError = this.createCompositeElement();
                this.moveUntilToken(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_COMMA, CssElementTypes.CSS_RPAREN}));
                argumentError.error(CssBundle.message((String)"parsing.error.invalid.argument", (Object[])new Object[0]));
            }
            while (this.getTokenType() == CssElementTypes.CSS_COMMA) {
                this.addToken();
                if (this.parseArgument() || this.getTokenType() == CssElementTypes.CSS_RPAREN) continue;
                argumentError = this.createCompositeElement();
                this.moveUntilToken(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_COMMA, CssElementTypes.CSS_RPAREN}));
                argumentError.error(CssBundle.message((String)"parsing.error.invalid.argument", (Object[])new Object[0]));
            }
        }
        termListMarker.done(SASSElementTypes.TERM_LIST);
        this.addRParenOrError();
    }

    protected boolean isRulesetStart() {
        return this.getTokenType() != CssElementTypes.CSS_SEMICOLON && (super.isRulesetStart() || this.getTokenType() == CssElementTypes.CSS_AMPERSAND || this.getTokenType() == SCSSTokenTypes.HASH_SIGN && this.myBuilder.rawLookup(1) == SCSSTokenTypes.INTERPOLATION_PREFIX || this.getTokenType() == CssElementTypes.CSS_PERCENT || this.getTokenType() == SCSSTokenTypes.INTERPOLATION_PREFIX);
    }

    protected TokenSet getCommentTokenTypes() {
        return SCSSTokenTypes.COMMENTS;
    }

    protected boolean tryToParseRuleset() {
        boolean filterProperty;
        if (!this.isRulesetStart()) {
            return false;
        }
        PsiBuilder.Marker position = this.myBuilder.mark();
        boolean first = true;
        IElementType lastElement = null;
        boolean interpolationBlock = false;
        String tokenText = this.getTokenText();
        boolean bl = filterProperty = this.getTokenType() == CssElementTypes.CSS_IDENT && tokenText != null && tokenText.endsWith("filter");
        while (!this.isDone() && ((this.getTokenType() == CssElementTypes.CSS_HASH || this.getTokenType() == SCSSTokenTypes.HASH_SIGN || this.getTokenType() == CssElementTypes.CSS_IDENT || this.getTokenType() == CssElementTypes.CSS_PERIOD || this.getTokenType() == CssElementTypes.CSS_COLON || this.getTokenType() == CssElementTypes.CSS_PIPE || this.getTokenType() == CssElementTypes.CSS_COMMA || SELECTORS_HIERARCHY_TOKENS.contains(this.getTokenType()) || this.getTokenType() == CssElementTypes.CSS_ASTERISK || this.getTokenType() == CssElementTypes.CSS_PERCENT || this.getTokenType() == CssElementTypes.CSS_AMPERSAND || this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN || this.getTokenType() == CssElementTypes.CSS_MINUS || this.getTokenType() == SCSSTokenTypes.UNDERSCORE || this.getTokenType() == SCSSTokenTypes.INTERPOLATION_PREFIX) && !interpolationBlock || interpolationBlock || this.getTokenType() == CssElementTypes.CSS_BAD_CHARACTER || first)) {
            if (this.isIdent()) {
                this.addIdentOrError();
                lastElement = CssElementTypes.CSS_IDENT;
                first = false;
                continue;
            }
            if (this.getTokenType() == SCSSTokenTypes.INTERPOLATION_PREFIX) {
                interpolationBlock = true;
            }
            if (this.getTokenType() == SCSSTokenTypes.INTERPOLATION_SUFFIX) {
                interpolationBlock = false;
            }
            IElementType rawLookup1 = this.myBuilder.rawLookup(1);
            if (this.getTokenType() == CssElementTypes.CSS_COLON) {
                if ((rawLookup1 == CssElementTypes.CSS_FUNCTION_TOKEN || rawLookup1 == CssElementTypes.CSS_IDENT || rawLookup1 == SCSSTokenTypes.INTERPOLATION_PREFIX || rawLookup1 == CssElementTypes.CSS_COLON) && this.parsePseudo()) {
                    if (first) {
                        position.rollbackTo();
                        return this.parseRuleset();
                    }
                    first = false;
                    continue;
                }
                position.rollbackTo();
                return false;
            }
            first = false;
            if (this.getTokenType() == CssElementTypes.CSS_AMPERSAND || this.getTokenType() == CssElementTypes.CSS_PERCENT || this.getTokenType() == CssElementTypes.CSS_PERIOD && !filterProperty) {
                position.rollbackTo();
                return this.parseRuleset();
            }
            lastElement = this.getTokenType();
            this.advanceAndSkipWhitespace();
        }
        if (this.getTokenType() == CssElementTypes.CSS_LBRACE || this.getTokenType() == CssElementTypes.CSS_LBRACKET) {
            position.rollbackTo();
            if (lastElement == CssElementTypes.CSS_COLON) {
                return this.parseNamespaceNesting();
            }
            return this.parseRuleset();
        }
        position.rollbackTo();
        return false;
    }

    private boolean parseNamespaceNesting() {
        PsiBuilder.Marker ruleset = this.createCompositeElement();
        boolean isDeclaration = false;
        boolean withoutValue = false;
        if (this.isIdent()) {
            PsiBuilder.Marker isDeclarationMarker = this.createCompositeElement();
            this.addIdentOrError();
            IElementType currentToken = this.getTokenType();
            IElementType nextToken = this.myBuilder.rawLookup(1);
            isDeclaration = currentToken == CssElementTypes.CSS_COLON && (CssElementTypes.WHITESPACES.contains(nextToken) || nextToken == CssElementTypes.CSS_LBRACE);
            withoutValue = this.myBuilder.lookAhead(1) == CssElementTypes.CSS_LBRACE;
            isDeclarationMarker.rollbackTo();
        }
        boolean declarationParsed = false;
        if (isDeclaration) {
            if (withoutValue) {
                PsiBuilder.Marker declaration = this.createCompositeElement();
                this.addIdentOrError();
                this.addTokenOrError(CssElementTypes.CSS_COLON, "':'");
                declaration.done(CssStubElementTypes.CSS_DECLARATION);
                declarationParsed = true;
            } else {
                declarationParsed = super.parseSingleDeclarationInBlock(false, false, true, CssStubElementTypes.CSS_DECLARATION);
            }
        }
        if (declarationParsed && this.parseDeclarationBlock()) {
            ruleset.done(SCSSElementTypes.SCSS_PROPERTY_RULESET);
            return true;
        }
        ruleset.rollbackTo();
        return false;
    }

    protected boolean isSemicolonRequired() {
        return !this.blockDeclarationSeen && super.isSemicolonRequired();
    }

    protected boolean _parseTerm(boolean strict, boolean nameValuePairSyntax) {
        if (!this.variableDeclarationsProhibited && this.getTokenType() == SCSSTokenTypes.VARIABLE && this.myBuilder.lookAhead(1) == CssElementTypes.CSS_COLON) {
            if (nameValuePairSyntax) {
                return this.parseVariableDeclarationElement();
            }
            return false;
        }
        return this.parseCondition(strict, nameValuePairSyntax);
    }

    private boolean parseCondition(boolean strict, boolean nameValuePairSyntax) {
        return this.parseBinaryOp((Function<Pair<Boolean, Boolean>, Boolean>)((Function)args -> this.parseEqEq((Boolean)args.first, (Boolean)args.second)), COMPARING_OPS, strict, nameValuePairSyntax);
    }

    private boolean parseEqEq(boolean strict, boolean nameValuePairSyntax) {
        return this.parseBinaryOp((Function<Pair<Boolean, Boolean>, Boolean>)((Function)args -> this.parseOr((Boolean)args.first, (Boolean)args.second)), EQEQ_OPS, strict, nameValuePairSyntax);
    }

    private boolean parseOr(boolean strict, boolean nameValuePairSyntax) {
        return this.parseBinaryOp((Function<Pair<Boolean, Boolean>, Boolean>)((Function)args -> this.parseAnd((Boolean)args.first, (Boolean)args.second)), OR_OPS, strict, nameValuePairSyntax);
    }

    private boolean parseAnd(boolean strict, boolean nameValuePairSyntax) {
        return this.parseBinaryOp((Function<Pair<Boolean, Boolean>, Boolean>)((Function)args -> this.parseAdd((Boolean)args.first, (Boolean)args.second)), AND_OPS, strict, nameValuePairSyntax);
    }

    private boolean parseAdd(boolean strict, boolean nameValuePairSyntax) {
        return this.parseBinaryOp((Function<Pair<Boolean, Boolean>, Boolean>)((Function)args -> this.parseMult((Boolean)args.first, (Boolean)args.second)), ADD_OPS, strict, nameValuePairSyntax);
    }

    protected boolean parseMult(boolean strict, boolean nameValuePairSyntax) {
        return this.parseBinaryOp((Function<Pair<Boolean, Boolean>, Boolean>)((Function)args -> this.parseModulo((Boolean)args.first, (Boolean)args.second)), MULT_OPS, strict, nameValuePairSyntax);
    }

    protected boolean parseModulo(boolean strict, boolean nameValuePairSyntax) {
        return this.parseBinaryOp((Function<Pair<Boolean, Boolean>, Boolean>)((Function)args -> this.parseTermInner((Boolean)args.first, (Boolean)args.second)), MODULO_OPS, strict, nameValuePairSyntax);
    }

    private boolean parseMapEntry() {
        if (this.getTokenType() == CssElementTypes.CSS_RPAREN) {
            return false;
        }
        this.variableDeclarationsProhibited = true;
        PsiBuilder.Marker mapEntry = this.createCompositeElement();
        if (this.parseTermList(true, new IElementType[]{CssElementTypes.CSS_COLON, CssElementTypes.CSS_COMMA})) {
            if (this.getTokenType() == CssElementTypes.CSS_COLON) {
                this.addSingleToken();
                if (!this.parseVariableValue(true, false, CssElementTypes.CSS_COMMA)) {
                    this.createTermExpectedErrorElement();
                }
                mapEntry.done(SCSSElementTypes.MAP_ENTRY);
                this.variableDeclarationsProhibited = false;
                return true;
            }
            this.createErrorElement(SASSBundle.message("parsing.error.colon.expected", new Object[0]));
        }
        this.variableDeclarationsProhibited = false;
        mapEntry.drop();
        return false;
    }

    protected boolean parseTermInner(boolean strict, boolean nameValuePairSyntax) {
        PsiBuilder.Marker term;
        if (this.getTokenType() == SCSSTokenTypes.INTERPOLATION_PREFIX) {
            PsiBuilder.Marker concatOperation = this.createCompositeElement();
            term = this.createCompositeElement();
            boolean interpolationParsed = this.parseInterpolation();
            term.done(CssElementTypes.CSS_TERM);
            if (interpolationParsed) {
                if (!this.hasWhitespaceBefore() && this.parseTermInner(strict, nameValuePairSyntax)) {
                    concatOperation.done(SCSSElementTypes.SCSS_OPERATION);
                } else {
                    concatOperation.drop();
                }
                return true;
            }
            concatOperation.rollbackTo();
        }
        if (this.getTokenType() == SCSSTokenTypes.NOT || this.getTokenType() == CssElementTypes.CSS_MINUS) {
            PsiBuilder.Marker notOrMinus = this.createCompositeElement();
            this.addToken();
            this.parseTermInner(strict, nameValuePairSyntax);
            notOrMinus.done(SCSSElementTypes.SCSS_OPERATION);
            return true;
        }
        IElementType tokenType = this.getTokenType();
        if (tokenType == CssElementTypes.CSS_LPAREN) {
            if (!nameValuePairSyntax) {
                PsiBuilder.Marker possibleMap = this.createCompositeElement();
                this.addToken();
                if (this.parseMapEntry()) {
                    while (this.getTokenType() == CssElementTypes.CSS_COMMA) {
                        this.addSingleToken();
                        if (this.parseMapEntry()) continue;
                    }
                    this.addRParenOrError();
                    possibleMap.done(SCSSElementTypes.MAP);
                    return true;
                }
                possibleMap.rollbackTo();
            }
            PsiBuilder.Marker parens = this.createCompositeElement();
            this.addToken();
            this.parseVariableValue(strict, nameValuePairSyntax, CssElementTypes.CSS_RPAREN);
            this.addRParenOrError();
            parens.done(SCSSElementTypes.SCSS_PARENTHESIS_EXPRESSION);
            return true;
        }
        if (this.getTokenType() == SCSSTokenTypes.VARIABLE) {
            term = this.createCompositeElement();
            PsiBuilder.Marker variable = this.createCompositeElement();
            this.addToken();
            variable.done(SCSSElementTypes.SCSS_VARIABLE);
            term.done(CssElementTypes.CSS_TERM);
            return true;
        }
        if (this.getTokenType() == CssElementTypes.CSS_IDENT && this.lookAhead(1) == CssElementTypes.CSS_PERIOD && this.lookAhead(2) == SCSSTokenTypes.VARIABLE) {
            term = this.createCompositeElement();
            PsiBuilder.Marker variable = this.createCompositeElement();
            this.addToken();
            this.addToken();
            this.addToken();
            variable.done(SCSSElementTypes.SCSS_VARIABLE);
            term.done(CssElementTypes.CSS_TERM);
            return true;
        }
        if (this.getTokenType() == CssElementTypes.CSS_URL) {
            this.advanceAndSkipWhitespace();
            return true;
        }
        if (this.allowImportantInTermList && this.getTokenType() == CssElementTypes.CSS_IMPORTANT) {
            this.advanceAndSkipWhitespace();
            return true;
        }
        return super._parseTerm(strict, nameValuePairSyntax);
    }

    private void advanceAndSkipWhitespace() {
        this.myBuilder.advanceLexer();
    }

    private boolean parseBinaryOp(Function<Pair<Boolean, Boolean>, Boolean> parseOperandFunc, TokenSet operands, boolean strict, boolean nameValuePairSyntax) {
        PsiBuilder.Marker operation = this.createCompositeElement();
        Boolean operand = (Boolean)parseOperandFunc.fun((Object)Pair.create((Object)strict, (Object)nameValuePairSyntax));
        if (operand == Boolean.FALSE) {
            operation.drop();
            return false;
        }
        while (operands.contains(this.getTokenType())) {
            super.addToken();
            operand = (Boolean)parseOperandFunc.fun((Object)Pair.create((Object)strict, (Object)nameValuePairSyntax));
            if (operand == Boolean.FALSE) {
                this.createErrorElement(CssBundle.message((String)"parsing.error.operand.expected", (Object[])new Object[0]));
            }
            operation.done(SCSSElementTypes.SCSS_OPERATION);
            operation = operation.precede();
        }
        operation.drop();
        return operand;
    }

    public boolean parseFunction(boolean strict) {
        if (this.rawLookup(-1) != CssElementTypes.CSS_PERIOD && this.getTokenType() == CssElementTypes.CSS_IDENT && this.lookAhead(1) == CssElementTypes.CSS_PERIOD && this.lookAhead(2) == CssElementTypes.CSS_FUNCTION_TOKEN) {
            PsiBuilder.Marker function = this.createCompositeElement();
            this.addToken();
            this.addToken();
            this.addToken();
            this.parseArgumentList();
            function.done(CssElementTypes.CSS_FUNCTION);
            return true;
        }
        if (this.getTokenType() != CssElementTypes.CSS_FUNCTION_TOKEN) {
            return false;
        }
        if (this.parseFunctionAcceptingMathExpressions() || this.parseAttrFunction()) {
            return true;
        }
        PsiBuilder.Marker function = this.createCompositeElement();
        String functionName = this.getTokenText();
        this.addToken();
        PsiBuilder.Marker beforeParenthesis = this.createCompositeElement();
        this.addLParenOrError();
        if ("alpha".equalsIgnoreCase(functionName) && "opacity".equalsIgnoreCase(this.getTokenText())) {
            this.parseVariableValue(strict, true, CssElementTypes.CSS_RPAREN);
            this.addRParenOrError();
            beforeParenthesis.drop();
        } else {
            beforeParenthesis.rollbackTo();
            this.parseArgumentList();
        }
        function.done(CssElementTypes.CSS_FUNCTION);
        return true;
    }

    protected CssMathParser getMathParser() {
        return this.SCSS_MATH_PARSER;
    }

    protected boolean parseUriContent() {
        return this.parseCondition(true, false) || this.parseCssString();
    }

    public boolean addIdentOrError() {
        IElementType lastElement = null;
        int offset = this.myBuilder.getCurrentOffset();
        boolean escape = false;
        while (!escape) {
            if (this.parseInterpolation()) {
                lastElement = null;
                escape = this.myBuilder.eof() || !this.isIdent(this.myBuilder.rawLookup(-1)) && this.myBuilder.rawLookup(-1) != SCSSTokenTypes.INTERPOLATION_SUFFIX || CssElementTypes.WHITESPACES.contains(this.myBuilder.rawLookup(-1));
            } else if (SCSSTokenTypes.IDENT_AND_INTERPOLATION.contains(this.getTokenType()) || SCSSTokenTypes.ELEMENTS_AFTER_INTERPOLATION.contains(this.getTokenType())) {
                IElementType nextToken = this.myBuilder.rawLookup(1);
                boolean nextTokenIsIdent = SCSSTokenTypes.IDENT_AND_INTERPOLATION.contains(nextToken) || SCSSTokenTypes.ELEMENTS_AFTER_INTERPOLATION.contains(nextToken);
                escape = this.myBuilder.eof() || !nextTokenIsIdent || CssElementTypes.WHITESPACES.contains(nextToken);
                lastElement = this.getTokenType();
                super.addToken();
            } else {
                escape = true;
            }
            if (lastElement != CssElementTypes.CSS_IDENT || this.getTokenType() != CssElementTypes.CSS_IDENT) continue;
        }
        if (offset == this.myBuilder.getCurrentOffset()) {
            super.addToken();
        }
        return true;
    }

    protected boolean parseIdSelector() {
        if (this.parseInterpolation()) {
            return true;
        }
        if (this.getTokenType() == CssElementTypes.CSS_HASH || this.getTokenType() == SCSSTokenTypes.HASH_SIGN && this.myBuilder.rawLookup(1) == SCSSTokenTypes.INTERPOLATION_PREFIX) {
            boolean escape;
            PsiBuilder.Marker idSelector = this.createCompositeElement();
            this.addToken();
            boolean bl = escape = this.myBuilder.eof() || CssElementTypes.WHITESPACES.contains(this.myBuilder.rawLookup(-1));
            while (!escape) {
                if (this.parseInterpolation()) {
                    escape = this.myBuilder.eof() || !this.isIdent(this.myBuilder.rawLookup(-1)) && this.myBuilder.rawLookup(-1) != SCSSTokenTypes.INTERPOLATION_SUFFIX || CssElementTypes.WHITESPACES.contains(this.myBuilder.rawLookup(-1));
                    continue;
                }
                if (SCSSTokenTypes.IDENT_AND_INTERPOLATION.contains(this.getTokenType()) || SCSSTokenTypes.ELEMENTS_AFTER_INTERPOLATION.contains(this.getTokenType())) {
                    IElementType nextToken = this.myBuilder.rawLookup(1);
                    boolean nextTokenIsIdent = SCSSTokenTypes.IDENT_AND_INTERPOLATION.contains(nextToken) || SCSSTokenTypes.ELEMENTS_AFTER_INTERPOLATION.contains(nextToken);
                    escape = this.myBuilder.eof() || !nextTokenIsIdent || CssElementTypes.WHITESPACES.contains(this.myBuilder.rawLookup(1));
                    super.addToken();
                    continue;
                }
                escape = true;
            }
            idSelector.done(CssStubElementTypes.CSS_ID_SELECTOR);
            return true;
        }
        return false;
    }

    protected boolean parseClass() {
        if (this.getTokenType() == CssElementTypes.CSS_PERCENT) {
            PsiBuilder.Marker placeholderSelector = this.createCompositeElement();
            this.addToken();
            if (!this.hasWhitespaceBefore()) {
                this.addIdentOrError();
            }
            placeholderSelector.done(ScssStubElementTypes.SCSS_PLACEHOLDER_SELECTOR);
            return true;
        }
        return super.parseClass();
    }

    public boolean parseInterpolation() {
        if (this.getTokenType() == SCSSTokenTypes.INTERPOLATION_PREFIX) {
            PsiBuilder.Marker interpolation = this.createCompositeElement();
            this.addSingleToken();
            PsiBuilder.Marker possibleError = this.myBuilder.mark();
            if (!this.parseVariableValue(true, false, SCSSTokenTypes.INTERPOLATION_SUFFIX)) {
                this.moveUntilToken(TokenSet.create((IElementType[])new IElementType[]{SCSSTokenTypes.INTERPOLATION_SUFFIX}));
                possibleError.error(SASSBundle.message("error.text.invalid.term", new Object[0]));
            } else {
                possibleError.drop();
            }
            if (this.getTokenType() == SCSSTokenTypes.INTERPOLATION_SUFFIX) {
                super.addToken();
                interpolation.done(SCSSElementTypes.SCSS_INTERPOLATION);
            } else {
                interpolation.error(SASSBundle.message("error.text.unclosed.interpolation", new Object[0]));
            }
            return true;
        }
        return false;
    }

    protected void parsePropertyOfDeclaration() {
        this.addIdentOrError();
    }

    protected boolean parseCssString() {
        return this.parseCssString(true);
    }

    private boolean parseCssString(boolean withInterpolation) {
        if (this.getTokenType() != CssElementTypes.CSS_STRING_TOKEN) {
            return false;
        }
        PsiBuilder.Marker string = this.createCompositeElement();
        this.addToken();
        while (!this.myBuilder.eof() && !CssElementTypes.WHITESPACES.contains(this.myBuilder.rawLookup(-1))) {
            PsiBuilder.Marker possibleError = this.myBuilder.mark();
            if (this.parseInterpolation()) {
                if (!withInterpolation) {
                    possibleError.error(CssBundle.message((String)"parsing.error.unexpected.interpolation", (Object[])new Object[0]));
                    continue;
                }
                possibleError.drop();
                continue;
            }
            possibleError.drop();
            if (this.getTokenType() != CssElementTypes.CSS_STRING_TOKEN) break;
            this.addToken();
        }
        string.done(CssElementTypes.CSS_STRING);
        return true;
    }

    protected IElementType getStylesheetLazyElementType() {
        return SCSSElementTypes.SCSS_LAZY_STYLESHEET;
    }

    protected IElementType getStylesheetElementType() {
        return ScssStubElementTypes.SCSS_STYLESHEET;
    }
}

