/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.goide.formatter;

import fleet.com.goide.GoLanguage;
import fleet.com.goide.GoParserDefinition;
import fleet.com.goide.GoTypes;
import fleet.com.intellij.formatting.Indent;
import fleet.com.intellij.lang.Language;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.psi.TokenType;
import fleet.com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import fleet.com.intellij.psi.impl.source.codeStyle.lineIndent.IndentCalculator;
import fleet.com.intellij.psi.impl.source.codeStyle.lineIndent.JavaLikeLangLineIndentProvider;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.util.text.CharArrayUtil;
import java.util.HashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoLineIndentProvider {
    private static final HashMap<IElementType, SemanticEditorPosition.SyntaxElement> SYNTAX_MAP = new HashMap<IElementType, SemanticEditorPosition.SyntaxElement>(){
        {
            this.put(TokenType.WHITE_SPACE, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
            this.put(GoParserDefinition.Lazy.NLS, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
            this.put(GoParserDefinition.Lazy.WS, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
            this.put(GoTypes.SEMICOLON_SYNTHETIC, GoElement.NewLine);
            this.put(GoTypes.SEMICOLON, JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon);
            this.put(GoTypes.LBRACE, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace);
            this.put(GoTypes.RBRACE, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
            this.put(GoTypes.LBRACK, JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket);
            this.put(GoTypes.RBRACK, JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket);
            this.put(GoTypes.RPAREN, JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
            this.put(GoTypes.LPAREN, JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis);
            this.put(GoTypes.COLON, JavaLikeLangLineIndentProvider.JavaLikeElement.Colon);
            this.put(GoTypes.CASE, JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase);
            this.put(GoTypes.DEFAULT, JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault);
            this.put(GoTypes.IF, JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword);
            this.put(GoTypes.ELSE, JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword);
            this.put(GoTypes.FOR, JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword);
            this.put(GoParserDefinition.Lazy.MULTILINE_COMMENT, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment);
            this.put(GoTypes.COMMA, JavaLikeLangLineIndentProvider.JavaLikeElement.Comma);
            this.put(GoTypes.SWITCH, GoElement.Switch);
            this.put(GoTypes.SELECT, GoElement.Select);
            this.put(GoTypes.FUNC, GoElement.Func);
            this.put(GoParserDefinition.Lazy.LINE_COMMENT, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment);
        }
    };

    @Nullable
    public static SemanticEditorPosition.SyntaxElement mapType(@NotNull IElementType tokenType) {
        return SYNTAX_MAP.get(tokenType);
    }

    public static boolean isSuitableForLanguage(@NotNull Language language) {
        return language.isKindOf(GoLanguage.INSTANCE);
    }

    @NotNull
    public abstract CharSequence getText();

    public abstract boolean isIndentOnEnterInRawStrings();

    @NotNull
    public abstract JavaLikeLangLineIndentProvider.IndentCalculatorFactory getIndentCalculatorFactory();

    public abstract SemanticEditorPosition getPosition(int var1);

    @Nullable
    public IndentCalculator getIndent(int offset) {
        SemanticEditorPosition prevLeftBrace;
        JavaLikeLangLineIndentProvider.IndentCalculatorFactory factory = this.getIndentCalculatorFactory();
        if (!this.isIndentOnEnterInRawStrings() && this.getPosition(offset).isAt(GoTypes.RAW_STRING)) {
            return factory.createIndentCalculator(Indent.Type.NONE, position -> 0);
        }
        if (this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace}).matchesRule(at -> at.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace) && at.isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{GoElement.Switch, GoElement.Select}))) {
            return factory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
        }
        SemanticEditorPosition rparenBlockStart = GoLineIndentProvider.findBlockStartForRParen(this.getPosition(offset + 1));
        if (rparenBlockStart != null) {
            return factory.createIndentCalculator(Indent.Type.NONE, pos -> rparenBlockStart.getStartOffset());
        }
        if (this.getPosition(offset).matchesRule(at -> at.beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace}).isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis))) {
            Indent.Type indent = GoLineIndentProvider.getIndentTypeInsideParens(this.getText(), this.getPosition(offset), Indent.Type.NORMAL);
            return factory.createIndentCalculator(indent, IndentCalculator.LINE_BEFORE);
        }
        SemanticEditorPosition prevLineEndBeforeComments = this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, GoElement.NewLine, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment});
        if (prevLineEndBeforeComments.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace) && !GoLineIndentProvider.isAtSameLineBeforeRBrace(this.getPosition(offset + 1))) {
            int baseLineOffset = this.getBaseLineOffsetForBlock(prevLineEndBeforeComments.getStartOffset());
            return factory.createIndentCalculator(Indent.Type.NORMAL, position -> baseLineOffset);
        }
        if (this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace}).isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon)) {
            return factory.createIndentCalculator(Indent.Type.NORMAL, IndentCalculator.LINE_BEFORE);
        }
        if (this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace}).isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma)) {
            if (this.getPosition(offset).afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace}).isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)) {
                Indent.Type indent = GoLineIndentProvider.getIndentTypeInsideParens(this.getText(), this.getPosition(offset), Indent.Type.NONE);
                return factory.createIndentCalculator(indent, IndentCalculator.LINE_BEFORE);
            }
            if (this.getPosition(offset).matchesRule(position -> {
                SemanticEditorPosition p = position.afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
                return !p.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis}) && !position.isAtEnd() && GoLineIndentProvider.isTheSameLineLeftParenthesis(position);
            })) {
                Indent.Type indent = GoLineIndentProvider.getIndentTypeInsideParens(this.getText(), this.getPosition(offset), Indent.Type.NONE);
                return factory.createIndentCalculator(indent, IndentCalculator.LINE_BEFORE);
            }
            SemanticEditorPosition comma = this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
            SemanticEditorPosition prevLeftBrace2 = GoLineIndentProvider.prevLeftBrace(comma.copy());
            if (prevLeftBrace2.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
                if (GoLineIndentProvider.isAtSameLine(prevLeftBrace2, comma)) {
                    return factory.createIndentCalculator(Indent.Type.NORMAL, IndentCalculator.LINE_BEFORE);
                }
                IndentCalculator.BaseLineOffsetCalculator calculator = GoLineIndentProvider.isAtSameLineBeforeRBrace(this.getPosition(offset)) ? position -> prevLeftBrace2.getStartOffset() : IndentCalculator.LINE_BEFORE;
                return factory.createIndentCalculator(Indent.Type.NONE, calculator);
            }
        }
        if (this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace}).matchesRule(at -> at.isAt(GoTypes.DOT) || GoLineIndentProvider.isAt(at, GoParserDefinition.Lazy.OPERATOR_TYPES))) {
            return factory.createIndentCalculator(Indent.Type.NORMAL, this::getStatementStartOffset);
        }
        if (GoLineIndentProvider.isAtSameLineBeforeRBrace(this.getPosition(offset + 1)) && !(prevLeftBrace = GoLineIndentProvider.prevLeftBrace(this.getPosition(offset))).isAtEnd()) {
            return factory.createIndentCalculator(Indent.Type.NONE, p -> prevLeftBrace.getStartOffset());
        }
        if (this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, GoElement.NewLine}).matchesRule(at -> at.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace) && at.before().beforeOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace).isAtMultiline())) {
            return factory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
        }
        if (this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, GoElement.NewLine}).matchesRule(at -> at.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis) || !at.isAt(GoTypes.DOT) && !GoLineIndentProvider.isAt(at, GoParserDefinition.Lazy.OPERATOR_TYPES) && !at.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment}))) {
            return factory.createIndentCalculator(Indent.Type.NONE, this::getStatementStartOffset);
        }
        SemanticEditorPosition prevLineEnd = this.getPosition(offset).beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, GoElement.NewLine});
        if (prevLineEnd.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment)) {
            return factory.createIndentCalculator(Indent.Type.NONE, p -> prevLineEnd.getStartOffset());
        }
        return factory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
    }

    private static boolean isAt(@NotNull SemanticEditorPosition at, Set<IElementType> types) {
        for (IElementType type : types) {
            if (!at.isAt(type)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Indent.Type getIndentTypeInsideParens(@NotNull CharSequence text, @NotNull SemanticEditorPosition position, @NotNull Indent.Type fallbackIndentType) {
        SemanticEditorPosition prevLeftParen;
        int offset = position.getStartOffset();
        SemanticEditorPosition firstLeftParen = null;
        while (!(prevLeftParen = position.findLeftParenthesisBackwardsSkippingNested((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)).isAtEnd()) {
            firstLeftParen = prevLeftParen;
            position = prevLeftParen.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
            if (position.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis) && !(position = position.before()).isAtEnd()) continue;
        }
        if (firstLeftParen == null) {
            return fallbackIndentType;
        }
        int leftParenLineEndOffset = StringUtil.indexOf((CharSequence)text, (char)'\n', (int)firstLeftParen.getStartOffset());
        String betweenParenAndPosition = leftParenLineEndOffset <= offset ? text.subSequence(leftParenLineEndOffset, offset) : "";
        return StringUtil.isEmptyOrSpaces((CharSequence)betweenParenAndPosition) ? Indent.Type.NORMAL : Indent.Type.NONE;
    }

    private static boolean isTheSameLineLeftParenthesis(@NotNull SemanticEditorPosition position) {
        return GoLineIndentProvider.isLeftParenthesis(GoLineIndentProvider.prevLeft(position));
    }

    private static boolean isLeftParenthesis(@NotNull SemanticEditorPosition position) {
        return position.matchesRule(it -> it.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis) && !it.after().isAt(GoParserDefinition.Lazy.NLS));
    }

    private static SemanticEditorPosition prevLeft(@NotNull SemanticEditorPosition position) {
        return position.findLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis, e -> e.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon}));
    }

    private static SemanticEditorPosition prevLeftBrace(@NotNull SemanticEditorPosition position) {
        return position.findLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace, e -> false);
    }

    private static boolean isAtSameLineBeforeRBrace(@NotNull SemanticEditorPosition p) {
        return p.afterOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace).matchesRule(it -> it.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace) && GoLineIndentProvider.isAtSameLine(p, it));
    }

    private static boolean isAtSameLine(@NotNull SemanticEditorPosition p1, @NotNull SemanticEditorPosition p2) {
        return !CharArrayUtil.containLineBreaks((CharSequence)p1.getChars(), (int)p1.getStartOffset(), (int)p2.getStartOffset());
    }

    private int getStatementStartOffset(@NotNull SemanticEditorPosition position) {
        SemanticEditorPosition initialPosition = position.copy().after();
        if (initialPosition.isAtEnd()) {
            initialPosition = position.copy();
        }
        boolean wasStartAtClosingBrace = initialPosition.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
        Language currLanguage = position.getLanguage();
        while (!position.isAtEnd()) {
            if (currLanguage == Language.ANY || currLanguage == null) {
                currLanguage = position.getLanguage();
            }
            if (GoLineIndentProvider.moveBeforeParentheses(position)) continue;
            if (!wasStartAtClosingBrace && position.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace) || position.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.DocBlockEnd, JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, JavaLikeLangLineIndentProvider.JavaLikeElement.LanguageStartDelimiter}) || position.getLanguage() != Language.ANY && !position.isAtLanguage(currLanguage) || GoLineIndentProvider.isAtCaseColon(position)) {
                SemanticEditorPosition statementStart = this.getPosition(position.getStartOffset());
                if (!(statementStart = statementStart.after().afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment})).isAtEnd() && statementStart.getStartOffset() < initialPosition.getStartOffset()) {
                    return statementStart.getStartOffset();
                }
            } else if (GoLineIndentProvider.isAt(position, GoParserDefinition.Lazy.ASSIGN_OPERATOR_TYPES)) {
                SemanticEditorPosition after = position.after();
                SemanticEditorPosition afterSpaces = after.afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment});
                if (afterSpaces.isAtEnd() || afterSpaces.getStartOffset() > initialPosition.getStartOffset()) {
                    return after.getStartOffset();
                }
                if (GoLineIndentProvider.isAtSameLine(position, afterSpaces)) {
                    return afterSpaces.getStartOffset();
                }
                SemanticEditorPosition p = initialPosition.copy();
                GoLineIndentProvider.moveToNewlineBackwards(p);
                boolean assignmentComplete = !p.beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment}).matchesRule(it -> it.isAt(GoTypes.DOT) || it.isAt(GoTypes.COMMA) || GoLineIndentProvider.isAt(it, GoParserDefinition.Lazy.OPERATOR_TYPES));
                return assignmentComplete ? position.getStartOffset() : afterSpaces.getStartOffset();
            }
            position.moveBefore();
        }
        return 0;
    }

    private static void moveToNewlineBackwards(@NotNull SemanticEditorPosition position) {
        while (!position.isAtEnd()) {
            if (position.isAt(GoParserDefinition.Lazy.NLS)) {
                return;
            }
            position.moveBefore();
        }
    }

    private static boolean isAtCaseColon(@NotNull SemanticEditorPosition position) {
        return position.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon) && position.copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase, JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault});
    }

    private int getBaseLineOffsetForBlock(int openBraceOffset) {
        if (openBraceOffset == 0) {
            return openBraceOffset;
        }
        SemanticEditorPosition p = this.getPosition(openBraceOffset - 1);
        while (!p.isAtEnd()) {
            if (p.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword, GoElement.Func})) {
                return p.getStartOffset();
            }
            if (GoLineIndentProvider.moveBeforeParentheses(p)) continue;
            if (p.isAt(GoParserDefinition.Lazy.NLS)) {
                SemanticEditorPosition prevLineEnd = p.copy();
                prevLineEnd.moveBeforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, GoElement.NewLine, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment});
                if (prevLineEnd.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword, GoElement.Func})) {
                    return prevLineEnd.getStartOffset();
                }
                if (!(GoLineIndentProvider.isAt(prevLineEnd, GoParserDefinition.Lazy.OPERATOR_TYPES) || prevLineEnd.isAt(GoTypes.COMMA) || prevLineEnd.isAt(GoTypes.COLON))) {
                    return p.after().getStartOffset();
                }
                p = prevLineEnd;
                continue;
            }
            p.moveBefore();
        }
        return 0;
    }

    private static boolean moveBeforeParentheses(@NotNull SemanticEditorPosition p) {
        if (p.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)) {
            p.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
            return true;
        }
        if (p.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace)) {
            p.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
            return true;
        }
        if (p.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket)) {
            p.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket);
            return true;
        }
        return false;
    }

    @Nullable
    private static SemanticEditorPosition findBlockStartForRParen(@NotNull SemanticEditorPosition p) {
        SemanticEditorPosition beforeLeftParen;
        SemanticEditorPosition leftParen;
        SemanticEditorPosition afterSpaces = p.afterOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
        if (afterSpaces.matchesRule(it -> it.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis) && GoLineIndentProvider.isAtSameLine(p, it)) && !(leftParen = afterSpaces.beforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)).isAtEnd() && (beforeLeftParen = leftParen.beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, GoElement.NewLine})).matchesRule(it -> it.isAt(GoTypes.VAR) || it.isAt(GoTypes.CONST) || it.isAt(GoTypes.TYPE_) || it.isAt(GoTypes.IMPORT))) {
            return beforeLeftParen;
        }
        return null;
    }

    private static enum GoElement implements SemanticEditorPosition.SyntaxElement
    {
        Switch,
        Select,
        NewLine,
        Func;

    }
}

