/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.markdown.frontend.language.typingAssists;

import andel.editor.MutableEditor;
import andel.editor.TransientEditor;
import andel.text.TextLine;
import andel.text.TextRange;
import andel.text.TextView;
import andel.text.TextViewExtKt;
import fleet.ast.AST;
import fleet.ast.SyntaxDocumentComponentKt;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.frontend.editor.typing.TypingAssistsBuilder;
import fleet.plugins.markdown.frontend.language.typingAssists.MarkdownListEnterTypingAssistKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\f\u0010\u000e\u001a\u00020\u0004*\u00020\u0006H\u0002\u001a\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u0006*\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0002\u001a$\u0010\u0014\u001a\u00020\u0015*\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u0006*\u00020\u00062\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0002\u00a8\u0006\u001b"}, d2={"enterInList", "", "Lfleet/frontend/editor/typing/TypingAssistsBuilder;", "isNestedListItem", "", "item", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "getParentListItem", "isEmptyListItem", "obtainNextListMarkerText", "", "obtainNextNumberedListMarkerText", "marker", "findListMarker", "isListMarker", "findListItem", "Landel/editor/TransientEditor;", "offset", "", "Lfleet/com/jetbrains/lang/syntax/CharOffset;", "shiftBackward", "", "minOffset", "maxOffset", "chars", "", "findLeaf", "fleet.plugins.markdown.frontend"})
@SourceDebugExtension(value={"SMAP\nMarkdownListEnterTypingAssist.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownListEnterTypingAssist.kt\nfleet/plugins/markdown/frontend/language/typingAssists/MarkdownListEnterTypingAssistKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,125:1\n401#2,4:126\n635#2,5:130\n*S KotlinDebug\n*F\n+ 1 MarkdownListEnterTypingAssist.kt\nfleet/plugins/markdown/frontend/language/typingAssists/MarkdownListEnterTypingAssistKt\n*L\n75#1:126,4\n76#1:130,5\n*E\n"})
public final class MarkdownListEnterTypingAssistKt {
    public static final void enterInList(@NotNull TypingAssistsBuilder $this$enterInList) {
        Intrinsics.checkNotNullParameter((Object)$this$enterInList, (String)"<this>");
        $this$enterInList.enter("Enter after header", (Function1)enterInList.1.INSTANCE);
    }

    private static final boolean isNestedListItem(SyntaxNode item) {
        SyntaxNode parentList = item.parent();
        SyntaxNode syntaxNode = parentList;
        if (syntaxNode == null || (syntaxNode = syntaxNode.parent()) == null || (syntaxNode = syntaxNode.parent()) == null) {
            return false;
        }
        SyntaxNode grandParentList = syntaxNode;
        return Intrinsics.areEqual((Object)grandParentList.getType(), (Object)MarkdownElementTypes.UNORDERED_LIST) || Intrinsics.areEqual((Object)grandParentList.getType(), (Object)MarkdownElementTypes.ORDERED_LIST);
    }

    @Nullable
    public static final SyntaxNode getParentListItem(@NotNull SyntaxNode item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        SyntaxNode syntaxNode = item.parent();
        return syntaxNode != null ? syntaxNode.parent() : null;
    }

    private static final boolean isEmptyListItem(SyntaxNode item) {
        Sequence children2 = SequencesKt.filterNot((Sequence)SyntaxNodeExtKt.children((SyntaxNode)item), (Function1)isEmptyListItem.children.1.INSTANCE);
        String text2 = SequencesKt.joinToString$default((Sequence)children2, (CharSequence)"", null, null, (int)0, null, (Function1)isEmptyListItem.text.1.INSTANCE, (int)30, null);
        return ((CharSequence)text2).length() == 0;
    }

    private static final CharSequence obtainNextListMarkerText(SyntaxNode item) {
        SyntaxNode syntaxNode = MarkdownListEnterTypingAssistKt.findListMarker(item);
        if (syntaxNode == null) {
            return "";
        }
        SyntaxNode marker = syntaxNode;
        return Intrinsics.areEqual((Object)marker.getType(), (Object)MarkdownTokenTypes.LIST_NUMBER) ? MarkdownListEnterTypingAssistKt.obtainNextNumberedListMarkerText(marker) : marker.getText();
    }

    private static final CharSequence obtainNextNumberedListMarkerText(SyntaxNode marker) {
        CharSequence charSequence;
        CharSequence text2;
        block4: {
            CharSequence charSequence2;
            block3: {
                CharSequence $this$dropWhile$iv = marker.getText();
                boolean $i$f$dropWhile = false;
                int n = $this$dropWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it = $this$dropWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (it == ' ') continue;
                    charSequence2 = $this$dropWhile$iv.subSequence(index$iv, $this$dropWhile$iv.length());
                    break block3;
                }
                charSequence2 = "";
            }
            CharSequence $this$takeWhile$iv = text2 = charSequence2;
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (Character.isDigit(it)) continue;
                charSequence = $this$takeWhile$iv.subSequence(0, index$iv);
                break block4;
            }
            charSequence = $this$takeWhile$iv.subSequence(0, $this$takeWhile$iv.length());
        }
        CharSequence number = charSequence;
        CharSequence tail = StringsKt.removePrefix((CharSequence)text2, (CharSequence)number);
        Integer n = StringsKt.toIntOrNull((String)((Object)number).toString());
        if (n == null) {
            return tail;
        }
        int value = n;
        return "" + (value + 1) + tail;
    }

    private static final SyntaxNode findListMarker(SyntaxNode item) {
        Sequence elements2 = SequencesKt.filter((Sequence)SyntaxNodeExtKt.descendants$default((SyntaxNode)item, null, (int)1, null), (Function1)findListMarker.elements.1.INSTANCE);
        return (SyntaxNode)SequencesKt.firstOrNull((Sequence)elements2);
    }

    private static final boolean isListMarker(SyntaxNode $this$isListMarker) {
        return Intrinsics.areEqual((Object)$this$isListMarker.getType(), (Object)MarkdownTokenTypes.LIST_BULLET) || Intrinsics.areEqual((Object)$this$isListMarker.getType(), (Object)MarkdownTokenTypes.LIST_NUMBER);
    }

    private static final SyntaxNode findListItem(TransientEditor $this$findListItem, long offset) {
        TextLine line = TextViewExtKt.textLineAtOffset$default((TextView)$this$findListItem.getDocument().getText().view(), (int)((int)offset), (boolean)false, (int)2, null).withoutSeparator();
        TextRange lineRange = line.getRange();
        long possibleOffset = MarkdownListEnterTypingAssistKt.shiftBackward((CharSequence)TextViewExtKt.charSequence((TextView)$this$findListItem.getDocument().getText().view()), (int)lineRange.getStart(), (int)lineRange.getEnd(), " \n\t");
        AST aST = SyntaxDocumentComponentKt.getActualAstAtOffset$default((MutableEditor)((MutableEditor)$this$findListItem), (long)possibleOffset, (long)0L, (long)0L, (int)6, null);
        if (aST == null || (aST = aST.root()) == null) {
            return null;
        }
        AST tree = aST;
        SyntaxNode syntaxNode = MarkdownListEnterTypingAssistKt.findLeaf((SyntaxNode)tree, possibleOffset);
        if (syntaxNode == null) {
            return null;
        }
        SyntaxNode element = syntaxNode;
        Sequence items2 = SequencesKt.filter((Sequence)SyntaxNodeExtKt.ancestors$default((SyntaxNode)element, (boolean)false, (int)1, null), (Function1)findListItem.items.1.INSTANCE);
        return (SyntaxNode)SequencesKt.firstOrNull((Sequence)items2);
    }

    private static final int shiftBackward(CharSequence $this$shiftBackward, int minOffset, int maxOffset, String chars) {
        int offset;
        if (maxOffset >= $this$shiftBackward.length()) {
            return maxOffset;
        }
        for (offset = maxOffset; offset >= minOffset && StringsKt.contains$default((CharSequence)chars, (char)$this$shiftBackward.charAt(offset), (boolean)false, (int)2, null); --offset) {
        }
        return offset;
    }

    private static final SyntaxNode findLeaf(SyntaxNode $this$findLeaf, long offset) {
        SyntaxNode exactLeaf = SyntaxNodeExtKt.leafByOffset((SyntaxNode)$this$findLeaf, (long)offset);
        if (exactLeaf != null) {
            return exactLeaf;
        }
        return offset > 0L ? SyntaxNodeExtKt.leafByOffset((SyntaxNode)$this$findLeaf, (long)(offset - 1L)) : null;
    }

    public static final /* synthetic */ SyntaxNode access$findListItem(TransientEditor $receiver, long offset) {
        return MarkdownListEnterTypingAssistKt.findListItem($receiver, offset);
    }

    public static final /* synthetic */ boolean access$isEmptyListItem(SyntaxNode item) {
        return MarkdownListEnterTypingAssistKt.isEmptyListItem(item);
    }

    public static final /* synthetic */ boolean access$isNestedListItem(SyntaxNode item) {
        return MarkdownListEnterTypingAssistKt.isNestedListItem(item);
    }

    public static final /* synthetic */ CharSequence access$obtainNextListMarkerText(SyntaxNode item) {
        return MarkdownListEnterTypingAssistKt.obtainNextListMarkerText(item);
    }

    public static final /* synthetic */ boolean access$isListMarker(SyntaxNode $receiver) {
        return MarkdownListEnterTypingAssistKt.isListMarker($receiver);
    }
}

