/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.ui.notifications.commonNotifications;

import com.jetbrains.rhizomedb.ChangeScope;
import fleet.frontend.notifications.NotificationCategory;
import fleet.frontend.notifications.NotificationCategoryId;
import fleet.frontend.notifications.NotificationEntity;
import fleet.frontend.notifications.NotificationIcon;
import fleet.frontend.notifications.NotificationLinkExternal;
import fleet.frontend.notifications.NotificationsKt;
import fleet.frontend.ui.notifications.commonNotifications.FsdError;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\t"}, d2={"FsdErrorNotificationCategory", "Lfleet/frontend/notifications/NotificationCategory;", "getFsdErrorNotificationCategory", "()Lfleet/frontend/notifications/NotificationCategory;", "createFsdErrorNotification", "Lfleet/frontend/notifications/NotificationEntity;", "Lcom/jetbrains/rhizomedb/ChangeScope;", "errorCode", "", "fleet.frontend.ui"})
public final class FsdErrorNotificationKt {
    @NotNull
    private static final NotificationCategory FsdErrorNotificationCategory = new NotificationCategory(NotificationCategoryId.constructor-impl((String)"fsdaemon"), "FSDaemon", null, 4, null);

    @NotNull
    public static final NotificationCategory getFsdErrorNotificationCategory() {
        return FsdErrorNotificationCategory;
    }

    @NotNull
    public static final NotificationEntity createFsdErrorNotification(@NotNull ChangeScope $this$createFsdErrorNotification, @NotNull String errorCode) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$createFsdErrorNotification, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        Pair pair = Intrinsics.areEqual((Object)errorCode, (Object)"INOTIFY_LIMIT") ? TuplesKt.to((Object)"Inotify watches limit reached", (Object)FsdError.INotifyLimit.INSTANCE) : TuplesKt.to((Object)"Error has occurred in fsdaemon", (Object)new FsdError.Other("Error code: " + errorCode));
        String title2 = (String)pair.component1();
        FsdError error2 = (FsdError)pair.component2();
        NotificationCategory notificationCategory = FsdErrorNotificationCategory;
        NotificationIcon notificationIcon = NotificationIcon.Companion.getError();
        Object object = error2;
        if (Intrinsics.areEqual((Object)object, (Object)FsdError.INotifyLimit.INSTANCE)) {
            string = "Fleet will not be able to react to file system changes.";
        } else if (object instanceof FsdError.Other) {
            string = ((FsdError.Other)error2).getText();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String string2 = string;
        object = Intrinsics.areEqual((Object)error2, (Object)FsdError.INotifyLimit.INSTANCE) ? CollectionsKt.listOf((Object)new NotificationLinkExternal("Read more", "https://fleet-support.jetbrains.com/hc/en-us/articles/8084899752722-Inotify-Watches-Limit-Linux")) : CollectionsKt.emptyList();
        return NotificationsKt.showNotification$default((ChangeScope)$this$createFsdErrorNotification, (NotificationCategory)notificationCategory, (String)title2, (NotificationIcon)notificationIcon, (String)string2, (boolean)true, null, (List)object, null, (int)160, null);
    }
}

