/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.util.containers;

import fleet.com.intellij.util.containers.CanonicalObjectStrategy;
import fleet.com.intellij.util.containers.FastUtilCaseInsensitiveStringHashingStrategy;
import fleet.com.intellij.util.containers.FastUtilCharSequenceHashingStrategy;
import fleet.com.intellij.util.containers.HashingStrategy;
import it.unimi.dsi.fastutil.Hash;
import java.io.Serializable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FastUtilHashingStrategies {
    private static final Hash.Strategy<CharSequence> CASE_SENSITIVE = new FastUtilCharSequenceHashingStrategy(true);
    private static final Hash.Strategy<CharSequence> CASE_INSENSITIVE = new FastUtilCharSequenceHashingStrategy(false);

    private FastUtilHashingStrategies() {
    }

    @NotNull
    public static Hash.Strategy<CharSequence> getCharSequenceStrategy(boolean isCaseSensitive) {
        return isCaseSensitive ? CASE_SENSITIVE : CASE_INSENSITIVE;
    }

    @NotNull
    public static Hash.Strategy<String> getStringStrategy(boolean isCaseSensitive) {
        return isCaseSensitive ? FastUtilHashingStrategies.getCanonicalStrategy() : FastUtilCaseInsensitiveStringHashingStrategy.INSTANCE;
    }

    @NotNull
    public static Hash.Strategy<String> getCaseInsensitiveStringStrategy() {
        return FastUtilCaseInsensitiveStringHashingStrategy.INSTANCE;
    }

    @NotNull
    public static <T> Hash.Strategy<T> getCanonicalStrategy() {
        return CanonicalObjectStrategy.INSTANCE;
    }

    @NotNull
    public static <T> Hash.Strategy<T> adaptAsNotNull(final @NotNull HashingStrategy<? super T> hashingStrategy) {
        return new Hash.Strategy<T>(){

            public int hashCode(@Nullable T o) {
                return o == null ? 0 : hashingStrategy.hashCode(o);
            }

            public boolean equals(@Nullable T a, @Nullable T b) {
                return a == b || a != null && b != null && hashingStrategy.equals(a, b);
            }
        };
    }

    static interface SerializableHashStrategy<T>
    extends Hash.Strategy<T>,
    Serializable {
    }
}

