/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.util.containers;

import fleet.com.intellij.util.containers.FastUtilHashingStrategies;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CollectionFactory {
    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive, int expectedSize, float loadFactor) {
        return new ObjectOpenCustomHashSet(expectedSize, loadFactor, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(List<CharSequence> items) {
        return new ObjectOpenCustomHashSet(items, FastUtilHashingStrategies.getCharSequenceStrategy(true));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive, int expectedSize) {
        return new ObjectOpenCustomHashSet(expectedSize, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive) {
        return new ObjectOpenCustomHashSet(FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(boolean caseSensitive) {
        return new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet() {
        return new ObjectOpenCustomHashSet(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap() {
        return new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }
}

