/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.parser;

import fleet.com.intellij.analysis.AnalysisBundle;
import fleet.com.intellij.lang.BraceMatchers;
import fleet.com.intellij.lang.BracePair;
import fleet.com.intellij.lang.Language;
import fleet.com.intellij.lang.LighterASTNode;
import fleet.com.intellij.lang.PairedBraceMatcher;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.PsiParser;
import fleet.com.intellij.lang.SyntaxTreeBuilder;
import fleet.com.intellij.lang.WhitespacesAndCommentsBinder;
import fleet.com.intellij.lang.WhitespacesBinders;
import fleet.com.intellij.lang.impl.PsiBuilderAdapter;
import fleet.com.intellij.openapi.diagnostic.Logger;
import fleet.com.intellij.openapi.util.Comparing;
import fleet.com.intellij.openapi.util.Pair;
import fleet.com.intellij.openapi.util.text.StringHash;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.openapi.util.text.Strings;
import fleet.com.intellij.psi.TokenType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.intellij.util.PairProcessor;
import fleet.com.intellij.util.containers.ContainerUtil;
import fleet.com.intellij.util.containers.LimitedPool;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratedParserUtilBase {
    private static final Logger LOG = Logger.getInstance(GeneratedParserUtilBase.class);
    private static final int MAX_RECURSION_LEVEL = StringUtil.parseInt(System.getProperty("grammar.kit.gpub.max.level"), 1000);
    private static final int MAX_VARIANTS_SIZE = 10000;
    private static final int MAX_VARIANTS_TO_DISPLAY = 50;
    private static final int MAX_ERROR_TOKEN_TEXT = 20;
    private static final int INITIAL_VARIANTS_SIZE = 1000;
    private static final int VARIANTS_POOL_SIZE = 10000;
    private static final int FRAMES_POOL_SIZE = 500;
    public static final IElementType DUMMY_BLOCK = new DummyBlockElementType();
    public static final Parser TOKEN_ADVANCER = (builder, level) -> {
        if (builder.eof()) {
            return false;
        }
        builder.advanceLexer();
        return true;
    };
    public static final Parser TRUE_CONDITION = (builder, level) -> true;
    public static final Hook<WhitespacesAndCommentsBinder> LEFT_BINDER = (builder, marker, param) -> {
        if (marker != null) {
            marker.setCustomEdgeTokenBinders((WhitespacesAndCommentsBinder)param, null);
        }
        return marker;
    };
    public static final Hook<WhitespacesAndCommentsBinder> RIGHT_BINDER = (builder, marker, param) -> {
        if (marker != null) {
            marker.setCustomEdgeTokenBinders(null, (WhitespacesAndCommentsBinder)param);
        }
        return marker;
    };
    public static final Hook<WhitespacesAndCommentsBinder[]> WS_BINDERS = (builder, marker, param) -> {
        if (marker != null) {
            marker.setCustomEdgeTokenBinders(param[0], param[1]);
        }
        return marker;
    };
    public static final int _NONE_ = 0;
    public static final int _COLLAPSE_ = 1;
    public static final int _LEFT_ = 2;
    public static final int _LEFT_INNER_ = 4;
    public static final int _AND_ = 8;
    public static final int _NOT_ = 16;
    public static final int _UPPER_ = 32;
    private static final int MAX_CHILDREN_IN_TREE = 10;

    public static boolean eof(PsiBuilder builder, int level) {
        return builder.eof();
    }

    public static int current_position_(PsiBuilder builder) {
        return builder.rawTokenIndex();
    }

    public static boolean recursion_guard_(PsiBuilder builder, int level, String funcName) {
        if (level > MAX_RECURSION_LEVEL) {
            builder.mark().error(AnalysisBundle.message("parsing.error.maximum.recursion.level.reached.in", MAX_RECURSION_LEVEL, funcName));
            return false;
        }
        return true;
    }

    public static boolean empty_element_parsed_guard_(PsiBuilder builder, String funcName, int pos) {
        if (pos == GeneratedParserUtilBase.current_position_(builder)) {
            builder.error(AnalysisBundle.message("parsing.error.empty.element.parsed.in.at.offset", funcName, builder.getCurrentOffset()));
            return false;
        }
        return true;
    }

    public static boolean invalid_left_marker_guard_(PsiBuilder builder, PsiBuilder.Marker marker, String funcName) {
        boolean goodMarker;
        boolean bl = goodMarker = marker != null;
        if (!goodMarker) {
            return false;
        }
        ErrorState state = ErrorState.get(builder);
        return state.currentFrame != null;
    }

    public static TokenSet create_token_set_(IElementType ... tokenTypes) {
        return TokenSet.create(tokenTypes);
    }

    public static boolean leftMarkerIs(PsiBuilder builder, IElementType type) {
        LighterASTNode marker = builder.getLatestDoneMarker();
        return marker != null && marker.getTokenType() == type;
    }

    private static boolean consumeTokens(PsiBuilder builder, boolean smart, int pin, IElementType ... tokens) {
        ErrorState state = ErrorState.get(builder);
        boolean result = true;
        boolean pinned = false;
        int tokensLength = tokens.length;
        for (int i = 0; i < tokensLength; ++i) {
            boolean fast;
            if (pin > 0 && i == pin) {
                pinned = result;
            }
            if (!result && !pinned) continue;
            boolean bl = fast = smart && i == 0;
            if (!fast ? GeneratedParserUtilBase.consumeToken(builder, tokens[i]) : GeneratedParserUtilBase.consumeTokenFast(builder, tokens[i])) continue;
            result = false;
            if (pin >= 0 && !pinned) continue;
            GeneratedParserUtilBase.report_error_(builder, state, false);
        }
        return pinned || result;
    }

    public static boolean consumeTokens(PsiBuilder builder, int pin, IElementType ... token) {
        return GeneratedParserUtilBase.consumeTokens(builder, false, pin, token);
    }

    public static boolean consumeTokensSmart(PsiBuilder builder, int pin, IElementType ... token) {
        return GeneratedParserUtilBase.consumeTokens(builder, true, pin, token);
    }

    public static boolean parseTokens(PsiBuilder builder, int pin, IElementType ... tokens) {
        return GeneratedParserUtilBase.parseTokens(builder, false, pin, tokens);
    }

    public static boolean parseTokensSmart(PsiBuilder builder, int pin, IElementType ... tokens) {
        return GeneratedParserUtilBase.parseTokens(builder, true, pin, tokens);
    }

    public static boolean parseTokens(PsiBuilder builder, boolean smart, int pin, IElementType ... tokens) {
        PsiBuilder.Marker marker = builder.mark();
        boolean result = GeneratedParserUtilBase.consumeTokens(builder, smart, pin, tokens);
        if (!result) {
            marker.rollbackTo();
        } else {
            marker.drop();
        }
        return result;
    }

    public static boolean consumeTokenSmart(PsiBuilder builder, IElementType token) {
        return GeneratedParserUtilBase.consumeTokenFast(builder, token);
    }

    public static boolean consumeTokenSmart(PsiBuilder builder, String token) {
        return GeneratedParserUtilBase.consumeTokenFast(builder, token);
    }

    public static boolean consumeToken(PsiBuilder builder, IElementType token) {
        GeneratedParserUtilBase.addVariantSmart(builder, token, true);
        if (GeneratedParserUtilBase.nextTokenIsFast(builder, token)) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean consumeTokenFast(PsiBuilder builder, IElementType token) {
        if (GeneratedParserUtilBase.nextTokenIsFast(builder, token)) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean consumeToken(PsiBuilder builder, String text) {
        return GeneratedParserUtilBase.consumeToken(builder, text, ErrorState.get((PsiBuilder)builder).caseSensitive);
    }

    public static boolean consumeToken(PsiBuilder builder, String text, boolean caseSensitive) {
        GeneratedParserUtilBase.addVariantSmart(builder, text, true);
        int count = GeneratedParserUtilBase.nextTokenIsFast(builder, text, caseSensitive);
        if (count > 0) {
            while (count-- > 0) {
                builder.advanceLexer();
            }
            return true;
        }
        return false;
    }

    public static boolean consumeTokenFast(PsiBuilder builder, String text) {
        int count = GeneratedParserUtilBase.nextTokenIsFast(builder, text, ErrorState.get((PsiBuilder)builder).caseSensitive);
        if (count > 0) {
            while (count-- > 0) {
                builder.advanceLexer();
            }
            return true;
        }
        return false;
    }

    public static boolean consumeToken(PsiBuilder builder, TokenSet tokens) {
        GeneratedParserUtilBase.addVariantSmart(builder, tokens.getTypes(), true);
        return GeneratedParserUtilBase.consumeTokenFast(builder, tokens);
    }

    public static boolean consumeTokenSmart(PsiBuilder builder, TokenSet tokens) {
        return GeneratedParserUtilBase.consumeTokenFast(builder, tokens);
    }

    public static boolean consumeTokenFast(PsiBuilder builder, TokenSet tokens) {
        if (GeneratedParserUtilBase.nextTokenIsFast(builder, tokens)) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean nextTokenIsFast(PsiBuilder builder, IElementType token) {
        return builder.getTokenType() == token;
    }

    public static boolean nextTokenIsFast(PsiBuilder builder, IElementType ... tokens) {
        IElementType tokenType = builder.getTokenType();
        for (IElementType token : tokens) {
            if (token != tokenType) continue;
            return true;
        }
        return false;
    }

    public static boolean nextTokenIsFast(PsiBuilder builder, TokenSet tokens) {
        return tokens.contains(builder.getTokenType());
    }

    public static boolean nextTokenIsSmart(PsiBuilder builder, IElementType token) {
        return GeneratedParserUtilBase.nextTokenIsFast(builder, token);
    }

    public static boolean nextTokenIsSmart(PsiBuilder builder, IElementType ... tokens) {
        return GeneratedParserUtilBase.nextTokenIsFast(builder, tokens);
    }

    public static boolean nextTokenIs(PsiBuilder builder, String frameName, IElementType ... tokens) {
        ErrorState state = ErrorState.get(builder);
        boolean track = !state.suppressErrors && state.predicateCount < 2 && state.predicateSign;
        return !track ? GeneratedParserUtilBase.nextTokenIsFast(builder, tokens) : GeneratedParserUtilBase.nextTokenIsSlow(builder, frameName, tokens);
    }

    public static boolean nextTokenIsSlow(PsiBuilder builder, String frameName, IElementType ... tokens) {
        ErrorState state = ErrorState.get(builder);
        IElementType tokenType = builder.getTokenType();
        if (Strings.isNotEmpty(frameName)) {
            GeneratedParserUtilBase.addVariantInner(state, state.currentFrame, builder.rawTokenIndex(), frameName);
        } else {
            for (IElementType token : tokens) {
                GeneratedParserUtilBase.addVariant(builder, state, token);
            }
        }
        if (tokenType == null) {
            return false;
        }
        for (IElementType token : tokens) {
            if (tokenType != token) continue;
            return true;
        }
        return false;
    }

    public static boolean nextTokenIs(PsiBuilder builder, IElementType token) {
        if (!GeneratedParserUtilBase.addVariantSmart(builder, token, false)) {
            return true;
        }
        return GeneratedParserUtilBase.nextTokenIsFast(builder, token);
    }

    public static boolean nextTokenIs(PsiBuilder builder, String tokenText) {
        if (!GeneratedParserUtilBase.addVariantSmart(builder, tokenText, false)) {
            return true;
        }
        return GeneratedParserUtilBase.nextTokenIsFast(builder, tokenText, ErrorState.get((PsiBuilder)builder).caseSensitive) > 0;
    }

    public static boolean nextTokenIsFast(PsiBuilder builder, String tokenText) {
        return GeneratedParserUtilBase.nextTokenIsFast(builder, tokenText, ErrorState.get((PsiBuilder)builder).caseSensitive) > 0;
    }

    public static int nextTokenIsFast(PsiBuilder builder, String tokenText, boolean caseSensitive) {
        int nextOffset;
        int endOffset;
        int offset;
        CharSequence sequence = builder.getOriginalText();
        CharSequence subSequence = sequence.subSequence(offset = builder.getCurrentOffset(), Math.min(endOffset = offset + tokenText.length(), sequence.length()));
        if (!Comparing.equal(subSequence, (CharSequence)tokenText, caseSensitive)) {
            return 0;
        }
        int count = 0;
        do {
            if ((nextOffset = builder.rawTokenTypeStart(++count)) <= endOffset) continue;
            return -count;
        } while (nextOffset != endOffset);
        return count;
    }

    private static boolean addVariantSmart(PsiBuilder builder, Object token, boolean force) {
        ErrorState state = ErrorState.get(builder);
        builder.eof();
        if (!state.suppressErrors && state.predicateCount < 2) {
            GeneratedParserUtilBase.addVariant(builder, state, token);
        }
        return true;
    }

    public static void addVariant(PsiBuilder builder, String text) {
        GeneratedParserUtilBase.addVariant(builder, ErrorState.get(builder), text);
    }

    private static void addVariant(PsiBuilder builder, ErrorState state, Object o) {
        builder.eof();
        GeneratedParserUtilBase.addVariantInner(state, state.currentFrame, builder.rawTokenIndex(), o);
    }

    private static void addVariantInner(ErrorState state, Frame frame, int pos, Object o) {
        Variant variant = state.VARIANTS.alloc().init(pos, o);
        if (state.predicateSign) {
            state.variants.add(variant);
            if (frame.lastVariantAt < pos) {
                frame.lastVariantAt = pos;
            }
        } else {
            state.unexpected.add(variant);
        }
    }

    public static boolean isWhitespaceOrComment(@NotNull PsiBuilder builder, @Nullable IElementType type) {
        return ((Builder)builder).getDelegate().isWhitespaceOrComment(type);
    }

    private static boolean wasAutoSkipped(@NotNull PsiBuilder builder, int steps) {
        for (int i = -1; i >= -steps; --i) {
            if (GeneratedParserUtilBase.isWhitespaceOrComment(builder, builder.rawLookup(i))) continue;
            return false;
        }
        return true;
    }

    public static PsiBuilder.Marker enter_section_(PsiBuilder builder) {
        ErrorState state = ErrorState.get(builder);
        GeneratedParserUtilBase.reportFrameError(builder, state);
        ++state.level;
        return builder.mark();
    }

    public static void exit_section_(PsiBuilder builder, PsiBuilder.Marker marker, @Nullable IElementType elementType, boolean result) {
        ErrorState state = ErrorState.get(builder);
        GeneratedParserUtilBase.close_marker_impl_(state.currentFrame, marker, elementType, result);
        GeneratedParserUtilBase.run_hooks_impl_(builder, state, result ? elementType : null);
        --state.level;
    }

    public static PsiBuilder.Marker enter_section_(PsiBuilder builder, int level, int modifiers, String frameName) {
        return GeneratedParserUtilBase.enter_section_(builder, level, modifiers, null, frameName);
    }

    public static PsiBuilder.Marker enter_section_(PsiBuilder builder, int level, int modifiers) {
        return GeneratedParserUtilBase.enter_section_(builder, level, modifiers, null, null);
    }

    public static PsiBuilder.Marker enter_section_(PsiBuilder builder, int level, int modifiers, IElementType elementType, String frameName) {
        GeneratedParserUtilBase.reportFrameError(builder, ErrorState.get(builder));
        PsiBuilder.Marker marker = builder.mark();
        GeneratedParserUtilBase.enter_section_impl_(builder, level, modifiers, elementType, frameName);
        return marker;
    }

    private static void enter_section_impl_(PsiBuilder builder, int level, int modifiers, IElementType elementType, String frameName) {
        PsiBuilder.Marker left;
        ErrorState state = ErrorState.get(builder);
        ++state.level;
        Frame frame = state.FRAMES.alloc().init(builder, state, level, modifiers, elementType, frameName);
        if ((frame.modifiers & 2 | frame.modifiers & 4) != 0 && GeneratedParserUtilBase.invalid_left_marker_guard_(builder, left = (PsiBuilder.Marker)builder.getLatestDoneMarker(), frameName)) {
            frame.leftMarker = left;
        }
        state.currentFrame = frame;
        if ((modifiers & 8) != 0) {
            if (state.predicateCount == 0 && !state.predicateSign) {
                throw new AssertionError((Object)"Incorrect false predicate sign");
            }
            ++state.predicateCount;
        } else if ((modifiers & 0x10) != 0) {
            state.predicateSign = state.predicateCount != 0 && !state.predicateSign;
            ++state.predicateCount;
        }
    }

    public static void exit_section_(PsiBuilder builder, int level, PsiBuilder.Marker marker, boolean result, boolean pinned, @Nullable Parser eatMore) {
        GeneratedParserUtilBase.exit_section_(builder, level, marker, null, result, pinned, eatMore);
    }

    public static void exit_section_(PsiBuilder builder, int level, PsiBuilder.Marker marker, @Nullable IElementType elementType, boolean result, boolean pinned, @Nullable Parser eatMore) {
        ErrorState state = ErrorState.get(builder);
        Frame frame = state.currentFrame;
        Frame frame2 = state.currentFrame = frame == null ? null : frame.parentFrame;
        if (frame != null && frame.elementType != null) {
            elementType = frame.elementType;
        }
        if (frame == null || level != frame.level) {
            LOG.error("Unbalanced error section: got " + frame + ", expected level " + level);
            if (frame != null) {
                state.FRAMES.recycle(frame);
            }
            GeneratedParserUtilBase.close_marker_impl_(frame, marker, elementType, result);
            return;
        }
        GeneratedParserUtilBase.close_frame_impl_(state, frame, builder, marker, elementType, result, pinned);
        GeneratedParserUtilBase.exit_section_impl_(state, frame, builder, elementType, result, pinned, eatMore);
        GeneratedParserUtilBase.run_hooks_impl_(builder, state, pinned || result ? elementType : null);
        state.FRAMES.recycle(frame);
        --state.level;
    }

    public static <T> void register_hook_(PsiBuilder builder, Hook<T> hook, T param) {
        ErrorState state = ErrorState.get(builder);
        state.hooks = Hooks.concat(hook, param, state.level, state.hooks);
    }

    @SafeVarargs
    public static <T> void register_hook_(PsiBuilder builder, Hook<T[]> hook, T ... param) {
        ErrorState state = ErrorState.get(builder);
        state.hooks = Hooks.concat(hook, param, state.level, state.hooks);
    }

    private static void run_hooks_impl_(PsiBuilder builder, ErrorState state, @Nullable IElementType elementType) {
        PsiBuilder.Marker marker;
        if (state.hooks == null) {
            return;
        }
        PsiBuilder.Marker marker2 = marker = elementType == null ? null : (PsiBuilder.Marker)builder.getLatestDoneMarker();
        if (elementType != null && marker == null) {
            builder.mark().error(AnalysisBundle.message("parsing.error.no.expected.done.marker.at.offset", builder.getCurrentOffset()));
        }
        while (state.hooks != null && state.hooks.level >= state.level) {
            if (state.hooks.level == state.level) {
                marker = state.hooks.hook.run(builder, marker, state.hooks.param);
            }
            state.hooks = state.hooks.next;
        }
    }

    private static void exit_section_impl_(ErrorState state, Frame frame, PsiBuilder builder, @Nullable IElementType elementType, boolean result, boolean pinned, @Nullable Parser eatMore) {
        int lastErrorPos;
        int initialPos = builder.rawTokenIndex();
        GeneratedParserUtilBase.replace_variants_with_name_(state, frame, builder, elementType, result, pinned);
        int n = lastErrorPos = frame.lastVariantAt < 0 ? initialPos : frame.lastVariantAt;
        if (!state.suppressErrors && eatMore != null) {
            boolean errorReported;
            state.suppressErrors = true;
            boolean eatMoreFlagOnce = !builder.eof() && eatMore.parse(builder, frame.level + 1);
            boolean eatMoreFlag = eatMoreFlagOnce || !result && frame.position == initialPos && lastErrorPos > frame.position;
            PsiBuilder.Marker latestDoneMarker = !(!pinned && !result || !state.altMode && elementType == null || !eatMoreFlagOnce) ? GeneratedParserUtilBase.getLatestExtensibleDoneMarker(builder) : null;
            int parenCount = 0;
            while ((eatMoreFlag || parenCount > 0) && builder.rawTokenIndex() < lastErrorPos) {
                IElementType tokenType = builder.getTokenType();
                if (state.braces != null) {
                    if (tokenType == state.braces[0].getLeftBraceType()) {
                        ++parenCount;
                    } else if (tokenType == state.braces[0].getRightBraceType()) {
                        --parenCount;
                    }
                }
                if (builder.rawTokenIndex() >= lastErrorPos) break;
                state.tokenAdvancer.parse(builder, frame.level + 1);
                eatMoreFlag = eatMore.parse(builder, frame.level + 1);
            }
            boolean bl = errorReported = frame.errorReportedAt == initialPos || !result && frame.errorReportedAt >= frame.position;
            if (errorReported || eatMoreFlag) {
                if (!errorReported) {
                    errorReported = GeneratedParserUtilBase.reportError(builder, state, frame, false, true, true);
                } else if (eatMoreFlag) {
                    state.tokenAdvancer.parse(builder, frame.level + 1);
                }
                if (eatMore.parse(builder, frame.level + 1)) {
                    GeneratedParserUtilBase.parseAsTree(state, builder, frame.level + 1, DUMMY_BLOCK, true, state.tokenAdvancer, eatMore);
                }
            } else if (eatMoreFlagOnce || !result && frame.position != builder.rawTokenIndex() || frame.errorReportedAt > initialPos) {
                errorReported = GeneratedParserUtilBase.reportError(builder, state, frame, false, true, false);
            } else if (!result && pinned && frame.errorReportedAt < 0) {
                errorReported = GeneratedParserUtilBase.reportError(builder, state, frame, elementType != null, false, false);
            }
            if (latestDoneMarker != null && frame.position >= latestDoneMarker.getStartIndex() && frame.position <= latestDoneMarker.getEndIndex()) {
                GeneratedParserUtilBase.extend_marker_impl(latestDoneMarker);
            }
            state.suppressErrors = false;
            if (errorReported || result) {
                state.clearVariants(true, 0);
                state.clearVariants(false, 0);
                frame.lastVariantAt = -1;
                Frame f = frame;
                while (f != null && f.variantCount > 0) {
                    f.variantCount = 0;
                    f = f.parentFrame;
                }
            }
        } else if (!result && pinned && frame.errorReportedAt < 0) {
            if (lastErrorPos == initialPos) {
                GeneratedParserUtilBase.reportError(builder, state, frame, elementType != null && (frame.modifiers & 0x20) == 0, false, false);
            } else if (lastErrorPos > initialPos) {
                frame.errorReportedAt = lastErrorPos;
            }
        }
        if (state.currentFrame != null) {
            if (state.currentFrame.errorReportedAt < frame.errorReportedAt) {
                state.currentFrame.errorReportedAt = frame.errorReportedAt;
            }
            if (state.currentFrame.lastVariantAt < frame.lastVariantAt) {
                state.currentFrame.lastVariantAt = frame.lastVariantAt;
            }
        }
    }

    private static void close_frame_impl_(ErrorState state, Frame frame, PsiBuilder builder, PsiBuilder.Marker marker, IElementType elementType, boolean result, boolean pinned) {
        if ((frame.modifiers & 8 | frame.modifiers & 0x10) != 0) {
            boolean resetLastPos = !state.suppressErrors && frame.lastVariantAt < 0 && frame.position < builder.rawTokenIndex();
            GeneratedParserUtilBase.close_marker_impl_(frame, marker, null, false);
            --state.predicateCount;
            if ((frame.modifiers & 0x10) != 0) {
                state.predicateSign = !state.predicateSign;
            }
            PsiBuilder.Marker marker2 = marker = elementType != null && marker != null && (result || pinned) ? builder.mark() : null;
            if (resetLastPos) {
                frame.lastVariantAt = builder.rawTokenIndex();
            }
        }
        if (elementType != null && marker != null) {
            if (result || pinned) {
                PsiBuilder.Marker last;
                if ((frame.modifiers & 1) != 0 && (last = (PsiBuilder.Marker)builder.getLatestDoneMarker()) != null && last.getStartIndex() == frame.position && state.typeExtends(last.getTokenType(), elementType) && GeneratedParserUtilBase.wasAutoSkipped(builder, builder.rawTokenIndex() - last.getEndIndex())) {
                    elementType = last.getTokenType();
                    last.drop();
                }
                if ((frame.modifiers & 0x20) != 0) {
                    marker.drop();
                    Frame f = frame.parentFrame;
                    while (f != null) {
                        if (f.elementType != null) {
                            f.elementType = elementType;
                            break;
                        }
                        f = f.parentFrame;
                    }
                } else if ((frame.modifiers & 4) != 0 && frame.leftMarker != null) {
                    marker.done(elementType);
                    GeneratedParserUtilBase.extend_marker_impl(frame.leftMarker);
                } else if ((frame.modifiers & 2) != 0 && frame.leftMarker != null) {
                    marker.drop();
                    frame.leftMarker.precede().done(elementType);
                } else {
                    if (frame.level == 0) {
                        builder.eof();
                    }
                    marker.done(elementType);
                }
            } else {
                GeneratedParserUtilBase.close_marker_impl_(frame, marker, null, false);
            }
        } else if (result || pinned) {
            if (marker != null) {
                marker.drop();
            }
            if ((frame.modifiers & 4) != 0 && frame.leftMarker != null) {
                GeneratedParserUtilBase.extend_marker_impl(frame.leftMarker);
            }
        } else {
            GeneratedParserUtilBase.close_marker_impl_(frame, marker, null, false);
        }
    }

    private static void extend_marker_impl(PsiBuilder.Marker marker) {
        PsiBuilder.Marker precede = marker.precede();
        IElementType elementType = marker.getTokenType();
        if (elementType == TokenType.ERROR_ELEMENT) {
            precede.error(StringUtil.notNullize(marker.getErrorMessage()));
        } else {
            precede.done(elementType);
        }
        marker.drop();
    }

    private static void close_marker_impl_(Frame frame, PsiBuilder.Marker marker, IElementType elementType, boolean result) {
        if (marker == null) {
            return;
        }
        if (result) {
            if (elementType != null) {
                marker.done(elementType);
            } else {
                marker.drop();
            }
        } else {
            int position;
            if (frame != null && frame.errorReportedAt > (position = marker.getStartIndex())) {
                frame.errorReportedAt = frame.parentFrame == null ? -1 : frame.parentFrame.errorReportedAt;
            }
            marker.rollbackTo();
        }
    }

    private static void replace_variants_with_name_(ErrorState state, Frame frame, PsiBuilder builder, IElementType elementType, boolean result, boolean pinned) {
        boolean willFail;
        int initialPos = builder.rawTokenIndex();
        boolean bl = willFail = !result && !pinned;
        if (willFail && initialPos == frame.position && frame.lastVariantAt == frame.position && frame.name != null && state.variants.size() >= frame.variantCount + (elementType == null ? 0 : 2)) {
            state.clearVariants(true, frame.variantCount);
            GeneratedParserUtilBase.addVariantInner(state, frame, initialPos, frame.name);
        }
    }

    public static boolean report_error_(PsiBuilder builder, boolean result) {
        if (!result) {
            GeneratedParserUtilBase.report_error_(builder, ErrorState.get(builder), false);
        }
        return result;
    }

    public static void report_error_(PsiBuilder builder, ErrorState state, boolean advance) {
        Frame frame = state.currentFrame;
        if (frame == null) {
            LOG.error("unbalanced enter/exit section call: got null");
            return;
        }
        int position = builder.rawTokenIndex();
        if (frame.errorReportedAt < position && frame.lastVariantAt > -1 && frame.lastVariantAt <= position) {
            GeneratedParserUtilBase.reportError(builder, state, frame, false, true, advance);
        }
    }

    @Nullable
    private static PsiBuilder.Marker getLatestExtensibleDoneMarker(@NotNull PsiBuilder builder) {
        SyntaxTreeBuilder.Production marker = ContainerUtil.getLastItem(builder.getProductions());
        return marker == null || marker.getTokenType() == null || !(marker instanceof PsiBuilder.Marker) ? null : (PsiBuilder.Marker)marker;
    }

    private static boolean reportError(PsiBuilder builder, ErrorState state, Frame frame, boolean inner, boolean force, boolean advance) {
        int position = builder.rawTokenIndex();
        String expected = state.getExpected(position, true);
        if (!force && expected.isEmpty() && !advance) {
            return false;
        }
        String actual = StringUtil.trim(builder.getTokenText());
        String message = expected.isEmpty() ? (StringUtil.isEmpty(actual) ? AnalysisBundle.message("parsing.error.unmatched.input", new Object[0]) : AnalysisBundle.message("parsing.error.unexpected", StringUtil.first(actual, 20, true))) : (StringUtil.isEmpty(actual) ? AnalysisBundle.message("parsing.error.expected", expected) : AnalysisBundle.message("parsing.error.expected.got", expected, StringUtil.first(actual, 20, true)));
        if (advance) {
            PsiBuilder.Marker mark = builder.mark();
            state.tokenAdvancer.parse(builder, frame.level + 1);
            mark.error(message);
        } else if (inner) {
            PsiBuilder.Marker latestDoneMarker = GeneratedParserUtilBase.getLatestExtensibleDoneMarker(builder);
            builder.error(message);
            if (latestDoneMarker != null && frame.position >= latestDoneMarker.getStartIndex() && frame.position <= latestDoneMarker.getEndIndex()) {
                GeneratedParserUtilBase.extend_marker_impl(latestDoneMarker);
            }
        } else {
            builder.error(message);
        }
        builder.eof();
        frame.errorReportedAt = builder.rawTokenIndex();
        return true;
    }

    private static void reportFrameError(PsiBuilder builder, ErrorState state) {
        if (state.currentFrame == null || state.suppressErrors) {
            return;
        }
        Frame frame = state.currentFrame;
        int pos = builder.rawTokenIndex();
        if (frame.errorReportedAt > pos) {
            int endOffset;
            PsiBuilder.Marker marker = (PsiBuilder.Marker)builder.getLatestDoneMarker();
            int n = endOffset = marker != null ? marker.getEndIndex() : pos + 1;
            while (endOffset <= pos && GeneratedParserUtilBase.isWhitespaceOrComment(builder, builder.rawLookup(endOffset - pos))) {
                ++endOffset;
            }
            boolean inner = endOffset == pos;
            builder.eof();
            GeneratedParserUtilBase.reportError(builder, state, frame, inner, true, false);
        }
    }

    public static PsiBuilder adapt_builder_(IElementType root, PsiBuilder builder, PsiParser parser) {
        return GeneratedParserUtilBase.adapt_builder_(root, builder, parser, null);
    }

    public static PsiBuilder adapt_builder_(IElementType root, PsiBuilder builder, PsiParser parser, TokenSet[] extendsSets) {
        ErrorState state = new ErrorState();
        ErrorState.initState(state, builder, root, extendsSets);
        return new Builder(builder, state, parser);
    }

    private static void checkSiblings(IElementType chunkType, Deque<Pair<PsiBuilder.Marker, PsiBuilder.Marker>> parens, Deque<Pair<PsiBuilder.Marker, Integer>> siblings) {
        block0: while (!siblings.isEmpty()) {
            Pair<PsiBuilder.Marker, PsiBuilder.Marker> parenPair = parens.peek();
            int rating = (Integer)siblings.getFirst().second;
            int count = 0;
            for (Pair<PsiBuilder.Marker, Integer> pair : siblings) {
                if ((Integer)pair.second != rating || parenPair != null && pair.first == parenPair.second) break block0;
                if (++count < 10) continue;
                PsiBuilder.Marker parentMarker = ((PsiBuilder.Marker)pair.first).precede();
                parentMarker.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, null);
                while (count-- > 0) {
                    siblings.removeFirst();
                }
                parentMarker.done(chunkType);
                siblings.addFirst(Pair.create(parentMarker, rating + 1));
                continue block0;
            }
        }
    }

    @Contract(pure=true)
    private static boolean isJavaIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierStart(c);
    }

    public static boolean parseAsTree(ErrorState state, PsiBuilder builder, int level, IElementType chunkType, boolean checkBraces, Parser parser, Parser eatMoreCondition) {
        ArrayDeque<Pair<PsiBuilder.Marker, PsiBuilder.Marker>> parens = new ArrayDeque<Pair<PsiBuilder.Marker, PsiBuilder.Marker>>(4);
        ArrayDeque<Pair<PsiBuilder.Marker, Integer>> siblings = new ArrayDeque<Pair<PsiBuilder.Marker, Integer>>();
        PsiBuilder.Marker marker = null;
        IElementType lBrace = checkBraces && state.braces != null && state.braces.length > 0 ? state.braces[0].getLeftBraceType() : null;
        IElementType rBrace = lBrace != null ? state.braces[0].getRightBraceType() : null;
        int totalCount = 0;
        int tokenCount = 0;
        if (lBrace != null) {
            LighterASTNode doneMarker;
            int tokenIdx = -1;
            while (builder.rawLookup(tokenIdx) == TokenType.WHITE_SPACE) {
                --tokenIdx;
            }
            LighterASTNode lighterASTNode = doneMarker = builder.rawLookup(tokenIdx) == lBrace ? builder.getLatestDoneMarker() : null;
            if (doneMarker != null && doneMarker.getStartOffset() == builder.rawTokenTypeStart(tokenIdx) && doneMarker.getTokenType() == TokenType.ERROR_ELEMENT) {
                parens.add(Pair.create(((PsiBuilder.Marker)doneMarker).precede(), null));
            }
        }
        int c = GeneratedParserUtilBase.current_position_(builder);
        while (true) {
            IElementType tokenType = builder.getTokenType();
            if (lBrace != null && (tokenType == lBrace || tokenType == rBrace && !parens.isEmpty())) {
                if (marker != null) {
                    marker.done(chunkType);
                    siblings.addFirst(Pair.create(marker, 1));
                    marker = null;
                    tokenCount = 0;
                }
                if (tokenType == lBrace) {
                    Pair prev = (Pair)siblings.peek();
                    parens.addFirst(Pair.create(builder.mark(), (PsiBuilder.Marker)Pair.getFirst(prev)));
                }
                GeneratedParserUtilBase.checkSiblings(chunkType, parens, siblings);
                state.tokenAdvancer.parse(builder, level);
                if (tokenType == rBrace) {
                    Pair<PsiBuilder.Marker, PsiBuilder.Marker> pair = parens.removeFirst();
                    ((PsiBuilder.Marker)pair.first).done(chunkType);
                    while (!siblings.isEmpty() && siblings.getFirst().first != pair.second) {
                        siblings.removeFirst();
                    }
                    siblings.addFirst(Pair.create((PsiBuilder.Marker)pair.first, 1));
                    GeneratedParserUtilBase.checkSiblings(chunkType, parens, siblings);
                }
            } else {
                boolean result;
                if (marker == null) {
                    marker = builder.mark();
                    marker.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, null);
                }
                boolean bl = result = (!parens.isEmpty() || eatMoreCondition.parse(builder, level + 1)) && parser.parse(builder, level + 1);
                if (!result) break;
                ++tokenCount;
                ++totalCount;
            }
            if (tokenCount >= 10) {
                marker.done(chunkType);
                siblings.addFirst(Pair.create(marker, 1));
                GeneratedParserUtilBase.checkSiblings(chunkType, parens, siblings);
                marker = null;
                tokenCount = 0;
            }
            if (!GeneratedParserUtilBase.empty_element_parsed_guard_(builder, "parseAsTree", c)) break;
            c = GeneratedParserUtilBase.current_position_(builder);
        }
        if (marker != null) {
            marker.drop();
        }
        for (Pair<PsiBuilder.Marker, PsiBuilder.Marker> pair : parens) {
            ((PsiBuilder.Marker)pair.first).drop();
        }
        return totalCount != 0;
    }

    public static class ErrorState {
        public Frame currentFrame;
        MyList<Variant> variants = new MyList(1000);
        MyList<Variant> unexpected = new MyList(100);
        int predicateCount;
        int level;
        boolean predicateSign = true;
        boolean suppressErrors;
        Hooks<?> hooks;
        TokenSet[] extendsSets;
        public PairProcessor<IElementType, IElementType> altExtendsChecker;
        private boolean caseSensitive;
        public BracePair[] braces;
        public Parser tokenAdvancer = TOKEN_ADVANCER;
        public boolean altMode;
        final LimitedPool<Variant> VARIANTS = new LimitedPool<Variant>(10000, Variant::new);
        final LimitedPool<Frame> FRAMES = new LimitedPool<Frame>(500, Frame::new);

        public static ErrorState get(PsiBuilder builder) {
            return ((Builder)builder).state;
        }

        public static void initState(ErrorState state, PsiBuilder builder, IElementType root, TokenSet[] extendsSets) {
            state.extendsSets = extendsSets;
            Language language2 = root.getLanguage();
            state.caseSensitive = language2.isCaseSensitive();
            PairedBraceMatcher matcher = BraceMatchers.get(root.getLanguage());
            BracePair[] bracePairArray = state.braces = matcher == null ? null : matcher.getPairs();
            if (state.braces != null && state.braces.length == 0) {
                state.braces = null;
            }
        }

        @NotNull
        public String getExpected(int position, boolean expected) {
            StringBuilder sb = new StringBuilder();
            MyList<Variant> list = expected ? this.variants : this.unexpected;
            Object[] strings = new String[list.size()];
            long[] hashes = new long[strings.length];
            Arrays.fill(strings, "");
            int count = 0;
            block0: for (Variant variant : list) {
                if (position != variant.position) continue;
                String text = String.valueOf(variant.object);
                long hash = StringHash.calc(text);
                for (int i = 0; i < count; ++i) {
                    if (hashes[i] == hash) continue block0;
                }
                hashes[count] = hash;
                strings[count] = text;
                ++count;
            }
            Arrays.sort(strings);
            count = 0;
            for (Object s : strings) {
                char c;
                if (((String)s).length() == 0) continue;
                if (count++ > 0) {
                    if (count > 50) {
                        sb.append(" ").append(AnalysisBundle.message("parsing.error.and.ellipsis", new Object[0]));
                        break;
                    }
                    sb.append(", ");
                }
                Object displayText = (c = ((String)s).charAt(0)) == '<' || GeneratedParserUtilBase.isJavaIdentifierStart(c) ? s : "'" + (String)s + "'";
                sb.append((String)displayText);
            }
            if (count > 1 && count < 50) {
                int idx = sb.lastIndexOf(", ");
                sb.replace(idx, idx + 1, " " + AnalysisBundle.message("parsing.error.or", new Object[0]));
            }
            return sb.toString();
        }

        public void clearVariants(Frame frame) {
            this.clearVariants(true, frame == null ? 0 : frame.variantCount);
            if (frame != null) {
                frame.lastVariantAt = -1;
            }
        }

        void clearVariants(boolean expected, int start) {
            MyList<Variant> list;
            MyList<Variant> myList = list = expected ? this.variants : this.unexpected;
            if (start < 0 || start >= list.size()) {
                return;
            }
            int len = list.size();
            for (int i = start; i < len; ++i) {
                this.VARIANTS.recycle((Variant)list.get(i));
            }
            list.setSize(start);
        }

        public boolean typeExtends(IElementType child, IElementType parent) {
            if (child == parent) {
                return true;
            }
            if (this.extendsSets != null) {
                for (TokenSet set : this.extendsSets) {
                    if (!set.contains(child) || !set.contains(parent)) continue;
                    return true;
                }
            }
            return this.altExtendsChecker != null && this.altExtendsChecker.process(child, parent);
        }
    }

    public static class Frame {
        public Frame parentFrame;
        public IElementType elementType;
        public int offset;
        public int position;
        public int level;
        public int modifiers;
        @NonNls
        public String name;
        public int variantCount;
        public int errorReportedAt;
        public int lastVariantAt;
        public PsiBuilder.Marker leftMarker;

        public Frame init(PsiBuilder builder, ErrorState state, int level_, int modifiers_, IElementType elementType_, String name_) {
            this.parentFrame = state.currentFrame;
            this.elementType = elementType_;
            this.offset = builder.getCurrentOffset();
            this.position = builder.rawTokenIndex();
            this.level = level_;
            this.modifiers = modifiers_;
            this.name = name_;
            this.variantCount = state.variants.size();
            this.errorReportedAt = -1;
            this.lastVariantAt = -1;
            this.leftMarker = null;
            return this;
        }

        @NonNls
        public String toString() {
            String mod = this.modifiers == 0 ? "_NONE_, " : ((this.modifiers & 1) != 0 ? "_CAN_COLLAPSE_, " : "") + ((this.modifiers & 2) != 0 ? "_LEFT_, " : "") + ((this.modifiers & 4) != 0 ? "_LEFT_INNER_, " : "") + ((this.modifiers & 8) != 0 ? "_AND_, " : "") + ((this.modifiers & 0x10) != 0 ? "_NOT_, " : "") + ((this.modifiers & 0x20) != 0 ? "_UPPER_, " : "");
            return String.format("{%s:%s:%d, %d, %s%s, %s}", this.offset, this.position, this.level, this.errorReportedAt, mod, this.elementType, this.name);
        }
    }

    private static class Variant {
        int position;
        Object object;

        private Variant() {
        }

        public Variant init(int pos, Object o) {
            this.position = pos;
            this.object = o;
            return this;
        }

        public String toString() {
            return "<" + this.position + ", " + this.object + ">";
        }
    }

    private static class MyList<E>
    extends ArrayList<E> {
        MyList(int initialCapacity) {
            super(initialCapacity);
        }

        protected void setSize(int fromIndex) {
            this.removeRange(fromIndex, this.size());
        }

        @Override
        public boolean add(E e) {
            int size = this.size();
            if (size >= 10000) {
                this.removeRange(2500, size - 2500);
            }
            return super.add(e);
        }
    }

    public static class Builder
    extends PsiBuilderAdapter {
        public final ErrorState state;
        public final PsiParser parser;

        public Builder(PsiBuilder builder, ErrorState state_, PsiParser parser_) {
            super(builder);
            this.state = state_;
            this.parser = parser_;
        }
    }

    public static interface Parser {
        public boolean parse(PsiBuilder var1, int var2);
    }

    private static class Hooks<T> {
        final Hook<T> hook;
        final T param;
        final int level;
        final Hooks<?> next;

        Hooks(Hook<T> hook, T param, int level, Hooks next) {
            this.hook = hook;
            this.param = param;
            this.level = level;
            this.next = next;
        }

        static <E> Hooks<E> concat(Hook<E> hook, E param, int level, Hooks<?> hooks) {
            return new Hooks<E>(hook, param, level, hooks);
        }
    }

    public static interface Hook<T> {
        @Contract(value="_,null,_->null")
        public PsiBuilder.Marker run(PsiBuilder var1, PsiBuilder.Marker var2, T var3);
    }

    private static class DummyBlockElementType
    extends IElementType {
        DummyBlockElementType() {
            super("DUMMY_BLOCK", Language.ANY);
        }
    }
}

