/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.devkit.frontend;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.CompositionLocal;
import fleet.frontend.layout.WindowEntity;
import fleet.frontend.layout.WindowEntityKt;
import fleet.frontend.ui.gotoPanel.GotoProvider;
import fleet.frontend.ui.gotoPanel.GotoProviderFactory;
import fleet.frontend.ui.gotoPanel.GotoProviderWithTextDescription;
import fleet.frontend.ui.layout.window.WindowViewKt;
import fleet.plugins.devkit.frontend.ResizeWindowGotoProviderKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import noria.NoriaContext;
import noria.ReadScope;
import noria.model.ActionContext;
import noria.model.ActionsKt;
import noria.model.CommonTrigger;
import noria.model.Trigger;
import noria.windowManagement.api.Size;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J%\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lfleet/plugins/devkit/frontend/ResizeWindowGotoProvider;", "Lfleet/frontend/ui/gotoPanel/GotoProviderWithTextDescription;", "oldSize", "Lnoria/windowManagement/api/Size;", "<init>", "(Lnoria/windowManagement/api/Size;)V", "descriptionText", "", "SIZE", "Lkotlin/text/Regex;", "confirm", "Lkotlin/Result;", "actionContext", "Lnoria/model/ActionContext;", "query", "confirm-gIAlu-s", "(Lnoria/model/ActionContext;Ljava/lang/String;)Ljava/lang/Object;", "initialQuery", "getInitialQuery", "()Ljava/lang/String;", "Companion", "fleet.plugins.devkit.frontend"})
final class ResizeWindowGotoProvider
extends GotoProviderWithTextDescription {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Size oldSize;
    @NotNull
    private final Regex SIZE;
    @NotNull
    private static final GotoProviderFactory.ID ID = new GotoProviderFactory.ID("resize-window");

    public ResizeWindowGotoProvider(@NotNull Size oldSize) {
        Intrinsics.checkNotNullParameter((Object)oldSize, (String)"oldSize");
        this.oldSize = oldSize;
        this.SIZE = new Regex("(\\d+) (\\d+)");
    }

    @NotNull
    public String descriptionText() {
        return "Enter new window size: [width] [height]";
    }

    @NotNull
    public Object confirm-gIAlu-s(@NotNull ActionContext actionContext, @NotNull String query) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        MatchResult match = this.SIZE.matchEntire((CharSequence)query);
        if (match != null) {
            MatchGroup matchGroup = match.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            float width = Float.parseFloat(matchGroup.getValue());
            MatchGroup matchGroup2 = match.getGroups().get(2);
            Intrinsics.checkNotNull((Object)matchGroup2);
            float height = Float.parseFloat(matchGroup2.getValue());
            ActionsKt.performAction((ActionContext)actionContext.put(ResizeWindowGotoProviderKt.access$getNewSizeKey$p(), (Object)new Size(width, height)), (CommonTrigger)CommonTrigger.ResizeWindow);
            object = Result.constructor-impl((Object)"Resized");
        } else {
            object = Result.constructor-impl((Object)"Incorrect size");
        }
        return object;
    }

    @NotNull
    public String getInitialQuery() {
        return (int)this.oldSize.getWidth() + " " + (int)this.oldSize.getHeight();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u001b\u001a\u00020\u0002*\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lfleet/plugins/devkit/frontend/ResizeWindowGotoProvider$Companion;", "Lfleet/frontend/ui/gotoPanel/GotoProviderFactory;", "", "<init>", "()V", "ID", "Lfleet/frontend/ui/gotoPanel/GotoProviderFactory$ID;", "getID", "()Lfleet/frontend/ui/gotoPanel/GotoProviderFactory$ID;", "name", "getName", "()Ljava/lang/String;", "plaqueText", "getPlaqueText", "trigger", "Lnoria/model/Trigger;", "getTrigger", "()Lnoria/model/Trigger;", "useSelectionForInitialQuery", "", "getUseSelectionForInitialQuery", "()Z", "createProvider", "Lfleet/frontend/ui/gotoPanel/GotoProvider;", "Lnoria/NoriaContext;", "actionContext", "Lnoria/model/ActionContext;", "placeholderText", "Lnoria/ReadScope;", "getPlaceholderText", "(Lnoria/ReadScope;)Ljava/lang/String;", "fleet.plugins.devkit.frontend"})
    public static final class Companion
    implements GotoProviderFactory<String> {
        private Companion() {
        }

        @NotNull
        public final GotoProviderFactory.ID getID() {
            return ID;
        }

        @NotNull
        public String getName() {
            return "Resize Window";
        }

        @NotNull
        public String getPlaqueText() {
            return "New size";
        }

        @Nullable
        public Trigger getTrigger() {
            return (Trigger)CommonTrigger.ShowResizeWindowDialog;
        }

        public boolean getUseSelectionForInitialQuery() {
            return false;
        }

        @Composable
        @NotNull
        public GotoProvider<String> createProvider(@NotNull NoriaContext $this$createProvider, @NotNull ActionContext actionContext) {
            Intrinsics.checkNotNullParameter((Object)$this$createProvider, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
            return (GotoProvider)new ResizeWindowGotoProvider(WindowEntityKt.getWindowPosition((WindowEntity)((WindowEntity)$this$createProvider.getCurrent((CompositionLocal)WindowViewKt.getLocalWindowEntity()))).getSize());
        }

        @NotNull
        public String getPlaceholderText(@NotNull ReadScope $this$placeholderText) {
            Intrinsics.checkNotNullParameter((Object)$this$placeholderText, (String)"<this>");
            return "width height";
        }

        @Composable
        @Nullable
        public String queryHint(@NotNull NoriaContext $this$queryHint) {
            return GotoProviderFactory.DefaultImpls.queryHint((GotoProviderFactory)this, (NoriaContext)$this$queryHint);
        }

        public boolean getReuseQueryFromOtherProviders() {
            return GotoProviderFactory.DefaultImpls.getReuseQueryFromOtherProviders((GotoProviderFactory)this);
        }

        @NotNull
        public List<GotoProviderFactory.ID> getChildScopes() {
            return GotoProviderFactory.DefaultImpls.getChildScopes((GotoProviderFactory)this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

