/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.dotnet.common;

import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import fleet.api.Arch;
import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.api.HostId;
import fleet.api.Os;
import fleet.api.Platform;
import fleet.api.ProtocolPath;
import fleet.bundles.PluginName;
import fleet.common.WorkspaceEntityKt;
import fleet.common.fs.SharedProjectRootEntity;
import fleet.common.topology.Filesystem;
import fleet.common.topology.Host;
import fleet.dock.connectors.ConnectorsKt;
import fleet.kernel.plugins.LoadedPluginEntity;
import fleet.plugins.dotnet.common.DotnetBackendKind;
import fleet.plugins.dotnet.common.UtilsKt;
import fleet.plugins.dotnet.common.entities.ReSharperFromSourcesEntity;
import fleet.preferences.FleetFromSourcesPaths;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n*\b\u0012\u0004\u0012\u00020\n0\u000b\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0006\u0010\u0010\u001a\u00020\r\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0015\u001a\u0016\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0015\u001a\u0016\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0086@\u00a2\u0006\u0002\u0010\u001a\u001a\f\u0010\u001b\u001a\u00020\u0001*\u00020\u001cH\u0002\u001a\u000e\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0015\u001a&\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010\"\u001a\u0016\u0010#\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0086@\u00a2\u0006\u0002\u0010\u001a\u001a&\u0010#\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010\"\u001a.\u0010$\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\rH\u0082@\u00a2\u0006\u0002\u0010&\u001a&\u0010'\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\"\u001a\u0016\u0010'\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0015\u001a\u0016\u0010(\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0086@\u00a2\u0006\u0002\u0010\u001a\u001a\u0016\u0010)\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0086@\u00a2\u0006\u0002\u0010\u001a\u001a\u0016\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020\u0001\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"dotnetCustomBackendLocation", "", "getDotnetCustomBackendLocation$annotations", "()V", "dotnetSnapshot", "FleetBackendDir", "getFleetBackendDir$annotations", "DotnetDirMonoRepoName", "LATEST", "getPrimaryDotnetProjectRoot", "Lfleet/common/fs/SharedProjectRootEntity;", "", "getBackendKind", "Lfleet/plugins/dotnet/common/DotnetBackendKind;", "hostId", "Lfleet/api/HostId;", "getBackendKindForSources", "getLogDirectory", "Lfleet/api/ProtocolPath;", "fs", "Lfleet/common/topology/Filesystem;", "(Lfleet/common/topology/Filesystem;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getConfigDirectory", "getDotnetUrl", "host", "Lfleet/common/topology/Host;", "(Lfleet/common/topology/Host;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toDotnetPlatformName", "Lfleet/api/Platform;", "getVersion", "getBackendBinDir", "os", "Lfleet/api/Os;", "userHome", "(Lfleet/api/HostId;Lfleet/api/Os;Lfleet/api/ProtocolPath;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getBackendDir", "getVersionedBackendPath", "kind", "(Lfleet/api/HostId;Lfleet/api/Os;Lfleet/api/ProtocolPath;Lfleet/plugins/dotnet/common/DotnetBackendKind;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDotnetCachesPath", "getRuntimeSpecificFolder", "getBundledDotnetRuntime", "makeDotnetPathFromRunTaskAbsolute", "Lfleet/api/FileAddress;", "workingDir", "relativePath", "fleet.plugins.dotnet.common"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nfleet/plugins/dotnet/common/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,312:1\n1#2:313\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final String dotnetCustomBackendLocation = "fleet.dotnet.backend.location";
    @NotNull
    private static final String dotnetSnapshot = "fleet.dotnet.backend.snapshot";
    @NotNull
    public static final String FleetBackendDir = "Bin.RiderBackend";
    @NotNull
    private static final String DotnetDirMonoRepoName = "dotnet";
    @NotNull
    private static final String LATEST = "latest";

    public static /* synthetic */ void getDotnetCustomBackendLocation$annotations() {
    }

    public static /* synthetic */ void getFleetBackendDir$annotations() {
    }

    @Nullable
    public static final SharedProjectRootEntity getPrimaryDotnetProjectRoot(@NotNull List<SharedProjectRootEntity> $this$getPrimaryDotnetProjectRoot) {
        Intrinsics.checkNotNullParameter($this$getPrimaryDotnetProjectRoot, (String)"<this>");
        return (SharedProjectRootEntity)CollectionsKt.firstOrNull($this$getPrimaryDotnetProjectRoot);
    }

    @NotNull
    public static final DotnetBackendKind getBackendKind(@NotNull HostId hostId) {
        Intrinsics.checkNotNullParameter((Object)hostId, (String)"hostId");
        String useSnapshot = System.getProperty(dotnetSnapshot);
        if (useSnapshot != null && Boolean.parseBoolean(useSnapshot)) {
            return DotnetBackendKind.Latest;
        }
        String customLocation = System.getProperty(dotnetCustomBackendLocation);
        if (customLocation != null) {
            return DotnetBackendKind.Custom;
        }
        ReSharperFromSourcesEntity sourcesEntity = (ReSharperFromSourcesEntity)EntityAttributeKt.entityOnNonUniqueAttribute((EntityAttribute)((EntityAttribute)ReSharperFromSourcesEntity.Companion.getHostIdAttr()), (Object)hostId);
        if (sourcesEntity != null) {
            return DotnetBackendKind.SourcesFromCurrentProject;
        }
        HostId workspaceHostId = WorkspaceEntityKt.currentWorkspaceOrDie().getWorkspaceHostId();
        return Intrinsics.areEqual((Object)workspaceHostId, (Object)hostId) ? (FleetFromSourcesPaths.INSTANCE.isRunningFromSources() ? UtilsKt.getBackendKindForSources() : DotnetBackendKind.Versioned) : DotnetBackendKind.Versioned;
    }

    @NotNull
    public static final DotnetBackendKind getBackendKindForSources() {
        Path backendPath = FleetFromSourcesPaths.INSTANCE.getIntellijProjectRoot().resolve("dotnet/Bin.RiderBackend");
        Intrinsics.checkNotNull((Object)backendPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(backendPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? DotnetBackendKind.Sources : DotnetBackendKind.Latest;
    }

    @Nullable
    public static final Object getLogDirectory(@NotNull Filesystem fs, @NotNull Continuation<? super ProtocolPath> $completion) {
        ProtocolPath protocolPath;
        HostId workspaceHostId = WorkspaceEntityKt.currentWorkspaceOrDie().getWorkspaceHostId();
        if (Intrinsics.areEqual((Object)workspaceHostId, (Object)fs.getHostId())) {
            Path path = ConnectorsKt.getAppLogsPath((CoroutineContext)$completion.getContext());
            Intrinsics.checkNotNull((Object)path);
            String nioPath = ((Object)path).toString();
            protocolPath = ProtocolPath.Companion.of(nioPath, fs.getOs());
        } else {
            FileAddress fileAddress = fs.getUserHome();
            if (fileAddress == null || (fileAddress = fileAddress.getPath()) == null) {
                throw new IllegalStateException("Could not find user home".toString());
            }
            FileAddress userHome = fileAddress;
            if (WhenMappings.$EnumSwitchMapping$0[fs.getOs().ordinal()] == 1) {
                String[] stringArray = new String[]{"AppData", "Local", "JetBrains", "Fleet", "log"};
                protocolPath = userHome.child(stringArray);
            } else {
                String[] stringArray = new String[]{"Library", "Logs", "JetBrains", "Fleet", "Dotnet"};
                protocolPath = userHome.child(stringArray);
            }
        }
        return protocolPath;
    }

    @Nullable
    public static final Object getConfigDirectory(@NotNull Filesystem fs, @NotNull Continuation<? super ProtocolPath> $completion) {
        ProtocolPath protocolPath;
        HostId workspaceHostId = WorkspaceEntityKt.currentWorkspaceOrDie().getWorkspaceHostId();
        if (Intrinsics.areEqual((Object)workspaceHostId, (Object)fs.getHostId())) {
            Path path = ConnectorsKt.getAppConfigPath((CoroutineContext)$completion.getContext());
            if (path == null) {
                boolean bl = false;
                String string = "config path is not set";
                throw new IllegalArgumentException(string.toString());
            }
            String configPath = ((Object)path).toString();
            protocolPath = ProtocolPath.Companion.of(configPath, fs.getOs());
        } else {
            FileAddress fileAddress = fs.getUserHome();
            if (fileAddress == null || (fileAddress = fileAddress.getPath()) == null) {
                throw new IllegalStateException("Could not find user home".toString());
            }
            FileAddress userHome = fileAddress;
            if (WhenMappings.$EnumSwitchMapping$0[fs.getOs().ordinal()] == 1) {
                String[] stringArray = new String[]{"AppData", "Local", "JetBrains", "Fleet", "config"};
                protocolPath = userHome.child(stringArray);
            } else {
                String[] stringArray = new String[]{"Library", "Config", "JetBrains", "Fleet", "Dotnet"};
                protocolPath = userHome.child(stringArray);
            }
        }
        return protocolPath;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getDotnetUrl(@NotNull Host var0, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof getDotnetUrl.1)) ** GOTO lbl-1000
        var10_2 = $completion;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return UtilsKt.getDotnetUrl(null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = host;
                $continuation.label = 1;
                v0 = host.getExec().getPlatform((Continuation)$continuation);
                if (v0 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                host = (Host)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                platform = (Platform)v0;
                v1 = (LoadedPluginEntity)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)LoadedPluginEntity.Companion.getPluginNameAttr()), (Object)new PluginName("fleet.dotnet"));
                if (v1 == null || (v1 = v1.getPlugin()) == null || (v1 = v1.getMeta()) == null) {
                    throw new IllegalStateException("Could not retrieve dotnet plugin meta".toString());
                }
                meta = v1;
                v2 = (String)meta.get("backendUrl");
                if (v2 == null) {
                    throw new IllegalStateException("could not find backend url for dotnet plugin".toString());
                }
                url = v2;
                kind = UtilsKt.getBackendKind(host.getHostId());
                urlWithFolder = kind == DotnetBackendKind.Latest ? StringsKt.replace$default((String)url, (String)"$ADD_FOLDER", (String)"latest/", (boolean)false, (int)4, null) : StringsKt.replace$default((String)url, (String)"$ADD_FOLDER", (String)"", (boolean)false, (int)4, null);
                dotnetPlatformName = UtilsKt.toDotnetPlatformName(platform);
                urlWithFolderWithPlatform = StringsKt.replace$default((String)urlWithFolder, (String)"$PLATFORM", (String)dotnetPlatformName, (boolean)false, (int)4, null);
                return StringsKt.replace$default((String)urlWithFolderWithPlatform, (String)"$BACKEND_VERSION", (String)UtilsKt.getVersion(host.getHostId()), (boolean)false, (int)4, null);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final String toDotnetPlatformName(Platform $this$toDotnetPlatformName) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toDotnetPlatformName.getOs().ordinal()]) {
            case 2 -> {
                switch (WhenMappings.$EnumSwitchMapping$1[$this$toDotnetPlatformName.getArch().ordinal()]) {
                    case 1: {
                        throw new IllegalStateException("Unexpected platform for DotnetBackend");
                    }
                    case 2: {
                        yield "linux-x64";
                    }
                    case 3: {
                        yield "linux-arm64";
                    }
                    case 4: {
                        throw new IllegalStateException("Unexpected platform for DotnetBackend");
                    }
                    case 5: {
                        throw new IllegalStateException("Unexpected platform for DotnetBackend");
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 1 -> {
                switch (WhenMappings.$EnumSwitchMapping$1[$this$toDotnetPlatformName.getArch().ordinal()]) {
                    case 1: {
                        throw new IllegalStateException("Unexpected platform for DotnetBackend");
                    }
                    case 2: {
                        yield "windows-x64";
                    }
                    case 3: {
                        yield "windows-arm64";
                    }
                    case 4: {
                        throw new IllegalStateException("Unexpected platform for DotnetBackend");
                    }
                    case 5: {
                        throw new IllegalStateException("Unexpected platform for DotnetBackend");
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 3 -> {
                switch (WhenMappings.$EnumSwitchMapping$1[$this$toDotnetPlatformName.getArch().ordinal()]) {
                    case 1: {
                        throw new IllegalStateException("Unexpected platform for DotnetBackend");
                    }
                    case 2: {
                        yield "macos-x64";
                    }
                    case 3: {
                        yield "macos-arm64";
                    }
                    case 4: {
                        throw new IllegalStateException("Unexpected platform for DotnetBackend");
                    }
                    case 5: {
                        throw new IllegalStateException("Unexpected platform for DotnetBackend");
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 4 -> throw new IllegalStateException("Unexpected platform for DotnetBackend");
            case 5 -> throw new IllegalStateException("Unexpected platform for DotnetBackend");
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final String getVersion(@NotNull HostId hostId) {
        Intrinsics.checkNotNullParameter((Object)hostId, (String)"hostId");
        switch (WhenMappings.$EnumSwitchMapping$2[UtilsKt.getBackendKind(hostId).ordinal()]) {
            case 1: {
                throw new IllegalStateException("Unsupported version".toString());
            }
            case 2: {
                throw new IllegalStateException("Unsupported version".toString());
            }
            case 3: {
                throw new IllegalStateException("Unsupported version".toString());
            }
            case 4: {
                break;
            }
            case 5: {
                Object object = (LoadedPluginEntity)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)LoadedPluginEntity.Companion.getPluginNameAttr()), (Object)new PluginName("fleet.dotnet"));
                if (object == null || (object = object.getPlugin()) == null || (object = object.getMeta()) == null) {
                    throw new IllegalStateException("Could not retrieve dotnet plugin meta".toString());
                }
                Object meta = object;
                String string = (String)meta.get("backendVersion");
                if (string == null) {
                    throw new IllegalStateException("could not find backend version for dotnet plugin".toString());
                }
                String version = string;
                return version;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return LATEST;
    }

    @Nullable
    public static final Object getBackendBinDir(@NotNull Filesystem fs, @NotNull Continuation<? super ProtocolPath> $completion) {
        HostId hostId = fs.getHostId();
        Os os = fs.getOs();
        FileAddress fileAddress = fs.getUserHome();
        Intrinsics.checkNotNull((Object)fileAddress);
        return UtilsKt.getBackendBinDir(hostId, os, fileAddress.getPath(), $completion);
    }

    /*
     * Unable to fully structure code
     */
    private static final Object getBackendBinDir(HostId var0, Os var1_1, ProtocolPath var2_2, Continuation<? super ProtocolPath> $completion) {
        if (!($completion instanceof getBackendBinDir.2)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return UtilsKt.access$getBackendBinDir(null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = hostId;
                $continuation.label = 1;
                v0 = UtilsKt.getBackendDir(hostId, (Os)os, (ProtocolPath)userHome, (Continuation<? super ProtocolPath>)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl22
            }
            case 1: {
                hostId = (HostId)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                backend = (ProtocolPath)v0;
                kind = UtilsKt.getBackendKind(hostId);
                if (kind == DotnetBackendKind.Sources || kind == DotnetBackendKind.SourcesFromCurrentProject) {
                    v1 = backend;
                } else {
                    var6_9 = new String[]{"bin"};
                    v1 = backend.child(var6_9);
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public static final Object getBackendDir(@NotNull Host host, @NotNull Continuation<? super ProtocolPath> $completion) {
        HostId hostId = host.getHostId();
        Os os = host.getFs().getOs();
        FileAddress fileAddress = host.getFs().getUserHome();
        Object object = fileAddress != null ? fileAddress.getPath() : null;
        Intrinsics.checkNotNull((Object)object);
        return UtilsKt.getBackendDir(hostId, os, object, $completion);
    }

    private static final Object getBackendDir(HostId hostId, Os os, ProtocolPath userHome, Continuation<? super ProtocolPath> $completion) {
        switch (WhenMappings.$EnumSwitchMapping$2[UtilsKt.getBackendKind(hostId).ordinal()]) {
            case 1: {
                Path nioPath = FleetFromSourcesPaths.INSTANCE.getIntellijProjectRoot().resolve("dotnet/Bin.RiderBackend").normalize();
                Intrinsics.checkNotNull((Object)nioPath);
                return ProtocolPath.Companion.of(((Object)nioPath).toString(), os);
            }
            case 2: {
                Entity entity = EntityAttributeKt.entityOnNonUniqueAttribute((EntityAttribute)((EntityAttribute)ReSharperFromSourcesEntity.Companion.getHostIdAttr()), (Object)hostId);
                if (entity == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                return ((ReSharperFromSourcesEntity)entity).getBackendPath();
            }
            case 4: {
                return UtilsKt.getVersionedBackendPath(hostId, os, userHome, DotnetBackendKind.Latest, $completion);
            }
            case 5: {
                return UtilsKt.getVersionedBackendPath(hostId, os, userHome, DotnetBackendKind.Versioned, $completion);
            }
            case 3: {
                String customLocation = System.getProperty(dotnetCustomBackendLocation);
                Intrinsics.checkNotNull((Object)customLocation);
                return ProtocolPath.Companion.of(customLocation, os);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * Unable to fully structure code
     */
    private static final Object getVersionedBackendPath(HostId var0, Os var1_1, ProtocolPath var2_2, DotnetBackendKind var3_3, Continuation<? super ProtocolPath> $completion) {
        if (!($completion instanceof getVersionedBackendPath.1)) ** GOTO lbl-1000
        var11_5 = $completion;
        if ((var11_5.label & -2147483648) != 0) {
            var11_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return UtilsKt.access$getVersionedBackendPath(null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = hostId;
                $continuation.L$1 = kind;
                $continuation.label = 1;
                v0 = UtilsKt.getDotnetCachesPath(hostId, (Os)os, (ProtocolPath)userHome, (Continuation<? super ProtocolPath>)$continuation);
                if (v0 == var12_7) {
                    return var12_7;
                }
                ** GOTO lbl24
            }
            case 1: {
                kind = (DotnetBackendKind)$continuation.L$1;
                hostId = (HostId)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                dotnetFolder = ((ProtocolPath)v0).resolveChild("fleet-backend");
                var7_9 = kind;
                switch (WhenMappings.$EnumSwitchMapping$2[var7_9.ordinal()]) {
                    case 4: {
                        var8_10 = new String[]{"latest"};
                        v1 = dotnetFolder.child(var8_10);
                        break;
                    }
                    case 5: {
                        versionString = UtilsKt.getVersion(hostId);
                        var9_11 = new String[]{versionString};
                        v1 = dotnetFolder.child(var9_11);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Not supported backend kind".toString());
                    }
                }
                versionedFolder = v1;
                return versionedFolder;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public static final Object getDotnetCachesPath(@NotNull HostId hostId, @NotNull Os os, @NotNull ProtocolPath userHome, @NotNull Continuation<? super ProtocolPath> $completion) {
        ProtocolPath protocolPath;
        HostId workspaceHostId = WorkspaceEntityKt.currentWorkspaceOrDie().getWorkspaceHostId();
        if (Intrinsics.areEqual((Object)workspaceHostId, (Object)hostId)) {
            Path path = ConnectorsKt.getAppCachesPath((CoroutineContext)$completion.getContext());
            if (path == null) {
                boolean bl = false;
                String string = "caches path is not set";
                throw new IllegalArgumentException(string.toString());
            }
            Path cachesPath = path;
            Path path2 = cachesPath.resolve("Dotnet");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            String nioPath = ((Object)path2).toString();
            protocolPath = ProtocolPath.Companion.of(nioPath, os);
        } else {
            ProtocolPath dotnetFolder;
            ProtocolPath protocolPath2;
            if (WhenMappings.$EnumSwitchMapping$0[os.ordinal()] == 1) {
                var9_9 = new String[]{"AppData", "Local", "JetBrains", "Fleet", "Dotnet"};
                protocolPath2 = userHome.child(CollectionsKt.listOf((Object[])var9_9));
            } else {
                var9_9 = new String[]{"Library", "Caches", "JetBrains", "Fleet", "Dotnet"};
                protocolPath2 = userHome.child(CollectionsKt.listOf((Object[])var9_9));
            }
            protocolPath = dotnetFolder = protocolPath2;
        }
        ProtocolPath dotnetFolder = protocolPath;
        return dotnetFolder;
    }

    @Nullable
    public static final Object getDotnetCachesPath(@NotNull Filesystem fs, @NotNull Continuation<? super ProtocolPath> $completion) {
        HostId hostId = fs.getHostId();
        Os os = fs.getOs();
        FileAddress fileAddress = fs.getUserHome();
        Object object = fileAddress != null ? fileAddress.getPath() : null;
        Intrinsics.checkNotNull((Object)object);
        return UtilsKt.getDotnetCachesPath(hostId, os, object, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getRuntimeSpecificFolder(@NotNull Host var0, @NotNull Continuation<? super ProtocolPath> $completion) {
        if (!($completion instanceof getRuntimeSpecificFolder.1)) ** GOTO lbl-1000
        var7_2 = $completion;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return UtilsKt.getRuntimeSpecificFolder(null, (Continuation<? super ProtocolPath>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = host;
                $continuation.label = 1;
                v0 = host.getExec().getPlatform((Continuation)$continuation);
                if (v0 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                host = (Host)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                platform = (Platform)v0;
                $continuation.L$0 = platform;
                $continuation.label = 2;
                v1 = UtilsKt.getBackendBinDir(host.getFs(), (Continuation<? super ProtocolPath>)$continuation);
                if (v1 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl33
            }
            case 2: {
                platform = (Platform)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                backendDir = (ProtocolPath)v1;
                runtimeFolder = UtilsKt.toDotnetPlatformName(platform);
                var5_8 = new String[]{runtimeFolder};
                return backendDir.child(var5_8);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getBundledDotnetRuntime(@NotNull Host var0, @NotNull Continuation<? super ProtocolPath> $completion) {
        if (!($completion instanceof getBundledDotnetRuntime.1)) ** GOTO lbl-1000
        var7_2 = $completion;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return UtilsKt.getBundledDotnetRuntime(null, (Continuation<? super ProtocolPath>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = host;
                $continuation.label = 1;
                v0 = host.getExec().getPlatform((Continuation)$continuation);
                if (v0 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                host = (Host)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                platform = (Platform)v0;
                $continuation.L$0 = platform;
                $continuation.label = 2;
                v1 = UtilsKt.getRuntimeSpecificFolder(host, (Continuation<? super ProtocolPath>)$continuation);
                if (v1 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl33
            }
            case 2: {
                platform = (Platform)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                runtimeFolder = (ProtocolPath)v1;
                var5_7 = platform.getOs();
                dotnet = WhenMappings.$EnumSwitchMapping$0[var5_7.ordinal()] == 1 ? "dotnet.exe" : "dotnet";
                var5_7 = new String[]{"dotnet", dotnet};
                return runtimeFolder.child(var5_7);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final FileAddress makeDotnetPathFromRunTaskAbsolute(@NotNull FileAddress workingDir, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        ProtocolPath path = ProtocolPath.Companion.ofOrNull(relativePath, workingDir.getPath().getOs());
        if (path == null) {
            return FileAddressKt.resolveChild((FileAddress)workingDir, (String)relativePath);
        }
        return new FileAddress(workingDir.getHostId(), path);
    }

    public static final /* synthetic */ Object access$getBackendBinDir(HostId hostId, Os os, ProtocolPath userHome, Continuation $completion) {
        return UtilsKt.getBackendBinDir(hostId, os, userHome, (Continuation<? super ProtocolPath>)$completion);
    }

    public static final /* synthetic */ Object access$getBackendDir(HostId hostId, Os os, ProtocolPath userHome, Continuation $completion) {
        return UtilsKt.getBackendDir(hostId, os, userHome, (Continuation<? super ProtocolPath>)$completion);
    }

    public static final /* synthetic */ Object access$getVersionedBackendPath(HostId hostId, Os os, ProtocolPath userHome, DotnetBackendKind kind, Continuation $completion) {
        return UtilsKt.getVersionedBackendPath(hostId, os, userHome, kind, (Continuation<? super ProtocolPath>)$completion);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[Os.values().length];
            try {
                nArray[Os.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Macos.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Other.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Imaginary.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Arch.values().length];
            try {
                nArray[Arch.x86.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Arch.x86_64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Arch.aarch64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Arch.arm.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Arch.other.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[DotnetBackendKind.values().length];
            try {
                nArray[DotnetBackendKind.Sources.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DotnetBackendKind.SourcesFromCurrentProject.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DotnetBackendKind.Custom.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DotnetBackendKind.Latest.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DotnetBackendKind.Versioned.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

