/*
 * Decompiled with CFR 0.152.
 */
package fleet.ai.frontend.view;

import androidx.compose.foundation.FocusableKt;
import androidx.compose.foundation.text.InlineTextContent;
import androidx.compose.foundation.text.InlineTextContentKt;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.PlaceholderVerticalAlign;
import fleet.ai.frontend.api.internal.AiChatSource;
import fleet.ai.frontend.api.internal.AiReports;
import fleet.ai.frontend.api.internal.ChatMessageChunk;
import fleet.ai.frontend.markdown.InlineLinkInfo;
import fleet.ai.frontend.markdown.SimpleMarkdownKt;
import fleet.ai.frontend.view.AiChatInputInlayRendererKt;
import fleet.api.FileAddress;
import fleet.common.FusEntityKt;
import fleet.compose.theme.components.TextKt;
import fleet.compose.theme.components.ThemedAnnotatedStringBuilder;
import fleet.compose.theme.keys.TextStyleKeys;
import fleet.compose.theme.text.NoriaParagraphStyle;
import fleet.frontend.KernelExtKt;
import fleet.frontend.fsd.FileIconsKt;
import fleet.frontend.icons.IconKeys;
import fleet.frontend.layout.LayoutEntityKt;
import fleet.frontend.layout.WindowEntity;
import fleet.kernel.plugins.PluginScope;
import fleet.util.UID;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import noria.NoriaContext;
import noria.impl.Runtime;
import noria.model.ThemeKey;
import noria.ui.core.BoundaryKt;
import noria.ui.events.HandlerScope;
import noria.ui.text.TextComponentsKt;
import org.intellij.markdown.ast.ASTNode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0001\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\nH\u0003\u001a$\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003\u001a*\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u0014H\u0003\"\u000e\u0010\u0015\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"renderTextChunk", "", "Lnoria/NoriaContext;", "chunk", "Lfleet/ai/frontend/api/internal/ChatMessageChunk$Text;", "session", "Lfleet/util/UID;", "chatSource", "Lfleet/ai/frontend/api/internal/AiChatSource;", "renderPlainTextChunk", "Lfleet/ai/frontend/api/internal/ChatMessageChunk$Text$Plain;", "renderMarkdownTextChunk", "Lfleet/ai/frontend/api/internal/ChatMessageChunk$Text$Markdown;", "renderInlineLink", "Landroidx/compose/foundation/text/InlineTextContent;", "tag", "", "link", "Lfleet/ai/frontend/markdown/InlineLinkInfo;", "onClick", "Lkotlin/Function0;", "DOCUMENTATION_LINK_PREFIX", "fleet.plugins.ai.frontend"})
@SourceDebugExtension(value={"SMAP\nAiChatMessageText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiChatMessageText.kt\nfleet/ai/frontend/view/AiChatMessageTextKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n462#2:105\n412#2:106\n1246#3,4:107\n*S KotlinDebug\n*F\n+ 1 AiChatMessageText.kt\nfleet/ai/frontend/view/AiChatMessageTextKt\n*L\n78#1:105\n78#1:106\n78#1:107,4\n*E\n"})
public final class AiChatMessageTextKt {
    @NotNull
    private static final String DOCUMENTATION_LINK_PREFIX = "https://www.jetbrains.com/help/fleet";

    @Composable
    public static final void renderTextChunk(@NotNull NoriaContext $this$renderTextChunk, @NotNull ChatMessageChunk.Text chunk, @NotNull UID session, @NotNull AiChatSource chatSource) {
        Intrinsics.checkNotNullParameter((Object)$this$renderTextChunk, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)((Object)chatSource), (String)"chatSource");
        Runtime.enterScope((NoriaContext)$this$renderTextChunk, (int)579);
        Object[] objectArray = new Object[]{chunk, session, chatSource};
        BoundaryKt.boundary((NoriaContext)$this$renderTextChunk, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<NoriaContext, Unit>(chunk, session, chatSource){
            final /* synthetic */ ChatMessageChunk.Text $chunk;
            final /* synthetic */ UID $session;
            final /* synthetic */ AiChatSource $chatSource;
            {
                this.$chunk = $chunk;
                this.$session = $session;
                this.$chatSource = $chatSource;
                super(1);
            }

            public final void invoke(NoriaContext $this$boundary) {
                Intrinsics.checkNotNullParameter((Object)$this$boundary, (String)"$this$boundary");
                ChatMessageChunk.Text text2 = this.$chunk;
                if (text2 instanceof ChatMessageChunk.Text.Plain) {
                    Runtime.enterScope((NoriaContext)$this$boundary, (int)577);
                    AiChatMessageTextKt.access$renderPlainTextChunk($this$boundary, (ChatMessageChunk.Text.Plain)this.$chunk);
                    Unit unit = Unit.INSTANCE;
                    Runtime.exitScope((NoriaContext)$this$boundary);
                } else if (text2 instanceof ChatMessageChunk.Text.Markdown) {
                    Runtime.enterScope((NoriaContext)$this$boundary, (int)578);
                    AiChatMessageTextKt.access$renderMarkdownTextChunk($this$boundary, (ChatMessageChunk.Text.Markdown)this.$chunk, this.$session, this.$chatSource);
                    Unit unit = Unit.INSTANCE;
                    Runtime.exitScope((NoriaContext)$this$boundary);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        })));
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$renderTextChunk);
    }

    @Composable
    private static final void renderPlainTextChunk(NoriaContext $this$renderPlainTextChunk, ChatMessageChunk.Text.Plain chunk) {
        Runtime.enterScope((NoriaContext)$this$renderPlainTextChunk, (int)580);
        TextKt.UiText-1ODQ_eA$default((NoriaContext)$this$renderPlainTextChunk, (String)((Object)StringsKt.trim((CharSequence)chunk.getContent())).toString(), (long)0L, null, null, (NoriaParagraphStyle)NoriaParagraphStyle.Companion.getMultiline(), null, null, null, null, (Modifier)FocusableKt.focusable$default((Modifier)((Modifier)Modifier.Companion), (boolean)false, null, (int)3, null), (int)494, null);
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$renderPlainTextChunk);
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    private static final void renderMarkdownTextChunk(NoriaContext $this$renderMarkdownTextChunk, ChatMessageChunk.Text.Markdown chunk, UID session, AiChatSource chatSource) {
        void $this$mapValuesTo$iv$iv;
        String content2 = ((Object)StringsKt.trim((CharSequence)chunk.getContent())).toString();
        PluginScope pluginScope = (PluginScope)$this$renderMarkdownTextChunk.getCurrent((CompositionLocal)KernelExtKt.getLocalPluginScope());
        WindowEntity window = LayoutEntityKt.lastFocusedWindow();
        Map links = new LinkedHashMap();
        Runtime.enterScope((NoriaContext)$this$renderMarkdownTextChunk, (int)581);
        AnnotatedString annotatedString = SimpleMarkdownKt.markdownToAnnotatedString($this$renderMarkdownTextChunk, content2, (Function2<? super ThemedAnnotatedStringBuilder, ? super ASTNode, Boolean>)((Function2)new Function2<ThemedAnnotatedStringBuilder, ASTNode, Boolean>(content2, (Map<String, InlineLinkInfo>)links){
            final /* synthetic */ String $content;
            final /* synthetic */ Map<String, InlineLinkInfo> $links;
            {
                this.$content = $content;
                this.$links = $links;
                super(2);
            }

            public final Boolean invoke(ThemedAnnotatedStringBuilder $this$markdownToAnnotatedString, ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)$this$markdownToAnnotatedString, (String)"$this$markdownToAnnotatedString");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                InlineLinkInfo linkInfo = SimpleMarkdownKt.inlineLink(node, this.$content);
                if (linkInfo == null) {
                    return false;
                }
                String tag = "[message_link_" + $this$markdownToAnnotatedString.getBuilder().getLength() + "]";
                this.$links.put(tag, linkInfo);
                InlineTextContentKt.appendInlineContent$default((AnnotatedString.Builder)$this$markdownToAnnotatedString.getBuilder(), (String)tag, null, (int)2, null);
                return true;
            }
        }));
        Runtime.exitScope((NoriaContext)$this$renderMarkdownTextChunk);
        AnnotatedString text2 = annotatedString;
        annotatedString = NoriaParagraphStyle.Companion.getMultiline();
        ThemeKey themeKey = TextStyleKeys.INSTANCE.getDefaultMultiline();
        Modifier modifier = FocusableKt.focusable$default((Modifier)((Modifier)Modifier.Companion), (boolean)false, null, (int)3, null);
        Map $this$mapValues$iv = links;
        boolean $i$f$mapValues = false;
        Map map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            String tag = (String)entry2.getKey();
            InlineLinkInfo link = (InlineLinkInfo)entry2.getValue();
            Runtime.enterScope((NoriaContext)$this$renderMarkdownTextChunk, (int)582);
            InlineTextContent inlineTextContent = AiChatMessageTextKt.renderInlineLink($this$renderMarkdownTextChunk, tag, link, (Function0<Unit>)((Function0)new Function0<Unit>(link, session, chatSource, pluginScope, window){
                final /* synthetic */ InlineLinkInfo $link;
                final /* synthetic */ UID $session;
                final /* synthetic */ AiChatSource $chatSource;
                final /* synthetic */ PluginScope $pluginScope;
                final /* synthetic */ WindowEntity $window;
                {
                    this.$link = $link;
                    this.$session = $session;
                    this.$chatSource = $chatSource;
                    this.$pluginScope = $pluginScope;
                    this.$window = $window;
                    super(0);
                }

                public final void invoke() {
                    boolean isDocumentationLink = StringsKt.startsWith$default((String)this.$link.getLinkDest(), (String)"https://www.jetbrains.com/help/fleet", (boolean)false, (int)2, null);
                    FusEntityKt.log(AiReports.INSTANCE.getNavigateToLink$fleet_plugins_ai_frontend(), (Object)this.$session.getId(), (Object)((Object)this.$chatSource), (Object)isDocumentationLink);
                    InlineLinkInfo.Companion.navigate(this.$link.getLinkDest(), this.$pluginScope, this.$window);
                }
            }));
            Runtime.exitScope((NoriaContext)$this$renderMarkdownTextChunk);
            InlineTextContent inlineTextContent2 = inlineTextContent;
            map4.put(k, inlineTextContent2);
        }
        Map map5 = destination$iv$iv;
        Runtime.enterScope((NoriaContext)$this$renderMarkdownTextChunk, (int)583);
        TextKt.UiText-uuipMMg$default((NoriaContext)$this$renderMarkdownTextChunk, (AnnotatedString)text2, (long)0L, (ThemeKey)themeKey, (NoriaParagraphStyle)annotatedString, null, null, null, null, (Modifier)modifier, (Map)map5, null, (int)1266, null);
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$renderMarkdownTextChunk);
    }

    @Composable
    private static final InlineTextContent renderInlineLink(NoriaContext $this$renderInlineLink, String tag, InlineLinkInfo link, Function0<Unit> onClick) {
        Runtime.enterScope((NoriaContext)$this$renderInlineLink, (int)589);
        Object[] objectArray = new Object[]{link, onClick};
        Pair pair = TextKt.inlineContentElement-7Vsejjo$default((NoriaContext)$this$renderInlineLink, (String)tag, null, (int)PlaceholderVerticalAlign.Companion.getTextCenter-J6kI3mc(), (Function2)((Function2)Runtime.closure((Object[])objectArray, (Object)new Function2<NoriaContext, String, Unit>(link, onClick){
            final /* synthetic */ InlineLinkInfo $link;
            final /* synthetic */ Function0<Unit> $onClick;
            {
                this.$link = $link;
                this.$onClick = $onClick;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(NoriaContext $this$inlineContentElement, String it) {
                Intrinsics.checkNotNullParameter((Object)$this$inlineContentElement, (String)"$this$inlineContentElement");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                InlineLinkInfo.Type type = InlineLinkInfo.Companion.decodeType(this.$link.getLinkDest());
                if (type instanceof InlineLinkInfo.Type.File) {
                    ThemeKey themeKey;
                    Runtime.enterScope((NoriaContext)$this$inlineContentElement, (int)584);
                    NoriaContext noriaContext = $this$inlineContentElement;
                    FileAddress fileAddress = InlineLinkInfo.Companion.decodeFileAddress(this.$link.getLinkDest());
                    if (fileAddress != null) {
                        void p0;
                        FileAddress fileAddress2 = fileAddress;
                        NoriaContext noriaContext2 = noriaContext;
                        boolean $i$f$invoke$stub_for_inlining = false;
                        boolean bl = false;
                        themeKey = FileIconsKt.fileIcon((FileAddress)p0);
                        noriaContext = noriaContext2;
                    } else {
                        themeKey = null;
                    }
                    AiChatInputInlayRendererKt.renderInlineLink(noriaContext, themeKey, this.$link.getLinkText(), this.$onClick);
                    Unit unit = Unit.INSTANCE;
                    Runtime.exitScope((NoriaContext)$this$inlineContentElement);
                } else if (type instanceof InlineLinkInfo.Type.Commit) {
                    Runtime.enterScope((NoriaContext)$this$inlineContentElement, (int)585);
                    AiChatInputInlayRendererKt.renderInlineLink($this$inlineContentElement, (ThemeKey<String>)IconKeys.Vcs.INSTANCE.getCommit(), this.$link.getLinkText(), this.$onClick);
                    Unit unit = Unit.INSTANCE;
                    Runtime.exitScope((NoriaContext)$this$inlineContentElement);
                } else if (type instanceof InlineLinkInfo.Type.WorkingScope) {
                    Runtime.enterScope((NoriaContext)$this$inlineContentElement, (int)586);
                    AiChatInputInlayRendererKt.renderInlineLink($this$inlineContentElement, (ThemeKey<String>)IconKeys.Vcs.INSTANCE.getCommit(), this.$link.getLinkText(), this.$onClick);
                    Unit unit = Unit.INSTANCE;
                    Runtime.exitScope((NoriaContext)$this$inlineContentElement);
                } else if (type instanceof InlineLinkInfo.Type.Changes) {
                    Runtime.enterScope((NoriaContext)$this$inlineContentElement, (int)587);
                    AiChatInputInlayRendererKt.renderInlineLink($this$inlineContentElement, (ThemeKey<String>)IconKeys.Vcs.INSTANCE.getDiff(), this.$link.getLinkText(), this.$onClick);
                    Unit unit = Unit.INSTANCE;
                    Runtime.exitScope((NoriaContext)$this$inlineContentElement);
                } else if (type == null) {
                    Runtime.enterScope((NoriaContext)$this$inlineContentElement, (int)588);
                    Object[] objectArray = new Object[]{this.$onClick};
                    TextComponentsKt.Link-ElI5-7k$default((NoriaContext)$this$inlineContentElement, (String)this.$link.getLinkText(), null, null, (boolean)false, (boolean)false, (long)0L, (long)0L, null, null, null, null, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<HandlerScope, Unit>(this.$onClick){
                        final /* synthetic */ Function0<Unit> $onClick;
                        {
                            this.$onClick = $onClick;
                            super(1);
                        }

                        public final void invoke(HandlerScope $this$Link) {
                            Intrinsics.checkNotNullParameter((Object)$this$Link, (String)"$this$Link");
                            this.$onClick.invoke();
                        }
                    })), (int)2046, null);
                    Unit unit = Unit.INSTANCE;
                    Runtime.exitScope((NoriaContext)$this$inlineContentElement);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        })), (int)2, null);
        Runtime.exitScope((NoriaContext)$this$renderInlineLink);
        return (InlineTextContent)pair.getSecond();
    }

    public static final /* synthetic */ void access$renderPlainTextChunk(NoriaContext $receiver, ChatMessageChunk.Text.Plain chunk) {
        AiChatMessageTextKt.renderPlainTextChunk($receiver, chunk);
    }

    public static final /* synthetic */ void access$renderMarkdownTextChunk(NoriaContext $receiver, ChatMessageChunk.Text.Markdown chunk, UID session, AiChatSource chatSource) {
        AiChatMessageTextKt.renderMarkdownTextChunk($receiver, chunk, session, chatSource);
    }
}

