/*
 * Decompiled with CFR 0.152.
 */
package fleet.ai.frontend.functions;

import fleet.ai.frontend.api.SyntaxTreeNode;
import fleet.ai.frontend.functions.ContextUtilKt;
import fleet.common.document.EditorEntity;
import fleet.frontend.editor.EditorEntityExtKt;
import fleet.frontend.editor.EditorLayoutEntity;
import fleet.frontend.editor.VisibleEditorEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u0004\u0018\u00010\u0001H\u0000\u001a.\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bH\u0000\u001a2\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bH\u0000\u001a\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\tH\u0000\u00a8\u0006\u0010"}, d2={"getCurrentOpenedEditor", "Lfleet/common/document/EditorEntity;", "findNode", "Lfleet/ai/frontend/api/SyntaxTreeNode;", "node", "offset", "", "matchingLambda", "Lkotlin/Function1;", "", "getNearestNode", "", "getDistance", "getFormattedContext", "", "includeFileName", "fleet.plugins.ai.frontend"})
@SourceDebugExtension(value={"SMAP\nContextUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextUtil.kt\nfleet/ai/frontend/functions/ContextUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1557#2:71\n1628#2,3:72\n1062#2:75\n2341#2,14:76\n1053#2:90\n1557#2:91\n1628#2,3:92\n1053#2:95\n1557#2:96\n1628#2,3:97\n1#3:100\n*S KotlinDebug\n*F\n+ 1 ContextUtil.kt\nfleet/ai/frontend/functions/ContextUtilKt\n*L\n11#1:71\n11#1:72,3\n11#1:75\n15#1:76,14\n24#1:90\n26#1:91\n26#1:92,3\n35#1:95\n37#1:96\n37#1:97,3\n*E\n"})
public final class ContextUtilKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final EditorEntity getCurrentOpenedEditor() {
        void var3_3;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = VisibleEditorEntity.Companion.all();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VisibleEditorEntity visibleEditorEntity = (VisibleEditorEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getEditor());
        }
        Iterable $this$sortedByDescending$iv = (List)var3_3;
        boolean $i$f$sortedByDescending = false;
        return (EditorEntity)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                EditorEntity it = (EditorEntity)b;
                boolean bl = false;
                EditorLayoutEntity editorLayoutEntity = EditorEntityExtKt.getLayout((EditorEntity)it);
                Long l = editorLayoutEntity != null && (editorLayoutEntity = editorLayoutEntity.getUserActionTimestamp()) != null ? (Long)editorLayoutEntity.getFirst() : null;
                it = (EditorEntity)a;
                Comparable comparable = l;
                bl = false;
                EditorLayoutEntity editorLayoutEntity2 = EditorEntityExtKt.getLayout((EditorEntity)it);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(editorLayoutEntity2 != null && (editorLayoutEntity2 = editorLayoutEntity2.getUserActionTimestamp()) != null ? (Long)editorLayoutEntity2.getFirst() : null));
            }
        }));
    }

    @Nullable
    public static final SyntaxTreeNode findNode(@NotNull SyntaxTreeNode node, long offset, @NotNull Function1<? super SyntaxTreeNode, Boolean> matchingLambda2) {
        Object v0;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(matchingLambda2, (String)"matchingLambda");
        Iterable $this$minByOrNull$iv = ContextUtilKt.getNearestNode(node, offset, matchingLambda2);
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                SyntaxTreeNode it = (SyntaxTreeNode)minElem$iv;
                boolean bl = false;
                long minValue$iv = ContextUtilKt.getDistance(it, offset);
                do {
                    Object e$iv = iterator$iv.next();
                    SyntaxTreeNode it2 = (SyntaxTreeNode)e$iv;
                    $i$a$-minByOrNull-ContextUtilKt$findNode$1 = false;
                    long v$iv = ContextUtilKt.getDistance(it2, offset);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SyntaxTreeNode> getNearestNode(@NotNull SyntaxTreeNode node, long offset, @NotNull Function1<? super SyntaxTreeNode, Boolean> matchingLambda2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(matchingLambda2, (String)"matchingLambda");
        SyntaxTreeNode syntaxTreeNode = node;
        if (syntaxTreeNode instanceof SyntaxTreeNode.Function) {
            list2 = ((Boolean)matchingLambda2.invoke((Object)node)).booleanValue() ? CollectionsKt.listOf((Object)node) : CollectionsKt.emptyList();
        } else if (syntaxTreeNode instanceof SyntaxTreeNode.Class) {
            void $this$mapTo$iv$iv;
            Iterable $this$sortedBy$iv = ((SyntaxTreeNode.Class)node).getNodes();
            boolean $i$f$sortedBy = false;
            Iterable $this$map$iv = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(offset){
                final /* synthetic */ long $offset$inlined;
                {
                    this.$offset$inlined = l;
                }

                public final int compare(T a, T b) {
                    SyntaxTreeNode it = (SyntaxTreeNode)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(ContextUtilKt.getDistance(it, this.$offset$inlined));
                    it = (SyntaxTreeNode)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(ContextUtilKt.getDistance(it, this.$offset$inlined)));
                }
            }), (int)2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SyntaxTreeNode syntaxTreeNode2 = (SyntaxTreeNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ContextUtilKt.getNearestNode((SyntaxTreeNode)it, offset, matchingLambda2));
            }
            List matchedNodes = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            list2 = CollectionsKt.plus((Collection)matchedNodes, (Iterable)((Boolean)matchingLambda2.invoke((Object)node) != false && matchedNodes.isEmpty() ? CollectionsKt.listOf((Object)node) : CollectionsKt.emptyList()));
        } else if (syntaxTreeNode instanceof SyntaxTreeNode.Field) {
            list2 = ((Boolean)matchingLambda2.invoke((Object)node)).booleanValue() ? CollectionsKt.listOf((Object)node) : CollectionsKt.emptyList();
        } else if (syntaxTreeNode instanceof SyntaxTreeNode.File) {
            Iterable $this$sortedBy$iv = ((SyntaxTreeNode.File)node).getNodes();
            boolean $i$f$sortedBy = false;
            Iterable $this$map$iv = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(offset){
                final /* synthetic */ long $offset$inlined;
                {
                    this.$offset$inlined = l;
                }

                public final int compare(T a, T b) {
                    SyntaxTreeNode it = (SyntaxTreeNode)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(ContextUtilKt.getDistance(it, this.$offset$inlined));
                    it = (SyntaxTreeNode)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(ContextUtilKt.getDistance(it, this.$offset$inlined)));
                }
            }), (int)2);
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                SyntaxTreeNode it = (SyntaxTreeNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ContextUtilKt.getNearestNode(it, offset, matchingLambda2));
            }
            List matchedNodes = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            list2 = CollectionsKt.plus((Collection)matchedNodes, (Iterable)((Boolean)matchingLambda2.invoke((Object)node) != false && matchedNodes.isEmpty() ? CollectionsKt.listOf((Object)node) : CollectionsKt.emptyList()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list2;
    }

    public static final long getDistance(@NotNull SyntaxTreeNode node, long offset) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.getStartOffset() <= offset && offset <= node.getEndOffset()) {
            return 0L;
        }
        return Math.min(Math.abs(node.getStartOffset() - offset), Math.abs(node.getEndOffset() - offset));
    }

    @NotNull
    public static final String getFormattedContext(@NotNull SyntaxTreeNode node, boolean includeFileName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        SyntaxTreeNode syntaxTreeNode = node;
        if (syntaxTreeNode instanceof SyntaxTreeNode.Class) {
            object = ((SyntaxTreeNode.Class)node).getDeclaration() + StringsKt.replace$default((String)("\n" + CollectionsKt.joinToString$default((Iterable)((SyntaxTreeNode.Class)node).getNodes(), (CharSequence)"\n\n", null, null, (int)0, null, (Function1)getFormattedContext.1.INSTANCE, (int)30, null)), (String)"\n", (String)"\n\t", (boolean)false, (int)4, null);
        } else if (syntaxTreeNode instanceof SyntaxTreeNode.Field) {
            object = ((SyntaxTreeNode.Field)node).getDeclaration();
        } else if (syntaxTreeNode instanceof SyntaxTreeNode.File) {
            String string;
            String string2;
            String string3 = ((SyntaxTreeNode.File)node).getName();
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                string2 = "File name: " + it + "\n\n";
            } else {
                string2 = null;
            }
            String it = string = string2;
            boolean bl = false;
            Object object2 = includeFileName ? string : null;
            if (object2 == null) {
                object2 = "";
            }
            object = (String)object2 + CollectionsKt.joinToString$default((Iterable)((SyntaxTreeNode.File)node).getNodes(), (CharSequence)"\n\n", null, null, (int)0, null, (Function1)getFormattedContext.4.INSTANCE, (int)30, null);
        } else if (syntaxTreeNode instanceof SyntaxTreeNode.Function) {
            object = ((SyntaxTreeNode.Function)node).getDeclaration();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    public static /* synthetic */ String getFormattedContext$default(SyntaxTreeNode syntaxTreeNode, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return ContextUtilKt.getFormattedContext(syntaxTreeNode, bl);
    }
}

