/*
 * Decompiled with CFR 0.152.
 */
package fleet.ai.frontend;

import andel.lines.Inlay;
import androidx.compose.ui.graphics.Color;
import fleet.ai.frontend.AiAttachment;
import fleet.ai.frontend.AiChatAttachmentsKt;
import fleet.ai.frontend.markdown.InlineLinkInfo;
import fleet.api.FileAddress;
import fleet.common.fs.FsdKt;
import fleet.common.fs.RelativePath;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import noria.model.ThemeKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005j\u0004\u0018\u0001`\u0007\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0018\u001a\u00020\u0006H\u0016J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0096@\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005j\u0004\u0018\u0001`\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0014\u0010\u0014\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0014\u0010\u0016\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lfleet/ai/frontend/FileAttachment;", "Lfleet/ai/frontend/AiAttachment;", "fileAddress", "Lfleet/api/FileAddress;", "popupIconKey", "Lnoria/model/ThemeKey;", "", "Lnoria/model/IconKey;", "popupText", "<init>", "(Lfleet/api/FileAddress;Lnoria/model/ThemeKey;Ljava/lang/String;)V", "getPopupIconKey", "()Lnoria/model/ThemeKey;", "getPopupText", "()Ljava/lang/String;", "key", "getKey", "()Lfleet/api/FileAddress;", "inlayText", "getInlayText", "grayText", "getGrayText", "markdownLink", "getMarkdownLink", "name", "content", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fleet.plugins.ai.frontend"})
@SourceDebugExtension(value={"SMAP\nAiChatAttachments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiChatAttachments.kt\nfleet/ai/frontend/FileAttachment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1#2:255\n*E\n"})
public final class FileAttachment
implements AiAttachment {
    @NotNull
    private final FileAddress fileAddress;
    @Nullable
    private final ThemeKey<String> popupIconKey;
    @NotNull
    private final String popupText;
    @NotNull
    private final FileAddress key;
    @NotNull
    private final String inlayText;
    @NotNull
    private final String grayText;
    @NotNull
    private final String markdownLink;

    public FileAttachment(@NotNull FileAddress fileAddress, @Nullable ThemeKey<String> popupIconKey, @NotNull String popupText) {
        Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
        Intrinsics.checkNotNullParameter((Object)popupText, (String)"popupText");
        this.fileAddress = fileAddress;
        this.popupIconKey = popupIconKey;
        this.popupText = popupText;
        this.key = this.fileAddress;
        this.inlayText = this.getPopupText();
        this.grayText = this.fileAddress.getPath().getName();
        this.markdownLink = InlineLinkInfo.Companion.encodeToMarkdown$default(InlineLinkInfo.Companion, this.fileAddress, null, null, 6, null);
    }

    @Override
    @Nullable
    public ThemeKey<String> getPopupIconKey() {
        return this.popupIconKey;
    }

    @Override
    @NotNull
    public String getPopupText() {
        return this.popupText;
    }

    @NotNull
    public FileAddress getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public String getInlayText() {
        return this.inlayText;
    }

    @Override
    @NotNull
    public String getGrayText() {
        return this.grayText;
    }

    @Override
    @NotNull
    public String getMarkdownLink() {
        return this.markdownLink;
    }

    @Override
    @NotNull
    public String name() {
        Object object;
        block3: {
            block2: {
                RelativePath relativePath = FsdKt.relativePath$default((FileAddress)this.fileAddress, (boolean)true, (boolean)false, (boolean)false, (int)12, null);
                String relativePathToFile = relativePath != null ? relativePath.joinToString(true) : null;
                object = relativePathToFile;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = "file " + it;
                object = string;
                if (string != null) break block3;
            }
            object = "file " + this.fileAddress.getPath().getName();
        }
        return object;
    }

    @Override
    @Nullable
    public Object content(@NotNull Continuation<? super String> $completion) {
        return AiChatAttachmentsKt.getTextOfFile(this.fileAddress, $completion);
    }

    @Override
    @NotNull
    public Inlay.Binding getBinding() {
        return AiAttachment.DefaultImpls.getBinding(this);
    }

    @Override
    @Nullable
    public ThemeKey<String> getInlayIconKey() {
        return AiAttachment.DefaultImpls.getInlayIconKey(this);
    }

    @Override
    @NotNull
    public ThemeKey<Color> getTextColor() {
        return AiAttachment.DefaultImpls.getTextColor(this);
    }

    @Override
    @NotNull
    public ThemeKey<Color> getBgColor() {
        return AiAttachment.DefaultImpls.getBgColor(this);
    }
}

