/*
 * Decompiled with CFR 0.152.
 */
package fleet.ai.frontend;

import ai.grazie.model.cloud.exceptions.ExtensionsKt;
import ai.grazie.model.cloud.exceptions.HTTPStatusException;
import fleet.ai.frontend.ErrorKind;
import fleet.ai.frontend.ErrorPlace;
import fleet.ai.frontend.HTTPExceptionMessages;
import fleet.api.Os;
import fleet.common.settings.SettingsKey;
import fleet.common.settings.SettingsLocation;
import fleet.schema.common.Schema;
import fleet.schema.common.SchemaKt;
import fleet.util.EnumSet;
import kotlin.KotlinNothingValueException;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.ULong;
import kotlin.enums.EnumEntries;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlinx.serialization.KSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0002H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0011"}, d2={"throwException", "", "Lfleet/ai/frontend/ErrorKind;", "getCode", "", "JBPolicyString", "", "toUserVisibleMessage", "Lfleet/ai/frontend/HTTPExceptionMessages;", "Lai/grazie/model/cloud/exceptions/HTTPStatusException;", "TestErrorPlace", "Lfleet/common/settings/SettingsKey;", "Lfleet/ai/frontend/ErrorPlace;", "getTestErrorPlace", "()Lfleet/common/settings/SettingsKey;", "TestErrorKind", "getTestErrorKind", "fleet.plugins.ai.frontend"})
@SourceDebugExtension(value={"SMAP\nErrors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Errors.kt\nfleet/ai/frontend/ErrorsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 EnumSet.kt\nfleet/util/EnumSetKt\n+ 4 EnumSet.kt\nfleet/util/EnumSet$Companion\n+ 5 SettingsEntity.kt\nfleet/common/settings/SettingsEntityKt\n*L\n1#1,99:1\n1#2:100\n157#3:101\n153#3:109\n157#3:122\n153#3:130\n85#4:102\n78#4,2:110\n85#4:123\n78#4,2:131\n87#5,6:103\n94#5,10:112\n87#5,6:124\n94#5,10:133\n*S KotlinDebug\n*F\n+ 1 Errors.kt\nfleet/ai/frontend/ErrorsKt\n*L\n89#1:101\n84#1:109\n97#1:122\n92#1:130\n89#1:102\n84#1:110,2\n97#1:123\n92#1:131,2\n84#1:103,6\n84#1:112,10\n92#1:124,6\n92#1:133,10\n*E\n"})
public final class ErrorsKt {
    @NotNull
    private static final String JBPolicyString = "[JetBrains AI Acceptable Use Policy](https://www.jetbrains.com/legal/docs/terms/jetbrains-ai/acceptable-use/)";
    @NotNull
    private static final SettingsKey<ErrorPlace> TestErrorPlace;
    @NotNull
    private static final SettingsKey<ErrorKind> TestErrorKind;

    @NotNull
    public static final Void throwException(@NotNull ErrorKind $this$throwException) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$throwException), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$throwException.ordinal()]) {
            case 1: {
                ExtensionsKt.badRequest$default(null, (int)1, null);
                throw new KotlinNothingValueException();
            }
            case 2: {
                ExtensionsKt.closedRequest$default(null, (int)1, null);
                throw new KotlinNothingValueException();
            }
            case 3: {
                ExtensionsKt.contentTooLarge$default(null, (int)1, null);
                throw new KotlinNothingValueException();
            }
            case 4: {
                ExtensionsKt.forbidden$default(null, (int)1, null);
                throw new KotlinNothingValueException();
            }
            case 5: {
                ExtensionsKt.internalServerError$default(null, (int)1, null);
                throw new KotlinNothingValueException();
            }
            case 6: {
                ExtensionsKt.lengthRequired$default(null, (int)1, null);
                throw new KotlinNothingValueException();
            }
            case 7: {
                ExtensionsKt.notFound$default(null, (int)1, null);
                throw new KotlinNothingValueException();
            }
            case 8: {
                ExtensionsKt.preconditionFailed$default(null, (int)1, null);
                throw new KotlinNothingValueException();
            }
            case 9: {
                ExtensionsKt.requestTimeout$default(null, (int)1, null);
                throw new KotlinNothingValueException();
            }
            case 10: {
                ExtensionsKt.tooManyRequests$default(null, null, (int)3, null);
                throw new KotlinNothingValueException();
            }
            case 11: {
                ExtensionsKt.unauthorized$default(null, (int)1, null);
                throw new KotlinNothingValueException();
            }
            case 12: {
                ExtensionsKt.unavailableForLegalReasons$default(null, (int)1, null);
                throw new KotlinNothingValueException();
            }
            case 13: {
                ExtensionsKt.unprocessableContent$default(null, (int)1, null);
                throw new KotlinNothingValueException();
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public static final int getCode(@NotNull ErrorKind $this$getCode) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getCode), (String)"<this>");
        ErrorKind errorKind = $this$getCode;
        try {
            ErrorKind $this$getCode_u24lambda_u240 = errorKind;
            boolean bl = false;
            ErrorsKt.throwException($this$getCode_u24lambda_u240);
            throw new KotlinNothingValueException();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
            HTTPStatusException hTTPStatusException = throwable2 instanceof HTTPStatusException ? (HTTPStatusException)throwable2 : null;
            if (hTTPStatusException == null) {
                throw new IllegalStateException("no exception was thrown???".toString());
            }
            return hTTPStatusException.getStatus();
        }
    }

    @NotNull
    public static final HTTPExceptionMessages toUserVisibleMessage(@NotNull HTTPStatusException $this$toUserVisibleMessage) {
        HTTPExceptionMessages hTTPExceptionMessages;
        Intrinsics.checkNotNullParameter((Object)$this$toUserVisibleMessage, (String)"<this>");
        HTTPStatusException hTTPStatusException = $this$toUserVisibleMessage;
        if (hTTPStatusException instanceof HTTPStatusException.AccessProhibited) {
            hTTPExceptionMessages = HTTPExceptionMessages.AccessProhibited.INSTANCE;
        } else if (hTTPStatusException instanceof HTTPStatusException.TooManyRequests) {
            hTTPExceptionMessages = HTTPExceptionMessages.TooManyRequests.INSTANCE;
        } else if (hTTPStatusException instanceof HTTPStatusException.UnavailableForLegalReasons) {
            hTTPExceptionMessages = HTTPExceptionMessages.UnavailableForLegalReasons.INSTANCE;
        } else if (hTTPStatusException instanceof HTTPStatusException.UnprocessableContent) {
            hTTPExceptionMessages = HTTPExceptionMessages.UnprocessableContent.INSTANCE;
        } else {
            int n = $this$toUserVisibleMessage.getStatus();
            String string = $this$toUserVisibleMessage.getDescription();
            if (string == null) {
                string = "";
            }
            hTTPExceptionMessages = new HTTPExceptionMessages.InternalError(n, string);
        }
        return hTTPExceptionMessages;
    }

    @NotNull
    public static final SettingsKey<ErrorPlace> getTestErrorPlace() {
        return TestErrorPlace;
    }

    @NotNull
    public static final SettingsKey<ErrorKind> getTestErrorKind() {
        return TestErrorKind;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void locations$iv;
        boolean supportContexts$iv;
        KSerializer<ErrorKind> kSerializer$iv;
        ErrorKind defaultValue$iv;
        String key$iv;
        String string = "grazie.test.error.place";
        ErrorPlace errorPlace = ErrorPlace.NONE;
        KSerializer<ErrorPlace> kSerializer = ErrorPlace.Companion.serializer();
        boolean bl = true;
        Enum value$iv = (Enum)SettingsLocation.LOCAL;
        boolean $i$f$enumSetOf = false;
        EnumSet.Companion this_$iv$iv = EnumSet.Companion;
        boolean $i$f$of = false;
        value$iv = new EnumSet(ULong.constructor-impl((long)(1L << value$iv.ordinal())), SettingsLocation.getEntries(), null);
        boolean $i$f$enumSetOfAll = false;
        EnumSet.Companion this_$iv$iv$iv = EnumSet.Companion;
        boolean $i$f$allOf = false;
        EnumEntries enumEntries$iv$iv$iv = Os.getEntries();
        EnumSet operatingSystems$iv = new EnumSet(ULong.constructor-impl((long)(ULong.constructor-impl((long)(1L << enumEntries$iv$iv$iv.size())) - 1L)), enumEntries$iv$iv$iv, null);
        Object schema$iv = null;
        boolean $i$f$SettingsKey = false;
        TestErrorPlace = new SettingsKey(key$iv, LazyKt.lazyOf((Object)((Object)defaultValue$iv)), (KSerializer)kSerializer$iv, supportContexts$iv, operatingSystems$iv, (EnumSet)locations$iv, LazyKt.lazy((Function0)((Function0)new Function0<Schema>((Object)defaultValue$iv){
            final /* synthetic */ Object $defaultValue;
            {
                this.$defaultValue = $defaultValue;
                super(0);
            }

            public final Schema invoke() {
                return SchemaKt.schemaForType$default((KType)Reflection.typeOf(ErrorPlace.class), (Object)this.$defaultValue, null, (int)4, null);
            }
        })));
        key$iv = "grazie.test.error.kind";
        defaultValue$iv = ErrorKind.internalServerError;
        kSerializer$iv = ErrorKind.Companion.serializer();
        supportContexts$iv = true;
        value$iv = (Enum)SettingsLocation.LOCAL;
        $i$f$enumSetOf = false;
        this_$iv$iv = EnumSet.Companion;
        $i$f$of = false;
        value$iv = new EnumSet(ULong.constructor-impl((long)(1L << value$iv.ordinal())), SettingsLocation.getEntries(), null);
        $i$f$enumSetOfAll = false;
        this_$iv$iv$iv = EnumSet.Companion;
        $i$f$allOf = false;
        enumEntries$iv$iv$iv = Os.getEntries();
        operatingSystems$iv = new EnumSet(ULong.constructor-impl((long)(ULong.constructor-impl((long)(1L << enumEntries$iv$iv$iv.size())) - 1L)), enumEntries$iv$iv$iv, null);
        schema$iv = null;
        $i$f$SettingsKey = false;
        TestErrorKind = new SettingsKey(key$iv, LazyKt.lazyOf((Object)((Object)defaultValue$iv)), kSerializer$iv, supportContexts$iv, operatingSystems$iv, (EnumSet)locations$iv, LazyKt.lazy((Function0)((Function0)new Function0<Schema>((Object)defaultValue$iv){
            final /* synthetic */ Object $defaultValue;
            {
                this.$defaultValue = $defaultValue;
                super(0);
            }

            public final Schema invoke() {
                return SchemaKt.schemaForType$default((KType)Reflection.typeOf(ErrorKind.class), (Object)this.$defaultValue, null, (int)4, null);
            }
        })));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ErrorKind.values().length];
            try {
                nArray[ErrorKind.badRequest.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorKind.closedRequest.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorKind.contentTooLarge.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorKind.forbidden.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorKind.internalServerError.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorKind.lengthRequired.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorKind.notFound.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorKind.preconditionFailed.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorKind.requestTimeout.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorKind.tooManyRequests.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorKind.unauthorized.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorKind.unavailableForLegalReasons.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorKind.unprocessableContent.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

