/*
 * Decompiled with CFR 0.152.
 */
package fleet.ai.common;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u00a8\u0006\t"}, d2={"levenshteinDistance", "", "s1", "", "s2", "levenshteinDistanceNormalized", "", "str1", "str2", "fleet.plugins.ai.frontend"})
public final class LevenshteinDistanceKt {
    public static final int levenshteinDistance(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        int len1 = s1.length();
        int len2 = s2.length();
        if (len1 == 0) {
            return len2;
        }
        if (len2 == 0) {
            return len1;
        }
        int n = 0;
        int n2 = len1 + 1;
        int[][] nArrayArray = new int[n2][];
        while (n < n2) {
            int n3 = n++;
            nArrayArray[n3] = new int[len2 + 1];
        }
        int[][] dp = nArrayArray;
        int i = 0;
        if (i <= len1) {
            while (true) {
                int j;
                if ((j = 0) <= len2) {
                    while (true) {
                        dp[i][j] = i == 0 ? j : (j == 0 ? i : Math.min(dp[i - 1][j - 1] + (s1.charAt(i - 1) == s2.charAt(j - 1) ? 0 : 1), Math.min(dp[i - 1][j] + 1, dp[i][j - 1] + 1)));
                        if (j == len2) break;
                        ++j;
                    }
                }
                if (i == len1) break;
                ++i;
            }
        }
        return dp[len1][len2];
    }

    public static final double levenshteinDistanceNormalized(@NotNull CharSequence str1, @NotNull CharSequence str2) {
        Intrinsics.checkNotNullParameter((Object)str1, (String)"str1");
        Intrinsics.checkNotNullParameter((Object)str2, (String)"str2");
        int maxLength = Math.max(str1.length(), str2.length());
        if (maxLength == 0) {
            return 0.0;
        }
        return (double)LevenshteinDistanceKt.levenshteinDistance(str1, str2) / (double)maxLength;
    }
}

