/*
 * Decompiled with CFR 0.152.
 */
package fleet.diff;

import andel.text.LineEnding;
import andel.text.TextRange;
import fleet.diff.FileMarkup;
import fleet.diff.LineTokenizer;
import fleet.diff.MarkupKt;
import fleet.diff.SyntaxMarkup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000 (2\u00020\u0001:\u0002()B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u001b\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fJ\u0017\u0010 \u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b!J\u001d\u0010\u0019\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b$J\b\u0010%\u001a\u00020\u001fH\u0016J\u000e\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006*"}, d2={"Lfleet/diff/FileText;", "", "text", "", "extraSyntaxMarkup", "", "Lfleet/diff/SyntaxMarkup;", "markup", "Lfleet/diff/FileMarkup;", "(Ljava/lang/CharSequence;Ljava/util/List;Lfleet/diff/FileMarkup;)V", "getExtraSyntaxMarkup", "()Ljava/util/List;", "isEmpty", "", "isEmpty$fleet_diff", "()Z", "lineEnding", "Landel/text/LineEnding;", "getLineEnding$fleet_diff", "()Landel/text/LineEnding;", "lines", "Lfleet/diff/FileText$Line;", "getLines", "getMarkup", "()Lfleet/diff/FileMarkup;", "getText", "()Ljava/lang/CharSequence;", "equals", "other", "getLine", "i", "", "getLineSafe", "getLineSafe$fleet_diff", "fromLine", "toLine", "getText$fleet_diff", "hashCode", "offsetToLine", "offset", "Companion", "Line", "fleet.diff"})
public final class FileText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharSequence text;
    @NotNull
    private final List<SyntaxMarkup> extraSyntaxMarkup;
    @NotNull
    private final FileMarkup markup;
    @NotNull
    private final List<Line> lines;
    @Nullable
    private final LineEnding lineEnding;
    private final boolean isEmpty;
    @NotNull
    private static final FileText Empty = new FileText("", null, null, 6, null);

    public FileText(@NotNull CharSequence text, @NotNull List<SyntaxMarkup> extraSyntaxMarkup, @NotNull FileMarkup markup) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(extraSyntaxMarkup, (String)"extraSyntaxMarkup");
        Intrinsics.checkNotNullParameter((Object)markup, (String)"markup");
        this.text = text;
        this.extraSyntaxMarkup = extraSyntaxMarkup;
        this.markup = markup;
        ArrayList<Line> lines = new ArrayList<Line>(this.text.length() / 36);
        LineTokenizer lineTokenizer = new LineTokenizer(this.text);
        LineEnding lastLineSeparator = null;
        HashSet<LineEnding> lineSeparators = new HashSet<LineEnding>();
        while (!lineTokenizer.getAtEnd()) {
            int start = lineTokenizer.getOffset();
            int end = start + lineTokenizer.getLength();
            lines.add(new Line(this, lines.size(), start, end));
            lastLineSeparator = lineTokenizer.getLineSeparator();
            if (lastLineSeparator != null) {
                lineSeparators.add(lastLineSeparator);
            }
            lineTokenizer.advance();
        }
        if (lines.size() > 0 && lastLineSeparator != null) {
            lines.add(new Line(this, lines.size(), this.text.length(), this.text.length()));
        }
        this.lines = lines;
        this.lineEnding = (LineEnding)CollectionsKt.singleOrNull((Iterable)lineSeparators);
        this.isEmpty = this.text.length() == 0;
    }

    public /* synthetic */ FileText(CharSequence charSequence, List list, FileMarkup fileMarkup, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            fileMarkup = FileMarkup.Companion.getEmpty();
        }
        this(charSequence, list, fileMarkup);
    }

    @NotNull
    public final CharSequence getText() {
        return this.text;
    }

    @NotNull
    public final List<SyntaxMarkup> getExtraSyntaxMarkup() {
        return this.extraSyntaxMarkup;
    }

    @NotNull
    public final FileMarkup getMarkup() {
        return this.markup;
    }

    @NotNull
    public final List<Line> getLines() {
        return this.lines;
    }

    @Nullable
    public final LineEnding getLineEnding$fleet_diff() {
        return this.lineEnding;
    }

    public final boolean isEmpty$fleet_diff() {
        return this.isEmpty;
    }

    @NotNull
    public final CharSequence getText$fleet_diff(int fromLine, int toLine) {
        if (!(fromLine >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(toLine <= this.lines.size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(fromLine < toLine)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.text.subSequence(this.lines.get(fromLine).getStart(), this.lines.get(toLine - 1).getEnd());
    }

    @NotNull
    public final Line getLine(int i) {
        if (i >= this.lines.size()) {
            return new Line(this, i, this.text.length(), this.text.length());
        }
        return this.lines.get(i);
    }

    @Nullable
    public final Line getLineSafe$fleet_diff(int i) {
        if (i < 0 || i >= this.lines.size()) {
            return null;
        }
        return this.lines.get(i);
    }

    public final int offsetToLine(int offset) {
        if (this.lines.isEmpty()) {
            return 0;
        }
        int low = 0;
        int high = this.lines.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Line line = this.lines.get(mid);
            if (line.getEnd() < offset) {
                low = mid + 1;
                continue;
            }
            if (offset < line.getStart()) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return this.lines.size() - 1;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileText)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.text, (Object)((FileText)other).text);
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lfleet/diff/FileText$Companion;", "", "()V", "Empty", "Lfleet/diff/FileText;", "getEmpty", "()Lfleet/diff/FileText;", "fleet.diff"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileText getEmpty() {
            return Empty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0010J\u0013\u0010\u001c\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010 \u001a\u00020\u0005H\u0016J\u000e\u0010 \u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0010J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0018J\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%J\b\u0010'\u001a\u00020\"H\u0016R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\n\u00a8\u0006("}, d2={"Lfleet/diff/FileText$Line;", "", "file", "Lfleet/diff/FileText;", "lineNumber", "", "start", "end", "(Lfleet/diff/FileText;III)V", "getEnd", "()I", "fileText", "", "getFileText", "()Ljava/lang/CharSequence;", "isEmptyOrBlank", "", "()Z", "length", "getLength", "getLineNumber", "lineText", "getLineText", "range", "Landel/text/TextRange;", "getRange", "()Landel/text/TextRange;", "getStart", "equals", "line", "ignoreWhiteSpaces", "other", "hashCode", "subStr", "", "textRange", "syntax", "", "Lfleet/diff/SyntaxMarkup;", "toString", "fleet.diff"})
    @SourceDebugExtension(value={"SMAP\nFileText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileText.kt\nfleet/diff/FileText$Line\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,271:1\n1726#2,3:272\n1360#2:275\n1446#2,5:276\n*S KotlinDebug\n*F\n+ 1 FileText.kt\nfleet/diff/FileText$Line\n*L\n101#1:272,3\n114#1:275\n114#1:276,5\n*E\n"})
    public static final class Line {
        @NotNull
        private final FileText file;
        private final int lineNumber;
        private final int start;
        private final int end;

        public Line(@NotNull FileText file, int lineNumber, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.lineNumber = lineNumber;
            this.start = start;
            this.end = end;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        private final CharSequence getFileText() {
            return this.file.getText();
        }

        @NotNull
        public final CharSequence getLineText() {
            return this.getFileText().subSequence(this.start, this.end);
        }

        public final boolean isEmptyOrBlank() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = (Iterable)RangesKt.until((int)this.start, (int)this.end);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator = $this$all$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl2 = false;
                        if (CharsKt.isWhitespace((char)this.getFileText().charAt(it))) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        @NotNull
        public final TextRange getRange() {
            return new TextRange((long)this.start, (long)this.end);
        }

        public final int getLength() {
            return this.end - this.start;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<SyntaxMarkup> syntax() {
            void var2_3;
            void $this$flatMapTo$iv$iv;
            Object[] objectArray = new List[]{this.file.getMarkup().getSyntax(), this.file.getExtraSyntaxMarkup()};
            Iterable $this$flatMap$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list;
                List markups = (List)element$iv$iv;
                boolean bl = false;
                int index2 = CollectionsKt.binarySearch$default((List)markups, (int)0, (int)0, (Function1)((Function1)new Function1<SyntaxMarkup, Integer>(this){
                    final /* synthetic */ Line this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(@NotNull SyntaxMarkup it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return it.getRange().getEnd() <= (long)this.this$0.getStart() ? -1 : (it.getRange().getStart() >= (long)this.this$0.getEnd() ? 1 : 0);
                    }
                }), (int)3, null);
                if (index2 < 0) {
                    list = CollectionsKt.emptyList();
                } else {
                    ArrayList<SyntaxMarkup> result = new ArrayList<SyntaxMarkup>();
                    while (index2 > 0 && Line.syntax$isInLine((SyntaxMarkup)markups.get(index2 - 1), this)) {
                        --index2;
                    }
                    while (index2 < markups.size() && Line.syntax$isInLine((SyntaxMarkup)markups.get(index2), this)) {
                        long s = Math.max(((SyntaxMarkup)markups.get(index2)).getRange().getStart(), (long)this.start);
                        long e = Math.min(((SyntaxMarkup)markups.get(index2)).getRange().getEnd(), (long)this.end);
                        result.add(MarkupKt.withRange((SyntaxMarkup)markups.get(index2), new TextRange(s - (long)this.start, e - (long)this.start)));
                        ++index2;
                    }
                    list = result;
                }
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List it = (List)destination$iv$iv;
            boolean bl = false;
            return it.isEmpty() ? null : var2_3;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Line)) {
                return false;
            }
            return this.equals((Line)other, false);
        }

        public final boolean equals(@NotNull Line line, boolean ignoreWhiteSpaces) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            CharSequence fti = this.getFileText();
            CharSequence ftj = line.getFileText();
            if (ignoreWhiteSpaces) {
                int i = this.start;
                for (int j = line.start; i < this.end || j < line.end; ++i, ++j) {
                    while (i < this.end && CharsKt.isWhitespace((char)fti.charAt(i))) {
                        ++i;
                    }
                    while (j < line.end && CharsKt.isWhitespace((char)ftj.charAt(j))) {
                        ++j;
                    }
                    if (i < this.end && j < line.end && fti.charAt(i) != ftj.charAt(j)) {
                        return false;
                    }
                    if ((i != this.end || j >= line.end) && (i >= this.end || j != line.end)) continue;
                    return false;
                }
            } else {
                if (this.end - this.start != line.end - line.start) {
                    return false;
                }
                int i = this.start;
                for (int j = line.start; i < this.end && j < line.end; ++i, ++j) {
                    if (fti.charAt(i) == ftj.charAt(j)) continue;
                    return false;
                }
            }
            return true;
        }

        public final int hashCode(boolean ignoreWhiteSpaces) {
            int hashCode = 0;
            CharSequence ft = this.getFileText();
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                char ch = ft.charAt(i);
                if (ignoreWhiteSpaces && CharsKt.isWhitespace((char)ch)) continue;
                hashCode = hashCode * 19 + ch * 17;
            }
            return hashCode;
        }

        public int hashCode() {
            return this.hashCode(false);
        }

        @NotNull
        public final String subStr(@NotNull TextRange textRange) {
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            if (!(textRange.getStart() >= 0L && textRange.getEnd() <= (long)this.getLength())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return ((Object)this.getFileText().subSequence(this.start + (int)textRange.getStart(), this.start + (int)textRange.getEnd())).toString();
        }

        @NotNull
        public String toString() {
            return ((Object)this.getLineText()).toString();
        }

        private static final boolean syntax$isInLine(SyntaxMarkup $this$syntax_u24isInLine, Line this$0) {
            return Math.max($this$syntax_u24isInLine.getRange().getStart(), (long)this$0.start) < Math.min($this$syntax_u24isInLine.getRange().getEnd(), (long)this$0.end);
        }
    }
}

