/*
 * Decompiled with CFR 0.152.
 */
package fleet.rpc.server.ktor;

import fleet.preferences.FleetPropertiesKt;
import fleet.rpc.core.TransportMessage;
import fleet.rpc.core.util.MappedChannelsKt;
import fleet.rpc.server.EndpointKind;
import fleet.rpc.server.RequestDispatcher;
import fleet.rpc.server.ktor.KtorRpcEndpoint;
import fleet.rpc.server.ktor.RpcStats;
import fleet.util.UID;
import fleet.util.logging.KLogger;
import io.ktor.server.application.Application;
import io.ktor.server.cio.CIO;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineEnvironmentBuilder;
import io.ktor.server.engine.ApplicationEngineEnvironmentKt;
import io.ktor.server.engine.ApplicationEngineFactory;
import io.ktor.server.engine.EmbeddedServerKt;
import io.ktor.server.engine.EngineConnectorBuilder;
import io.ktor.server.routing.Route;
import io.ktor.server.routing.Routing;
import io.ktor.server.websocket.DefaultWebSocketServerSession;
import io.ktor.server.websocket.RoutingKt;
import io.ktor.websocket.Frame;
import io.ktor.websocket.FrameCommonKt;
import java.io.Writer;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\r\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011\u001a$\u0010\u0012\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00160\u0013*\u00020\u0017H\u0002\u001a7\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00062\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00010\u001f\u00a2\u0006\u0002\b!\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\""}, d2={"rpcEndpoint", "", "Lio/ktor/server/routing/Routing;", "handler", "Lfleet/rpc/server/RequestDispatcher;", "WARNING_THRESHOLD", "", "receiveStats", "Lfleet/rpc/server/ktor/RpcStats;", "getReceiveStats", "()Lfleet/rpc/server/ktor/RpcStats;", "sendStats", "getSendStats", "printStats", "Ljava/io/Writer;", "stats", "title", "", "toChannels", "Lkotlin/Pair;", "Lkotlinx/coroutines/channels/SendChannel;", "Lfleet/rpc/core/TransportMessage;", "Lkotlinx/coroutines/channels/ReceiveChannel;", "Lio/ktor/server/websocket/DefaultWebSocketServerSession;", "cioEngine", "Lio/ktor/server/engine/ApplicationEngine;", "parentContext", "Lkotlin/coroutines/CoroutineContext;", "host", "port", "main", "Lkotlin/Function1;", "Lio/ktor/server/application/Application;", "Lkotlin/ExtensionFunctionType;", "fleet.rpc.server.ktor"})
@SourceDebugExtension(value={"SMAP\nKtorRpcEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorRpcEndpoint.kt\nfleet/rpc/server/ktor/KtorRpcEndpointKt\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n+ 3 EngineConnectorConfig.kt\nio/ktor/server/engine/EngineConnectorConfigKt\n*L\n1#1,134:1\n18#2,2:135\n18#2,2:137\n52#3,2:139\n*S KotlinDebug\n*F\n+ 1 KtorRpcEndpoint.kt\nfleet/rpc/server/ktor/KtorRpcEndpointKt\n*L\n92#1:135,2\n101#1:137,2\n127#1:139,2\n*E\n"})
public final class KtorRpcEndpointKt {
    private static final int WARNING_THRESHOLD = 0x500000;
    @NotNull
    private static final RpcStats receiveStats = new RpcStats(null, null, null, 7, null);
    @NotNull
    private static final RpcStats sendStats = new RpcStats(null, null, null, 7, null);

    public static final void rpcEndpoint(@NotNull Routing $this$rpcEndpoint, @NotNull RequestDispatcher handler) {
        Intrinsics.checkNotNullParameter((Object)$this$rpcEndpoint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        RoutingKt.webSocket$default((Route)((Route)$this$rpcEndpoint), (String)"/ws", null, (Function2)((Function2)new Function2<DefaultWebSocketServerSession, Continuation<? super Unit>, Object>(handler, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ RequestDispatcher $handler;
            {
                this.$handler = $handler;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DefaultWebSocketServerSession $this$webSocket = (DefaultWebSocketServerSession)this.L$0;
                        String string = $this$webSocket.getCall().getParameters().get("clientId");
                        if (string == null) {
                            throw new IllegalStateException("Required parameter clientId is missing".toString());
                        }
                        String clientId = string;
                        String presentableName = $this$webSocket.getCall().getParameters().get("presentableName");
                        KtorRpcEndpoint.INSTANCE.getLog().info((Object)("routing /ws: " + clientId));
                        Pair pair = KtorRpcEndpointKt.access$toChannels($this$webSocket);
                        SendChannel send = (SendChannel)pair.component1();
                        ReceiveChannel receive = (ReceiveChannel)pair.component2();
                        this.label = 1;
                        Object object3 = this.$handler.handleConnection(UID.Companion.fromString(clientId), EndpointKind.Client, presentableName, send, receive, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(DefaultWebSocketServerSession p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        RoutingKt.webSocket$default((Route)((Route)$this$rpcEndpoint), (String)"/ws-service", null, (Function2)((Function2)new Function2<DefaultWebSocketServerSession, Continuation<? super Unit>, Object>(handler, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ RequestDispatcher $handler;
            {
                this.$handler = $handler;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DefaultWebSocketServerSession $this$webSocket = (DefaultWebSocketServerSession)this.L$0;
                        String string = $this$webSocket.getCall().getParameters().get("serviceId");
                        if (string == null) {
                            throw new IllegalStateException("Required parameter serviceId is missing".toString());
                        }
                        String serviceId = string;
                        KLogger this_$iv = KtorRpcEndpoint.INSTANCE.getLog();
                        boolean $i$f$info = false;
                        if (this_$iv.isInfoEnabled()) {
                            KLogger kLogger = this_$iv;
                            boolean bl = false;
                            kLogger.info((Object)("routing /ws-service: " + serviceId));
                        }
                        Pair pair = KtorRpcEndpointKt.access$toChannels($this$webSocket);
                        SendChannel send = (SendChannel)pair.component1();
                        ReceiveChannel receive = (ReceiveChannel)pair.component2();
                        this.label = 1;
                        Object object3 = RequestDispatcher.handleConnection$default((RequestDispatcher)this.$handler, (UID)UID.Companion.fromString(serviceId), (EndpointKind)EndpointKind.Provider, null, (SendChannel)send, (ReceiveChannel)receive, (Continuation)((Continuation)this), (int)4, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(DefaultWebSocketServerSession p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public static final RpcStats getReceiveStats() {
        return receiveStats;
    }

    @NotNull
    public static final RpcStats getSendStats() {
        return sendStats;
    }

    public static final void printStats(@NotNull Writer $this$printStats, @NotNull RpcStats stats, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)$this$printStats, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        $this$printStats.write(title + "\n  total duration: " + ((Number)stats.getDuration().get()).doubleValue() / 1.0E9 + "s\n  count:          " + stats.getCount().get() + "\n  avg duration:   " + (double)(((Number)stats.getDuration().get()).longValue() / ((Number)stats.getCount().get()).longValue()) / 1000000.0 + "ms\n  total size:     " + stats.getSizeInBytes().get() + "\n  avg size:       " + ((Number)stats.getSizeInBytes().get()).longValue() / ((Number)stats.getCount().get()).longValue() + "\n\n");
    }

    private static final Pair<SendChannel<TransportMessage>, ReceiveChannel<TransportMessage>> toChannels(DefaultWebSocketServerSession $this$toChannels) {
        DefaultWebSocketServerSession session = $this$toChannels;
        SendChannel send = MappedChannelsKt.map((SendChannel)session.getOutgoing(), KtorRpcEndpointKt::toChannels$lambda$1);
        ReceiveChannel receive = MappedChannelsKt.map((ReceiveChannel)session.getIncoming(), KtorRpcEndpointKt::toChannels$lambda$3);
        return TuplesKt.to((Object)send, (Object)receive);
    }

    @NotNull
    public static final ApplicationEngine cioEngine(@NotNull CoroutineContext parentContext, @NotNull String host, int port, @NotNull Function1<? super Application, Unit> main) {
        Intrinsics.checkNotNullParameter((Object)parentContext, (String)"parentContext");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter(main, (String)"main");
        ApplicationEngineEnvironment env = ApplicationEngineEnvironmentKt.applicationEngineEnvironment(arg_0 -> KtorRpcEndpointKt.cioEngine$lambda$6(parentContext, main, host, port, arg_0));
        return EmbeddedServerKt.embeddedServer$default((ApplicationEngineFactory)((ApplicationEngineFactory)CIO.INSTANCE), (ApplicationEngineEnvironment)env, null, (int)4, null);
    }

    private static final Frame.Text toChannels$lambda$1(TransportMessage transportMessage) {
        Intrinsics.checkNotNullParameter((Object)transportMessage, (String)"transportMessage");
        String str = transportMessage.serialize();
        if (str.length() > 0x500000) {
            KLogger this_$iv = KtorRpcEndpoint.INSTANCE.getLog();
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.warn((Object)("Outgoing message too large: " + StringsKt.take((String)str, (int)1024) + ".." + StringsKt.takeLast((String)str, (int)1024)));
            }
        }
        return new Frame.Text(str);
    }

    private static final TransportMessage toChannels$lambda$3(Frame frame) {
        String text;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        if (frame instanceof Frame.Text) {
            text = FrameCommonKt.readText((Frame.Text)((Frame.Text)frame));
            if (text.length() > 0x500000) {
                KLogger this_$iv = KtorRpcEndpoint.INSTANCE.getLog();
                boolean $i$f$warn = false;
                if (this_$iv.isWarnEnabled()) {
                    KLogger kLogger = this_$iv;
                    boolean bl = false;
                    kLogger.warn((Object)("Incoming message too large: " + StringsKt.take((String)text, (int)1024) + ".." + StringsKt.takeLast((String)text, (int)1024)));
                }
            }
        } else {
            throw new IllegalStateException("Binary web sockets are not supported".toString());
        }
        return TransportMessage.Companion.deserialize(text);
    }

    private static final Unit cioEngine$lambda$6$lambda$4(Function1 $main, Application $this$module) {
        Intrinsics.checkNotNullParameter((Object)$this$module, (String)"$this$module");
        $main.invoke((Object)$this$module);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit cioEngine$lambda$6(CoroutineContext $parentContext, Function1 $main, String $host, int $port, ApplicationEngineEnvironmentBuilder $this$applicationEngineEnvironment) {
        void $this$cioEngine_u24lambda_u246_u24lambda_u245;
        EngineConnectorBuilder engineConnectorBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$applicationEngineEnvironment, (String)"$this$applicationEngineEnvironment");
        $this$applicationEngineEnvironment.setParentCoroutineContext($parentContext);
        if (!FleetPropertiesKt.isFleetDevMode()) {
            $this$applicationEngineEnvironment.setWatchPaths(CollectionsKt.emptyList());
        }
        $this$applicationEngineEnvironment.module(arg_0 -> KtorRpcEndpointKt.cioEngine$lambda$6$lambda$4($main, arg_0));
        ApplicationEngineEnvironmentBuilder $this$connector$iv = $this$applicationEngineEnvironment;
        boolean $i$f$connector = false;
        EngineConnectorBuilder engineConnectorBuilder2 = engineConnectorBuilder = new EngineConnectorBuilder(null, 1, null);
        List list = $this$connector$iv.getConnectors();
        boolean bl = false;
        $this$cioEngine_u24lambda_u246_u24lambda_u245.setHost($host);
        $this$cioEngine_u24lambda_u246_u24lambda_u245.setPort($port);
        list.add(engineConnectorBuilder);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Pair access$toChannels(DefaultWebSocketServerSession $receiver) {
        return KtorRpcEndpointKt.toChannels($receiver);
    }
}

