/*
 * Decompiled with CFR 0.152.
 */
package fleet.git.frontend;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lfleet/git/frontend/GitRefNames;", "", "<init>", "()V", "CONTROL_CHARS", "", "ILLEGAL_CHARS", "Lkotlin/text/Regex;", "ILLEGAL", "DUPLICATED_SLASHES", "DUPLICATED_UNDERSCORES", "MAIN_BRANCH", "isMainBranch", "", "name", "cleanUpBranchName", "branchName", "deduplicateChars", "fleet.git.frontend"})
public final class GitRefNames {
    @NotNull
    public static final GitRefNames INSTANCE;
    @Nullable
    private static String CONTROL_CHARS;
    @NotNull
    private static final Regex ILLEGAL_CHARS;
    @NotNull
    private static final Regex ILLEGAL;
    @NotNull
    private static final Regex DUPLICATED_SLASHES;
    @NotNull
    private static final Regex DUPLICATED_UNDERSCORES;
    @NotNull
    private static final Regex MAIN_BRANCH;

    private GitRefNames() {
    }

    public final boolean isMainBranch(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return MAIN_BRANCH.matches((CharSequence)name);
    }

    @NotNull
    public final String cleanUpBranchName(@NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        CharSequence charSequence = branchName;
        Regex regex = ILLEGAL;
        String string = "_";
        return this.deduplicateChars(StringsKt.replace$default((String)regex.replace(charSequence, string), (String)"\"", (String)"", (boolean)false, (int)4, null));
    }

    private final String deduplicateChars(String branchName) {
        CharSequence charSequence = branchName;
        Regex regex = DUPLICATED_SLASHES;
        String string = "/";
        charSequence = regex.replace(charSequence, string);
        regex = DUPLICATED_UNDERSCORES;
        string = "_";
        return regex.replace(charSequence, string);
    }

    static {
        GitRefNames $this$CONTROL_CHARS_u24lambda_u240 = INSTANCE = new GitRefNames();
        boolean bl = false;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int c = 0; c < 32; ++c) {
            if (c < 0 || c > 65535) {
                throw new IllegalArgumentException("Invalid Char code: " + c);
            }
            sb.append((char)c);
        }
        sb.append('\u007f');
        sb.append("]");
        CONTROL_CHARS = sb.toString();
        ILLEGAL_CHARS = new Regex("(^\\.)|(^-)|(^/)|(\\.\\.)+|[ ~:^?*\\[\\\\]+|(@\\{)+|" + CONTROL_CHARS);
        ILLEGAL = new Regex("(([./]|\\.lock)$)|\\.(?=/)|(?<=/)\\.|" + ILLEGAL_CHARS.getPattern());
        DUPLICATED_SLASHES = new Regex("(/){2,}");
        DUPLICATED_UNDERSCORES = new Regex("(_){2,}");
        MAIN_BRANCH = new Regex("master|main|default|stable");
    }
}

