/*
 * Decompiled with CFR 0.152.
 */
package fleet.git.frontend;

import androidx.compose.runtime.Composable;
import com.intellij.openapi.util.text.Strings;
import com.jetbrains.rhizomedb.Entity;
import fleet.frontend.ui.gotoPanel.GotoProviderWithTextDescription;
import fleet.frontend.ui.gotoPanel.GotoProviderWithTextDescriptionKt;
import fleet.git.frontend.GitCommand;
import fleet.git.frontend.GitLogEntitiesKt;
import fleet.git.frontend.GitNewBranchStart;
import fleet.git.frontend.GitQueueKt;
import fleet.git.frontend.GitRefNames;
import fleet.git.frontend.RepositoryEntity;
import fleet.git.protocol.VcsBranch;
import fleet.kernel.SagaKt;
import fleet.kernel.plugins.PluginScope;
import fleet.util.UID;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import noria.NoriaContext;
import noria.impl.Runtime;
import noria.model.ActionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J%\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J \u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u0011H\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lfleet/git/frontend/GitNewBranchProvider;", "Lfleet/frontend/ui/gotoPanel/GotoProviderWithTextDescription;", "pluginScope", "Lfleet/kernel/plugins/PluginScope;", "repo", "Lfleet/git/frontend/RepositoryEntity;", "branchStart", "Lfleet/git/frontend/GitNewBranchStart;", "<init>", "(Lfleet/kernel/plugins/PluginScope;Lfleet/git/frontend/RepositoryEntity;Lfleet/git/frontend/GitNewBranchStart;)V", "getPluginScope", "()Lfleet/kernel/plugins/PluginScope;", "getRepo", "()Lfleet/git/frontend/RepositoryEntity;", "getBranchStart", "()Lfleet/git/frontend/GitNewBranchStart;", "descriptionText", "", "confirm", "Lkotlin/Result;", "actionContext", "Lnoria/model/ActionContext;", "query", "confirm-gIAlu-s", "(Lnoria/model/ActionContext;Ljava/lang/String;)Ljava/lang/Object;", "renderHint", "", "Lnoria/NoriaContext;", "description", "error", "fleet.git.frontend"})
final class GitNewBranchProvider
extends GotoProviderWithTextDescription {
    @NotNull
    private final PluginScope pluginScope;
    @NotNull
    private final RepositoryEntity repo;
    @NotNull
    private final GitNewBranchStart branchStart;

    public GitNewBranchProvider(@NotNull PluginScope pluginScope, @NotNull RepositoryEntity repo, @NotNull GitNewBranchStart branchStart) {
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)branchStart, (String)"branchStart");
        this.pluginScope = pluginScope;
        this.repo = repo;
        this.branchStart = branchStart;
    }

    @NotNull
    public final PluginScope getPluginScope() {
        return this.pluginScope;
    }

    @NotNull
    public final RepositoryEntity getRepo() {
        return this.repo;
    }

    @NotNull
    public final GitNewBranchStart getBranchStart() {
        return this.branchStart;
    }

    @NotNull
    public String descriptionText() {
        return "Branch will be created from '" + this.branchStart.getDescription() + "'";
    }

    @NotNull
    public Object confirm-gIAlu-s(@NotNull ActionContext actionContext, @NotNull String query) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        if (Strings.isEmptyOrSpaces((CharSequence)query)) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Branch name cannot be empty")));
        }
        String cleanName = GitRefNames.INSTANCE.cleanUpBranchName(query);
        VcsBranch existing = GitLogEntitiesKt.findLocalBranch(this.repo, cleanName);
        if (existing != null) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Branch '" + GitLogEntitiesKt.presentable(existing) + "' already exists")));
        } else {
            SagaKt.saga$default((CoroutineScope)((CoroutineScope)this.pluginScope), (Entity[])new Entity[0], null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, cleanName, null){
                int label;
                final /* synthetic */ GitNewBranchProvider this$0;
                final /* synthetic */ String $cleanName;
                {
                    this.this$0 = $receiver;
                    this.$cleanName = $cleanName;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = GitQueueKt.submit(this.this$0.getRepo(), new GitCommand.Checkout(UID.Companion.random(), this.$cleanName, this.this$0.getBranchStart().getRef()), (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)6, null);
            object = Result.constructor-impl((Object)cleanName);
        }
        return object;
    }

    @Composable
    public void renderHint(@NotNull NoriaContext $this$renderHint, @Nullable String description, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)$this$renderHint, (String)"<this>");
        Runtime.enterScope((NoriaContext)$this$renderHint, (int)1);
        GotoProviderWithTextDescriptionKt.GotoProviderWithTextHintDescriptionAndError((NoriaContext)$this$renderHint, (String)description, (String)error);
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$renderHint);
    }
}

