/*
 * Decompiled with CFR 0.152.
 */
package fleet.git.frontend;

import com.jetbrains.rhizomedb.Attributes;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import com.jetbrains.rhizomedb.EntityType;
import com.jetbrains.rhizomedb.Indexing;
import com.jetbrains.rhizomedb.Mixin;
import com.jetbrains.rhizomedb.RefFlags;
import fleet.api.FileAddress;
import fleet.git.frontend.GitStatusWithTimestamp;
import fleet.git.frontend.RepositoryEntity;
import fleet.git.protocol.GitFileStatus;
import fleet.util.UID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlinx.serialization.KSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 E2\u00020\u0001:\u0001EB\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010!\u001a\u00020\"*\u00020#2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J\u001a\u0010'\u001a\u00020\"*\u00020#2\u0006\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&J\u0012\u0010*\u001a\u00020\"*\u00020#2\u0006\u0010+\u001a\u00020,J\n\u0010-\u001a\u00020\"*\u00020#J\u0018\u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020\u001cH\u0002J\r\u0010=\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0017\u0010>\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0001J\u0013\u0010?\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010AH\u00d6\u0003J\t\u0010B\u001a\u00020\u0003H\u00d6\u0001J\t\u0010C\u001a\u00020DH\u00d6\u0001R\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e*\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013*\u0004\b\u0011\u0010\fR\u001d\u0010\u0014\u001a\u0004\u0018\u00010\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0013*\u0004\b\u0015\u0010\fR\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u001b\u0010.\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b0\u0010\u001e*\u0004\b/\u0010\fR\u001b\u00101\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b3\u0010\u001e*\u0004\b2\u0010\fR\u001b\u00104\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b6\u0010\u001e*\u0004\b5\u0010\fR\u001b\u00107\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b9\u0010\u001e*\u0004\b8\u0010\f\u00a8\u0006F"}, d2={"Lfleet/git/frontend/FileStatusEntity;", "Lcom/jetbrains/rhizomedb/Entity;", "eid", "", "Lcom/jetbrains/rhizomedb/EID;", "<init>", "(I)V", "getEid", "()I", "repo", "Lfleet/git/frontend/RepositoryEntity;", "getRepo$delegate", "(Lfleet/git/frontend/FileStatusEntity;)Ljava/lang/Object;", "getRepo", "()Lfleet/git/frontend/RepositoryEntity;", "address", "Lfleet/api/FileAddress;", "getAddress$delegate", "getAddress", "()Lfleet/api/FileAddress;", "oldAddress", "getOldAddress$delegate", "getOldAddress", "busy", "", "getBusy", "()Z", "staged", "Lfleet/git/frontend/GitStatusWithTimestamp;", "getStaged", "()Lfleet/git/frontend/GitStatusWithTimestamp;", "unstaged", "getUnstaged", "toggleStatusSpeculative", "", "Lcom/jetbrains/rhizomedb/ChangeScope;", "stage", "requestId", "Lfleet/util/UID;", "setSpeculativeStatus", "status", "Lfleet/git/protocol/GitFileStatus;", "persistSpeculativeState", "indexMTime", "", "clearSpeculativeState", "speculativeStaged", "getSpeculativeStaged$delegate", "getSpeculativeStaged", "speculativeUnstaged", "getSpeculativeUnstaged$delegate", "getSpeculativeUnstaged", "gitStaged", "getGitStaged$delegate", "getGitStaged", "gitUnstaged", "getGitUnstaged$delegate", "getGitUnstaged", "getStatus", "speculative", "fromGit", "component1", "copy", "equals", "other", "", "hashCode", "toString", "", "Companion", "fleet.git.frontend"})
public final class FileStatusEntity
implements Entity {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private final int eid;
    @NotNull
    private static final Attributes.Required<RepositoryEntity> RepoAttr;
    @NotNull
    private static final Attributes.Required<FileAddress> AddressAttr;
    @NotNull
    private static final Attributes.Optional<FileAddress> OldAddressAttr;
    @NotNull
    private static final Attributes.Optional<UID> PendingRequestAttr;
    @NotNull
    private static final Attributes.Required<GitStatusWithTimestamp> SpeculativeStagedAttr;
    @NotNull
    private static final Attributes.Required<GitStatusWithTimestamp> SpeculativeUnstagedAttr;
    @NotNull
    private static final Attributes.Required<GitStatusWithTimestamp> GitStagedAttr;
    @NotNull
    private static final Attributes.Required<GitStatusWithTimestamp> GitUnstagedAttr;

    public FileStatusEntity(int eid) {
        this.eid = eid;
    }

    public int getEid() {
        return this.eid;
    }

    @NotNull
    public final RepositoryEntity getRepo() {
        return (RepositoryEntity)RepoAttr.getValue((Entity)this, $$delegatedProperties[0]);
    }

    private static Object getRepo$delegate(FileStatusEntity fileStatusEntity) {
        return RepoAttr;
    }

    @NotNull
    public final FileAddress getAddress() {
        return (FileAddress)AddressAttr.getValue((Entity)this, $$delegatedProperties[1]);
    }

    private static Object getAddress$delegate(FileStatusEntity fileStatusEntity) {
        return AddressAttr;
    }

    @Nullable
    public final FileAddress getOldAddress() {
        return (FileAddress)OldAddressAttr.getValue((Entity)this, $$delegatedProperties[2]);
    }

    private static Object getOldAddress$delegate(FileStatusEntity fileStatusEntity) {
        return OldAddressAttr;
    }

    public final boolean getBusy() {
        return EntityAttributeKt.getOptional((Entity)this, PendingRequestAttr) != null;
    }

    @NotNull
    public final GitStatusWithTimestamp getStaged() {
        return this.getStatus(this.getSpeculativeStaged(), this.getGitStaged());
    }

    @NotNull
    public final GitStatusWithTimestamp getUnstaged() {
        return this.getStatus(this.getSpeculativeUnstaged(), this.getGitUnstaged());
    }

    public final void toggleStatusSpeculative(@NotNull ChangeScope $this$toggleStatusSpeculative, boolean stage2, @NotNull UID requestId) {
        Intrinsics.checkNotNullParameter((Object)$this$toggleStatusSpeculative, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        FileStatusEntity self = this;
        if (stage2 && this.getUnstaged().getStatus() != GitFileStatus.Unchanged) {
            $this$toggleStatusSpeculative.set((Entity)self, SpeculativeStagedAttr, (Object)new GitStatusWithTimestamp(this.getUnstaged().getStatus()));
            $this$toggleStatusSpeculative.set((Entity)self, SpeculativeUnstagedAttr, (Object)new GitStatusWithTimestamp(GitFileStatus.Unchanged));
        }
        if (!stage2 && this.getStaged().getStatus() != GitFileStatus.Unchanged) {
            $this$toggleStatusSpeculative.set((Entity)self, SpeculativeUnstagedAttr, (Object)new GitStatusWithTimestamp(this.getStaged().getStatus()));
            $this$toggleStatusSpeculative.set((Entity)self, SpeculativeStagedAttr, (Object)new GitStatusWithTimestamp(GitFileStatus.Unchanged));
        }
        $this$toggleStatusSpeculative.set((Entity)self, PendingRequestAttr, (Object)requestId);
    }

    public final void setSpeculativeStatus(@NotNull ChangeScope $this$setSpeculativeStatus, @NotNull GitFileStatus status, @NotNull UID requestId) {
        Intrinsics.checkNotNullParameter((Object)$this$setSpeculativeStatus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        FileStatusEntity self = this;
        $this$setSpeculativeStatus.set((Entity)self, PendingRequestAttr, (Object)requestId);
        $this$setSpeculativeStatus.set((Entity)self, SpeculativeStagedAttr, (Object)new GitStatusWithTimestamp(status));
        $this$setSpeculativeStatus.set((Entity)self, SpeculativeUnstagedAttr, (Object)new GitStatusWithTimestamp(status));
    }

    public final void persistSpeculativeState(@NotNull ChangeScope $this$persistSpeculativeState, long indexMTime) {
        Intrinsics.checkNotNullParameter((Object)$this$persistSpeculativeState, (String)"<this>");
        FileStatusEntity self = this;
        $this$persistSpeculativeState.set((Entity)self, PendingRequestAttr, null);
        $this$persistSpeculativeState.set((Entity)self, SpeculativeStagedAttr, (Object)GitStatusWithTimestamp.copy$default(this.getSpeculativeStaged(), null, indexMTime, 1, null));
        $this$persistSpeculativeState.set((Entity)self, SpeculativeUnstagedAttr, (Object)GitStatusWithTimestamp.copy$default(this.getSpeculativeUnstaged(), null, indexMTime, 1, null));
    }

    public final void clearSpeculativeState(@NotNull ChangeScope $this$clearSpeculativeState) {
        Intrinsics.checkNotNullParameter((Object)$this$clearSpeculativeState, (String)"<this>");
        FileStatusEntity self = this;
        $this$clearSpeculativeState.set((Entity)self, PendingRequestAttr, null);
        $this$clearSpeculativeState.set((Entity)self, SpeculativeStagedAttr, (Object)GitStatusWithTimestamp.copy$default(this.getGitStaged(), null, 0L, 3, null));
        $this$clearSpeculativeState.set((Entity)self, SpeculativeUnstagedAttr, (Object)GitStatusWithTimestamp.copy$default(this.getGitUnstaged(), null, 0L, 3, null));
    }

    private final GitStatusWithTimestamp getSpeculativeStaged() {
        return (GitStatusWithTimestamp)SpeculativeStagedAttr.getValue((Entity)this, $$delegatedProperties[3]);
    }

    private static Object getSpeculativeStaged$delegate(FileStatusEntity fileStatusEntity) {
        return SpeculativeStagedAttr;
    }

    private final GitStatusWithTimestamp getSpeculativeUnstaged() {
        return (GitStatusWithTimestamp)SpeculativeUnstagedAttr.getValue((Entity)this, $$delegatedProperties[4]);
    }

    private static Object getSpeculativeUnstaged$delegate(FileStatusEntity fileStatusEntity) {
        return SpeculativeUnstagedAttr;
    }

    private final GitStatusWithTimestamp getGitStaged() {
        return (GitStatusWithTimestamp)GitStagedAttr.getValue((Entity)this, $$delegatedProperties[5]);
    }

    private static Object getGitStaged$delegate(FileStatusEntity fileStatusEntity) {
        return GitStagedAttr;
    }

    private final GitStatusWithTimestamp getGitUnstaged() {
        return (GitStatusWithTimestamp)GitUnstagedAttr.getValue((Entity)this, $$delegatedProperties[6]);
    }

    private static Object getGitUnstaged$delegate(FileStatusEntity fileStatusEntity) {
        return GitUnstagedAttr;
    }

    private final GitStatusWithTimestamp getStatus(GitStatusWithTimestamp speculative, GitStatusWithTimestamp fromGit) {
        return speculative.getIndexMTime() > fromGit.getIndexMTime() ? speculative : fromGit;
    }

    public final int component1() {
        return this.eid;
    }

    @NotNull
    public final FileStatusEntity copy(int eid) {
        return new FileStatusEntity(eid);
    }

    public static /* synthetic */ FileStatusEntity copy$default(FileStatusEntity fileStatusEntity, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = fileStatusEntity.eid;
        }
        return fileStatusEntity.copy(n);
    }

    @NotNull
    public String toString() {
        return "FileStatusEntity(eid=" + this.eid + ")";
    }

    public int hashCode() {
        return Integer.hashCode(this.eid);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileStatusEntity)) {
            return false;
        }
        FileStatusEntity fileStatusEntity = (FileStatusEntity)other;
        return this.eid == fileStatusEntity.eid;
    }

    @NotNull
    public KClass<? extends Entity> getEntityClass() {
        return Entity.DefaultImpls.getEntityClass((Entity)this);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FileStatusEntity.class, "repo", "getRepo()Lfleet/git/frontend/RepositoryEntity;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FileStatusEntity.class, "address", "getAddress()Lfleet/api/FileAddress;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FileStatusEntity.class, "oldAddress", "getOldAddress()Lfleet/api/FileAddress;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FileStatusEntity.class, "speculativeStaged", "getSpeculativeStaged()Lfleet/git/frontend/GitStatusWithTimestamp;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FileStatusEntity.class, "speculativeUnstaged", "getSpeculativeUnstaged()Lfleet/git/frontend/GitStatusWithTimestamp;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FileStatusEntity.class, "gitStaged", "getGitStaged()Lfleet/git/frontend/GitStatusWithTimestamp;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FileStatusEntity.class, "gitUnstaged", "getGitUnstaged()Lfleet/git/frontend/GitStatusWithTimestamp;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        kPropertyArray = new RefFlags[]{RefFlags.CASCADE_DELETE_BY};
        RepoAttr = FileStatusEntity.Companion.requiredRef("repo", (RefFlags[])kPropertyArray);
        AddressAttr = Attributes.requiredValue$default((Attributes)((Attributes)Companion), (String)"address", (KSerializer)FileAddress.Companion.serializer(), (Indexing)Indexing.UNIQUE, null, (int)8, null);
        OldAddressAttr = Attributes.optionalValue$default((Attributes)((Attributes)Companion), (String)"oldAddress", (KSerializer)FileAddress.Companion.serializer(), null, null, (int)12, null);
        PendingRequestAttr = Attributes.optionalValue$default((Attributes)((Attributes)Companion), (String)"pendingRequest", (KSerializer)UID.Companion.serializer(), (Indexing)Indexing.INDEXED, null, (int)8, null);
        SpeculativeStagedAttr = Attributes.requiredTransient$default((Attributes)((Attributes)Companion), (String)"speculativeStaged", null, null, (int)6, null);
        SpeculativeUnstagedAttr = Attributes.requiredTransient$default((Attributes)((Attributes)Companion), (String)"speculativeUnstaged", null, null, (int)6, null);
        GitStagedAttr = Attributes.requiredTransient$default((Attributes)((Attributes)Companion), (String)"gitStaged", null, null, (int)6, null);
        GitUnstagedAttr = Attributes.requiredTransient$default((Attributes)((Attributes)Companion), (String)"gitUnstaged", null, null, (int)6, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006R\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0006R\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR!\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000fR\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u000fR\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R!\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0006R\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\nR!\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0006R\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\nR!\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0006R\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\nR!\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0006R\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\n\u00a8\u0006\u001e"}, d2={"Lfleet/git/frontend/FileStatusEntity$Companion;", "Lcom/jetbrains/rhizomedb/EntityType;", "Lfleet/git/frontend/FileStatusEntity;", "<init>", "()V", "RepoAttr", "Lcom/jetbrains/rhizomedb/Attributes$Required;", "Lfleet/git/frontend/RepositoryEntity;", "Lcom/jetbrains/rhizomedb/Attributes;", "getRepoAttr", "()Lcom/jetbrains/rhizomedb/Attributes$Required;", "AddressAttr", "Lfleet/api/FileAddress;", "getAddressAttr", "OldAddressAttr", "Lcom/jetbrains/rhizomedb/Attributes$Optional;", "getOldAddressAttr", "()Lcom/jetbrains/rhizomedb/Attributes$Optional;", "PendingRequestAttr", "Lfleet/util/UID;", "getPendingRequestAttr", "SpeculativeStagedAttr", "Lfleet/git/frontend/GitStatusWithTimestamp;", "getSpeculativeStagedAttr", "SpeculativeUnstagedAttr", "getSpeculativeUnstagedAttr", "GitStagedAttr", "getGitStagedAttr", "GitUnstagedAttr", "getGitUnstagedAttr", "fleet.git.frontend"})
    public static final class Companion
    extends EntityType<FileStatusEntity> {
        private Companion() {
            super(Reflection.getOrCreateKotlinClass(FileStatusEntity.class), (Function1)1.INSTANCE, new Mixin[0]);
        }

        @NotNull
        public final Attributes.Required<RepositoryEntity> getRepoAttr() {
            return RepoAttr;
        }

        @NotNull
        public final Attributes.Required<FileAddress> getAddressAttr() {
            return AddressAttr;
        }

        @NotNull
        public final Attributes.Optional<FileAddress> getOldAddressAttr() {
            return OldAddressAttr;
        }

        @NotNull
        public final Attributes.Optional<UID> getPendingRequestAttr() {
            return PendingRequestAttr;
        }

        @NotNull
        public final Attributes.Required<GitStatusWithTimestamp> getSpeculativeStagedAttr() {
            return SpeculativeStagedAttr;
        }

        @NotNull
        public final Attributes.Required<GitStatusWithTimestamp> getSpeculativeUnstagedAttr() {
            return SpeculativeUnstagedAttr;
        }

        @NotNull
        public final Attributes.Required<GitStatusWithTimestamp> getGitStagedAttr() {
            return GitStagedAttr;
        }

        @NotNull
        public final Attributes.Required<GitStatusWithTimestamp> getGitUnstagedAttr() {
            return GitUnstagedAttr;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

