/*
 * Decompiled with CFR 0.152.
 */
package fleet.git.frontend;

import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.frontend.icons.IconKeys;
import fleet.git.frontend.GitBranchEntity;
import fleet.git.frontend.GitBranchesPopupItem;
import fleet.git.frontend.GitBranchesPopupKt;
import fleet.git.frontend.GitCommitEntity;
import fleet.git.frontend.GitLogEntitiesKt;
import fleet.git.frontend.GitRefEntity;
import fleet.git.frontend.HeaderData;
import fleet.git.frontend.InProgressOperation;
import fleet.git.frontend.RepositoryEntity;
import fleet.git.frontend.RepositoryEntityKt;
import fleet.git.protocol.VcsBranch;
import fleet.kernel.plugins.PluginScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import noria.model.ThemeKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001:\u0002\r\u000eJ\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH&J\b\u0010\u000b\u001a\u00020\fH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lfleet/git/frontend/DiscoveryResult;", "", "address", "Lfleet/api/FileAddress;", "getAddress", "()Lfleet/api/FileAddress;", "items", "", "Lfleet/git/frontend/GitBranchesPopupItem;", "withHeader", "", "toHeaderData", "Lfleet/git/frontend/HeaderData;", "DiscoveryFailed", "DiscoveredRepository", "Lfleet/git/frontend/DiscoveryResult$DiscoveredRepository;", "Lfleet/git/frontend/DiscoveryResult$DiscoveryFailed;", "fleet.git.frontend"})
public interface DiscoveryResult {
    @NotNull
    public FileAddress getAddress();

    @NotNull
    public List<GitBranchesPopupItem> items(boolean var1);

    @NotNull
    public HeaderData toHeaderData();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lfleet/git/frontend/DiscoveryResult$DiscoveredRepository;", "Lfleet/git/frontend/DiscoveryResult;", "pluginScope", "Lfleet/kernel/plugins/PluginScope;", "repository", "Lfleet/git/frontend/RepositoryEntity;", "<init>", "(Lfleet/kernel/plugins/PluginScope;Lfleet/git/frontend/RepositoryEntity;)V", "address", "Lfleet/api/FileAddress;", "getAddress", "()Lfleet/api/FileAddress;", "items", "", "Lfleet/git/frontend/GitBranchesPopupItem;", "withHeader", "", "toHeaderData", "Lfleet/git/frontend/HeaderData;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "fleet.git.frontend"})
    @SourceDebugExtension(value={"SMAP\nGitBranchesPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchesPopup.kt\nfleet/git/frontend/DiscoveryResult$DiscoveredRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,561:1\n774#2:562\n865#2,2:563\n1557#2:565\n1628#2,3:566\n1557#2:569\n1628#2,3:570\n*S KotlinDebug\n*F\n+ 1 GitBranchesPopup.kt\nfleet/git/frontend/DiscoveryResult$DiscoveredRepository\n*L\n356#1:562\n356#1:563,2\n364#1:565\n364#1:566,3\n368#1:569\n368#1:570,3\n*E\n"})
    public static final class DiscoveredRepository
    implements DiscoveryResult {
        @NotNull
        private final PluginScope pluginScope;
        @NotNull
        private final RepositoryEntity repository;
        @NotNull
        private final FileAddress address;

        public DiscoveredRepository(@NotNull PluginScope pluginScope, @NotNull RepositoryEntity repository) {
            Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            this.pluginScope = pluginScope;
            this.repository = repository;
            this.address = RepositoryEntityKt.getWorktree(this.repository);
        }

        @Override
        @NotNull
        public FileAddress getAddress() {
            return this.address;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<GitBranchesPopupItem> items(boolean withHeader) {
            Object headerItem;
            List list;
            List $this$items_u24lambda_u244 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            if (withHeader) {
                GitBranchesPopupItem.RepositoryBranchesHeader repositoryBranchesHeader;
                HeaderData headerData = this.toHeaderData();
                if (this.repository.getInProgressOperation() != null) {
                    repositoryBranchesHeader = new GitBranchesPopupItem.RepositoryBranchesHeader(FileAddressKt.getName((FileAddress)RepositoryEntityKt.getWorktree(this.repository)) + ": " + headerData.getTitle(), null, null, 6, null);
                } else if (this.repository.getHead() instanceof GitCommitEntity) {
                    repositoryBranchesHeader = new GitBranchesPopupItem.RepositoryBranchesHeader(FileAddressKt.getName((FileAddress)RepositoryEntityKt.getWorktree(this.repository)), headerData.getTooltip(), headerData.getIcon());
                } else if (this.repository.getHead() instanceof GitBranchEntity) {
                    repositoryBranchesHeader = new GitBranchesPopupItem.RepositoryBranchesHeader(FileAddressKt.getName((FileAddress)RepositoryEntityKt.getWorktree(this.repository)), null, null, 6, null);
                } else {
                    throw new IllegalStateException("unreachable".toString());
                }
                headerItem = repositoryBranchesHeader;
                $this$items_u24lambda_u244.add(headerItem);
            }
            if (this.repository.getInProgressOperation() != null) {
                $this$items_u24lambda_u244.add(new GitBranchesPopupItem.ResolveConflictsAction(this.repository));
            } else {
                List localBranches;
                List list2;
                VcsBranch $this$filterTo$iv$iv;
                $this$items_u24lambda_u244.add(new GitBranchesPopupItem.CreateNewBranchAction(this.repository));
                $this$items_u24lambda_u244.add(new GitBranchesPopupItem.HeadBranchItem(this.repository));
                List $this$items_u24lambda_u244_u24lambda_u241 = $this$items_u24lambda_u244;
                boolean bl22 = false;
                List all = GitLogEntitiesKt.localBranches(this.repository);
                GitRefEntity head = this.repository.getHead();
                if (head instanceof GitBranchEntity) {
                    Iterable $this$filter$iv = all;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        VcsBranch it = (VcsBranch)element$iv$iv;
                        boolean bl3 = false;
                        if (!(!Intrinsics.areEqual((Object)it.getRefname(), (Object)((GitBranchEntity)head).getRefname()))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list2 = (List)destination$iv$iv;
                } else {
                    list2 = all;
                }
                if ((localBranches = list2).size() > 4) {
                    void $this$mapTo$iv$iv;
                    headerItem = CollectionsKt.take((Iterable)localBranches, (int)3);
                    List list3 = $this$items_u24lambda_u244;
                    boolean $i$f$map = false;
                    Iterable bl22 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        $this$filterTo$iv$iv = (VcsBranch)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add(GitBranchesPopupKt.access$toBranchesPopupLocalItem(it, this.repository, true));
                    }
                    list3.addAll((List)destination$iv$iv);
                    v2 = $this$items_u24lambda_u244.add(new GitBranchesPopupItem.MoreLocalBranchesSubmenu(this.repository));
                } else {
                    $this$map$iv = localBranches;
                    List list4 = $this$items_u24lambda_u244;
                    boolean $i$f$map = false;
                    Iterable $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (VcsBranch)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl5 = false;
                        collection.add(GitBranchesPopupKt.access$toBranchesPopupLocalItem(it, this.repository, true));
                    }
                    v2 = list4.addAll((List)destination$iv$iv);
                }
                if (!((Collection)this.repository.getRemotes()).isEmpty()) {
                    $this$items_u24lambda_u244.add(new GitBranchesPopupItem.RemoteBranchesSubmenu(this.repository));
                }
            }
            return CollectionsKt.build((List)list);
        }

        @Override
        @NotNull
        public HeaderData toHeaderData() {
            HeaderData headerData;
            if (this.repository.getInProgressOperation() != null) {
                InProgressOperation inProgressOperation = this.repository.getInProgressOperation();
                Intrinsics.checkNotNull((Object)inProgressOperation);
                headerData = GitBranchesPopupKt.access$toHeaderData(inProgressOperation);
            } else {
                GitRefEntity head = this.repository.getHead();
                if (head instanceof GitCommitEntity) {
                    headerData = new HeaderData(((GitCommitEntity)head).presentable(), "HEAD detached at " + ((GitCommitEntity)head).getId().getOid(), (ThemeKey<String>)IconKeys.INSTANCE.getWarning());
                } else if (head instanceof GitBranchEntity) {
                    String name = ((GitBranchEntity)head).presentable();
                    headerData = new HeaderData(name, "Current Branch: " + name, (ThemeKey<String>)IconKeys.Vcs.INSTANCE.getVcs());
                } else {
                    throw new IllegalStateException("unknown HEAD type".toString());
                }
            }
            return headerData;
        }

        private final PluginScope component1() {
            return this.pluginScope;
        }

        private final RepositoryEntity component2() {
            return this.repository;
        }

        @NotNull
        public final DiscoveredRepository copy(@NotNull PluginScope pluginScope, @NotNull RepositoryEntity repository) {
            Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            return new DiscoveredRepository(pluginScope, repository);
        }

        public static /* synthetic */ DiscoveredRepository copy$default(DiscoveredRepository discoveredRepository, PluginScope pluginScope, RepositoryEntity repositoryEntity, int n, Object object) {
            if ((n & 1) != 0) {
                pluginScope = discoveredRepository.pluginScope;
            }
            if ((n & 2) != 0) {
                repositoryEntity = discoveredRepository.repository;
            }
            return discoveredRepository.copy(pluginScope, repositoryEntity);
        }

        @NotNull
        public String toString() {
            return "DiscoveredRepository(pluginScope=" + this.pluginScope + ", repository=" + this.repository + ")";
        }

        public int hashCode() {
            int result2 = this.pluginScope.hashCode();
            result2 = result2 * 31 + this.repository.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DiscoveredRepository)) {
                return false;
            }
            DiscoveredRepository discoveredRepository = (DiscoveredRepository)other;
            if (!Intrinsics.areEqual((Object)this.pluginScope, (Object)discoveredRepository.pluginScope)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.repository, (Object)discoveredRepository.repository);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lfleet/git/frontend/DiscoveryResult$DiscoveryFailed;", "Lfleet/git/frontend/DiscoveryResult;", "address", "Lfleet/api/FileAddress;", "error", "", "<init>", "(Lfleet/api/FileAddress;Ljava/lang/String;)V", "getAddress", "()Lfleet/api/FileAddress;", "getError", "()Ljava/lang/String;", "items", "", "Lfleet/git/frontend/GitBranchesPopupItem;", "withHeader", "", "toHeaderData", "Lfleet/git/frontend/HeaderData;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "fleet.git.frontend"})
    public static final class DiscoveryFailed
    implements DiscoveryResult {
        @NotNull
        private final FileAddress address;
        @Nullable
        private final String error;

        public DiscoveryFailed(@NotNull FileAddress address, @Nullable String error) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            this.address = address;
            this.error = error;
        }

        @Override
        @NotNull
        public FileAddress getAddress() {
            return this.address;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        @Override
        @NotNull
        public List<GitBranchesPopupItem> items(boolean withHeader) {
            List list;
            if (withHeader) {
                HeaderData data2 = this.toHeaderData();
                list = CollectionsKt.listOf((Object)new GitBranchesPopupItem.RepositoryBranchesHeader(data2.getTitle(), data2.getTooltip(), data2.getIcon()));
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @Override
        @NotNull
        public HeaderData toHeaderData() {
            String string = this.error;
            if (string == null) {
                string = "Unknown error";
            }
            String tooltip = string;
            return new HeaderData("Failed to detect git", tooltip, (ThemeKey<String>)IconKeys.INSTANCE.getError());
        }

        @NotNull
        public final FileAddress component1() {
            return this.address;
        }

        @Nullable
        public final String component2() {
            return this.error;
        }

        @NotNull
        public final DiscoveryFailed copy(@NotNull FileAddress address, @Nullable String error) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            return new DiscoveryFailed(address, error);
        }

        public static /* synthetic */ DiscoveryFailed copy$default(DiscoveryFailed discoveryFailed, FileAddress fileAddress, String string, int n, Object object) {
            if ((n & 1) != 0) {
                fileAddress = discoveryFailed.address;
            }
            if ((n & 2) != 0) {
                string = discoveryFailed.error;
            }
            return discoveryFailed.copy(fileAddress, string);
        }

        @NotNull
        public String toString() {
            return "DiscoveryFailed(address=" + this.address + ", error=" + this.error + ")";
        }

        public int hashCode() {
            int result2 = this.address.hashCode();
            result2 = result2 * 31 + (this.error == null ? 0 : this.error.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DiscoveryFailed)) {
                return false;
            }
            DiscoveryFailed discoveryFailed = (DiscoveryFailed)other;
            if (!Intrinsics.areEqual((Object)this.address, (Object)discoveryFailed.address)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.error, (Object)discoveryFailed.error);
        }
    }
}

