/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.python.parsing.console;

import fleet.com.intellij.lexer.Lexer;
import fleet.com.intellij.lexer.MergeFunction;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.jetbrains.python.PyTokenTypes;
import fleet.com.jetbrains.python.lexer.PythonIndentingLexer;
import fleet.com.jetbrains.python.lexer.PythonIndentingProcessor;
import fleet.com.jetbrains.python.lexer.PythonLexerKind;
import fleet.com.jetbrains.python.parsing.console.PyConsoleTokenTypes;
import fleet.com.jetbrains.python.psi.PyElementType;
import java.util.Map;

public class PythonConsoleLexer
extends PythonIndentingLexer {
    private static final Map<String, PyElementType> SPECIAL_IPYTHON_SYMBOLS = Map.of("?", PyConsoleTokenTypes.QUESTION_MARK, "!", PyConsoleTokenTypes.PLING, "$", PyConsoleTokenTypes.DOLLAR);

    public PythonConsoleLexer() {
        super(PythonLexerKind.CONSOLE);
    }

    @Override
    public IElementType getTokenType() {
        IElementType type = super.getTokenType();
        if (type == PyTokenTypes.BAD_CHARACTER && PythonConsoleLexer.isSpecialSymbols(this.getTokenText())) {
            type = PythonConsoleLexer.getElementType(this.getTokenText());
        }
        return type;
    }

    public MergeFunction getMergeFunction() {
        MergeFunction origMergeFunction = super.getMergeFunction();
        return (type, originalLexer) -> {
            if (type == PyTokenTypes.BAD_CHARACTER && PythonConsoleLexer.getElementType(this.getBaseTokenText()) == PyConsoleTokenTypes.PLING) {
                PythonConsoleLexer.collectFullLine(originalLexer);
                return PyConsoleTokenTypes.SHELL_COMMAND;
            }
            if (type == PyTokenTypes.PERC && this.additionMagicLineCheck(originalLexer)) {
                PythonConsoleLexer.collectFullLine(originalLexer);
                return PyConsoleTokenTypes.MAGIC_COMMAND_LINE;
            }
            return origMergeFunction.merge(type, originalLexer);
        };
    }

    private boolean additionMagicLineCheck(Lexer originalLexer) {
        if (this.getBaseTokenStart() == 0 && originalLexer.getBufferEnd() >= 2 && !StringUtil.isWhiteSpace((char)originalLexer.getBufferSequence().charAt(1))) {
            return true;
        }
        int lastIndex = this.myTokenQueue.size() - 1;
        return this.getBaseTokenStart() >= 1 && originalLexer.getBufferEnd() > this.getBaseTokenStart() + 1 && originalLexer.getBufferSequence().charAt(this.getBaseTokenStart() - 1) == '\n' && !StringUtil.isWhiteSpace((char)originalLexer.getBufferSequence().charAt(this.getBaseTokenStart() + 1)) && (lastIndex >= 0 && (((PythonIndentingProcessor.PendingToken)this.myTokenQueue.get(lastIndex)).getType() == PyTokenTypes.STATEMENT_BREAK || ((PythonIndentingProcessor.PendingToken)this.myTokenQueue.get(lastIndex)).getType() == PyTokenTypes.END_OF_LINE_COMMENT) || StringUtil.isEmptyOrSpaces((CharSequence)originalLexer.getBufferSequence().subSequence(0, this.getBaseTokenStart())));
    }

    private static void collectFullLine(Lexer originalLexer) {
        while (originalLexer.getTokenType() != PyTokenTypes.LINE_BREAK && originalLexer.getTokenType() != PyTokenTypes.STATEMENT_BREAK && originalLexer.getTokenType() != null) {
            originalLexer.advance();
        }
    }

    public static PyElementType getElementType(String token) {
        return SPECIAL_IPYTHON_SYMBOLS.get(token);
    }

    public static boolean isSpecialSymbols(String token) {
        return SPECIAL_IPYTHON_SYMBOLS.containsKey(token);
    }
}

