/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.python.parsing.console;

import fleet.com.intellij.lang.SyntaxTreeBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.jetbrains.python.PyElementTypes;
import fleet.com.jetbrains.python.PyParsingBundle;
import fleet.com.jetbrains.python.PyTokenTypes;
import fleet.com.jetbrains.python.parsing.ExpressionParsing;
import fleet.com.jetbrains.python.parsing.ParsingContext;
import fleet.com.jetbrains.python.parsing.StatementParsing;
import fleet.com.jetbrains.python.parsing.console.PyConsoleTokenTypes;
import fleet.com.jetbrains.python.parsing.console.PythonConsoleData;
import fleet.com.jetbrains.python.psi.LanguageLevel;

public class PyConsoleParsingContext
extends ParsingContext {
    private final StatementParsing stmtParser;
    private final ExpressionParsing expressionParser;

    public PyConsoleParsingContext(SyntaxTreeBuilder builder, LanguageLevel languageLevel, PythonConsoleData pythonConsoleData, boolean startsWithIPythonSymbol) {
        super(builder, languageLevel);
        this.stmtParser = new ConsoleStatementParsing(this, startsWithIPythonSymbol, pythonConsoleData);
        this.expressionParser = pythonConsoleData.isIPythonEnabled() ? new ConsoleExpressionParsing(this) : new ExpressionParsing(this);
    }

    @Override
    public StatementParsing getStatementParser() {
        return this.stmtParser;
    }

    @Override
    public ExpressionParsing getExpressionParser() {
        return this.expressionParser;
    }

    public static class ConsoleStatementParsing
    extends StatementParsing {
        private final boolean myStartsWithIPythonSymbol;
        private final PythonConsoleData myPythonConsoleData;

        protected ConsoleStatementParsing(ParsingContext context, boolean startsWithIPythonSymbol, PythonConsoleData pythonConsoleData) {
            super(context);
            this.myStartsWithIPythonSymbol = startsWithIPythonSymbol;
            this.myPythonConsoleData = pythonConsoleData;
        }

        @Override
        public void parseStatement() {
            if (this.parseIPythonHelp()) {
                return;
            }
            if (this.shouldParseIPythonCommand()) {
                this.parseIPythonCommand();
            } else {
                if (this.myPythonConsoleData.isIPythonEnabled() && this.myPythonConsoleData.isIPythonAutomagic() && this.myPythonConsoleData.isMagicCommand(this.myBuilder.getTokenText())) {
                    this.parseIPythonCommand();
                }
                if (this.myPythonConsoleData.getIndentSize() > 0 && this.myBuilder.getTokenType() == PyTokenTypes.INDENT) {
                    this.myBuilder.advanceLexer();
                }
                super.parseStatement();
            }
        }

        private boolean parseIPythonHelp() {
            return this.parseIPythonGlobalHelp() || this.parseIPythonSuffixHelp();
        }

        private boolean parseIPythonGlobalHelp() {
            SyntaxTreeBuilder.Marker ipythonHelp = this.myBuilder.mark();
            if (this.myBuilder.getTokenType() == PyConsoleTokenTypes.QUESTION_MARK) {
                this.myBuilder.advanceLexer();
                if (this.myBuilder.getTokenType() == PyTokenTypes.STATEMENT_BREAK || this.myBuilder.eof()) {
                    this.myBuilder.advanceLexer();
                    ipythonHelp.done((IElementType)PyElementTypes.EMPTY_EXPRESSION);
                    return true;
                }
            }
            ipythonHelp.rollbackTo();
            return false;
        }

        private boolean parseIPythonSuffixHelp() {
            SyntaxTreeBuilder.Marker ipythonHelp = this.myBuilder.mark();
            while (this.myBuilder.getTokenType() != PyTokenTypes.STATEMENT_BREAK && this.myBuilder.getTokenType() != PyTokenTypes.LINE_BREAK && !this.myBuilder.eof()) {
                this.myBuilder.advanceLexer();
            }
            if (this.myBuilder.rawLookup(-1) != PyConsoleTokenTypes.QUESTION_MARK) {
                ipythonHelp.rollbackTo();
                return false;
            }
            int lookupIndex = -2;
            if (this.myBuilder.rawLookup(lookupIndex) == PyConsoleTokenTypes.QUESTION_MARK) {
                --lookupIndex;
            }
            if (this.myBuilder.rawLookup(lookupIndex) == PyTokenTypes.MULT) {
                ipythonHelp.rollbackTo();
                this.parseIPythonCommand();
                return true;
            }
            if (this.myBuilder.rawLookup(lookupIndex) != PyTokenTypes.IDENTIFIER) {
                this.myBuilder.error(PyParsingBundle.message("PARSE.console.help.request.warn", new Object[0]));
            }
            ipythonHelp.done((IElementType)PyElementTypes.EMPTY_EXPRESSION);
            this.myBuilder.advanceLexer();
            return true;
        }

        protected boolean shouldParseIPythonCommand() {
            return this.myStartsWithIPythonSymbol;
        }

        protected boolean continueParseIPythonCommand() {
            return !this.myBuilder.eof();
        }

        private void parseIPythonCommand() {
            SyntaxTreeBuilder.Marker ipythonCommand = this.myBuilder.mark();
            while (this.continueParseIPythonCommand()) {
                this.myBuilder.advanceLexer();
            }
            ipythonCommand.done((IElementType)PyElementTypes.EMPTY_EXPRESSION);
        }
    }

    public static class ConsoleExpressionParsing
    extends ExpressionParsing {
        public ConsoleExpressionParsing(ParsingContext context) {
            super(context);
        }

        @Override
        public boolean parseExpressionOptional() {
            if (this.myBuilder.getTokenType() == PyTokenTypes.PERC || this.myBuilder.getTokenType() == PyConsoleTokenTypes.PLING || this.myBuilder.getTokenType() == PyConsoleTokenTypes.QUESTION_MARK) {
                SyntaxTreeBuilder.Marker expr = this.myBuilder.mark();
                SyntaxTreeBuilder.Marker command = this.myBuilder.mark();
                this.myBuilder.advanceLexer();
                if (this.myBuilder.getTokenType() == PyConsoleTokenTypes.PLING) {
                    this.myBuilder.advanceLexer();
                }
                if (this.myBuilder.getTokenType() == PyTokenTypes.IDENTIFIER) {
                    this.myBuilder.advanceLexer();
                    command.done(this.getReferenceType());
                } else {
                    expr.drop();
                    command.drop();
                    this.myBuilder.error(PyParsingBundle.message("PARSE.expected.identifier", new Object[0]));
                    return false;
                }
                while (this.myBuilder.getTokenType() != null) {
                    this.myBuilder.advanceLexer();
                }
                expr.done((IElementType)PyElementTypes.EMPTY_EXPRESSION);
                return true;
            }
            return super.parseExpressionOptional();
        }

        @Override
        public boolean parseYieldOrTupleExpression(boolean isTargetExpression) {
            if (this.parseIPythonCaptureExpression()) {
                return true;
            }
            return super.parseYieldOrTupleExpression(isTargetExpression);
        }

        private boolean parseIPythonCaptureExpression() {
            if (this.myBuilder.getTokenType() == PyConsoleTokenTypes.SHELL_COMMAND || this.myBuilder.getTokenType() == PyConsoleTokenTypes.MAGIC_COMMAND_LINE) {
                this.captureIPythonExpression();
                return true;
            }
            if (this.myBuilder.getTokenType() == PyTokenTypes.PERC) {
                if (this.myBuilder.lookAhead(1) == PyTokenTypes.PERC) {
                    this.myBuilder.error(PyParsingBundle.message("PARSE.console.multiline.magic.warn", new Object[0]));
                }
                this.captureIPythonExpression();
                return true;
            }
            return false;
        }

        private void captureIPythonExpression() {
            SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
            while (this.myBuilder.getTokenType() != PyTokenTypes.STATEMENT_BREAK) {
                this.myBuilder.advanceLexer();
            }
            mark.done((IElementType)PyElementTypes.EMPTY_EXPRESSION);
        }
    }
}

