/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.python.parsing.console;

import fleet.com.intellij.lang.SyntaxTreeBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.python.PyTokenTypes;
import fleet.com.jetbrains.python.parsing.ParsingContext;
import fleet.com.jetbrains.python.parsing.PyParser;
import fleet.com.jetbrains.python.parsing.console.PyConsoleParsingContext;
import fleet.com.jetbrains.python.parsing.console.PyConsoleTokenTypes;
import fleet.com.jetbrains.python.parsing.console.PythonConsoleData;
import fleet.com.jetbrains.python.psi.LanguageLevel;

public class PyConsoleParser
extends PyParser {
    private static final TokenSet IPYTHON_START_SYMBOLS = TokenSet.create((IElementType[])new IElementType[]{PyConsoleTokenTypes.PLING, PyConsoleTokenTypes.QUESTION_MARK, PyConsoleTokenTypes.SHELL_COMMAND, PyConsoleTokenTypes.MAGIC_COMMAND_LINE, PyTokenTypes.COMMA, PyTokenTypes.DIV, PyTokenTypes.PERC, PyTokenTypes.SEMICOLON});
    private final PythonConsoleData myPythonConsoleData;

    public PyConsoleParser(PythonConsoleData pythonConsoleData, LanguageLevel languageLevel) {
        this.myPythonConsoleData = pythonConsoleData;
        this.myLanguageLevel = languageLevel;
    }

    @Override
    protected ParsingContext createParsingContext(SyntaxTreeBuilder builder, LanguageLevel languageLevel) {
        boolean iPythonStartSymbol = this.myPythonConsoleData.isIPythonEnabled() && PyConsoleParser.isIPythonSpecialSymbol(builder.getTokenType());
        return new PyConsoleParsingContext(builder, languageLevel, this.myPythonConsoleData, iPythonStartSymbol);
    }

    public static boolean isIPythonSpecialSymbol(IElementType tokenType) {
        return IPYTHON_START_SYMBOLS.contains(tokenType);
    }
}

