/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.python.lexer;

import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.jetbrains.python.PyTokenTypes;
import fleet.com.jetbrains.python.lexer.PythonLexer;
import fleet.com.jetbrains.python.lexer.PythonLexerKind;
import fleet.com.jetbrains.python.psi.FutureFeature;
import fleet.com.jetbrains.python.psi.LanguageLevel;
import fleet.com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import fleet.com.jetbrains.python.psi.PyStringLiteralUtil;
import org.jetbrains.annotations.NotNull;

public class PythonHighlightingLexer
extends PythonLexer {
    private final LanguageLevel myLanguageLevel;
    private state myState = state.init;
    private boolean hasUnicodeImport;
    private int myImportOffset = -1;
    private boolean hasPrintFunctionImport;

    public PythonHighlightingLexer(LanguageLevel languageLevel) {
        this(languageLevel, PythonLexerKind.REGULAR);
    }

    public PythonHighlightingLexer(LanguageLevel languageLevel, @NotNull PythonLexerKind kind) {
        super(kind);
        this.myLanguageLevel = languageLevel;
        this.hasUnicodeImport = false;
        this.hasPrintFunctionImport = false;
    }

    @NotNull
    public static IElementType convertStringType(@NotNull IElementType tokenType, @NotNull String tokenText, @NotNull LanguageLevel languageLevel, boolean unicodeImport) {
        String prefix = PyStringLiteralCoreUtil.getPrefix(tokenText);
        if (tokenType == PyTokenTypes.SINGLE_QUOTED_STRING && (languageLevel.isPy3K() ? !PyStringLiteralUtil.isBytesPrefix(prefix) : unicodeImport && !PyStringLiteralUtil.isBytesPrefix(prefix) || PyStringLiteralUtil.isUnicodePrefix(prefix))) {
            return PyTokenTypes.SINGLE_QUOTED_UNICODE;
        }
        if (tokenType == PyTokenTypes.TRIPLE_QUOTED_STRING && (languageLevel.isPy3K() ? !PyStringLiteralUtil.isBytesPrefix(prefix) : unicodeImport && !PyStringLiteralUtil.isBytesPrefix(prefix) || PyStringLiteralUtil.isUnicodePrefix(prefix))) {
            return PyTokenTypes.TRIPLE_QUOTED_UNICODE;
        }
        return tokenType;
    }

    public IElementType getTokenType() {
        IElementType tokenType = super.getTokenType();
        if (PyTokenTypes.STRING_NODES.contains(tokenType)) {
            return PythonHighlightingLexer.convertStringType(tokenType, this.getTokenText(), this.myLanguageLevel, this.hasUnicodeImport);
        }
        if (tokenType == PyTokenTypes.IDENTIFIER) {
            String tokenText = this.getTokenText();
            if (tokenText.equals("with")) {
                return PyTokenTypes.WITH_KEYWORD;
            }
            if (tokenText.equals("as")) {
                return PyTokenTypes.AS_KEYWORD;
            }
            if (this.myLanguageLevel.hasPrintStatement() && !this.hasPrintFunctionImport && tokenText.equals("print")) {
                return PyTokenTypes.PRINT_KEYWORD;
            }
            if (this.myLanguageLevel.isPy3K()) {
                if (tokenText.equals("None")) {
                    return PyTokenTypes.NONE_KEYWORD;
                }
                if (tokenText.equals("True")) {
                    return PyTokenTypes.TRUE_KEYWORD;
                }
                if (tokenText.equals("False")) {
                    return PyTokenTypes.FALSE_KEYWORD;
                }
                if (tokenText.equals("nonlocal")) {
                    return PyTokenTypes.NONLOCAL_KEYWORD;
                }
                if (tokenText.equals("__debug__")) {
                    return PyTokenTypes.DEBUG_KEYWORD;
                }
                if (this.myLanguageLevel.isAtLeast(LanguageLevel.PYTHON37)) {
                    if (tokenText.equals("async")) {
                        return PyTokenTypes.ASYNC_KEYWORD;
                    }
                    if (tokenText.equals("await")) {
                        return PyTokenTypes.AWAIT_KEYWORD;
                    }
                }
            } else if (tokenText.equals("exec")) {
                return PyTokenTypes.EXEC_KEYWORD;
            }
        }
        return tokenType;
    }

    public void advance() {
        IElementType type = super.getTokenType();
        switch (this.myState) {
            case init: {
                if (type == PyTokenTypes.BACKSLASH || PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(type) || PyTokenTypes.END_OF_LINE_COMMENT == type || PyTokenTypes.DOCSTRING == type) break;
                if (type == PyTokenTypes.FROM_KEYWORD) {
                    this.myState = state.pending_future;
                    break;
                }
                this.myState = state.stop;
                break;
            }
            case pending_future: {
                if (type == PyTokenTypes.BACKSLASH || PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(type)) break;
                if (type == PyTokenTypes.IDENTIFIER && "__future__".equals(super.getTokenText())) {
                    this.myState = state.pending_import;
                    break;
                }
                this.myState = state.stop;
                break;
            }
            case pending_import: {
                if (type == PyTokenTypes.BACKSLASH || PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(type)) break;
                if (type == PyTokenTypes.IMPORT_KEYWORD) {
                    this.myState = state.pending_lpar;
                    break;
                }
                this.myState = state.stop;
                break;
            }
            case pending_lpar: {
                if (type == PyTokenTypes.LPAR) {
                    this.myState = state.pending_id;
                    break;
                }
            }
            case pending_id: {
                if (type == PyTokenTypes.BACKSLASH || PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(type)) break;
                if (type == PyTokenTypes.IDENTIFIER) {
                    this.myState = state.pending_comma;
                    if ("unicode_literals".equals(super.getTokenText())) {
                        this.hasUnicodeImport = true;
                        this.myImportOffset = this.getTokenEnd();
                        break;
                    }
                    if (!FutureFeature.PRINT_FUNCTION.toString().equals(super.getTokenText())) break;
                    this.hasPrintFunctionImport = true;
                    this.myImportOffset = this.getTokenEnd();
                    break;
                }
                this.myState = state.init;
                break;
            }
            case pending_comma: {
                if (type == PyTokenTypes.RPAR || type == PyTokenTypes.BACKSLASH) break;
                if (PyTokenTypes.LINE_BREAK == type) {
                    this.myState = state.init;
                }
                if (PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(type) || type != PyTokenTypes.COMMA) break;
                this.myState = state.pending_id;
                break;
            }
        }
        super.advance();
    }

    public int getImportOffset() {
        return this.myImportOffset;
    }

    public void clearState(int position) {
        this.myState = state.init;
        this.myImportOffset = position;
        this.hasUnicodeImport = false;
        this.hasPrintFunctionImport = false;
    }

    private static enum state {
        init,
        pending_future,
        pending_import,
        pending_lpar,
        pending_id,
        pending_comma,
        stop;

    }
}

