/*
 * Decompiled with CFR 0.152.
 */
package fleet.themes;

import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.unit.Dp;
import fleet.compose.theme.keys.ThemeKeys;
import fleet.themes.Colors;
import fleet.themes.PTextAttributes;
import fleet.themes.PTextSpec;
import fleet.themes.Palette;
import fleet.themes.ThemeData;
import fleet.themes.ThemeLoaderKt;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import noria.model.ThemeKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u0000 12\u00020\u0001:\u00011BY\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010\u0019\u001a\u0004\u0018\u00010\u0000J\u0016\u0010\u001a\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010\u001bJp\u0010\u001c\u001a\u00020\u001d\"\b\b\u0000\u0010\u001e*\u00020\u0001\"\b\b\u0001\u0010\u001f*\u00020\u00012\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u001e0\u00032\u0016\u0010!\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010\"2&\u0010#\u001a\"\u0012\u0004\u0012\u0002H\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020%0\u0003\u0012\u0006\u0012\u0004\u0018\u0001H\u001f0$H\u0002J\u0019\u0010&\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\u0017\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u000bH\u00c6\u0003J\t\u0010*\u001a\u00020\rH\u00c6\u0003Je\u0010+\u001a\u00020\u00002\u0018\b\u0002\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010\u00032\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00032\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\t\u00100\u001a\u00020\u0006H\u00d6\u0001R!\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001f\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00062"}, d2={"Lfleet/themes/ThemeData;", "", "meta", "", "Lnoria/model/ThemeKey;", "textAttributes", "", "Lfleet/themes/PTextAttributes;", "styles", "Lfleet/themes/PTextSpec;", "colors", "Lfleet/themes/Colors;", "palette", "Lfleet/themes/Palette;", "<init>", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Lfleet/themes/Colors;Lfleet/themes/Palette;)V", "getMeta", "()Ljava/util/Map;", "getTextAttributes", "getStyles", "getColors", "()Lfleet/themes/Colors;", "getPalette", "()Lfleet/themes/Palette;", "merge", "other", "toMap", "Lkotlinx/collections/immutable/PersistentMap;", "resolve", "", "F", "T", "from", "to", "", "transform", "Lkotlin/Function2;", "Landroidx/compose/ui/graphics/Color;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "hashCode", "", "toString", "Companion", "fleet.themes"})
@SourceDebugExtension(value={"SMAP\nThemeLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThemeLoader.kt\nfleet/themes/ThemeData\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,714:1\n216#2,2:715\n155#3:717\n*S KotlinDebug\n*F\n+ 1 ThemeLoader.kt\nfleet/themes/ThemeData\n*L\n706#1:715,2\n645#1:717\n*E\n"})
final class ThemeData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<ThemeKey<?>, Object> meta;
    @Nullable
    private final Map<String, PTextAttributes> textAttributes;
    @NotNull
    private final Map<String, PTextSpec> styles;
    @NotNull
    private final Colors colors;
    @NotNull
    private final Palette palette;
    @NotNull
    private static final ThemeData MINIMAL;

    public ThemeData(@NotNull Map<ThemeKey<?>, ? extends Object> meta, @Nullable Map<String, PTextAttributes> textAttributes, @NotNull Map<String, PTextSpec> styles, @NotNull Colors colors, @NotNull Palette palette) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter(styles, (String)"styles");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        this.meta = meta;
        this.textAttributes = textAttributes;
        this.styles = styles;
        this.colors = colors;
        this.palette = palette;
    }

    @NotNull
    public final Map<ThemeKey<?>, Object> getMeta() {
        return this.meta;
    }

    @Nullable
    public final Map<String, PTextAttributes> getTextAttributes() {
        return this.textAttributes;
    }

    @NotNull
    public final Map<String, PTextSpec> getStyles() {
        return this.styles;
    }

    @NotNull
    public final Colors getColors() {
        return this.colors;
    }

    @NotNull
    public final Palette getPalette() {
        return this.palette;
    }

    @NotNull
    public final ThemeData merge(@Nullable ThemeData other) {
        if (other == null) {
            return this;
        }
        Map map = MapsKt.plus(this.meta, other.meta);
        Map<String, PTextAttributes> map2 = other.textAttributes;
        if (map2 == null) {
            map2 = this.textAttributes;
        }
        return new ThemeData(map, map2, MapsKt.plus(this.styles, other.styles), new Colors(MapsKt.plus(this.colors.getColors(), other.colors.getColors())), new Palette(this.palette.getPrefix(), MapsKt.plus(this.palette.getColors(), other.palette.getColors())));
    }

    @NotNull
    public final PersistentMap<ThemeKey<?>, Object> toMap() {
        Map<String, PTextAttributes> map;
        PersistentMap.Builder result = ExtensionsKt.persistentHashMapOf().builder();
        if (!this.meta.isEmpty()) {
            result.putAll(this.meta);
        }
        if (!((map = this.textAttributes) == null || map.isEmpty())) {
            this.resolve(this.textAttributes, (Map)result, toMap.1.INSTANCE);
        }
        if (!this.styles.isEmpty()) {
            this.resolve(this.styles, (Map)result, toMap.2.INSTANCE);
        }
        if (!this.colors.getColors().isEmpty()) {
            this.resolve(this.colors.getColors(), (Map)result, toMap.3.INSTANCE);
        }
        return result.build();
    }

    private final <F, T> void resolve(Map<String, ? extends F> from, Map<ThemeKey<?>, Object> to, Function2<? super F, ? super Map<String, Color>, ? extends T> transform) {
        Map<String, Color> nameToColor = this.palette.getColors();
        Map<String, F> $this$forEach$iv = from;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, F>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, F> element$iv;
            Map.Entry<String, F> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            F value = entry.getValue();
            Object transformed = transform.invoke(value, nameToColor);
            if (transformed == null) continue;
            to.put(new ThemeKey(key), transformed);
        }
    }

    @NotNull
    public final Map<ThemeKey<?>, Object> component1() {
        return this.meta;
    }

    @Nullable
    public final Map<String, PTextAttributes> component2() {
        return this.textAttributes;
    }

    @NotNull
    public final Map<String, PTextSpec> component3() {
        return this.styles;
    }

    @NotNull
    public final Colors component4() {
        return this.colors;
    }

    @NotNull
    public final Palette component5() {
        return this.palette;
    }

    @NotNull
    public final ThemeData copy(@NotNull Map<ThemeKey<?>, ? extends Object> meta, @Nullable Map<String, PTextAttributes> textAttributes, @NotNull Map<String, PTextSpec> styles, @NotNull Colors colors, @NotNull Palette palette) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter(styles, (String)"styles");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        return new ThemeData(meta, textAttributes, styles, colors, palette);
    }

    public static /* synthetic */ ThemeData copy$default(ThemeData themeData, Map map, Map map2, Map map3, Colors colors, Palette palette, int n, Object object) {
        if ((n & 1) != 0) {
            map = themeData.meta;
        }
        if ((n & 2) != 0) {
            map2 = themeData.textAttributes;
        }
        if ((n & 4) != 0) {
            map3 = themeData.styles;
        }
        if ((n & 8) != 0) {
            colors = themeData.colors;
        }
        if ((n & 0x10) != 0) {
            palette = themeData.palette;
        }
        return themeData.copy(map, map2, map3, colors, palette);
    }

    @NotNull
    public String toString() {
        return "ThemeData(meta=" + this.meta + ", textAttributes=" + this.textAttributes + ", styles=" + this.styles + ", colors=" + this.colors + ", palette=" + this.palette + ")";
    }

    public int hashCode() {
        int result = ((Object)this.meta).hashCode();
        result = result * 31 + (this.textAttributes == null ? 0 : ((Object)this.textAttributes).hashCode());
        result = result * 31 + ((Object)this.styles).hashCode();
        result = result * 31 + this.colors.hashCode();
        result = result * 31 + this.palette.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ThemeData)) {
            return false;
        }
        ThemeData themeData = (ThemeData)other;
        if (!Intrinsics.areEqual(this.meta, themeData.meta)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.textAttributes, themeData.textAttributes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.styles, themeData.styles)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.colors, (Object)themeData.colors)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.palette, (Object)themeData.palette);
    }

    static {
        int $this$dp$iv = 16;
        boolean $i$f$getDp = false;
        Pair[] pairArray = new Pair[]{ThemeLoaderKt.figmaFont$default("header.0.semi.bold.text", "Inter Variable", 600, 26, 26, 0.0f, 32, false, 160, null), ThemeLoaderKt.figmaFont$default("header.1.semi.bold.text", "Inter Variable", 600, 23, 23, 0.0f, 28, false, 160, null), ThemeLoaderKt.figmaFont$default("header.1.text", "Inter Variable", 400, 23, 23, 0.0f, 28, false, 160, null), ThemeLoaderKt.figmaFont$default("header.2.semi.bold.text", "Inter Variable", 600, 19, 19, 0.0f, 24, false, 160, null), ThemeLoaderKt.figmaFont$default("header.2.text", "Inter Variable", 400, 19, 19, 0.0f, 24, false, 160, null), ThemeLoaderKt.figmaFont$default("header.3.semi.bold.text", "Inter Variable", 600, 15, null, 0.1f, 20, false, 144, null), ThemeLoaderKt.figmaFont$default("header.3.text", "Inter Variable", 450, 15, null, 0.1f, 20, false, 144, null), ThemeLoaderKt.figmaFont$default("header.4.semi.bold.text", "Inter Variable", 600, 13, null, 0.4f, 18, false, 144, null), ThemeLoaderKt.figmaFont$default("header.5.semi.bold.text", "Inter Variable", 700, 10, null, 10.0f, 14, false, 144, null), ThemeLoaderKt.figmaFont$default("default.text", "Inter Variable", 480, 13, null, 0.4f, 16, false, 144, null), ThemeLoaderKt.figmaFont$default("default.italic.text", "Inter Variable", 480, 13, null, 0.4f, 16, true, 16, null), ThemeLoaderKt.figmaFont$default("default.semi.bold.text", "Inter Variable", 600, 13, null, 0.4f, 16, false, 144, null), ThemeLoaderKt.figmaFont$default("default.multiline.text", "Inter Variable", 480, 13, null, 0.4f, 18, false, 144, null), ThemeLoaderKt.figmaFont$default("medium.text", "Inter Variable", 500, 12, null, 0.5f, 16, false, 144, null), ThemeLoaderKt.figmaFont$default("medium.semi.bold.text", "Inter Variable", 625, 12, null, 0.5f, 16, false, 144, null), ThemeLoaderKt.figmaFont$default("small.text", "Inter Variable", 500, 10, null, 0.6f, 14, false, 144, null), ThemeLoaderKt.figmaFont$default("code.text", "JetBrains Mono", 400, 13, null, 0.0f, 22, false, 176, null), ThemeLoaderKt.figmaFont$default("code.italic.text", "JetBrains Mono", 400, 13, null, 0.0f, 22, true, 48, null), ThemeLoaderKt.figmaFont$default("code.bold.text", "JetBrains Mono", 700, 13, null, 0.0f, 22, false, 176, null)};
        MINIMAL = new ThemeData(MapsKt.mapOf((Pair)TuplesKt.to((Object)ThemeKeys.INSTANCE.getIconSize(), (Object)Dp.box-impl((float)Dp.constructor-impl((float)$this$dp$iv)))), null, MapsKt.mapOf((Pair[])pairArray), Colors.Companion.getEmpty(), Palette.Companion.getEmpty());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lfleet/themes/ThemeData$Companion;", "", "<init>", "()V", "MINIMAL", "Lfleet/themes/ThemeData;", "getMINIMAL", "()Lfleet/themes/ThemeData;", "fleet.themes"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ThemeData getMINIMAL() {
            return MINIMAL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

