/*
 * Decompiled with CFR 0.152.
 */
package fleet.supervisor.impl.welcomescreen.connections;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.ui.focus.FocusRequester;
import fleet.compose.theme.layout.NavigationStack;
import fleet.supervisor.api.ShipHostEntity;
import fleet.supervisor.api.SupervisorKey;
import fleet.supervisor.api.SupervisorPriority;
import fleet.supervisor.impl.ship.ShipHostEntitiesKt;
import fleet.supervisor.impl.ship.ShipHostSupervisorEntity;
import fleet.supervisor.impl.welcomescreen.connections.ConnectionsNavigationPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R/\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u00138F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lfleet/supervisor/impl/welcomescreen/connections/ConnectionsViewModel;", "", "navigationStack", "Lfleet/compose/theme/layout/NavigationStack;", "Lfleet/supervisor/impl/welcomescreen/connections/ConnectionsNavigationPath;", "<init>", "(Lfleet/compose/theme/layout/NavigationStack;)V", "getNavigationStack", "()Lfleet/compose/theme/layout/NavigationStack;", "availableConnectionTypes", "", "Lfleet/supervisor/impl/ship/ShipHostSupervisorEntity;", "getAvailableConnectionTypes", "()Ljava/util/List;", "contentFocusRequester", "Landroidx/compose/ui/focus/FocusRequester;", "getContentFocusRequester", "()Landroidx/compose/ui/focus/FocusRequester;", "<set-?>", "Lfleet/supervisor/api/SupervisorKey;", "currentSupervisorKey", "getCurrentSupervisorKey", "()Lfleet/supervisor/api/SupervisorKey;", "setCurrentSupervisorKey", "(Lfleet/supervisor/api/SupervisorKey;)V", "currentSupervisorKey$delegate", "Landroidx/compose/runtime/MutableState;", "navigateToNewConnection", "", "navigateToExistingConnections", "host", "Lfleet/supervisor/api/ShipHostEntity;", "fleet.supervisor"})
@SourceDebugExtension(value={"SMAP\nConnectionsViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionsViewModel.kt\nfleet/supervisor/impl/welcomescreen/connections/ConnectionsViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,40:1\n774#2:41\n865#2,2:42\n68#3:44\n94#3,2:45\n*S KotlinDebug\n*F\n+ 1 ConnectionsViewModel.kt\nfleet/supervisor/impl/welcomescreen/connections/ConnectionsViewModel\n*L\n16#1:41\n16#1:42,2\n18#1:44\n18#1:45,2\n*E\n"})
public final class ConnectionsViewModel {
    @NotNull
    private final NavigationStack<ConnectionsNavigationPath> navigationStack;
    @NotNull
    private final FocusRequester contentFocusRequester;
    @NotNull
    private final MutableState currentSupervisorKey$delegate;

    public ConnectionsViewModel(@NotNull NavigationStack<ConnectionsNavigationPath> navigationStack) {
        Intrinsics.checkNotNullParameter(navigationStack, (String)"navigationStack");
        this.navigationStack = navigationStack;
        this.contentFocusRequester = new FocusRequester();
        ShipHostSupervisorEntity shipHostSupervisorEntity = (ShipHostSupervisorEntity)CollectionsKt.firstOrNull(this.getAvailableConnectionTypes());
        this.currentSupervisorKey$delegate = SnapshotStateKt.mutableStateOf$default((Object)(shipHostSupervisorEntity != null ? shipHostSupervisorEntity.getKey() : null), null, (int)2, null);
    }

    @NotNull
    public final NavigationStack<ConnectionsNavigationPath> getNavigationStack() {
        return this.navigationStack;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ShipHostSupervisorEntity> getAvailableConnectionTypes() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ShipHostSupervisorEntity.Companion.all();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ShipHostSupervisorEntity it = (ShipHostSupervisorEntity)element$iv$iv;
            boolean bl = false;
            if (!ShipHostEntitiesKt.getCanCreateNewConnection(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ShipHostSupervisorEntity it = (ShipHostSupervisorEntity)b;
                boolean bl = false;
                Comparable comparable = SupervisorPriority.box-impl(it.getSupervisor().getPriority-GjMK-Zs());
                it = (ShipHostSupervisorEntity)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)SupervisorPriority.box-impl(it.getSupervisor().getPriority-GjMK-Zs()));
            }
        });
    }

    @NotNull
    public final FocusRequester getContentFocusRequester() {
        return this.contentFocusRequester;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SupervisorKey getCurrentSupervisorKey() {
        void $this$getValue$iv;
        State state = (State)this.currentSupervisorKey$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (SupervisorKey)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setCurrentSupervisorKey(@Nullable SupervisorKey supervisorKey) {
        void $this$setValue$iv;
        MutableState mutableState = this.currentSupervisorKey$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)supervisorKey);
    }

    public final void navigateToNewConnection() {
        if (!(this.navigationStack.getCurrent() instanceof ConnectionsNavigationPath.NewConnection)) {
            this.navigationStack.push((Object)ConnectionsNavigationPath.NewConnection.INSTANCE);
        }
    }

    public final void navigateToExistingConnections(@NotNull ShipHostEntity host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Object object = this.navigationStack.getCurrent();
        ConnectionsNavigationPath.EditConnection editConnection2 = object instanceof ConnectionsNavigationPath.EditConnection ? (ConnectionsNavigationPath.EditConnection)object : null;
        if (!Intrinsics.areEqual((Object)(editConnection2 != null ? editConnection2.getHost() : null), (Object)host)) {
            this.navigationStack.push((Object)new ConnectionsNavigationPath.EditConnection(host));
        }
    }
}

