/*
 * Decompiled with CFR 0.152.
 */
package fleet.mercury.frontend.avdmanager.ui.newavd;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import fleet.api.ProjectRootId;
import fleet.mercury.frontend.avdmanager.ui.DialogState;
import fleet.mercury.frontend.avdmanager.ui.analytics.AnalyticsLogger;
import fleet.mercury.frontend.avdmanager.ui.analytics.AnalyticsLoggerImpl;
import fleet.mercury.frontend.avdmanager.ui.analytics.AvdReportingUtilsKt;
import fleet.mercury.frontend.avdmanager.ui.analytics.AvdReports;
import fleet.mercury.frontend.avdmanager.ui.newavd.SoftwareStepViewModel;
import fleet.mercury.frontend.avdmanager.ui.newavd.SoftwareStepViewModelKt;
import fleet.mercury.protocol.MercuryAvdManagerApi;
import fleet.mercury.protocol.avdmanager.AvdSystemImage;
import fleet.mercury.protocol.avdmanager.DownloadImageResult;
import fleet.util.logging.KLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\fJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\u001eJ@\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001d0#H\u0082@\u00a2\u0006\u0002\u0010%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0011\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\r0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lfleet/mercury/frontend/avdmanager/ui/newavd/SoftwareStepViewModel;", "", "service", "Lfleet/mercury/protocol/MercuryAvdManagerApi;", "projectRootId", "Lfleet/api/ProjectRootId;", "analyticsLogger", "Lfleet/mercury/frontend/avdmanager/ui/analytics/AnalyticsLogger;", "<init>", "(Lfleet/mercury/protocol/MercuryAvdManagerApi;Lfleet/api/ProjectRootId;Lfleet/mercury/frontend/avdmanager/ui/analytics/AnalyticsLogger;)V", "downloadStates", "Ljava/util/concurrent/ConcurrentHashMap;", "Lfleet/mercury/protocol/avdmanager/AvdSystemImage;", "", "triggerRefetchState", "Landroidx/compose/runtime/MutableState;", "", "licenseAccepted", "Lfleet/mercury/frontend/avdmanager/ui/DialogState;", "", "", "getLicenseAccepted", "()Lfleet/mercury/frontend/avdmanager/ui/DialogState;", "triggerRefetch", "getTriggerRefetch", "()I", "isDownloadingImage", "systemImage", "downloadImage", "", "(Lfleet/mercury/protocol/avdmanager/AvdSystemImage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "image", "onSuccess", "Lkotlin/Function0;", "onError", "Lkotlin/Function1;", "Lfleet/mercury/protocol/avdmanager/DownloadImageResult$Error;", "(Lfleet/mercury/protocol/avdmanager/AvdSystemImage;Lfleet/mercury/protocol/MercuryAvdManagerApi;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fleet.plugins.mercury.frontend"})
@SourceDebugExtension(value={"SMAP\nSoftwareStepViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoftwareStepViewModel.kt\nfleet/mercury/frontend/avdmanager/ui/newavd/SoftwareStepViewModel\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,86:1\n10#2,2:87\n*S KotlinDebug\n*F\n+ 1 SoftwareStepViewModel.kt\nfleet/mercury/frontend/avdmanager/ui/newavd/SoftwareStepViewModel\n*L\n53#1:87,2\n*E\n"})
public final class SoftwareStepViewModel {
    @NotNull
    private final MercuryAvdManagerApi service;
    @NotNull
    private final ProjectRootId projectRootId;
    @NotNull
    private final AnalyticsLogger analyticsLogger;
    @NotNull
    private final ConcurrentHashMap<AvdSystemImage, Boolean> downloadStates;
    @NotNull
    private final MutableState<Integer> triggerRefetchState;
    @NotNull
    private final DialogState<Map<String, String>, Boolean> licenseAccepted;

    public SoftwareStepViewModel(@NotNull MercuryAvdManagerApi service, @NotNull ProjectRootId projectRootId, @NotNull AnalyticsLogger analyticsLogger) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)projectRootId, (String)"projectRootId");
        Intrinsics.checkNotNullParameter((Object)analyticsLogger, (String)"analyticsLogger");
        this.service = service;
        this.projectRootId = projectRootId;
        this.analyticsLogger = analyticsLogger;
        this.downloadStates = new ConcurrentHashMap();
        this.triggerRefetchState = SnapshotStateKt.mutableStateOf$default((Object)0, null, (int)2, null);
        this.licenseAccepted = new DialogState();
    }

    public /* synthetic */ SoftwareStepViewModel(MercuryAvdManagerApi mercuryAvdManagerApi, ProjectRootId projectRootId, AnalyticsLogger analyticsLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            analyticsLogger = new AnalyticsLoggerImpl();
        }
        this(mercuryAvdManagerApi, projectRootId, analyticsLogger);
    }

    @NotNull
    public final DialogState<Map<String, String>, Boolean> getLicenseAccepted() {
        return this.licenseAccepted;
    }

    public final int getTriggerRefetch() {
        return ((Number)this.triggerRefetchState.getValue()).intValue();
    }

    public final boolean isDownloadingImage(@NotNull AvdSystemImage systemImage) {
        Intrinsics.checkNotNullParameter((Object)systemImage, (String)"systemImage");
        Boolean bl = this.downloadStates.get(systemImage);
        return bl != null ? bl : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object downloadImage(@NotNull AvdSystemImage var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof downloadImage.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SoftwareStepViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadImage(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.analyticsLogger.log(AvdReports.INSTANCE.getNewDeviceSoftwareImageDownloadButtonPressed(), Boxing.boxInt((int)systemImage.getApiLevel()), AvdReportingUtilsKt.reportedConfig(systemImage));
                ((Map)this.downloadStates).put(systemImage, Boxing.boxBoolean((boolean)true));
                $continuation.L$0 = this;
                $continuation.L$1 = systemImage;
                $continuation.label = 1;
                v0 = this.downloadImage(systemImage, this.service, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ SoftwareStepViewModel this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        KLogger this_$iv = SoftwareStepViewModelKt.access$getLogger();
                        boolean $i$f$debug = false;
                        if (this_$iv.isDebugEnabled()) {
                            KLogger kLogger = this_$iv;
                            boolean bl = false;
                            kLogger.debug((Object)"system image download successful, refreshing");
                        }
                        MutableState mutableState = SoftwareStepViewModel.access$getTriggerRefetchState$p(this.this$0);
                        int n = ((Number)mutableState.getValue()).intValue();
                        mutableState.setValue((Object)(n + 1));
                    }
                }), (Function1<? super DownloadImageResult.Error, Unit>)((Function1)downloadImage.3.INSTANCE), (Continuation<? super Unit>)$continuation);
                ** if (v0 != var10_5) goto lbl23
lbl22:
                // 1 sources

                return var10_5;
lbl23:
                // 1 sources

                ** GOTO lbl45
            }
            case 1: {
                systemImage = (AvdSystemImage)$continuation.L$1;
                this = (SoftwareStepViewModel)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Throwable var3_7) {
                    throw var3_7;
                }
                finally {
                    this_$iv = SoftwareStepViewModelKt.access$getLogger();
                    $i$f$debug = false;
                    if (this_$iv.isDebugEnabled()) {
                        var7_10 = this_$iv;
                        $i$a$-debug-SoftwareStepViewModel$downloadImage$4 = false;
                        var7_10.debug((Object)"download image finished");
                    }
                    ((Map)this.downloadStates).put(systemImage, Boxing.boxBoolean((boolean)false));
                }
lbl45:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object downloadImage(AvdSystemImage var1_1, MercuryAvdManagerApi var2_2, Function0<Unit> var3_3, Function1<? super DownloadImageResult.Error, Unit> var4_4, Continuation<? super Unit> $completion) {
        block19: {
            if (!($completion instanceof downloadImage.5)) ** GOTO lbl-1000
            var9_6 = $completion;
            if ((var9_6.label & -2147483648) != 0) {
                var9_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    /* synthetic */ Object result;
                    final /* synthetic */ SoftwareStepViewModel this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return SoftwareStepViewModel.access$downloadImage(this.this$0, null, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = this;
                    $continuation.L$1 = image;
                    $continuation.L$2 = service;
                    $continuation.L$3 = onSuccess;
                    $continuation.L$4 = onError;
                    $continuation.label = 1;
                    v0 = service.tryDownloadImage(image, this.projectRootId, (Continuation)$continuation);
                    if (v0 == var10_8) {
                        return var10_8;
                    }
                    ** GOTO lbl30
                }
                case 1: {
                    onError = (Function1)$continuation.L$4;
                    onSuccess = (Function0)$continuation.L$3;
                    service = (MercuryAvdManagerApi)$continuation.L$2;
                    image = (AvdSystemImage)$continuation.L$1;
                    this = (SoftwareStepViewModel)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    $continuation.L$0 = this;
                    $continuation.L$1 = image;
                    $continuation.L$2 = service;
                    $continuation.L$3 = onSuccess;
                    $continuation.L$4 = onError;
                    $continuation.label = 2;
                    v1 = ((Deferred)v0).await((Continuation)$continuation);
                    if (v1 == var10_8) {
                        return var10_8;
                    }
                    ** GOTO lbl48
                }
                case 2: {
                    onError = (Function1)$continuation.L$4;
                    onSuccess = (Function0)$continuation.L$3;
                    service = (MercuryAvdManagerApi)$continuation.L$2;
                    image = (AvdSystemImage)$continuation.L$1;
                    this = (SoftwareStepViewModel)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl48:
                    // 2 sources

                    if (!((result = (DownloadImageResult)v1) instanceof DownloadImageResult.Error)) ** GOTO lbl52
                    onError.invoke((Object)result);
                    break block19;
lbl52:
                    // 1 sources

                    if (!(result instanceof DownloadImageResult.PendingLicenses)) break;
                    $continuation.L$0 = this;
                    $continuation.L$1 = image;
                    $continuation.L$2 = service;
                    $continuation.L$3 = onSuccess;
                    $continuation.L$4 = onError;
                    $continuation.L$5 = result;
                    $continuation.label = 3;
                    v2 = this.licenseAccepted.awaitResult(((DownloadImageResult.PendingLicenses)result).getLicenses(), (Continuation<Boolean>)$continuation);
                    if (v2 == var10_8) {
                        return var10_8;
                    }
                    ** GOTO lbl73
                }
                case 3: {
                    result = (DownloadImageResult)$continuation.L$5;
                    onError = (Function1)$continuation.L$4;
                    onSuccess = (Function0)$continuation.L$3;
                    service = (MercuryAvdManagerApi)$continuation.L$2;
                    image = (AvdSystemImage)$continuation.L$1;
                    this = (SoftwareStepViewModel)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl73:
                    // 2 sources

                    if (!((Boolean)v2).booleanValue()) {
                        onError.invoke((Object)new DownloadImageResult.Error("The license agreement was denied"));
                        return Unit.INSTANCE;
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = image;
                    $continuation.L$2 = service;
                    $continuation.L$3 = onSuccess;
                    $continuation.L$4 = onError;
                    $continuation.L$5 = null;
                    $continuation.label = 4;
                    v3 = service.acceptAllLicenses(((DownloadImageResult.PendingLicenses)result).getLicenses().keySet(), (Continuation)$continuation);
                    if (v3 == var10_8) {
                        return var10_8;
                    }
                    ** GOTO lbl96
                }
                case 4: {
                    onError = (Function1)$continuation.L$4;
                    onSuccess = (Function0)$continuation.L$3;
                    service = (MercuryAvdManagerApi)$continuation.L$2;
                    image = (AvdSystemImage)$continuation.L$1;
                    this = (SoftwareStepViewModel)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl96:
                    // 2 sources

                    if (!(success = ((Boolean)v3).booleanValue())) {
                        onError.invoke((Object)new DownloadImageResult.Error("Licenses could not be accepted"));
                        return Unit.INSTANCE;
                    }
                    $continuation.L$0 = null;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.L$3 = null;
                    $continuation.L$4 = null;
                    $continuation.label = 5;
                    v4 = this.downloadImage(image, service, (Function0<Unit>)onSuccess, (Function1<? super DownloadImageResult.Error, Unit>)onError, (Continuation<? super Unit>)$continuation);
                    if (v4 == var10_8) {
                        return var10_8;
                    }
                    ** GOTO lbl113
                }
                case 5: {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl113:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            if (Intrinsics.areEqual((Object)result, (Object)DownloadImageResult.Success.INSTANCE)) {
                onSuccess.invoke();
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ MutableState access$getTriggerRefetchState$p(SoftwareStepViewModel $this) {
        return $this.triggerRefetchState;
    }

    public static final /* synthetic */ Object access$downloadImage(SoftwareStepViewModel $this, AvdSystemImage image2, MercuryAvdManagerApi service, Function0 onSuccess, Function1 onError, Continuation $completion) {
        return $this.downloadImage(image2, service, (Function0<Unit>)onSuccess, (Function1<? super DownloadImageResult.Error, Unit>)onError, (Continuation<? super Unit>)$completion);
    }
}

