/*
 * Decompiled with CFR 0.152.
 */
package fleet.common.run.impl.config;

import andel.text.Text;
import fleet.api.FileAddress;
import fleet.ast.Parser;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.common.run.impl.config.ConfigKt;
import fleet.common.topology.Filesystem;
import fleet.common.topology.HostKt;
import fleet.lang.intellij.common.IntellijMarkersAST;
import fleet.language.json.parser.JsonParserKt;
import fleet.language.json.parser.SyntaxNodeDecoder;
import fleet.language.json.parser.TreeWalkerUtilsKt;
import fleet.util.CancellationToken;
import fleet.util.logging.KLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\r\u001a\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u0007\u001a\u0016\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\r\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0015"}, d2={"logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "logger$delegate", "Lkotlin/Lazy;", "readFleetJsonRunConfiguration", "Lkotlinx/serialization/json/JsonObject;", "content", "", "cancellationToken", "Lfleet/util/CancellationToken;", "taskEnvFile", "Lfleet/api/FileAddress;", "taskConfig", "workingDir", "taskEnvironment", "", "", "taskWorkingDir", "projectRoot", "fleet.run.common"})
@SourceDebugExtension(value={"SMAP\nConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Config.kt\nfleet/common/run/impl/config/ConfigKt\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n+ 3 TreeWalkerDecoder.kt\nfleet/language/json/parser/TreeWalkerDecoderKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n13#2,2:55\n13#2,2:58\n18#3:57\n135#4,9:60\n215#4:69\n216#4:72\n144#4:73\n1#5:70\n1#5:71\n*S KotlinDebug\n*F\n+ 1 Config.kt\nfleet/common/run/impl/config/ConfigKt\n*L\n25#1:55,2\n31#1:58,2\n27#1:57\n45#1:60,9\n45#1:69\n45#1:72\n45#1:73\n45#1:71\n*E\n"})
public final class ConfigKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);

    private static final KLogger getLogger() {
        Lazy lazy = logger$delegate;
        return (KLogger)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final JsonObject readFleetJsonRunConfiguration(@NotNull CharSequence content, @NotNull CancellationToken cancellationToken) {
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)cancellationToken, (String)"cancellationToken");
        try {
            JsonObject jsonObject2;
            KLogger this_$iv;
            SyntaxNode config;
            CharSequence charSequence = content;
            Regex regex = new Regex("\\\\(?!\")");
            String string = "\\\\\\\\";
            String hackyContentWithEscapedEscapes = regex.replace(charSequence, string);
            SyntaxNode syntaxNode = ((IntellijMarkersAST)Parser.parse$default((Parser)((Parser)JsonParserKt.getJsonParser()), (Text)Text.Companion.makeText(hackyContentWithEscapedEscapes), null, (CancellationToken)cancellationToken, (int)2, null)).root().firstChild();
            Object object = config = syntaxNode != null ? TreeWalkerUtilsKt.singleOrNull((SyntaxNode)syntaxNode) : null;
            if (config == null) {
                this_$iv = ConfigKt.getLogger();
                boolean $i$f$info = false;
                if (this_$iv.isInfoEnabled()) {
                    KLogger kLogger = this_$iv;
                    boolean bl = false;
                    kLogger.info((Object)"Couldn't parse run configuration content as it consists of more than one node");
                }
            }
            SyntaxNode syntaxNode2 = config;
            if (syntaxNode2 != null) {
                void $this$decodeAs$iv;
                this_$iv = syntaxNode2;
                boolean graceful$iv = true;
                boolean $i$f$decodeAs = false;
                jsonObject2 = (JsonObject)BuiltinSerializersKt.getNullable((KSerializer)JsonObject.Companion.serializer()).deserialize((Decoder)new SyntaxNodeDecoder((SyntaxNode)$this$decodeAs$iv, graceful$iv));
            } else {
                jsonObject2 = null;
            }
            jsonObject = jsonObject2;
        }
        catch (IllegalArgumentException t) {
            if (!StringsKt.isBlank((CharSequence)content)) {
                KLogger this_$iv = ConfigKt.getLogger();
                boolean $i$f$info = false;
                if (this_$iv.isInfoEnabled()) {
                    KLogger kLogger = this_$iv;
                    boolean bl = false;
                    kLogger.info((Object)"Couldn't parse run configuration content");
                }
            }
            jsonObject = null;
        }
        return jsonObject;
    }

    @NotNull
    public static final FileAddress taskWorkingDir(@NotNull JsonObject taskConfig, @NotNull FileAddress projectRoot) {
        Object object;
        block4: {
            block3: {
                Object object2;
                Intrinsics.checkNotNullParameter((Object)taskConfig, (String)"taskConfig");
                Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
                Object object3 = taskConfig.get((Object)"workingDir");
                object = object3 instanceof JsonPrimitive ? (JsonPrimitive)object3 : null;
                if (object == null || (object = JsonElementKt.getContentOrNull((JsonPrimitive)object)) == null) break block3;
                Object workingDirString = object;
                boolean bl = false;
                Filesystem filesystem = Filesystem.Companion.lookup(projectRoot.getHostId());
                FileAddress fileAddress = filesystem != null ? (FileAddress)(Result.isFailure-impl((Object)(object2 = HostKt.parseToFileAddress((Filesystem)filesystem, (String)workingDirString, (FileAddress)projectRoot))) ? null : object2) : null;
                object = fileAddress;
                if (fileAddress != null) break block4;
            }
            object = projectRoot;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Map<String, String> taskEnvironment(@NotNull JsonObject taskConfig) {
        Map map2;
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter((Object)taskConfig, (String)"taskConfig");
        Object object = taskConfig.get((Object)"environment");
        JsonObject jsonObject2 = jsonObject = object instanceof JsonObject ? (JsonObject)object : null;
        if (jsonObject != null) {
            void $this$mapNotNullTo$iv$iv;
            Map $this$mapNotNull$iv = (Map)jsonObject;
            boolean $i$f$mapNotNull = false;
            Map map3 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Pair pair;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Map.Entry entry = element$iv$iv;
                boolean bl2 = false;
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                Object object2 = value instanceof JsonPrimitive ? (JsonPrimitive)value : null;
                if (object2 != null && (object2 = JsonElementKt.getContentOrNull((JsonPrimitive)object2)) != null) {
                    Object object3 = object2;
                    boolean bl3 = false;
                    pair = TuplesKt.to((Object)key, (Object)object3);
                } else {
                    pair = null;
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Map map4 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            if (map4 != null) {
                map2 = map4;
                return map2;
            }
        }
        map2 = MapsKt.emptyMap();
        return map2;
    }

    @Nullable
    public static final FileAddress taskEnvFile(@NotNull JsonObject taskConfig, @NotNull FileAddress workingDir) {
        FileAddress fileAddress;
        Intrinsics.checkNotNullParameter((Object)taskConfig, (String)"taskConfig");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Object object = taskConfig.get((Object)"environmentFile");
        Object object2 = object instanceof JsonPrimitive ? (JsonPrimitive)object : null;
        if (object2 != null && (object2 = JsonElementKt.getContentOrNull((JsonPrimitive)object2)) != null) {
            Object object3;
            Object envFileString = object2;
            boolean bl = false;
            Filesystem filesystem = Filesystem.Companion.lookup(workingDir.getHostId());
            fileAddress = filesystem != null ? (FileAddress)(Result.isFailure-impl((Object)(object3 = HostKt.parseToFileAddress((Filesystem)filesystem, (String)envFileString, (FileAddress)workingDir))) ? null : object3) : null;
        } else {
            fileAddress = null;
        }
        return fileAddress;
    }
}

