/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.java.parser;

import fleet.com.intellij.core.java.JavaPsiBundle;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.PsiBuilderUtil;
import fleet.com.intellij.lang.java.parser.BasicJavaParser;
import fleet.com.intellij.lang.java.parser.BasicJavaParserUtil;
import fleet.com.intellij.openapi.util.NlsContexts;
import fleet.com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import fleet.com.intellij.psi.impl.source.BasicElementTypes;
import fleet.com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import fleet.com.intellij.psi.java.JavaTokenType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicModuleParser {
    private static final Set<String> STATEMENT_KEYWORDS = ContainerUtil.newHashSet((Object[])new String[]{"requires", "exports", "uses", "provides"});
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;
    private final WhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder = WhiteSpaceAndCommentSetHolder.INSTANCE;

    public BasicModuleParser(@NotNull BasicJavaParser parser) {
        this.myParser = parser;
        this.myJavaElementTypeContainer = parser.getJavaElementTypeFactory().getContainer();
    }

    @Nullable
    public PsiBuilder.Marker parse(@NotNull PsiBuilder builder) {
        PsiBuilder.Marker modifierList;
        String text;
        PsiBuilder.Marker module = builder.mark();
        PsiBuilder.Marker firstAnnotation = this.myParser.getDeclarationParser().parseAnnotations(builder);
        IElementType type = builder.getTokenType();
        String string = text = type == JavaTokenType.IDENTIFIER ? builder.getTokenText() : null;
        if (!"open".equals(text) && !"module".equals(text)) {
            module.rollbackTo();
            return null;
        }
        PsiBuilder.Marker marker = modifierList = firstAnnotation != null ? firstAnnotation.precede() : builder.mark();
        if ("open".equals(text)) {
            BasicModuleParser.mapAndAdvance(builder, JavaTokenType.OPEN_KEYWORD);
            text = builder.getTokenText();
        }
        BasicJavaParserUtil.done(modifierList, this.myJavaElementTypeContainer.MODIFIER_LIST, this.myWhiteSpaceAndCommentSetHolder);
        if (!"module".equals(text)) {
            module.drop();
            BasicModuleParser.parseExtras(builder, JavaPsiBundle.message("expected.module.declaration", new Object[0]));
            return module;
        }
        BasicModuleParser.mapAndAdvance(builder, JavaTokenType.MODULE_KEYWORD);
        if (this.parseName(builder) == null) {
            module.drop();
            if (builder.getTokenType() != null) {
                BasicModuleParser.parseExtras(builder, JavaPsiBundle.message("expected.module.declaration", new Object[0]));
            } else {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            }
            return module;
        }
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LBRACE)) {
            if (builder.getTokenType() != null) {
                BasicModuleParser.parseExtras(builder, JavaPsiBundle.message("expected.module.declaration", new Object[0]));
            } else {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.lbrace", new Object[0]));
            }
        } else {
            this.parseModuleContent(builder);
        }
        BasicJavaParserUtil.done(module, this.myJavaElementTypeContainer.MODULE, this.myWhiteSpaceAndCommentSetHolder);
        if (builder.getTokenType() != null) {
            BasicModuleParser.parseExtras(builder, JavaPsiBundle.message("unexpected.tokens", new Object[0]));
        }
        return module;
    }

    public PsiBuilder.Marker parseName(PsiBuilder builder) {
        PsiBuilder.Marker nameElement = builder.mark();
        boolean empty = true;
        boolean idExpected = true;
        while (true) {
            IElementType t;
            if ((t = builder.getTokenType()) == JavaTokenType.IDENTIFIER) {
                if (!idExpected) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.dot", new Object[0]));
                }
                idExpected = false;
            } else {
                if (t != JavaTokenType.DOT) break;
                if (idExpected) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                }
                idExpected = true;
            }
            builder.advanceLexer();
            empty = false;
        }
        if (!empty) {
            if (idExpected) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            }
            nameElement.done(this.myJavaElementTypeContainer.MODULE_REFERENCE);
            return nameElement;
        }
        nameElement.drop();
        return null;
    }

    private void parseModuleContent(PsiBuilder builder) {
        IElementType token;
        PsiBuilder.Marker invalid = null;
        while ((token = builder.getTokenType()) != null && token != JavaTokenType.RBRACE) {
            if (token == JavaTokenType.SEMICOLON) {
                if (invalid != null) {
                    invalid.error(JavaPsiBundle.message("expected.module.statement", new Object[0]));
                    invalid = null;
                }
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker statement = this.parseStatement(builder);
            if (statement == null) {
                if (invalid == null) {
                    invalid = builder.mark();
                }
                builder.advanceLexer();
                continue;
            }
            if (invalid == null) continue;
            invalid.errorBefore(JavaPsiBundle.message("expected.module.statement", new Object[0]), statement);
            invalid = null;
        }
        if (invalid != null) {
            invalid.error(JavaPsiBundle.message("expected.module.statement", new Object[0]));
        }
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RBRACE) && invalid == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rbrace", new Object[0]));
        }
    }

    private PsiBuilder.Marker parseStatement(PsiBuilder builder) {
        String kw = builder.getTokenText();
        if ("requires".equals(kw)) {
            return this.parseRequiresStatement(builder);
        }
        if ("exports".equals(kw)) {
            return this.parseExportsStatement(builder);
        }
        if ("opens".equals(kw)) {
            return this.parseOpensStatement(builder);
        }
        if ("uses".equals(kw)) {
            return this.parseUsesStatement(builder);
        }
        if ("provides".equals(kw)) {
            return this.parseProvidesStatement(builder);
        }
        return null;
    }

    private PsiBuilder.Marker parseRequiresStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        BasicModuleParser.mapAndAdvance(builder, JavaTokenType.REQUIRES_KEYWORD);
        PsiBuilder.Marker modifierList = builder.mark();
        while (true) {
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (TokenSet)BasicElementTypes.BASIC_MODIFIER_BIT_SET)) {
                continue;
            }
            if (builder.getTokenType() != JavaTokenType.IDENTIFIER || !"transitive".equals(builder.getTokenText())) break;
            BasicModuleParser.mapAndAdvance(builder, JavaTokenType.TRANSITIVE_KEYWORD);
        }
        BasicJavaParserUtil.done(modifierList, this.myJavaElementTypeContainer.MODIFIER_LIST, this.myWhiteSpaceAndCommentSetHolder);
        if (this.parseNameRef(builder) != null) {
            BasicJavaParserUtil.semicolon(builder);
        } else {
            PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.SEMICOLON);
        }
        statement.done(this.myJavaElementTypeContainer.REQUIRES_STATEMENT);
        return statement;
    }

    private PsiBuilder.Marker parseExportsStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        BasicModuleParser.mapAndAdvance(builder, JavaTokenType.EXPORTS_KEYWORD);
        return this.parsePackageStatement(builder, statement, this.myJavaElementTypeContainer.EXPORTS_STATEMENT);
    }

    private PsiBuilder.Marker parseOpensStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        BasicModuleParser.mapAndAdvance(builder, JavaTokenType.OPENS_KEYWORD);
        return this.parsePackageStatement(builder, statement, this.myJavaElementTypeContainer.OPENS_STATEMENT);
    }

    @NotNull
    private PsiBuilder.Marker parsePackageStatement(PsiBuilder builder, PsiBuilder.Marker statement, IElementType type) {
        boolean hasError = false;
        if (this.parseClassOrPackageRef(builder) != null) {
            if ("to".equals(builder.getTokenText())) {
                PsiBuilder.Marker ref;
                BasicModuleParser.mapAndAdvance(builder, JavaTokenType.TO_KEYWORD);
                do {
                    ref = this.parseNameRef(builder);
                } while (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.COMMA));
                if (ref == null) {
                    hasError = true;
                }
            }
        } else {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.package.reference", new Object[0]));
            hasError = true;
        }
        if (!hasError) {
            BasicJavaParserUtil.semicolon(builder);
        } else {
            PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.SEMICOLON);
        }
        statement.done(type);
        return statement;
    }

    private PsiBuilder.Marker parseUsesStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        BasicModuleParser.mapAndAdvance(builder, JavaTokenType.USES_KEYWORD);
        if (this.parseClassOrPackageRef(builder) != null) {
            BasicJavaParserUtil.semicolon(builder);
        } else {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.class.reference", new Object[0]));
            PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.SEMICOLON);
        }
        statement.done(this.myJavaElementTypeContainer.USES_STATEMENT);
        return statement;
    }

    private PsiBuilder.Marker parseProvidesStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        boolean hasError = false;
        BasicModuleParser.mapAndAdvance(builder, JavaTokenType.PROVIDES_KEYWORD);
        if (this.parseClassOrPackageRef(builder) == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.class.reference", new Object[0]));
            hasError = true;
        }
        if ("with".equals(builder.getTokenText())) {
            builder.remapCurrentToken(JavaTokenType.WITH_KEYWORD);
            hasError = this.myParser.getReferenceParser().parseReferenceList(builder, JavaTokenType.WITH_KEYWORD, this.myJavaElementTypeContainer.PROVIDES_WITH_LIST, JavaTokenType.COMMA);
        } else if (!hasError) {
            IElementType next = builder.getTokenType();
            if (next == JavaTokenType.IDENTIFIER && !STATEMENT_KEYWORDS.contains(builder.getTokenText())) {
                PsiBuilder.Marker marker = builder.mark();
                builder.advanceLexer();
                marker.error(JavaPsiBundle.message("expected.with", new Object[0]));
            } else {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.with", new Object[0]));
            }
            hasError = true;
        }
        if (!hasError) {
            BasicJavaParserUtil.semicolon(builder);
        } else {
            PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.SEMICOLON);
        }
        statement.done(this.myJavaElementTypeContainer.PROVIDES_STATEMENT);
        return statement;
    }

    private PsiBuilder.Marker parseNameRef(PsiBuilder builder) {
        PsiBuilder.Marker name = this.parseName(builder);
        if (name == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
        }
        return name;
    }

    private static void mapAndAdvance(PsiBuilder builder, IElementType keyword) {
        builder.remapCurrentToken(keyword);
        builder.advanceLexer();
    }

    private static void parseExtras(PsiBuilder builder, @NotNull @NlsContexts.ParsingError String message) {
        PsiBuilder.Marker extras = builder.mark();
        while (builder.getTokenType() != null) {
            builder.advanceLexer();
        }
        extras.error(message);
    }

    private PsiBuilder.Marker parseClassOrPackageRef(PsiBuilder builder) {
        return this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, false, false, false);
    }
}

