/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.ui.tooling.preview.rpc.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010(\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003J\u0006\u0010\u0014\u001a\u00020\u000fJ\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0096\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/utils/RingBuffer;", "T", "", "", "maxSize", "", "(I)V", "getMaxSize$preview_rpc", "()I", "size", "start", "values", "", "[Ljava/lang/Object;", "add", "", "element", "(Ljava/lang/Object;)V", "addAll", "elements", "clear", "iterator", "", "preview-rpc"})
public final class RingBuffer<T>
implements Iterable<T>,
KMappedMarker {
    private final int maxSize;
    private int start;
    private int size;
    @NotNull
    private final Object[] values;

    public RingBuffer(int maxSize) {
        this.maxSize = maxSize;
        this.values = new Object[this.maxSize];
        if (!(this.maxSize > 0)) {
            boolean bl = false;
            String string = "Max size should be a positive number: " + this.maxSize;
            throw new IllegalStateException(string.toString());
        }
    }

    public final int getMaxSize$preview_rpc() {
        return this.maxSize;
    }

    public final void add(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        if (this.size < this.maxSize) {
            int n = this.size;
            this.size = n + 1;
        } else {
            this.start = (this.start + 1) % this.maxSize;
        }
        this.values[(this.start + this.size - 1) % this.maxSize] = element;
    }

    public final void addAll(@NotNull Iterable<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable<T> $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator<T> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            T element$iv;
            T it = element$iv = iterator2.next();
            boolean bl = false;
            this.add(it);
        }
    }

    public final void clear() {
        this.start = 0;
        this.size = 0;
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            this.values[i] = null;
        }
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(this){
            private int i;
            final /* synthetic */ RingBuffer<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean hasNext() {
                return this.i < RingBuffer.access$getSize$p(this.this$0);
            }

            @NotNull
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int n = this.i;
                this.i = n + 1;
                Object object = RingBuffer.access$getValues$p(this.this$0)[(RingBuffer.access$getStart$p(this.this$0) + n) % this.this$0.getMaxSize$preview_rpc()];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of org.jetbrains.compose.desktop.ui.tooling.preview.rpc.utils.RingBuffer");
                return (T)object;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    public static final /* synthetic */ int access$getSize$p(RingBuffer $this) {
        return $this.size;
    }

    public static final /* synthetic */ Object[] access$getValues$p(RingBuffer $this) {
        return $this.values;
    }

    public static final /* synthetic */ int access$getStart$p(RingBuffer $this) {
        return $this.start;
    }
}

