/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript;

import fleet.com.intellij.lang.javascript.DialectOptionHolder;
import fleet.com.intellij.lang.javascript.JSDocLexer;
import fleet.com.intellij.lang.javascript.JSDocTokenTypes;
import fleet.com.intellij.lang.javascript.JSFlexAdapter;
import fleet.com.intellij.lang.javascript.JSStringLiteralLexer;
import fleet.com.intellij.lang.javascript.JSTokenTypes;
import fleet.com.intellij.lexer.LayeredLexer;
import fleet.com.intellij.lexer.Lexer;
import fleet.com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JavaScriptHighlightingLexer
extends LayeredLexer {
    private static final String ESCAPES;

    public JavaScriptHighlightingLexer(@NotNull DialectOptionHolder optionHolder) {
        super((Lexer)new JSFlexAdapter(optionHolder, true));
        String escapes = !optionHolder.isECMA4 ? ESCAPES : "/";
        this.registerSelfStoppingLayer((Lexer)new JSStringLiteralLexer('\"', JSTokenTypes.STRING_LITERAL, escapes, !optionHolder.isECMA4, optionHolder.isJavaScript() || optionHolder.isTypeScript, false), new IElementType[]{JSTokenTypes.STRING_LITERAL}, IElementType.EMPTY_ARRAY);
        this.registerSelfStoppingLayer((Lexer)new JSStringLiteralLexer('\uffff', JSTokenTypes.STRING_TEMPLATE_PART, escapes, !optionHolder.isECMA4, optionHolder.isJavaScript() || optionHolder.isTypeScript, true), new IElementType[]{JSTokenTypes.STRING_TEMPLATE_PART}, IElementType.EMPTY_ARRAY);
        this.registerSelfStoppingLayer((Lexer)new JSStringLiteralLexer('\'', JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL, escapes, !optionHolder.isECMA4, optionHolder.isJavaScript() || optionHolder.isTypeScript, false), new IElementType[]{JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL}, IElementType.EMPTY_ARRAY);
        this.registerSelfStoppingLayer((Lexer)new JSDocLexer(true), new IElementType[]{JSTokenTypes.DOC_COMMENT}, new IElementType[]{JSDocTokenTypes.DOC_COMMENT_END});
    }

    static {
        StringBuilder escapesBuilder = new StringBuilder("/");
        for (char c = '\u0001'; c < '\u00ad'; c = (char)(c + 1)) {
            if (c == 120 || c == 117 || Character.isDigit(c) || c == 10 || c == 13) continue;
            escapesBuilder.append(c);
        }
        ESCAPES = escapesBuilder.toString();
    }
}

