/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript;

import fleet.com.intellij.lang.Language;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.javascript.DialectOptionHolder;
import fleet.com.intellij.lang.javascript.JavascriptLanguage;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JSLanguageDialect
extends Language {
    private final DialectOptionHolder myDialectOptionsHolder;

    protected JSLanguageDialect(@NonNls @NotNull String id, @NotNull DialectOptionHolder dialectOptionsHolder, String ... mimeTypes) {
        this(id, dialectOptionsHolder, JavascriptLanguage.INSTANCE, mimeTypes);
    }

    protected JSLanguageDialect(@NonNls @NotNull String id, @NotNull DialectOptionHolder dialectOptionsHolder, Language baseLanguage, String ... mimeTypes) {
        super(baseLanguage, id, mimeTypes);
        this.myDialectOptionsHolder = dialectOptionsHolder;
        if (baseLanguage != JavascriptLanguage.INSTANCE && this != JavascriptLanguage.INSTANCE) {
            JavascriptLanguage.INSTANCE.registerDialect(this);
        }
    }

    public void unregisterDialect(@NotNull Language language) {
        super.unregisterDialect(language);
        if (this != JavascriptLanguage.INSTANCE) {
            JavascriptLanguage.INSTANCE.unregisterDialect(language);
        }
    }

    @Deprecated
    @NonNls
    public String getFileExtension() {
        return "js";
    }

    @NotNull
    public final DialectOptionHolder getOptionHolder() {
        return this.myDialectOptionsHolder;
    }

    public boolean isAtLeast(@NotNull JSLanguageDialect other) {
        if (this == other) {
            return true;
        }
        Language baseLanguage = this.getBaseLanguage();
        return baseLanguage instanceof JSLanguageDialect && ((JSLanguageDialect)baseLanguage).isAtLeast(other);
    }

    @Deprecated
    public Object createParser(@NotNull PsiBuilder builder) {
        return null;
    }

    public boolean isCaseSensitive() {
        return true;
    }
}

