/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.ecmascript6.parsing;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.javascript.JSTokenTypes;
import fleet.com.intellij.lang.javascript.parsing.ExpressionParser;
import fleet.com.intellij.lang.javascript.parsing.FunctionParser;
import fleet.com.intellij.lang.javascript.parsing.JSParsingContextUtil;
import fleet.com.intellij.lang.javascript.parsing.JavaScriptParser;
import fleet.com.intellij.lang.javascript.parsing.StatementParser;
import fleet.com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import fleet.com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import fleet.com.intellij.openapi.util.Key;
import fleet.com.intellij.psi.tree.IElementType;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6FunctionParser<T extends JavaScriptParser>
extends FunctionParser<T> {
    public static final Key<Boolean> HAD_ASYNC_MODIFIER_KEY = Key.create((String)"js.asyncModifier");
    private static final JSModifiersStructure ARROW_FUNCTION_MODIFIERS = new JSModifiersStructureLeaf(JSTokenTypes.ASYNC_KEYWORD);

    public ES6FunctionParser(T parser) {
        super(parser);
    }

    @Override
    public boolean parseFunctionNoMarker(FunctionParser.Context context, @NotNull PsiBuilder.Marker functionMarker) {
        boolean wasAsync = this.checkModifierAndSaveAsync();
        boolean result = super.parseFunctionNoMarker(context, functionMarker);
        this.restoreAsync(wasAsync);
        return result;
    }

    @Override
    public boolean hasSupportDecorators() {
        return true;
    }

    @Override
    public boolean isFunctionDeclarationStart() {
        IElementType tokenType = this.builder.getTokenType();
        return tokenType == JSTokenTypes.FUNCTION_KEYWORD || tokenType == JSTokenTypes.ASYNC_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.FUNCTION_KEYWORD;
    }

    @Override
    public boolean parseAttributesList() {
        if (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
            return false;
        }
        PsiBuilder.Marker modifierList = this.builder.mark();
        boolean hadAttributes = this.tryParseES7Decorators();
        if (hadAttributes && ((StatementParser)this.myJavaScriptParser.getStatementParser()).isExportDefault()) {
            modifierList.done(this.getAttributeListElementType());
            return true;
        }
        boolean hadExport = false;
        if (this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD) {
            hadExport = true;
            this.builder.advanceLexer();
        }
        if (!hadAttributes) {
            this.tryParseES7Decorators();
        }
        if (this.builder.getTokenType() == JSTokenTypes.ASYNC_KEYWORD) {
            this.builder.advanceLexer();
            this.builder.putUserData(HAD_ASYNC_MODIFIER_KEY, (Object)Boolean.TRUE);
        }
        if (!hadExport && JSTokenTypes.GET_SET.contains(this.builder.getTokenType()) && ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).isPropertyNameStart(this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
        }
        modifierList.done(this.getAttributeListElementType());
        return true;
    }

    @Override
    public boolean parseArrowFunctionWithoutModifiers(@NotNull PsiBuilder.Marker arrowFunction) {
        EnumSet<JSModifiersStructure.JSModifiersParseResult> modifiers = this.parseArrowFunctionAttributeList();
        EnumSet<JSModifiersStructure.JSModifiersParseResult> savedContext = JSParsingContextUtil.saveAndUpdateParsingContext(modifiers, this.builder);
        boolean result = super.parseArrowFunctionWithoutModifiers(arrowFunction);
        JSParsingContextUtil.restoreParsingContext(savedContext, this.builder);
        return result;
    }

    @Override
    protected boolean isValidFirstParameterStart(IElementType next) {
        IElementType nextLookAhead;
        return super.isValidFirstParameterStart(next) && (next != JSTokenTypes.ASYNC_KEYWORD || (nextLookAhead = this.builder.lookAhead(2)) != JSTokenTypes.LPAR && nextLookAhead != JSTokenTypes.MULT);
    }

    @NotNull
    protected EnumSet<JSModifiersStructure.JSModifiersParseResult> parseArrowFunctionAttributeList() {
        return this.myJavaScriptParser.parseModifiers(ARROW_FUNCTION_MODIFIERS, false, builder -> this.isAcceptableLambdaTokenAfterAsync(builder.getTokenType()));
    }

    protected boolean isAcceptableLambdaTokenAfterAsync(IElementType tokenType) {
        return tokenType == JSTokenTypes.LPAR || this.myJavaScriptParser.isIdentifierName(tokenType);
    }

    @Override
    public boolean allowLastCommaInParameterAndArgumentList() {
        return true;
    }

    private boolean checkModifierAndSaveAsync() {
        boolean hadAsyncModifier = Boolean.TRUE.equals(this.builder.getUserData(HAD_ASYNC_MODIFIER_KEY));
        this.builder.putUserData(HAD_ASYNC_MODIFIER_KEY, null);
        boolean wasAsync = JSParsingContextUtil.isAsyncContext(this.builder);
        this.builder.putUserData(JSParsingContextUtil.ASYNC_METHOD_KEY, (Object)hadAsyncModifier);
        return wasAsync;
    }

    private void restoreAsync(@Nullable Boolean wasAsync) {
        this.builder.putUserData(JSParsingContextUtil.ASYNC_METHOD_KEY, (Object)wasAsync);
    }
}

