/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.intellij.workspace;

import fleet.api.HostId;
import fleet.api.Os;
import fleet.api.PlatformKt;
import fleet.api.ProtocolPath;
import fleet.api.WorkspaceId;
import fleet.common.topology.HostEntity;
import fleet.common.topology.HostKt;
import fleet.plugins.intellij.workspace.BackendParameters;
import fleet.plugins.intellij.workspace.BackendParametersBuilder;
import fleet.plugins.intellij.workspace.BackendParametersKt;
import fleet.plugins.intellij.workspace.IntellijBackendFlavour;
import fleet.plugins.intellij.workspace.LaunchFromSourceKt;
import fleet.plugins.smartMode.protocol.BackendRequirements;
import fleet.preferences.FleetFromSourcesPaths;
import fleet.preferences.FleetPropertiesKt;
import fleet.util.UID;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 L2\u00020\u0001:\u0001LB\u0087\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\f\u0012\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0005J\u0018\u00105\u001a\u0002032\u0006\u00106\u001a\u00020\u00052\b\u00104\u001a\u0004\u0018\u00010\u0005J\t\u00107\u001a\u00020\u0003H\u00c6\u0003J\u000b\u00108\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u00109\u001a\u00020\u0005H\u00c6\u0003J\t\u0010:\u001a\u00020\u0005H\u00c6\u0003J\t\u0010;\u001a\u00020\u0005H\u00c6\u0003J\t\u0010<\u001a\u00020\nH\u00c6\u0003J\t\u0010=\u001a\u00020\fH\u00c6\u0003J\t\u0010>\u001a\u00020\u000eH\u00c6\u0003J\t\u0010?\u001a\u00020\u0010H\u00c6\u0003J\u0010\u0010@\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003\u00a2\u0006\u0002\u0010*J\t\u0010A\u001a\u00020\u0013H\u00c6\u0003J\t\u0010B\u001a\u00020\fH\u00c6\u0003J\u0015\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0016H\u00c6\u0003J\t\u0010D\u001a\u00020\u0010H\u00c6\u0003J\u00aa\u0001\u0010E\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\f2\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0010H\u00c6\u0001\u00a2\u0006\u0002\u0010FJ\u0013\u0010G\u001a\u00020H2\b\u0010I\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010J\u001a\u00020\u0010H\u00d6\u0001J\t\u0010K\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\n\n\u0002\u0010+\u001a\u0004\b)\u0010*R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\u0014\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010$R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u0017\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010(\u00a8\u0006M"}, d2={"Lfleet/plugins/intellij/workspace/BackendParametersBuilder;", "", "intellijBackendFlavour", "Lfleet/plugins/intellij/workspace/IntellijBackendFlavour;", "userHomePath", "Lfleet/api/ProtocolPath;", "ideaSystemPath", "ideaConfigPath", "ideaLogPath", "workspaceId", "Lfleet/api/WorkspaceId;", "workspaceHostId", "Lfleet/api/HostId;", "workspaceHost", "", "workspacePort", "", "debugPort", "processId", "Lfleet/util/UID;", "backendHostId", "additionalOptions", "", "xmxMb", "<init>", "(Lfleet/plugins/intellij/workspace/IntellijBackendFlavour;Lfleet/api/ProtocolPath;Lfleet/api/ProtocolPath;Lfleet/api/ProtocolPath;Lfleet/api/ProtocolPath;Lfleet/api/WorkspaceId;Lfleet/api/HostId;Ljava/lang/String;ILjava/lang/Integer;Lfleet/util/UID;Lfleet/api/HostId;Ljava/util/Map;I)V", "getIntellijBackendFlavour", "()Lfleet/plugins/intellij/workspace/IntellijBackendFlavour;", "getUserHomePath", "()Lfleet/api/ProtocolPath;", "getIdeaSystemPath", "getIdeaConfigPath", "getIdeaLogPath", "getWorkspaceId", "()Lfleet/api/WorkspaceId;", "getWorkspaceHostId", "()Lfleet/api/HostId;", "getWorkspaceHost", "()Ljava/lang/String;", "getWorkspacePort", "()I", "getDebugPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getProcessId", "()Lfleet/util/UID;", "getBackendHostId", "getAdditionalOptions", "()Ljava/util/Map;", "getXmxMb", "runFromSources", "Lfleet/plugins/intellij/workspace/BackendParameters;", "shutdownSocket", "runExecutable", "binary", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "copy", "(Lfleet/plugins/intellij/workspace/IntellijBackendFlavour;Lfleet/api/ProtocolPath;Lfleet/api/ProtocolPath;Lfleet/api/ProtocolPath;Lfleet/api/ProtocolPath;Lfleet/api/WorkspaceId;Lfleet/api/HostId;Ljava/lang/String;ILjava/lang/Integer;Lfleet/util/UID;Lfleet/api/HostId;Ljava/util/Map;I)Lfleet/plugins/intellij/workspace/BackendParametersBuilder;", "equals", "", "other", "hashCode", "toString", "Companion", "fleet.plugins.intellij.workspace"})
@SourceDebugExtension(value={"SMAP\nBackendParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendParameters.kt\nfleet/plugins/intellij/workspace/BackendParametersBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,538:1\n1187#2,2:539\n1261#2,4:541\n1557#2:547\n1628#2,3:548\n216#3,2:545\n10#4,2:551\n10#4,2:553\n10#4,2:555\n*S KotlinDebug\n*F\n+ 1 BackendParameters.kt\nfleet/plugins/intellij/workspace/BackendParametersBuilder\n*L\n175#1:539,2\n175#1:541,4\n239#1:547\n239#1:548,3\n192#1:545,2\n313#1:551,2\n350#1:553,2\n351#1:555,2\n*E\n"})
public final class BackendParametersBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IntellijBackendFlavour intellijBackendFlavour;
    @Nullable
    private final ProtocolPath userHomePath;
    @NotNull
    private final ProtocolPath ideaSystemPath;
    @NotNull
    private final ProtocolPath ideaConfigPath;
    @NotNull
    private final ProtocolPath ideaLogPath;
    @NotNull
    private final WorkspaceId workspaceId;
    @NotNull
    private final HostId workspaceHostId;
    @NotNull
    private final String workspaceHost;
    private final int workspacePort;
    @Nullable
    private final Integer debugPort;
    @NotNull
    private final UID processId;
    @NotNull
    private final HostId backendHostId;
    @NotNull
    private final Map<String, String> additionalOptions;
    private final int xmxMb;
    @NotNull
    private static final KLogger logger = KLoggers.INSTANCE.logger(BackendParametersBuilder.class);

    public BackendParametersBuilder(@NotNull IntellijBackendFlavour intellijBackendFlavour, @Nullable ProtocolPath userHomePath, @NotNull ProtocolPath ideaSystemPath, @NotNull ProtocolPath ideaConfigPath, @NotNull ProtocolPath ideaLogPath, @NotNull WorkspaceId workspaceId, @NotNull HostId workspaceHostId, @NotNull String workspaceHost, int workspacePort, @Nullable Integer debugPort, @NotNull UID processId, @NotNull HostId backendHostId, @NotNull Map<String, String> additionalOptions, int xmxMb) {
        Intrinsics.checkNotNullParameter((Object)intellijBackendFlavour, (String)"intellijBackendFlavour");
        Intrinsics.checkNotNullParameter((Object)ideaSystemPath, (String)"ideaSystemPath");
        Intrinsics.checkNotNullParameter((Object)ideaConfigPath, (String)"ideaConfigPath");
        Intrinsics.checkNotNullParameter((Object)ideaLogPath, (String)"ideaLogPath");
        Intrinsics.checkNotNullParameter((Object)workspaceId, (String)"workspaceId");
        Intrinsics.checkNotNullParameter((Object)workspaceHostId, (String)"workspaceHostId");
        Intrinsics.checkNotNullParameter((Object)workspaceHost, (String)"workspaceHost");
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        Intrinsics.checkNotNullParameter((Object)backendHostId, (String)"backendHostId");
        Intrinsics.checkNotNullParameter(additionalOptions, (String)"additionalOptions");
        this.intellijBackendFlavour = intellijBackendFlavour;
        this.userHomePath = userHomePath;
        this.ideaSystemPath = ideaSystemPath;
        this.ideaConfigPath = ideaConfigPath;
        this.ideaLogPath = ideaLogPath;
        this.workspaceId = workspaceId;
        this.workspaceHostId = workspaceHostId;
        this.workspaceHost = workspaceHost;
        this.workspacePort = workspacePort;
        this.debugPort = debugPort;
        this.processId = processId;
        this.backendHostId = backendHostId;
        this.additionalOptions = additionalOptions;
        this.xmxMb = xmxMb;
    }

    @NotNull
    public final IntellijBackendFlavour getIntellijBackendFlavour() {
        return this.intellijBackendFlavour;
    }

    @Nullable
    public final ProtocolPath getUserHomePath() {
        return this.userHomePath;
    }

    @NotNull
    public final ProtocolPath getIdeaSystemPath() {
        return this.ideaSystemPath;
    }

    @NotNull
    public final ProtocolPath getIdeaConfigPath() {
        return this.ideaConfigPath;
    }

    @NotNull
    public final ProtocolPath getIdeaLogPath() {
        return this.ideaLogPath;
    }

    @NotNull
    public final WorkspaceId getWorkspaceId() {
        return this.workspaceId;
    }

    @NotNull
    public final HostId getWorkspaceHostId() {
        return this.workspaceHostId;
    }

    @NotNull
    public final String getWorkspaceHost() {
        return this.workspaceHost;
    }

    public final int getWorkspacePort() {
        return this.workspacePort;
    }

    @Nullable
    public final Integer getDebugPort() {
        return this.debugPort;
    }

    @NotNull
    public final UID getProcessId() {
        return this.processId;
    }

    @NotNull
    public final HostId getBackendHostId() {
        return this.backendHostId;
    }

    @NotNull
    public final Map<String, String> getAdditionalOptions() {
        return this.additionalOptions;
    }

    public final int getXmxMb() {
        return this.xmxMb;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BackendParameters runFromSources(@Nullable ProtocolPath shutdownSocket) {
        List list;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String key;
        Object object;
        void $this$associateTo$iv$iv;
        Path ideaHome = FleetFromSourcesPaths.INSTANCE.getIntellijProjectRoot();
        ProtocolPath protocolPath = this.userHomePath;
        if (protocolPath == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Path userHome = protocolPath.toNio();
        Path ideaSystemPath = this.ideaSystemPath.toNio();
        Path ideaConfigPath = this.ideaConfigPath.toNio();
        Path ideaLogPath = this.ideaLogPath.toNio();
        String javaExe = fleet.util.os.Os.INSTANCE.isWindows() ? "java.exe" : "java";
        Path jdkHome = BackendParametersKt.access$getDocker$p() ? Paths.get("/usr/lib/jvm/java-17-amazon-corretto", new String[0]) : BackendParametersKt.access$locateJDK(javaExe);
        Path runConfiguration = ideaHome.resolve(".idea/runConfigurations/FleetBackend.xml");
        Intrinsics.checkNotNull((Object)runConfiguration);
        String runConfigurationText = PathsKt.readText$default((Path)runConfiguration, null, (int)1, null);
        String mainClass = BackendParametersBuilder.runFromSources$findTagValue(runConfigurationText, runConfiguration, "MAIN_CLASS_NAME");
        String vmOptionsText = BackendParametersBuilder.runFromSources$findTagValue(runConfigurationText, runConfiguration, "VM_PARAMETERS");
        ProtocolPath workDir = ProtocolPath.Companion.of(StringsKt.replace$default((String)BackendParametersBuilder.runFromSources$findTagValue(runConfigurationText, runConfiguration, "WORKING_DIRECTORY"), (String)"$PROJECT_DIR$", (String)((Object)ideaHome).toString(), (boolean)false, (int)4, null), Os.Companion.local());
        Regex regex = new Regex("<module\\s+name=\"(.+?)\"\\s*/>");
        Object object2 = Regex.find$default((Regex)regex, (CharSequence)runConfigurationText, (int)0, (int)2, null);
        if (object2 == null || (object2 = object2.getGroupValues()) == null || (object2 = (String)object2.get(1)) == null) {
            throw new Exception("Module not found in " + runConfiguration);
        }
        Object mainModule = object2;
        if (StringsKt.contains$default((CharSequence)vmOptionsText, (CharSequence)"\"", (boolean)false, (int)2, null)) {
            throw new Exception("VM options parsing not implemented for quited argument");
        }
        String[] stringArray = new String[]{" "};
        Iterable $this$associate$iv = StringsKt.split$default((CharSequence)vmOptionsText, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean bl = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Pair pair;
            Map map2 = destination$iv$iv;
            String vmOption = (String)element$iv$iv;
            boolean bl2 = false;
            if (StringsKt.startsWith$default((String)vmOption, (String)"-X", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)vmOption, (String)"-D", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)vmOption, (String)"-agentlib", (boolean)false, (int)2, null)) {
                object = new char[]{'='};
                List options = StringsKt.split$default((CharSequence)vmOption, (char[])object, (boolean)false, (int)2, (int)2, null);
                pair = TuplesKt.to(options.get(0), (Object)CollectionsKt.getOrNull((List)options, (int)1));
            } else {
                pair = TuplesKt.to((Object)vmOption, null);
            }
            vmOption = pair;
            map2.put(vmOption.getFirst(), vmOption.getSecond());
        }
        Map vmOptions = MapsKt.toMutableMap((Map)destination$iv$iv);
        String realWorkspaceHost = BackendParametersKt.access$getDocker$p() && (Intrinsics.areEqual((Object)this.workspaceHost, (Object)"localhost") || Intrinsics.areEqual((Object)this.workspaceHost, (Object)"127.0.0.1")) ? "host.docker.internal" : this.workspaceHost;
        HostId realBackendHostId = BackendParametersKt.access$getDocker$p() ? new HostId(UID.Companion.random()) : this.backendHostId;
        vmOptions.put("-XX:HeapDumpPath", ((Object)ideaLogPath).toString());
        vmOptions.put("-Dfleet.workspace.host", realWorkspaceHost);
        vmOptions.put("-Dfleet.workspace.port", String.valueOf(this.workspacePort));
        vmOptions.put("-Dfleet.backend.process.id", this.processId.toString());
        vmOptions.put("-Dfleet.backend.host.id", realBackendHostId.getUid().getId());
        Map<String, String> $this$forEach$iv = this.additionalOptions;
        boolean $i$f$forEach = false;
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            Map.Entry entry2 = entry;
            boolean bl3 = false;
            key = (String)entry2.getKey();
            String value = (String)entry2.getValue();
            vmOptions.put("-D" + key, value);
        }
        Iterator iterator = vmOptions.entrySet().iterator();
        while (iterator.hasNext()) {
            if (!StringsKt.startsWith$default((String)((String)iterator.next().getKey()), (String)"-Xmx", (boolean)false, (int)2, null)) continue;
            iterator.remove();
        }
        vmOptions.put("-Xmx" + this.xmxMb + "m", null);
        if (this.xmxMb < 1000) {
            vmOptions.put("-XX:MaxDirectMemorySize", "850m");
        }
        if (FleetPropertiesKt.isFleetDevMode()) {
            vmOptions.put("-Dfleet.dev.mode", "true");
        }
        if (!Intrinsics.areEqual((Object)System.getProperty("fleet.backend.debug"), (Object)"false")) {
            String suspend = Intrinsics.areEqual((Object)System.getProperty("fleet.backend.debug.suspend"), (Object)"y") ? "y" : "n";
            String address = this.debugPort != null && this.debugPort > 0 ? ",address=*:" + this.debugPort : "";
            vmOptions.put("-agentlib:jdwp", "transport=dt_socket,server=y,suspend=" + suspend + address);
        }
        if (BackendParametersKt.access$getDocker$p()) {
            vmOptions.put("-Didea.home.path", ((Object)ideaHome).toString());
        }
        vmOptions.put("-Didea.log.path", ((Object)ideaLogPath).toString());
        vmOptions.put("-Didea.config.path", ((Object)ideaConfigPath).toString());
        vmOptions.put("-Didea.system.path", ((Object)ideaSystemPath).toString());
        String string = System.getProperty("fleet.log.config.path");
        if (string != null) {
            String string2 = string;
            boolean bl4 = false;
            vmOptions.put("-Dfleet.log.config.path", string2);
        }
        List args = new ArrayList();
        Path path = jdkHome.resolve("bin").resolve(javaExe);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String executable = ((Object)path.toAbsolutePath()).toString();
        List list2 = new ArrayList();
        if (Boolean.parseBoolean(System.getProperty("FLEET.BACKEND.RUNNING.FROM.TEST"))) {
            vmOptions.put("-Dij.dir.lock.timeout", String.valueOf(Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES))));
            if (shutdownSocket != null) {
                ((Collection)list2).add("--shutdown-socket");
                ((Collection)list2).add(shutdownSocket.joinToString());
            }
        }
        Iterable bl4 = vmOptions.entrySet();
        List list22 = args;
        boolean $i$f$map = false;
        key = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            Object item$iv$iv = object.next();
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            String key2 = (String)entry.getKey();
            String value = (String)entry.getValue();
            collection.add(value != null ? key2 + "=" + value : key2);
        }
        list22.addAll((List)destination$iv$iv2);
        args.addAll(BackendParametersKt.access$getAddOpensOptions());
        List ideaClassPath = LaunchFromSourceKt.loadClasspath(ideaHome, userHome, (String)mainModule);
        if (BackendParametersKt.access$getDocker$p()) {
            list = ideaClassPath;
        } else {
            Intrinsics.checkNotNull((Object)jdkHome);
            list = CollectionsKt.plus((Collection)BackendParametersKt.access$findToolsJar(jdkHome), (Iterable)ideaClassPath);
        }
        List classPath = list;
        Path tmpFile = BackendParametersKt.access$writeClassPathToFile(classPath);
        args.add("@" + tmpFile.toAbsolutePath());
        ((Collection)args).add(mainClass);
        ((Collection)args).add("FleetStarter");
        ((Collection)args).add(realWorkspaceHost);
        ((Collection)args).add(String.valueOf(this.workspacePort));
        ((Collection)args).add(realBackendHostId.toString());
        args.addAll(list2);
        if (BackendParametersKt.access$getDocker$p()) {
            String[] stringArray2;
            String dockerExecutable = "docker";
            object = new SpreadBuilder(22);
            object.add((Object)"run");
            object.addSpread((Object)BackendParametersKt.access$mountVolume(ideaHome + "/.idea"));
            object.addSpread((Object)BackendParametersKt.access$mountVolume(ideaHome + "/out/kotlin-dist"));
            object.addSpread((Object)BackendParametersKt.access$mountVolume(ideaHome + "/out/classes/production"));
            object.addSpread((Object)BackendParametersKt.access$mountVolume(ideaHome + "/lib"));
            object.addSpread((Object)BackendParametersKt.access$mountVolume(ideaHome + "/community/.idea"));
            object.addSpread((Object)BackendParametersKt.access$mountVolume(ideaHome + "/community/bin"));
            object.addSpread((Object)BackendParametersKt.access$mountVolume(ideaHome + "/community/lib"));
            object.addSpread((Object)BackendParametersKt.access$mountVolume(ideaHome + "/community/java/jdkAnnotations"));
            object.addSpread((Object)BackendParametersKt.access$mountVolume(ideaHome + "/community/xml/relaxng/lib"));
            object.addSpread((Object)BackendParametersKt.access$mountVolume(ideaHome + "/community/plugins/editorconfig/lib"));
            object.addSpread((Object)BackendParametersKt.access$mountVolume(ideaHome + "/community/plugins/maven-server-api/lib"));
            object.addSpread((Object)BackendParametersKt.access$mountVolume(ideaHome + "/community/plugins/maven/maven3-server-common/lib"));
            object.addSpread((Object)BackendParametersKt.access$mountVolume(ideaHome + "/community/plugins/maven/maven36-server-impl/lib/maven3"));
            object.addSpread((Object)BackendParametersKt.access$mountVolume(((Object)LaunchFromSourceKt.getLocalMavenRepoPath(userHome)).toString(), ((Object)LaunchFromSourceKt.getTargetMavenRepoPath(userHome)).toString()));
            object.addSpread((Object)BackendParametersKt.access$mountVolume(((Object)tmpFile.toAbsolutePath()).toString()));
            object.addSpread((Object)BackendParametersKt.access$mountVolume(ideaHome + "/system/fleet.backend", "/system/fleet.backend"));
            object.addSpread((Object)BackendParametersKt.access$mountVolume(ideaHome + "/fleet/backend/build/fleet_backend.properties", "/fleet/backend/build/fleet_backend.properties"));
            Path path2 = userHome.resolve(".fleet");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            object.addSpread((Object)BackendParametersKt.access$mountVolume(((Object)path2).toString(), "/root/.fleet"));
            if (this.debugPort != null && this.debugPort > 0) {
                String[] stringArray3 = new String[]{"-p", this.debugPort + ":" + this.debugPort};
                stringArray2 = stringArray3;
            } else {
                stringArray2 = new String[]{};
            }
            object.addSpread((Object)stringArray2);
            object.addSpread((Object)BackendParametersKt.access$withRestartWithExitCode());
            object.add((Object)"amazoncorretto:17");
            List dockerArgs = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])object.toArray((Object[])new String[object.size()])), (Object)executable), (Iterable)args);
            return new BackendParameters(dockerExecutable, dockerArgs, workDir, this.ideaLogPath, this.intellijBackendFlavour, this.workspaceHostId, this.backendHostId, (Function1<? super Map<String, String>, Unit>)((Function1)runFromSources.4.INSTANCE));
        }
        return new BackendParameters(executable, args, workDir, this.ideaLogPath, this.intellijBackendFlavour, this.workspaceHostId, this.backendHostId, (Function1<? super Map<String, String>, Unit>)((Function1)runFromSources.5.INSTANCE));
    }

    @NotNull
    public final BackendParameters runExecutable(@NotNull ProtocolPath binary, @Nullable ProtocolPath shutdownSocket) {
        Object $i$a$-runCatching-BackendParametersBuilder$runExecutable$backendVmoptionsFile$22;
        Object object;
        KLogger kLogger;
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        KLogger this_$iv = logger;
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            kLogger = this_$iv;
            boolean bl = false;
            kLogger.debug((Object)("Launching Backend from distribution [" + binary + "]"));
        }
        HostEntity backendHostEntity = HostKt.host((HostId)this.backendHostId);
        List args = new ArrayList();
        if (PlatformKt.isUnix((Os)HostKt.getFs((HostEntity)backendHostEntity).getOs())) {
            object = "./" + binary.getName();
        } else {
            ((Collection)args).add("/C");
            ((Collection)args).add(binary.getName());
            object = "cmd";
        }
        String executable = object;
        ((Collection)args).add("FleetStarter");
        ((Collection)args).add(this.workspaceHost);
        ((Collection)args).add(String.valueOf(this.workspacePort));
        ((Collection)args).add(this.backendHostId.getUid().toString());
        ((Collection)args).add(this.processId.toString());
        Map additionalOptions = MapsKt.toMutableMap(this.additionalOptions);
        if (Boolean.parseBoolean(System.getProperty("FLEET.BACKEND.RUNNING.FROM.TEST"))) {
            additionalOptions.put("-Dij.dir.lock.timeout", String.valueOf(Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES))));
            if (shutdownSocket != null) {
                ((Collection)args).add("--shutdown-socket");
                ((Collection)args).add(shutdownSocket.joinToString());
            }
        }
        String backendPropertiesFile = BackendParametersKt.access$writePropertiesFile(this.ideaSystemPath, this.ideaConfigPath, this.ideaLogPath, additionalOptions);
        try {
            boolean $i$a$-runCatching-BackendParametersBuilder$runExecutable$backendVmoptionsFile$22 = false;
            Path path = Path.of(binary.joinToString(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            $i$a$-runCatching-BackendParametersBuilder$runExecutable$backendVmoptionsFile$22 = Result.constructor-impl((Object)BackendParametersKt.access$writeVmoptionsFile(path, this.xmxMb, this.debugPort));
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-BackendParametersBuilder$runExecutable$backendVmoptionsFile$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object backendVmoptionsFile = $i$a$-runCatching-BackendParametersBuilder$runExecutable$backendVmoptionsFile$22;
        KLogger this_$iv2 = logger;
        boolean $i$f$debug2 = false;
        if (this_$iv2.isDebugEnabled()) {
            kLogger = this_$iv2;
            boolean bl = false;
            kLogger.debug((Object)("Writing IntelliJ Backend properties file: " + backendPropertiesFile));
        }
        this_$iv2 = logger;
        $i$f$debug2 = false;
        if (this_$iv2.isDebugEnabled()) {
            kLogger = this_$iv2;
            boolean bl = false;
            kLogger.debug((Object)("Writing IntelliJ Backend vmoptions file: " + Result.toString-impl((Object)backendVmoptionsFile)));
        }
        Function1 environmentAugmenter2 = (Function1)new Function1<Map<String, String>, Unit>(backendPropertiesFile, backendVmoptionsFile){
            final /* synthetic */ String $backendPropertiesFile;
            final /* synthetic */ Object $backendVmoptionsFile;
            {
                this.$backendPropertiesFile = $backendPropertiesFile;
                this.$backendVmoptionsFile = $backendVmoptionsFile;
                super(1);
            }

            public final void invoke(Map<String, String> environment) {
                String customJavaPath;
                Intrinsics.checkNotNullParameter(environment, (String)"environment");
                environment.put("FLEET_BACKEND_PROPERTIES", this.$backendPropertiesFile);
                Object object = this.$backendVmoptionsFile;
                if (Result.isSuccess-impl((Object)object)) {
                    String file = (String)object;
                    boolean bl = false;
                    environment.put("FLEET_BACKEND_VM_OPTIONS", file);
                }
                if ((customJavaPath = FleetPropertiesKt.fleetProperty$default((String)"fleet.backend.java", null, (int)2, null)) != null) {
                    environment.put("FLEET_BACKEND_JDK", customJavaPath);
                }
                environment.put("_", "");
                BackendParametersKt.access$withRestartWithExitCode(environment);
            }
        };
        ProtocolPath protocolPath = binary.parent();
        if (protocolPath == null) {
            throw new IllegalStateException(("Parent directory of the binary does not exist (path to binary is " + binary + ")").toString());
        }
        ProtocolPath workingDir = protocolPath;
        return new BackendParameters(executable, args, workingDir, this.ideaLogPath, this.intellijBackendFlavour, this.workspaceHostId, this.backendHostId, (Function1<? super Map<String, String>, Unit>)environmentAugmenter2);
    }

    @NotNull
    public final IntellijBackendFlavour component1() {
        return this.intellijBackendFlavour;
    }

    @Nullable
    public final ProtocolPath component2() {
        return this.userHomePath;
    }

    @NotNull
    public final ProtocolPath component3() {
        return this.ideaSystemPath;
    }

    @NotNull
    public final ProtocolPath component4() {
        return this.ideaConfigPath;
    }

    @NotNull
    public final ProtocolPath component5() {
        return this.ideaLogPath;
    }

    @NotNull
    public final WorkspaceId component6() {
        return this.workspaceId;
    }

    @NotNull
    public final HostId component7() {
        return this.workspaceHostId;
    }

    @NotNull
    public final String component8() {
        return this.workspaceHost;
    }

    public final int component9() {
        return this.workspacePort;
    }

    @Nullable
    public final Integer component10() {
        return this.debugPort;
    }

    @NotNull
    public final UID component11() {
        return this.processId;
    }

    @NotNull
    public final HostId component12() {
        return this.backendHostId;
    }

    @NotNull
    public final Map<String, String> component13() {
        return this.additionalOptions;
    }

    public final int component14() {
        return this.xmxMb;
    }

    @NotNull
    public final BackendParametersBuilder copy(@NotNull IntellijBackendFlavour intellijBackendFlavour, @Nullable ProtocolPath userHomePath, @NotNull ProtocolPath ideaSystemPath, @NotNull ProtocolPath ideaConfigPath, @NotNull ProtocolPath ideaLogPath, @NotNull WorkspaceId workspaceId, @NotNull HostId workspaceHostId, @NotNull String workspaceHost, int workspacePort, @Nullable Integer debugPort, @NotNull UID processId, @NotNull HostId backendHostId, @NotNull Map<String, String> additionalOptions, int xmxMb) {
        Intrinsics.checkNotNullParameter((Object)intellijBackendFlavour, (String)"intellijBackendFlavour");
        Intrinsics.checkNotNullParameter((Object)ideaSystemPath, (String)"ideaSystemPath");
        Intrinsics.checkNotNullParameter((Object)ideaConfigPath, (String)"ideaConfigPath");
        Intrinsics.checkNotNullParameter((Object)ideaLogPath, (String)"ideaLogPath");
        Intrinsics.checkNotNullParameter((Object)workspaceId, (String)"workspaceId");
        Intrinsics.checkNotNullParameter((Object)workspaceHostId, (String)"workspaceHostId");
        Intrinsics.checkNotNullParameter((Object)workspaceHost, (String)"workspaceHost");
        Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
        Intrinsics.checkNotNullParameter((Object)backendHostId, (String)"backendHostId");
        Intrinsics.checkNotNullParameter(additionalOptions, (String)"additionalOptions");
        return new BackendParametersBuilder(intellijBackendFlavour, userHomePath, ideaSystemPath, ideaConfigPath, ideaLogPath, workspaceId, workspaceHostId, workspaceHost, workspacePort, debugPort, processId, backendHostId, additionalOptions, xmxMb);
    }

    public static /* synthetic */ BackendParametersBuilder copy$default(BackendParametersBuilder backendParametersBuilder, IntellijBackendFlavour intellijBackendFlavour, ProtocolPath protocolPath, ProtocolPath protocolPath2, ProtocolPath protocolPath3, ProtocolPath protocolPath4, WorkspaceId workspaceId, HostId hostId, String string, int n, Integer n2, UID uID, HostId hostId2, Map map2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            intellijBackendFlavour = backendParametersBuilder.intellijBackendFlavour;
        }
        if ((n4 & 2) != 0) {
            protocolPath = backendParametersBuilder.userHomePath;
        }
        if ((n4 & 4) != 0) {
            protocolPath2 = backendParametersBuilder.ideaSystemPath;
        }
        if ((n4 & 8) != 0) {
            protocolPath3 = backendParametersBuilder.ideaConfigPath;
        }
        if ((n4 & 0x10) != 0) {
            protocolPath4 = backendParametersBuilder.ideaLogPath;
        }
        if ((n4 & 0x20) != 0) {
            workspaceId = backendParametersBuilder.workspaceId;
        }
        if ((n4 & 0x40) != 0) {
            hostId = backendParametersBuilder.workspaceHostId;
        }
        if ((n4 & 0x80) != 0) {
            string = backendParametersBuilder.workspaceHost;
        }
        if ((n4 & 0x100) != 0) {
            n = backendParametersBuilder.workspacePort;
        }
        if ((n4 & 0x200) != 0) {
            n2 = backendParametersBuilder.debugPort;
        }
        if ((n4 & 0x400) != 0) {
            uID = backendParametersBuilder.processId;
        }
        if ((n4 & 0x800) != 0) {
            hostId2 = backendParametersBuilder.backendHostId;
        }
        if ((n4 & 0x1000) != 0) {
            map2 = backendParametersBuilder.additionalOptions;
        }
        if ((n4 & 0x2000) != 0) {
            n3 = backendParametersBuilder.xmxMb;
        }
        return backendParametersBuilder.copy(intellijBackendFlavour, protocolPath, protocolPath2, protocolPath3, protocolPath4, workspaceId, hostId, string, n, n2, uID, hostId2, map2, n3);
    }

    @NotNull
    public String toString() {
        return "BackendParametersBuilder(intellijBackendFlavour=" + this.intellijBackendFlavour + ", userHomePath=" + this.userHomePath + ", ideaSystemPath=" + this.ideaSystemPath + ", ideaConfigPath=" + this.ideaConfigPath + ", ideaLogPath=" + this.ideaLogPath + ", workspaceId=" + this.workspaceId + ", workspaceHostId=" + this.workspaceHostId + ", workspaceHost=" + this.workspaceHost + ", workspacePort=" + this.workspacePort + ", debugPort=" + this.debugPort + ", processId=" + this.processId + ", backendHostId=" + this.backendHostId + ", additionalOptions=" + this.additionalOptions + ", xmxMb=" + this.xmxMb + ")";
    }

    public int hashCode() {
        int result2 = this.intellijBackendFlavour.hashCode();
        result2 = result2 * 31 + (this.userHomePath == null ? 0 : this.userHomePath.hashCode());
        result2 = result2 * 31 + this.ideaSystemPath.hashCode();
        result2 = result2 * 31 + this.ideaConfigPath.hashCode();
        result2 = result2 * 31 + this.ideaLogPath.hashCode();
        result2 = result2 * 31 + this.workspaceId.hashCode();
        result2 = result2 * 31 + this.workspaceHostId.hashCode();
        result2 = result2 * 31 + this.workspaceHost.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.workspacePort);
        result2 = result2 * 31 + (this.debugPort == null ? 0 : ((Object)this.debugPort).hashCode());
        result2 = result2 * 31 + this.processId.hashCode();
        result2 = result2 * 31 + this.backendHostId.hashCode();
        result2 = result2 * 31 + ((Object)this.additionalOptions).hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.xmxMb);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BackendParametersBuilder)) {
            return false;
        }
        BackendParametersBuilder backendParametersBuilder = (BackendParametersBuilder)other;
        if (!Intrinsics.areEqual((Object)this.intellijBackendFlavour, (Object)backendParametersBuilder.intellijBackendFlavour)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.userHomePath, (Object)backendParametersBuilder.userHomePath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.ideaSystemPath, (Object)backendParametersBuilder.ideaSystemPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.ideaConfigPath, (Object)backendParametersBuilder.ideaConfigPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.ideaLogPath, (Object)backendParametersBuilder.ideaLogPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.workspaceId, (Object)backendParametersBuilder.workspaceId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.workspaceHostId, (Object)backendParametersBuilder.workspaceHostId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.workspaceHost, (Object)backendParametersBuilder.workspaceHost)) {
            return false;
        }
        if (this.workspacePort != backendParametersBuilder.workspacePort) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.debugPort, (Object)backendParametersBuilder.debugPort)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.processId, (Object)backendParametersBuilder.processId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.backendHostId, (Object)backendParametersBuilder.backendHostId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.additionalOptions, backendParametersBuilder.additionalOptions)) {
            return false;
        }
        return this.xmxMb == backendParametersBuilder.xmxMb;
    }

    private static final String runFromSources$findTagValue(String runConfigurationText, Path runConfiguration, String tag) {
        Regex regex = new Regex("<option name=\"" + tag + "\" value=\"(.+?)\"\\s?/>");
        Object object = Regex.find$default((Regex)regex, (CharSequence)runConfigurationText, (int)0, (int)2, null);
        if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
            throw new Exception(tag + " not found in " + runConfiguration);
        }
        return object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u009d\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u001e2\u0006\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lfleet/plugins/intellij/workspace/BackendParametersBuilder$Companion;", "", "<init>", "()V", "logger", "Lfleet/util/logging/KLogger;", "prepare", "Lfleet/plugins/intellij/workspace/BackendParameters;", "intellijBackendFlavour", "Lfleet/plugins/intellij/workspace/IntellijBackendFlavour;", "userHomePath", "Lfleet/api/ProtocolPath;", "ideaSystemPath", "ideaConfigPath", "ideaLogPath", "workspaceId", "Lfleet/api/WorkspaceId;", "workspaceHostId", "Lfleet/api/HostId;", "workspaceHost", "", "workspacePort", "", "debugPort", "processId", "Lfleet/util/UID;", "backendHostId", "backendRequirements", "Lfleet/plugins/smartMode/protocol/BackendRequirements;", "additionalOptions", "", "xmxMb", "shutdownSocket", "(Lfleet/plugins/intellij/workspace/IntellijBackendFlavour;Lfleet/api/ProtocolPath;Lfleet/api/ProtocolPath;Lfleet/api/ProtocolPath;Lfleet/api/ProtocolPath;Lfleet/api/WorkspaceId;Lfleet/api/HostId;Ljava/lang/String;ILjava/lang/Integer;Lfleet/util/UID;Lfleet/api/HostId;Lfleet/plugins/smartMode/protocol/BackendRequirements;Ljava/util/Map;ILfleet/api/ProtocolPath;)Lfleet/plugins/intellij/workspace/BackendParameters;", "fleet.plugins.intellij.workspace"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackendParameters prepare(@NotNull IntellijBackendFlavour intellijBackendFlavour, @Nullable ProtocolPath userHomePath, @NotNull ProtocolPath ideaSystemPath, @NotNull ProtocolPath ideaConfigPath, @NotNull ProtocolPath ideaLogPath, @NotNull WorkspaceId workspaceId, @NotNull HostId workspaceHostId, @NotNull String workspaceHost, int workspacePort, @Nullable Integer debugPort, @NotNull UID processId, @NotNull HostId backendHostId, @NotNull BackendRequirements backendRequirements, @NotNull Map<String, String> additionalOptions, int xmxMb, @Nullable ProtocolPath shutdownSocket) {
            BackendParameters backendParameters;
            Intrinsics.checkNotNullParameter((Object)intellijBackendFlavour, (String)"intellijBackendFlavour");
            Intrinsics.checkNotNullParameter((Object)ideaSystemPath, (String)"ideaSystemPath");
            Intrinsics.checkNotNullParameter((Object)ideaConfigPath, (String)"ideaConfigPath");
            Intrinsics.checkNotNullParameter((Object)ideaLogPath, (String)"ideaLogPath");
            Intrinsics.checkNotNullParameter((Object)workspaceId, (String)"workspaceId");
            Intrinsics.checkNotNullParameter((Object)workspaceHostId, (String)"workspaceHostId");
            Intrinsics.checkNotNullParameter((Object)workspaceHost, (String)"workspaceHost");
            Intrinsics.checkNotNullParameter((Object)processId, (String)"processId");
            Intrinsics.checkNotNullParameter((Object)backendHostId, (String)"backendHostId");
            Intrinsics.checkNotNullParameter((Object)backendRequirements, (String)"backendRequirements");
            Intrinsics.checkNotNullParameter(additionalOptions, (String)"additionalOptions");
            Map updatedAdditionalOptions = BackendParametersKt.access$getUpdatedAdditionalOptions(additionalOptions, backendRequirements);
            BackendParametersBuilder builder = new BackendParametersBuilder(intellijBackendFlavour, userHomePath, ideaSystemPath, ideaConfigPath, ideaLogPath, workspaceId, workspaceHostId, workspaceHost, workspacePort, debugPort, processId, backendHostId, updatedAdditionalOptions, xmxMb);
            IntellijBackendFlavour intellijBackendFlavour2 = intellijBackendFlavour;
            if (intellijBackendFlavour2 instanceof IntellijBackendFlavour.FromSources) {
                backendParameters = builder.runFromSources(shutdownSocket);
            } else if (intellijBackendFlavour2 instanceof IntellijBackendFlavour.FromExecutable) {
                backendParameters = builder.runExecutable(((IntellijBackendFlavour.FromExecutable)intellijBackendFlavour).getExecutablePath(), shutdownSocket);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return backendParameters;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

