/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.navigation;

import andel.text.Text;
import andel.text.TextLines;
import andel.text.TextView;
import andel.text.TextViewExtKt;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import fleet.api.FileAddress;
import fleet.common.document.DocumentEntity;
import fleet.common.document.DocumentEntityKt;
import fleet.common.document.SharedOpenedFileEntity;
import fleet.frontend.navigation.NavigationLocation;
import fleet.kernel.DurableEntityKt;
import fleet.util.StringKt;
import fleet.util.UID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0001H\u0000\u001a_\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2:\u0010\u000f\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u0002H\n0\u0010H\u0002\u00a2\u0006\u0002\u0010\u0015\u001a8\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000eH\u0002\"\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"lookupDocument", "Lfleet/common/document/DocumentEntity;", "Lfleet/frontend/navigation/NavigationLocation;", "fileAddress", "Lfleet/api/FileAddress;", "getFileAddress", "(Lfleet/frontend/navigation/NavigationLocation;)Lfleet/api/FileAddress;", "navigationLocation", "Lfleet/frontend/navigation/NavigationLocation$Document;", "withLineRange", "T", "text", "Landel/text/Text;", "lineNumber", "", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "lineStartOffset", "nextLineStartOffset", "(Landel/text/Text;JLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "correctOffset", "offset", "line", "", "originalLineStartOffset", "charsCount", "fleet.frontend"})
@SourceDebugExtension(value={"SMAP\nNavigationPosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigationPosition.kt\nfleet/frontend/navigation/NavigationPositionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
public final class NavigationPositionKt {
    @Nullable
    public static final DocumentEntity lookupDocument(@NotNull NavigationLocation $this$lookupDocument) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$lookupDocument, (String)"<this>");
        NavigationLocation navigationLocation = $this$lookupDocument;
        if (navigationLocation instanceof NavigationLocation.Document) {
            object = (DocumentEntity)DurableEntityKt.byUidOrNull((UID)((NavigationLocation.Document)$this$lookupDocument).getDocumentId());
            if (object == null) {
                FileAddress fileAddress = ((NavigationLocation.Document)$this$lookupDocument).getFallbackFileAddress();
                if (fileAddress != null) {
                    FileAddress it = fileAddress;
                    boolean bl = false;
                    SharedOpenedFileEntity sharedOpenedFileEntity = (SharedOpenedFileEntity)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)SharedOpenedFileEntity.Companion.getFileAddressAttr()), (Object)it);
                    object = sharedOpenedFileEntity != null ? sharedOpenedFileEntity.getDocumentEntity() : null;
                } else {
                    object = null;
                }
            }
        } else if (navigationLocation instanceof NavigationLocation.File) {
            SharedOpenedFileEntity sharedOpenedFileEntity = (SharedOpenedFileEntity)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)SharedOpenedFileEntity.Companion.getFileAddressAttr()), (Object)((NavigationLocation.File)$this$lookupDocument).getFileAddress());
            object = sharedOpenedFileEntity != null ? sharedOpenedFileEntity.getDocumentEntity() : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Nullable
    public static final FileAddress getFileAddress(@NotNull NavigationLocation $this$fileAddress) {
        FileAddress fileAddress;
        Intrinsics.checkNotNullParameter((Object)$this$fileAddress, (String)"<this>");
        NavigationLocation navigationLocation = $this$fileAddress;
        if (navigationLocation instanceof NavigationLocation.File) {
            fileAddress = ((NavigationLocation.File)$this$fileAddress).getFileAddress();
        } else if (navigationLocation instanceof NavigationLocation.Document) {
            fileAddress = (DocumentEntity)DurableEntityKt.byUidOrNull((UID)((NavigationLocation.Document)$this$fileAddress).getDocumentId());
            if (fileAddress == null || (fileAddress = DocumentEntityKt.getLocationFileAddress((DocumentEntity)fileAddress)) == null) {
                fileAddress = ((NavigationLocation.Document)$this$fileAddress).getFallbackFileAddress();
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return fileAddress;
    }

    @NotNull
    public static final NavigationLocation.Document navigationLocation(@NotNull DocumentEntity $this$navigationLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$navigationLocation, (String)"<this>");
        return new NavigationLocation.Document($this$navigationLocation.getUid(), DocumentEntityKt.getVersion((DocumentEntity)$this$navigationLocation), null, 4, null);
    }

    private static final <T> T withLineRange(Text text2, long lineNumber, Function2<? super Long, ? super Long, ? extends T> block) {
        TextLines lines = TextViewExtKt.textLines$default((TextView)text2.view(), (boolean)false, (int)1, null);
        long linesCount = text2.getLineCount-bcnjDHU();
        if (lineNumber >= linesCount) {
            return (T)block.invoke(null, null);
        }
        long lineStartOffset = lines.lineStartOffset(lineNumber);
        long nextLineOffset = lineNumber + 1L < linesCount ? lines.lineStartOffset(lineNumber + 1L) : (long)text2.getCharCount();
        return (T)block.invoke((Object)lineStartOffset, (Object)nextLineOffset);
    }

    private static final long correctOffset(long offset, String line, long lineStartOffset, long nextLineStartOffset, long originalLineStartOffset, long charsCount) {
        long lineLength;
        long offsetInLine = StringKt.offset8to16((String)line, (int)((int)(offset - originalLineStartOffset)));
        return RangesKt.coerceIn((long)(offsetInLine > (lineLength = nextLineStartOffset - lineStartOffset) ? nextLineStartOffset : offsetInLine + lineStartOffset), (long)0L, (long)charsCount);
    }

    public static final /* synthetic */ Object access$withLineRange(Text text2, long lineNumber, Function2 block) {
        return NavigationPositionKt.withLineRange(text2, lineNumber, block);
    }

    public static final /* synthetic */ long access$correctOffset(long offset, String line, long lineStartOffset, long nextLineStartOffset, long originalLineStartOffset, long charsCount) {
        return NavigationPositionKt.correctOffset(offset, line, lineStartOffset, nextLineStartOffset, originalLineStartOffset, charsCount);
    }
}

