/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.editor;

import andel.editor.Document;
import andel.editor.Editor;
import andel.editor.EditorLayout;
import andel.editor.MultiCaret;
import andel.intervals.Intervals;
import andel.lines.Fold;
import andel.lines.Inlay;
import andel.lines.Interline;
import andel.lines.LinesCache;
import andel.lines.Postline;
import andel.text.TextRange;
import andel.undo.UndoLog;
import fleet.common.document.DocumentEntity;
import fleet.common.document.DocumentEntityKt;
import fleet.common.document.EditorEntity;
import fleet.common.document.UndoLogEntityKt;
import fleet.common.user.UserEntity;
import fleet.frontend.editor.ComposableTextKt;
import fleet.frontend.editor.ComposableTextRangeEntity;
import fleet.frontend.editor.EditorEntityExtKt;
import fleet.frontend.editor.EditorLayoutEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lfleet/frontend/editor/EditorFromEntity;", "Landel/editor/Editor;", "editor", "Lfleet/common/document/EditorEntity;", "oneLine", "", "<init>", "(Lfleet/common/document/EditorEntity;Z)V", "getEditor", "()Lfleet/common/document/EditorEntity;", "getOneLine", "()Z", "document", "Landel/editor/Document;", "getDocument", "()Landel/editor/Document;", "multiCaret", "Landel/editor/MultiCaret;", "getMultiCaret", "()Landel/editor/MultiCaret;", "writable", "getWritable", "undoLog", "Landel/undo/UndoLog;", "getUndoLog", "()Landel/undo/UndoLog;", "composableTextRange", "Landel/text/TextRange;", "getComposableTextRange", "()Landel/text/TextRange;", "layout", "Landel/editor/EditorLayout;", "getLayout", "()Landel/editor/EditorLayout;", "fleet.frontend"})
public final class EditorFromEntity
implements Editor {
    @NotNull
    private final EditorEntity editor;
    private final boolean oneLine;

    public EditorFromEntity(@NotNull EditorEntity editor2, boolean oneLine) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.oneLine = oneLine;
    }

    @NotNull
    public final EditorEntity getEditor() {
        return this.editor;
    }

    public boolean getOneLine() {
        return this.oneLine;
    }

    @NotNull
    public Document getDocument() {
        return DocumentEntityKt.asDocument((DocumentEntity)this.editor.getDocument());
    }

    @NotNull
    public MultiCaret getMultiCaret() {
        return EditorEntityExtKt.getMultiCaret(this.editor);
    }

    public boolean getWritable() {
        return this.editor.getDocument().getWritable();
    }

    @NotNull
    public UndoLog getUndoLog() {
        return (UndoLog)UndoLogEntityKt.getUndoLog((DocumentEntity)this.editor.getDocument(), (UserEntity)this.editor.getUser());
    }

    @Nullable
    public TextRange getComposableTextRange() {
        ComposableTextRangeEntity composableTextRangeEntity = ComposableTextKt.getComposableTextRangeEntity(this.editor);
        return composableTextRangeEntity != null ? composableTextRangeEntity.getRange() : null;
    }

    @NotNull
    public EditorLayout getLayout() {
        return new EditorLayout(this){
            private final EditorLayoutEntity layout;
            {
                this.layout = EditorEntityExtKt.getLayout($receiver.getEditor());
            }

            public final EditorLayoutEntity getLayout() {
                return this.layout;
            }

            public LinesCache getLinesCache() {
                EditorLayoutEntity editorLayoutEntity = this.layout;
                Intrinsics.checkNotNull((Object)editorLayoutEntity);
                return editorLayoutEntity.getLinesCache();
            }

            public Intervals<?, Inlay> getInlays() {
                EditorLayoutEntity editorLayoutEntity = this.layout;
                Intrinsics.checkNotNull((Object)editorLayoutEntity);
                return editorLayoutEntity.getEditorMarkup().getInlays();
            }

            public Intervals<?, Fold> getFolds() {
                Intervals<Long, Fold> intervals = this.layout;
                if (intervals == null || (intervals = intervals.getEditorMarkup()) == null || (intervals = intervals.getFolds()) == null) {
                    intervals = Intervals.Companion.empty();
                }
                return intervals;
            }

            public Intervals<?, Postline> getPostlines() {
                Intervals<Long, Postline> intervals = this.layout;
                if (intervals == null || (intervals = intervals.getEditorMarkup()) == null || (intervals = intervals.getPostlines()) == null) {
                    intervals = Intervals.Companion.empty();
                }
                return intervals;
            }

            public Intervals<?, Interline> getInterlines() {
                Intervals<Long, Interline> intervals = this.layout;
                if (intervals == null || (intervals = intervals.getEditorMarkup()) == null || (intervals = intervals.getInterlines()) == null) {
                    intervals = Intervals.Companion.empty();
                }
                return intervals;
            }
        };
    }
}

