/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.editor;

import andel.editor.DocumentComponent;
import andel.editor.EditorCommandKey;
import andel.editor.EditorCommandType;
import andel.editor.EditorComponentKey;
import andel.editor.EditorFocusPlace;
import andel.editor.EditorMeta;
import andel.editor.EditorScrollCommand;
import andel.editor.MutableEditor;
import andel.editor.MutableEditorLayout;
import andel.editor.MutableMultiCaret;
import andel.intervals.Interval;
import andel.intervals.Intervals;
import andel.lines.Fold;
import andel.lines.Inlay;
import andel.lines.Interline;
import andel.lines.LinesCache;
import andel.lines.Postline;
import andel.text.TextRange;
import andel.undo.UndoGroupAttributes;
import andel.undo.UndoGroupKey;
import andel.undo.UndoLog;
import andel.undo.UndoScope;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import com.jetbrains.rhizomedb.EntityBuilder;
import com.jetbrains.rhizomedb.EntityType;
import fleet.common.document.DbMutableDocument;
import fleet.common.document.DocumentComponentEntity;
import fleet.common.document.DocumentEntity;
import fleet.common.document.DocumentEntityKt;
import fleet.common.document.EditorCommand;
import fleet.common.document.EditorEntity;
import fleet.common.document.UndoLogEntityKt;
import fleet.common.user.UserEntity;
import fleet.frontend.editor.ComposableTextKt;
import fleet.frontend.editor.ComposableTextRangeEntity;
import fleet.frontend.editor.DbMutableMultiCaret;
import fleet.frontend.editor.EditorCommandListenerEntity;
import fleet.frontend.editor.EditorCommandUndoScope;
import fleet.frontend.editor.EditorComponentEntity;
import fleet.frontend.editor.EditorEntityExtKt;
import fleet.frontend.editor.EditorLayoutEntity;
import fleet.frontend.editor.EditorLayoutKt;
import fleet.frontend.editor.components.EditorNotificationEntityKt;
import fleet.frontend.layout.TabEntityKt;
import fleet.frontend.navigation.ViewEntity;
import fleet.util.openmap.BoundedOpenMap;
import fleet.util.openmap.Key;
import fleet.util.openmap.MutableBoundedOpenMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 E2\u00020\u0001:\u0001EB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*H\u0016J1\u00101\u001a\u00020'2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0017\u00101\u001a\u0013\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020'06\u00a2\u0006\u0002\b8H\u0016J\b\u00109\u001a\u00020'H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R*\u0010\u0014\u001a\u0018\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001c0\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\u0004\u0018\u00010#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010+\u001a\u00020,X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010.R\u0014\u0010:\u001a\u00020;8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R(\u0010@\u001a\u0004\u0018\u00010?2\b\u0010>\u001a\u0004\u0018\u00010?8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010B\"\u0004\bC\u0010D\u00a8\u0006F"}, d2={"Lfleet/frontend/editor/DbMutableEditor;", "Landel/editor/MutableEditor;", "dbEditor", "Lfleet/common/document/EditorEntity;", "changeScope", "Lcom/jetbrains/rhizomedb/ChangeScope;", "document", "Lfleet/common/document/DbMutableDocument;", "<init>", "(Lfleet/common/document/EditorEntity;Lcom/jetbrains/rhizomedb/ChangeScope;Lfleet/common/document/DbMutableDocument;)V", "getDbEditor", "()Lfleet/common/document/EditorEntity;", "getChangeScope", "()Lcom/jetbrains/rhizomedb/ChangeScope;", "getDocument", "()Lfleet/common/document/DbMutableDocument;", "undoLog", "Landel/undo/UndoLog;", "getUndoLog", "()Landel/undo/UndoLog;", "meta", "Lfleet/util/openmap/MutableBoundedOpenMap;", "Landel/editor/EditorMeta;", "", "Lfleet/util/openmap/MutableOpenMap;", "getMeta", "()Lfleet/util/openmap/MutableBoundedOpenMap;", "components", "Landel/editor/DocumentComponent;", "getComponents", "multiCaret", "Landel/editor/MutableMultiCaret;", "getMultiCaret", "()Landel/editor/MutableMultiCaret;", "scrollCommand", "Landel/editor/EditorScrollCommand;", "getScrollCommand", "()Landel/editor/EditorScrollCommand;", "scrollTo", "", "switchFocus", "place", "Landel/editor/EditorFocusPlace;", "oneLine", "", "getOneLine", "()Z", "writable", "getWritable", "command", "commandType", "Landel/editor/EditorCommandType;", "groupKey", "Landel/undo/UndoGroupKey;", "Lkotlin/Function1;", "Landel/undo/UndoScope;", "Lkotlin/ExtensionFunctionType;", "addHistoryPlace", "layout", "Landel/editor/MutableEditorLayout;", "getLayout", "()Landel/editor/MutableEditorLayout;", "value", "Landel/text/TextRange;", "composableTextRange", "getComposableTextRange", "()Landel/text/TextRange;", "setComposableTextRange", "(Landel/text/TextRange;)V", "Companion", "fleet.frontend"})
@SourceDebugExtension(value={"SMAP\nDbMutableEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMutableEditor.kt\nfleet/frontend/editor/DbMutableEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 EntityAttribute.kt\ncom/jetbrains/rhizomedb/EntityAttributeKt\n+ 4 CollectionsUtil.kt\nfleet/util/CollectionsUtilKt\n+ 5 CollectionsUtil.kt\nfleet/util/CollectionsUtilKt$singleOrNullOrThrow$1\n*L\n1#1,258:1\n1863#2,2:259\n808#2,11:262\n130#3:261\n36#4,5:273\n41#4,8:279\n36#5:278\n*S KotlinDebug\n*F\n+ 1 DbMutableEditor.kt\nfleet/frontend/editor/DbMutableEditor\n*L\n103#1:259,2\n110#1:262,11\n110#1:261\n110#1:273,5\n110#1:279,8\n110#1:278\n*E\n"})
public final class DbMutableEditor
implements MutableEditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEntity dbEditor;
    @NotNull
    private final ChangeScope changeScope;
    @NotNull
    private final DbMutableDocument document;
    @NotNull
    private final MutableBoundedOpenMap<EditorMeta, Object> meta;
    @NotNull
    private final MutableBoundedOpenMap<MutableEditor, DocumentComponent> components;
    @NotNull
    private final MutableMultiCaret multiCaret;
    private final boolean oneLine;

    public DbMutableEditor(@NotNull EditorEntity dbEditor, @NotNull ChangeScope changeScope, @NotNull DbMutableDocument document2) {
        Intrinsics.checkNotNullParameter((Object)dbEditor, (String)"dbEditor");
        Intrinsics.checkNotNullParameter((Object)changeScope, (String)"changeScope");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        this.dbEditor = dbEditor;
        this.changeScope = changeScope;
        this.document = document2;
        this.meta = Companion.collectMeta(this.dbEditor).mutable();
        this.components = Companion.collectComponents(this.changeScope, this.dbEditor).mutable();
        this.multiCaret = new DbMutableMultiCaret(this);
    }

    @NotNull
    public final EditorEntity getDbEditor() {
        return this.dbEditor;
    }

    @NotNull
    public final ChangeScope getChangeScope() {
        return this.changeScope;
    }

    @NotNull
    public DbMutableDocument getDocument() {
        return this.document;
    }

    @NotNull
    public UndoLog getUndoLog() {
        return UndoLogEntityKt.getGlobalUndoModel((UserEntity)this.dbEditor.getUser()).getDocumentUndoLog(this.getDocument().getDbDocument());
    }

    @NotNull
    public MutableBoundedOpenMap<EditorMeta, Object> getMeta() {
        return this.meta;
    }

    @NotNull
    public MutableBoundedOpenMap<MutableEditor, DocumentComponent> getComponents() {
        return this.components;
    }

    @NotNull
    public MutableMultiCaret getMultiCaret() {
        return this.multiCaret;
    }

    @Nullable
    public EditorScrollCommand getScrollCommand() {
        EditorLayoutEntity editorLayoutEntity = EditorEntityExtKt.getLayout(this.dbEditor);
        return editorLayoutEntity != null ? editorLayoutEntity.getScrollCommand() : null;
    }

    public void scrollTo(@NotNull EditorScrollCommand scrollCommand) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)scrollCommand, (String)"scrollCommand");
            EditorLayoutEntity editorLayout = EditorEntityExtKt.getLayout(this.dbEditor);
            ChangeScope $this$scrollTo_u24lambda_u240 = this.changeScope;
            boolean bl = false;
            EditorLayoutEntity editorLayoutEntity = editorLayout;
            if (editorLayoutEntity == null) break block0;
            EditorScrollCommand editorScrollCommand = editorLayout.getScrollCommand();
            $this$scrollTo_u24lambda_u240.set((Entity)editorLayoutEntity, EditorLayoutEntity.Companion.getScrollCommandAttr(), (Object)EditorScrollCommand.copy$default((EditorScrollCommand)scrollCommand, (long)0L, (long)0L, null, null, (boolean)false, (long)((editorScrollCommand != null ? editorScrollCommand.getTimestamp() : 0L) + 1L), null, null, (int)223, null));
        }
    }

    public void switchFocus(@NotNull EditorFocusPlace place) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            ChangeScope $this$switchFocus_u24lambda_u241 = this.changeScope;
            boolean bl = false;
            EditorLayoutEntity editorLayoutEntity = EditorEntityExtKt.getLayout(this.dbEditor);
            if (editorLayoutEntity == null) break block0;
            $this$switchFocus_u24lambda_u241.set((Entity)editorLayoutEntity, EditorLayoutEntity.Companion.getEditorFocusPlaceAttr(), (Object)place);
        }
    }

    public boolean getOneLine() {
        return this.oneLine;
    }

    public boolean getWritable() {
        return this.dbEditor.getDocument().getWritable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void command(@NotNull EditorCommandType commandType, @NotNull UndoGroupKey groupKey, @NotNull Function1<? super UndoScope, Unit> command2) {
        Intrinsics.checkNotNullParameter((Object)commandType, (String)"commandType");
        Intrinsics.checkNotNullParameter((Object)groupKey, (String)"groupKey");
        Intrinsics.checkNotNullParameter(command2, (String)"command");
        if (!(commandType != EditorCommandType.EDIT && commandType != EditorCommandType.GENERATED_EDIT || this.getWritable())) {
            ChangeScope $this$command_u24lambda_u242 = this.changeScope;
            boolean bl = false;
            EditorNotificationEntityKt.showEditorNotification-G6qTlXE$default($this$command_u24lambda_u242, this.dbEditor, EditorEntityExtKt.getMultiCaret(this.dbEditor).getPrimaryCaret().getOffset(), null, "Document is read-only", null, 16, null);
        } else {
            Object undoScope;
            Object[] $this$command_u24lambda_u242 = new EditorCommandType[]{this.getMeta().get((Key)EditorCommandKey.INSTANCE), commandType};
            EditorCommandType winningCommandType = (EditorCommandType)CollectionsKt.maxOrThrow((Iterable)CollectionsKt.listOfNotNull((Object[])$this$command_u24lambda_u242));
            Object $this$command_u24lambda_u243 = this.changeScope;
            boolean $i$a$-run-DbMutableEditor$command$32 = false;
            EditorLayoutEntity editorLayoutEntity = EditorEntityExtKt.getLayout(this.dbEditor);
            if (editorLayoutEntity != null) {
                $this$command_u24lambda_u243.set((Entity)editorLayoutEntity, EditorLayoutEntity.Companion.getUserActionTimestampAttr(), (Object)TuplesKt.to((Object)System.currentTimeMillis(), (Object)winningCommandType));
            }
            if (this.getMeta().contains((Key)EditorCommandKey.INSTANCE)) {
                Object object = this.getMeta().get((Key)EditorCommandUndoScope.INSTANCE);
                Intrinsics.checkNotNull((Object)object);
                undoScope = (UndoScope)object;
                command2.invoke(undoScope);
                return;
            }
            this.getMeta().set((Key)EditorCommandKey.INSTANCE, (Object)winningCommandType);
            undoScope = this.getDocument().getDbDocument();
            $this$command_u24lambda_u243 = this.changeScope;
            UserEntity $i$a$-run-DbMutableEditor$command$32 = this.dbEditor.getUser();
            EditorEntity editorEntity = this.dbEditor;
            UndoGroupAttributes undoGroupAttributes = groupKey.toAttributes();
            undoScope = (AutoCloseable)DocumentEntityKt.startCommand((DocumentEntity)undoScope, (ChangeScope)$this$command_u24lambda_u243, (UserEntity)$i$a$-run-DbMutableEditor$command$32, (UndoGroupAttributes)undoGroupAttributes, (EditorEntity)editorEntity, null);
            $this$command_u24lambda_u243 = null;
            try {
                EditorCommand it = (EditorCommand)undoScope;
                boolean bl = false;
                this.getMeta().set((Key)EditorCommandUndoScope.INSTANCE, (Object)it.getUndoScope());
                command2.invoke((Object)it.getUndoScope());
                this.getMeta().remove((Key)EditorCommandUndoScope.INSTANCE);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                $this$command_u24lambda_u243 = throwable;
                throw throwable;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)undoScope, (Throwable)$this$command_u24lambda_u243);
            }
            this.getMeta().remove((Key)EditorCommandKey.INSTANCE);
            Iterable $this$forEach$iv = EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)EditorCommandListenerEntity.Companion.getEditorAttr()), (Object)this.dbEditor);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorCommandListenerEntity listener = (EditorCommandListenerEntity)element$iv;
                boolean bl = false;
                listener.commandFinished(commandType);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addHistoryPlace() {
        block4: {
            void $this$singleOrNullOrThrow_u24default$iv$iv;
            void $this$filterIsInstanceTo$iv$iv$iv;
            void entityAttribute$iv;
            EntityAttribute entityAttribute = (EntityAttribute)EditorComponentEntity.Companion.getEditorAttr();
            EditorEntity value$iv = this.dbEditor;
            boolean $i$f$entityCasted = false;
            Iterable $this$filterIsInstance$iv$iv = EntityAttributeKt.entities((EntityAttribute)entityAttribute$iv, (Object)value$iv);
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                if (!(element$iv$iv$iv instanceof EditorLayoutEntity)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            $this$filterIsInstance$iv$iv = (List)destination$iv$iv$iv;
            boolean $i$f$singleOrNullOrThrow = false;
            Object single$iv$iv = null;
            boolean found$iv$iv = false;
            Iterator iterator = $this$singleOrNullOrThrow_u24default$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv;
                Object t = element$iv$iv = iterator.next();
                boolean bl = false;
                Object it$iv = t;
                if (found$iv$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element: " + single$iv$iv + ", " + element$iv$iv);
                }
                single$iv$iv = element$iv$iv;
                found$iv$iv = true;
            }
            EditorLayoutEntity editorLayoutEntity = (EditorLayoutEntity)((Entity)single$iv$iv);
            if (editorLayoutEntity == null) break block4;
            EditorLayoutEntity editorLayout = editorLayoutEntity;
            boolean bl = false;
            ViewEntity<?> viewEntity2 = EditorLayoutKt.ownerTab(editorLayout);
            if (viewEntity2 != null) {
                TabEntityKt.addToNavigationHistory(viewEntity2, this.changeScope, false);
            }
        }
    }

    @NotNull
    public MutableEditorLayout getLayout() {
        return new MutableEditorLayout(this){
            final /* synthetic */ DbMutableEditor this$0;
            {
                this.this$0 = $receiver;
            }

            public LinesCache getLinesCache() {
                EditorLayoutEntity editorLayoutEntity = EditorEntityExtKt.getLayout(this.this$0.getDbEditor());
                Intrinsics.checkNotNull((Object)editorLayoutEntity);
                return editorLayoutEntity.getLinesCache();
            }

            public Intervals<?, Inlay> getInlays() {
                EditorLayoutEntity editorLayoutEntity = EditorEntityExtKt.getLayout(this.this$0.getDbEditor());
                Intrinsics.checkNotNull((Object)editorLayoutEntity);
                return editorLayoutEntity.getEditorMarkup().getInlays();
            }

            public Intervals<?, Fold> getFolds() {
                Intervals<Long, Fold> intervals = EditorEntityExtKt.getLayout(this.this$0.getDbEditor());
                if (intervals == null || (intervals = intervals.getEditorMarkup()) == null || (intervals = intervals.getFolds()) == null) {
                    intervals = Intervals.Companion.empty();
                }
                return intervals;
            }

            public Intervals<?, Postline> getPostlines() {
                Intervals<Long, Postline> intervals = EditorEntityExtKt.getLayout(this.this$0.getDbEditor());
                if (intervals == null || (intervals = intervals.getEditorMarkup()) == null || (intervals = intervals.getPostlines()) == null) {
                    intervals = Intervals.Companion.empty();
                }
                return intervals;
            }

            public Intervals<?, Interline> getInterlines() {
                Intervals<Long, Interline> intervals = EditorEntityExtKt.getLayout(this.this$0.getDbEditor());
                if (intervals == null || (intervals = intervals.getEditorMarkup()) == null || (intervals = intervals.getInterlines()) == null) {
                    intervals = Intervals.Companion.empty();
                }
                return intervals;
            }

            /*
             * WARNING - void declaration
             */
            public void unfold(List<? extends Interval<?, ? extends Fold>> affectedFolds2) {
                block1: {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Intrinsics.checkNotNullParameter(affectedFolds2, (String)"affectedFolds");
                    EditorLayoutEntity editorLayoutEntity = EditorEntityExtKt.getLayout(this.this$0.getDbEditor());
                    if (editorLayoutEntity == null) break block1;
                    Iterable iterable = affectedFolds2;
                    List list = CollectionsKt.emptyList();
                    ChangeScope changeScope = this.this$0.getChangeScope();
                    EditorLayoutEntity editorLayoutEntity2 = editorLayoutEntity;
                    boolean $i$f$filter = false;
                    void var4_7 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        Interval it = (Interval)element$iv$iv;
                        boolean bl = false;
                        if (!(!((Fold)it.data).getFocusable())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List list2 = (List)destination$iv$iv;
                    EditorLayoutEntity.toggleFolds$default(editorLayoutEntity2, changeScope, list, list2, false, 8, null);
                }
            }
        };
    }

    @Nullable
    public TextRange getComposableTextRange() {
        ComposableTextRangeEntity composableTextRangeEntity = ComposableTextKt.getComposableTextRangeEntity(this.dbEditor);
        return composableTextRangeEntity != null ? composableTextRangeEntity.getRange() : null;
    }

    public void setComposableTextRange(@Nullable TextRange value) {
        ChangeScope $this$_set_composableTextRange__u24lambda_u248 = this.changeScope;
        boolean bl = false;
        ComposableTextRangeEntity composableTextRangeEntity = ComposableTextKt.getComposableTextRangeEntity(this.dbEditor);
        if (composableTextRangeEntity != null) {
            $this$_set_composableTextRange__u24lambda_u248.delete((Entity)composableTextRangeEntity);
        }
        if (value != null) {
            $this$_set_composableTextRange__u24lambda_u248.new((EntityType)ComposableTextRangeEntity.Companion, arg_0 -> DbMutableEditor._set_composableTextRange_$lambda$8$lambda$7(this, value, arg_0));
        }
    }

    private static final void _set_composableTextRange_$lambda$8$lambda$7(DbMutableEditor this$0, TextRange $value, EntityBuilder.Target it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(DocumentComponentEntity.Companion.getDocumentAttr(), (Object)this$0.dbEditor.getDocument());
        it.set(EditorComponentEntity.Companion.getEditorAttr(), (Object)this$0.dbEditor);
        it.set(ComposableTextRangeEntity.Companion.getRangeAttr(), (Object)$value);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00072\u0006\u0010\b\u001a\u00020\tJ\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0010"}, d2={"Lfleet/frontend/editor/DbMutableEditor$Companion;", "", "<init>", "()V", "collectMeta", "Lfleet/util/openmap/MutableBoundedOpenMap;", "Landel/editor/EditorMeta;", "Lfleet/util/openmap/MutableOpenMap;", "dbEditor", "Lfleet/common/document/EditorEntity;", "collectComponents", "Lfleet/util/openmap/BoundedOpenMap;", "Landel/editor/MutableEditor;", "Landel/editor/DocumentComponent;", "changeScope", "Lcom/jetbrains/rhizomedb/ChangeScope;", "fleet.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MutableBoundedOpenMap<EditorMeta, Object> collectMeta(@NotNull EditorEntity dbEditor) {
            Intrinsics.checkNotNullParameter((Object)dbEditor, (String)"dbEditor");
            return MutableBoundedOpenMap.Companion.empty();
        }

        @NotNull
        public final BoundedOpenMap<MutableEditor, DocumentComponent> collectComponents(@NotNull ChangeScope changeScope, @NotNull EditorEntity dbEditor) {
            Intrinsics.checkNotNullParameter((Object)changeScope, (String)"changeScope");
            Intrinsics.checkNotNullParameter((Object)dbEditor, (String)"dbEditor");
            MutableBoundedOpenMap res = MutableBoundedOpenMap.Companion.emptyBounded();
            Set components2 = EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)EditorComponentEntity.Companion.getEditorAttr()), (Object)dbEditor);
            for (EditorComponentEntity c : components2) {
                EditorComponentKey editorComponentKey = c.getEditorKey();
                Intrinsics.checkNotNull(editorComponentKey, (String)"null cannot be cast to non-null type fleet.util.openmap.Key<andel.editor.DocumentComponent, andel.editor.MutableEditor>");
                res.set((Key)editorComponentKey, (Object)c.asComponent(changeScope));
            }
            return (BoundedOpenMap)res;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

