/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.psi.util.java;

import fleet.com.intellij.pom.java.JavaFeature;
import fleet.com.intellij.pom.java.LanguageLevel;
import fleet.com.intellij.util.containers.CollectionFactory;
import fleet.com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class PsiUtil {
    @NotNull
    private static final Map<CharSequence, JavaFeature> SOFT_KEYWORDS = CollectionFactory.createCharSequenceMap((boolean)true);
    private static final Set<String> KEYWORDS;

    public static boolean isKeyword(@NotNull String id, @NotNull LanguageLevel level) {
        return KEYWORDS.contains(id) || JavaFeature.ASSERTIONS.isSufficient(level) && "assert".equals(id) || JavaFeature.ENUMS.isSufficient(level) && "enum".equals(id);
    }

    public static boolean isSoftKeyword(@NotNull CharSequence id, @NotNull LanguageLevel level) {
        JavaFeature feature = PsiUtil.softKeywordFeature(id);
        return feature != null && feature.isSufficient(level);
    }

    @Nullable
    public static JavaFeature softKeywordFeature(@NotNull CharSequence keyword) {
        return SOFT_KEYWORDS.get(keyword);
    }

    static {
        SOFT_KEYWORDS.put("var", JavaFeature.LVTI);
        SOFT_KEYWORDS.put("record", JavaFeature.RECORDS);
        SOFT_KEYWORDS.put("yield", JavaFeature.SWITCH_EXPRESSION);
        SOFT_KEYWORDS.put("sealed", JavaFeature.SEALED_CLASSES);
        SOFT_KEYWORDS.put("permits", JavaFeature.SEALED_CLASSES);
        SOFT_KEYWORDS.put("when", JavaFeature.PATTERN_GUARDS_AND_RECORD_PATTERNS);
        SOFT_KEYWORDS.put("open", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("module", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("requires", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("exports", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("opens", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("uses", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("provides", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("transitive", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("to", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("with", JavaFeature.MODULES);
        KEYWORDS = ContainerUtil.immutableSet((Object[])new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "non-sealed"});
    }
}

